/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.msg;

import com.huawei.ism.cbb.proxy.protocol.tlv.constant.BitUtils;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.ParamType;
import com.huawei.ism.cbb.proxy.protocol.tlv.exception.TLVException;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmIntegerFactory;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmSignedInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmUnsignedInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt16;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class Param
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5291037308885169620L;
    private ParamType type;
    private int index;
    private Object value;

    public Param() {
    }

    public Param(int index, ParamType paramType, byte[] tlvBytes) {
        this.index = index;
        this.type = paramType;
        switch (paramType) {
            case STRING: 
            case ARRAY: 
            case JSON: {
                this.value = BitUtils.utf8ByteArrayToString(tlvBytes, tlvBytes.length, 0);
                break;
            }
            case UNSIGN_INT: 
            case SIGN_INT: 
            case BOOL: 
            case ENUM: 
            case TIME: {
                IsmIntegerFactory factory = IsmIntegerFactory.getInstance();
                this.value = factory.newIsmInteger(paramType, tlvBytes, tlvBytes.length).orElse(null);
                break;
            }
        }
    }

    public Param(int index, ParamType type, String value) {
        this.index = index;
        this.type = type;
        if ((type == ParamType.STRING || type == ParamType.ARRAY || type == ParamType.JSON) && value == null) {
            throw new TLVException("The value of index: " + index + " is: null, not a String type");
        }
        if (Arrays.asList(ParamType.UNSIGN_INT, ParamType.BOOL, ParamType.ENUM, ParamType.TIME, ParamType.SIGN_INT).contains((Object)type)) {
            throw new TLVException("ParamType must be a String Data");
        }
        this.value = value;
    }

    public Param(int index, ParamType type, IsmInteger value) {
        this.index = index;
        this.type = type;
        if (type == ParamType.STRING || type == ParamType.ARRAY || type == ParamType.JSON) {
            throw new TLVException("ParamType must be a IsmInteger Data");
        }
        if (!(type != ParamType.UNSIGN_INT && type != ParamType.BOOL && type != ParamType.ENUM || value instanceof IsmUnsignedInteger)) {
            throw new TLVException(value + " is a " + value.getClass() + " not a IsmUnsignedInteger type");
        }
        if (!(type != ParamType.SIGN_INT && type != ParamType.TIME || value instanceof IsmSignedInteger)) {
            throw new TLVException(value + " is a " + value.getClass() + " not a IsmSignedInteger type");
        }
        this.value = value;
    }

    public Param(int index, String value) {
        this(index, ParamType.STRING, value);
    }

    public Param(int index, IsmInteger value) {
        this(index, value.getType(), value);
    }

    public short getLength() {
        short length = 0;
        if (this.isStringType()) {
            length = this.value != null ? (short)BitUtils.stringToUtf8ByteArray(this.value.toString()).length : (short)1;
        }
        if (this.isIntType()) {
            length = (short)((IsmInteger)this.value).toByteArray().length;
        }
        return length;
    }

    private boolean isIntType() {
        return (this.checkType() || this.checkTypeAgnin()) && this.value instanceof IsmInteger;
    }

    private boolean checkType() {
        return this.type == ParamType.UNSIGN_INT || this.type == ParamType.SIGN_INT;
    }

    private boolean checkTypeAgnin() {
        return Arrays.asList(ParamType.ENUM, ParamType.BOOL, ParamType.TIME).contains((Object)this.type);
    }

    private boolean isStringType() {
        return Arrays.asList(ParamType.STRING, ParamType.JSON, ParamType.ARRAY).contains((Object)this.type);
    }

    public int intValue() {
        int result = 0;
        if (this.value instanceof Number) {
            result = ((Number)this.value).intValue();
        }
        return result;
    }

    public long longValue() {
        long result = 0L;
        if (this.value instanceof Number) {
            result = ((Number)this.value).longValue();
        }
        return result;
    }

    public long shortValue() {
        int result = 0;
        if (this.value instanceof Number) {
            result = ((Number)this.value).shortValue();
        }
        return result;
    }

    public String stringValue() {
        String result = "";
        if (this.value instanceof String) {
            result = (String)this.value;
            result = result.trim();
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Param param;
        try {
            param = (Param)super.clone();
            param.type = this.type;
            param.index = this.index;
            param.value = this.value;
        }
        catch (CloneNotSupportedException e) {
            throw new TLVException("exception:", (Throwable)e);
        }
        return param;
    }

    public String toString() {
        return this.index + "(" + (Object)((Object)this.type) + ")=" + this.value;
    }

    List<byte[]> toByteArray() {
        ArrayList<byte[]> tlvList = new ArrayList<byte[]>();
        ParamType paramType = this.getType();
        short shortInd = (short)this.getIndex();
        short typeCmo = (short)((shortInd << 4) + paramType.getValue());
        short paramLen = this.getLength();
        Object objVal = this.getValue().orElse(null);
        tlvList.add(new UnsignedInt16(typeCmo).toByteArray());
        tlvList.add(new UnsignedInt16(paramLen).toByteArray());
        if (objVal instanceof String) {
            tlvList.add(BitUtils.stringToUtf8ByteArray(objVal.toString()));
        }
        if (objVal instanceof IsmInteger) {
            IsmInteger ismIntegerValue = (IsmInteger)objVal;
            tlvList.add(ismIntegerValue.toByteArray());
        }
        return tlvList;
    }

    public ParamType getType() {
        return this.type;
    }

    public void setType(ParamType type) {
        this.type = type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Optional getValue() {
        return Optional.ofNullable(this.value);
    }

    public <T> void setValue(T value) {
        this.value = value;
    }
}

