/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.msg;

import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt16;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt64;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Param;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Record {
    private int length;
    private long msgCode;
    private List<Param> params = new ArrayList<Param>();

    public void add(Param param) {
        this.params.add(param);
    }

    public int getFieldCount() {
        return this.params.size();
    }

    public int getLength() {
        return this.length;
    }

    public long getMsgCode() {
        return this.msgCode;
    }

    public Optional<IsmInteger> getParamIntValue(int tag) {
        for (Param param : this.params) {
            if (param.getIndex() != tag || !(param.getValue().orElse(null) instanceof IsmInteger)) continue;
            return Optional.of((IsmInteger)param.getValue().get());
        }
        return Optional.empty();
    }

    public List<Param> getParams() {
        return this.params;
    }

    public String getParamStrValue(int tag) {
        for (Param param : this.params) {
            if (param.getIndex() != tag || !(param.getValue().orElse(null) instanceof String)) continue;
            return (String)param.getValue().get();
        }
        return "";
    }

    public Optional<IsmInteger> getParamValue(int tag) {
        for (Param param : this.params) {
            if (param.getIndex() != tag || !(param.getValue().orElse(null) instanceof IsmInteger)) continue;
            return Optional.of((IsmInteger)param.getValue().get());
        }
        return Optional.empty();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setMsgCode(long msgCode) {
        this.msgCode = msgCode;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    public <T> void setParamValue(int paramIdx, T value) {
        for (Param param : this.params) {
            if (param.getIndex() != paramIdx) continue;
            param.setValue(value);
            break;
        }
    }

    public byte[] toByteArray(int msgVersion) throws IOException {
        byte[] result = null;
        if (msgVersion == 3) {
            result = this.toByteArrayVersion3();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] toByteArrayVersion3() throws IOException {
        byte[] result;
        ArrayList<byte[]> tlvList = new ArrayList<byte[]>();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream out = new DataOutputStream(bos);){
            void var9_16;
            out.write(new UnsignedInt64(this.msgCode).toByteArray());
            int recordLen = 0;
            for (Param param : this.params) {
                tlvList.addAll(param.toByteArray());
                recordLen = (short)(recordLen + (param.getLength() + 2 + 2));
            }
            this.setLength(recordLen);
            short recordLength = 0;
            for (byte[] paramBuf : tlvList) {
                recordLength = (short)(recordLength + paramBuf.length);
            }
            out.write(new UnsignedInt16(recordLength).toByteArray());
            boolean bl = false;
            while (var9_16 < tlvList.size()) {
                out.write((byte[])tlvList.get((int)var9_16));
                ++var9_16;
            }
            result = bos.toByteArray();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        for (Param param : this.params) {
            sb.append(param);
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }
}

