/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class IsmBeanUtils
extends BeanUtils {
    private static final Log logger = LogFactory.getInstance(IsmBeanUtils.class);

    private IsmBeanUtils() {
    }

    public static Object forceGetProperty(final Object object, String propertyName) throws NoSuchFieldException {
        if (!StringUtils.hasText((String)propertyName)) {
            throw new IllegalArgumentException("This String argument must have text; it must not be null, empty, or blank");
        }
        final Field field = IsmBeanUtils.getDeclaredField(object, propertyName);
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object result = null;
                try {
                    boolean accessible = field.isAccessible();
                    field.setAccessible(true);
                    result = field.get(object);
                    field.setAccessible(accessible);
                }
                catch (IllegalAccessException e) {
                    logger.info((Object)"error wont' happen", 90160758784000L);
                }
                return result;
            }
        });
    }

    public static void forceSetProperty(final Object object, String propertyName, final Object newValue) throws NoSuchFieldException {
        if (object == null) {
            throw new IllegalArgumentException("This argument is required; it must not be null");
        }
        if (!StringUtils.hasText((String)propertyName)) {
            throw new IllegalArgumentException("This String argument must have text; it must not be null, empty, or blank");
        }
        final Field field = IsmBeanUtils.getDeclaredField(object, propertyName);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    field.set(object, newValue);
                }
                catch (IllegalAccessException e) {
                    logger.info((Object)"Error won't happen", 90160758784000L);
                }
                field.setAccessible(accessible);
                return null;
            }
        });
    }

    public static Field getDeclaredField(Class clazz, String propertyName) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException("This argument is required; it must not be null");
        }
        if (!StringUtils.hasText((String)propertyName)) {
            throw new IllegalArgumentException("This String argument must have text; it must not be null, empty, or blank");
        }
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(propertyName);
            }
            catch (RuntimeException e) {
                logger.info((Object)("No declared field " + propertyName + " in class " + superClass + ExceptionUtil.getErrorMessage((Throwable)e)));
                continue;
            }
            catch (Exception e) {
                logger.info((Object)("No declared field " + propertyName + " in class " + superClass + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        throw new NoSuchFieldException("No such field: " + clazz.getName() + '.' + propertyName);
    }

    public static Field getDeclaredField(Object object, String propertyName) throws NoSuchFieldException {
        if (object == null) {
            throw new IllegalArgumentException("This argument is required; it must not be null");
        }
        return IsmBeanUtils.getDeclaredField(object.getClass(), propertyName);
    }

    public static Method getGetterMethod(Class type, String fieldName) {
        try {
            return type.getMethod(IsmBeanUtils.getGetterName(type, fieldName), new Class[0]);
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160758784000L);
            return null;
        }
    }

    public static String getGetterName(Class type, String fieldName) {
        Assert.notNull((Object)type, (String)"Type required");
        Assert.hasText((String)fieldName, (String)"FieldName required");
        String className = type.getName();
        if ("boolean".equals(className)) {
            return "is" + StringUtils.capitalize((String)fieldName);
        }
        return "get" + StringUtils.capitalize((String)fieldName);
    }
}

