/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public final class NumberUtil {
    private static final Log logger = LogFactory.getInstance(NumberUtil.class);
    private static final short ZERO = 0;
    private static final boolean FALSE = Boolean.FALSE;
    private static final int PERCENT_MULTIPLIER = 100;

    private NumberUtil() {
    }

    public static boolean getBooleanValue(Boolean booleanValue) {
        return booleanValue == null ? FALSE : booleanValue;
    }

    public static short getShortValue(Short shortObj) {
        return shortObj == null ? (short)0 : shortObj;
    }

    public static int getIntValue(Integer intObj) {
        return intObj == null ? 0 : intObj;
    }

    public static long getLongValue(Long longObj) {
        return longObj == null ? 0L : longObj;
    }

    public static Double getSpaceUsage(Long usedCapacity, Long totalCapacity) {
        if (null == usedCapacity || null == totalCapacity || totalCapacity <= 0L || usedCapacity <= 0L) {
            return Double.valueOf("0");
        }
        Double tempDouble = NumberUtil.convertToDouble(1.0 * (double)usedCapacity.longValue() / (double)totalCapacity.longValue());
        if (tempDouble - 1.0 <= 0.0) {
            return tempDouble;
        }
        return Double.valueOf("1.0");
    }

    public static Double getSpaceUsageRatio(Long usedCapacity, Long totalCapacity) {
        return NumberUtil.getSpaceUsage(usedCapacity, totalCapacity) * 100.0;
    }

    public static Double getSpaceUsage(Double usedCapacity, Double totalCapacity) {
        if (null == usedCapacity || null == totalCapacity || totalCapacity <= 0.0 || usedCapacity <= 0.0) {
            return Double.valueOf("0");
        }
        Double tempDouble = NumberUtil.convertToDouble(usedCapacity / totalCapacity);
        if (tempDouble - 1.0 <= 0.0) {
            return tempDouble;
        }
        return Double.valueOf("1.0");
    }

    public static Double getSpaceUsageRatio(Double usedCapacity, Double totalCapacity) {
        return NumberUtil.getSpaceUsage(usedCapacity, totalCapacity) * 100.0;
    }

    public static Double parseDouble(Object obj) {
        Double data = 0.0;
        if (obj != null) {
            try {
                data = Double.valueOf(obj.toString());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Parsing failed. obj:" + obj), 90160758784001L);
                data = 0.0;
            }
        }
        return data;
    }

    public static Integer parseInteger(Object obj) {
        return NumberUtil.parseInteger(obj, 0);
    }

    public static Integer parseInteger(Object obj, Integer otherwise) {
        if (obj != null) {
            try {
                return Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Parsing failed. obj:" + obj));
                return otherwise;
            }
        }
        logger.error((Object)"Parsing failed. obj is null");
        return otherwise;
    }

    public static boolean between(int n, int s, int e) {
        return s <= n && n <= e;
    }

    public static boolean between(String n, int s, int e) {
        Integer i = NumberUtil.parseInteger(n, null);
        return i != null && NumberUtil.between(i, s, e);
    }

    public static Long parseLong(Object obj) {
        return NumberUtil.parseLong(obj, 0L);
    }

    public static Long parseLong(Object obj, Long otherwise) {
        Long value = otherwise;
        if (obj != null) {
            try {
                value = Long.valueOf(obj.toString());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Parsing failed. obj:" + obj + ", using otherwise value: " + otherwise), 90160758784001L);
                value = otherwise;
            }
        }
        return value;
    }

    public static Long convertToLong(Object object, long defaultValue) {
        Long result;
        if (null == object) {
            return defaultValue;
        }
        try {
            result = Long.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 90160758784001L);
            result = defaultValue;
        }
        return result;
    }

    public static Integer convertToInteger(Object object, int defaultValue) {
        Integer result;
        if (null == object) {
            return defaultValue;
        }
        try {
            result = Integer.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 90160758784001L);
            result = defaultValue;
        }
        return result;
    }

    public static Double convertToDouble(Object object, double defaultValue) {
        Double result;
        if (null == object) {
            return defaultValue;
        }
        try {
            result = Double.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 90160758784001L);
            result = defaultValue;
        }
        return result;
    }

    public static Long convertToLong(Object object, LegoCheckedException failException) {
        if (null == object) {
            throw failException;
        }
        try {
            return Long.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 90160758784001L);
            throw failException;
        }
    }

    public static Integer convertToInteger(Object object, LegoCheckedException failException) {
        if (null == object) {
            throw failException;
        }
        try {
            return Integer.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 90160758784001L);
            throw failException;
        }
    }

    public static Double convertToDouble(Object object, LegoCheckedException failException) {
        if (null == object) {
            throw failException;
        }
        try {
            return Double.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Converting failed. obj:" + object), 90160758784001L);
            throw failException;
        }
    }

    public static Long convertToLong(Object object) {
        return NumberUtil.convertToLong(object, new LegoCheckedException(1073947393L));
    }

    public static Integer convertToInteger(Object object) {
        return NumberUtil.convertToInteger(object, new LegoCheckedException(1073947393L));
    }

    public static Double convertToDouble(Object object) {
        return NumberUtil.convertToDouble(object, new LegoCheckedException(1073947393L));
    }
}

