/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import com.huawei.ism.cbb.util.OppoField;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class ObjectConvert {
    private static final String METHOD_HEAD_GET_BOOLEAN = "is";
    private static final String METHOD_HEAD_GET = "get";
    private static final String METHOD_HEAD_SET = "set";
    private static Map<String, Object> defaultValueMap = new HashMap<String, Object>();
    private static final Log logger = LogFactory.getInstance((Object)new ObjectConvert());

    private ObjectConvert() {
    }

    public static void convert(Object from, Object to) {
        Field[] fields;
        for (Field field : fields = to.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(OppoField.class)) continue;
            OppoField oAnnotation = field.getAnnotation(OppoField.class);
            Method toMethod = ObjectConvert.getMethodName(to, field.getName(), METHOD_HEAD_SET, field.getType());
            Object value = ObjectConvert.getValue(oAnnotation, from);
            if (null == value) {
                value = defaultValueMap.get(field.getType().getName());
            }
            ObjectConvert.invokeMethd(to, toMethod, value);
        }
    }

    public static void antiConvert(Object from, Object to) {
        Field[] fields;
        for (Field field : fields = from.getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            if (!field.isAnnotationPresent(OppoField.class)) continue;
            OppoField oAnnotation = field.getAnnotation(OppoField.class);
            Method toMethod = ObjectConvert.getMethodName(to, oAnnotation.fieldName(), METHOD_HEAD_SET, oAnnotation.fieldType());
            Method fromMethod = Boolean.class.getName().equals(field.getType().getName()) || Boolean.TYPE.getName().equals(field.getType().getName()) ? ObjectConvert.getMethodName(from, fieldName, METHOD_HEAD_GET_BOOLEAN, new Class[0]) : ObjectConvert.getMethodName(from, fieldName, METHOD_HEAD_GET, new Class[0]);
            Object value = ObjectConvert.invokeMethd(from, fromMethod, new Object[0]);
            if (null == value) {
                value = defaultValueMap.get(field.getType().getName());
            }
            ObjectConvert.invokeMethd(to, toMethod, value);
        }
    }

    private static Object getValue(OppoField oAnnotation, Object from) {
        String fromFieldName = oAnnotation.fieldName();
        Class<?> fieldType = oAnnotation.fieldType();
        String customMethodName = oAnnotation.methodName();
        Class<?> customMethodClass = oAnnotation.methodClass();
        Method fromMethod = Boolean.class.getName().equals(fieldType.getName()) || Boolean.TYPE.getName().equals(fieldType.getName()) ? ObjectConvert.getMethodName(from, fromFieldName, METHOD_HEAD_GET_BOOLEAN, new Class[0]) : ObjectConvert.getMethodName(from, fromFieldName, METHOD_HEAD_GET, new Class[0]);
        Object value = ObjectConvert.invokeMethd(from, fromMethod, new Object[0]);
        if (null == value) {
            return null;
        }
        if (VerifyUtil.isEmpty(customMethodName)) {
            return value;
        }
        try {
            fromMethod = customMethodClass.getDeclaredMethod(customMethodName, fieldType);
            fromMethod.setAccessible(true);
            return ObjectConvert.invokeMethd(customMethodClass.newInstance(), fromMethod, value);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Convert field error, field name is: " + fromMethod.getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)("Convert field error, field name is: " + fromMethod.getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }

    private static Method getMethodName(Object obj, String fieldName, String methodType, Class<?> ... parameterTypes) {
        StringBuilder methodName = new StringBuilder();
        methodName.append(methodType);
        methodName.append(fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH));
        methodName.append(fieldName.substring(1, fieldName.length()));
        try {
            return obj.getClass().getMethod(methodName.toString(), parameterTypes);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Convert field error, field name is: " + fieldName + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (Exception e) {
            logger.error((Object)("Convert field error, field name is: " + fieldName + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return null;
    }

    private static Object invokeMethd(Object tag, Method method, Object ... args) {
        if (null == method) {
            return null;
        }
        try {
            return method.invoke(tag, args);
        }
        catch (Exception e) {
            logger.error((Object)("Convert field error, method name is: " + method.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160766255364L);
            return null;
        }
    }

    static {
        defaultValueMap.put("java.lang.String", "");
        defaultValueMap.put("java.lang.Integer", 0);
        defaultValueMap.put("java.lang.int", 0);
        defaultValueMap.put("java.lang.Double", 0.0);
        defaultValueMap.put("java.lang.double", 0.0);
        defaultValueMap.put("java.lang.Long", 0L);
        defaultValueMap.put("java.lang.long", 0L);
        defaultValueMap.put("java.lang.Byte", 0);
        defaultValueMap.put("java.lang.byte", 0);
        defaultValueMap.put("java.lang.Boolean", false);
        defaultValueMap.put("java.lang.boolean", false);
    }
}

