/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import org.springframework.util.StringUtils;

public final class StringEscapeUtil {
    private StringEscapeUtil() {
    }

    public static String escape(String str, String escapeStr) {
        if ("<".equals(escapeStr)) {
            str = str.replaceAll(escapeStr, "&lt;");
        } else if (">".equals(escapeStr)) {
            str = str.replaceAll(escapeStr, "&gt;");
        } else if (" ".equals(escapeStr)) {
            str = str.replaceAll(escapeStr, "&nbsp;");
        } else if ("&".equals(escapeStr)) {
            str = str.replaceAll(escapeStr, "&amp;");
        } else if ("\"".equals(escapeStr)) {
            str = str.replaceAll(escapeStr, "&quot;");
        } else if ("'".equals(escapeStr)) {
            str = str.replaceAll(escapeStr, "&acute;");
        }
        return str;
    }

    public static String restoreEscape(String str, String escapeStr) {
        if ("<".equals(escapeStr)) {
            str = str.replaceAll("&lt;", escapeStr);
        } else if (">".equals(escapeStr)) {
            str = str.replaceAll("&gt;", escapeStr);
        } else if (" ".equals(escapeStr)) {
            str = str.replaceAll("&nbsp;", escapeStr);
        } else if ("&".equals(escapeStr)) {
            str = str.replaceAll("&amp;", escapeStr);
        } else if ("\"".equals(escapeStr)) {
            str = str.replaceAll("&quot;", escapeStr);
        }
        return str;
    }

    public static String escape(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&#39;");
    }

    public static String restore(String str) {
        return str.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&#39;", "'").replaceAll("&amp;", "&");
    }

    public static String escapeSql(String str) {
        String escapedStr = StringUtils.replace((String)str, (String)"'", (String)"''");
        if (null == escapedStr) {
            return null;
        }
        StringBuilder escapedBuilder = new StringBuilder();
        int strLen = escapedStr.length();
        for (int i = 0; i < strLen; ++i) {
            char c = escapedStr.charAt(i);
            if (c == '%' || c == '_') {
                escapedBuilder.append('\\');
            }
            escapedBuilder.append(c);
        }
        return escapedBuilder.toString();
    }

    public static String decode(String encodedChar) {
        if (null == encodedChar) {
            return "";
        }
        return encodedChar.replaceAll("&quot;", "\"").replaceAll("&#39;", "'").replaceAll("&#96;", "`").replaceAll("&#37;", "%").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&#40;", "\\\\(").replaceAll("&#41;", "\\\\)").replaceAll("&#58;", ":").replaceAll("&#46;", ".");
    }
}

