/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    private static final int SIXTY = 60;
    private static final int THOUSAND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;

    public static synchronized String toUTCString(Date date) {
        if (null == date) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(date) + " UTC";
    }

    public static String toUTCString(long date) {
        return TimeUtil.toUTCString(new Date(date));
    }

    public static synchronized String toGMTString(Date date, TimeZone tz) {
        if (null == date || null == tz) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(tz);
        return df.format(date);
    }

    public static String toGMTString(long date, TimeZone tz) {
        return TimeUtil.toGMTString(new Date(date), tz);
    }

    public static synchronized String getTimeZoneOffset(TimeZone timeZone) {
        if (null == timeZone) {
            return null;
        }
        int rawOffset = timeZone.getRawOffset();
        String sign = rawOffset < 0 ? "-" : "+";
        int offset = Math.abs(rawOffset);
        int hour = offset / 3600000;
        int minute = offset % 3600000 / 60000;
        return MessageFormat.format("UTC{0}{1,number,00}:{2,number,00}", sign, hour, minute);
    }
}

