/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util.unit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;

public final class MathUtil {
    private static final int PRECISION_TWO = 2;
    private static final int PRECISION_ONE = 1;

    private MathUtil() {
    }

    public static double downScaleToDouble(double number, int ... scale) {
        int precision = 2;
        if (scale.length >= 1) {
            precision = scale[0];
        }
        BigDecimal bigDec = new BigDecimal(number);
        BigDecimal one = new BigDecimal(1);
        BigDecimal newBig = bigDec.divide(one, precision, 1);
        return newBig.doubleValue();
    }

    public static String downScaleToString(double number, int ... scale) {
        int precision = 2;
        if (scale.length >= 1) {
            precision = scale[0];
        }
        BigDecimal bigDec = new BigDecimal(number);
        BigDecimal one = new BigDecimal(1);
        BigDecimal newBig = bigDec.divide(one, precision, 1);
        return newBig.toString();
    }

    public static String computePercentNoSign(double p1, double p2, int scale) {
        String perCent = MathUtil.computePercent(p1, p2, scale);
        return perCent.replace("%", "");
    }

    public static String computePercent(double p1, double p2, int scale) {
        if (0.0 >= p2) {
            return "0";
        }
        double p3 = p1 / p2;
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(scale);
        nf.setRoundingMode(RoundingMode.DOWN);
        nf.setMaximumFractionDigits(scale);
        return nf.format(p3);
    }

    public static String computePercent(double p1, double p2) {
        return MathUtil.computePercent(p1, p2, 2);
    }

    public static String parseNumber(Object val, int ... precision) {
        return MathUtil.parseNumber(val, false, precision);
    }

    public static String parseNumber(Object val, boolean isGroupingUsed, int ... precision) {
        int max = 2;
        int min = 2;
        if (precision.length == 1) {
            max = precision[0];
        } else if (precision.length == 2) {
            max = precision[0];
            min = precision[1];
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.DOWN);
        nf.setMaximumFractionDigits(max);
        nf.setMinimumFractionDigits(min > max ? max : min);
        nf.setGroupingUsed(isGroupingUsed);
        return nf.format(val);
    }
}

