/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.host.sdk.model;

import com.huawei.ism.base.port.sdk.model.EthernetPort;
import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.util.CapacityUnitUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.host.sdk.model.HostFileSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Host
extends NetworkEntity {
    private static final long serialVersionUID = 3351041979172674559L;
    private static final double HUNDRED = 100.0;
    private String agentVersion;
    private String hostName;
    private String hostSN;
    private Integer hostStatus = 0;
    private Integer hostType = 0;
    private Integer cpuCoreNum = 0;
    private String cpuDesc;
    private Double cpuFrequency;
    private List<DatabaseInstance> databaseInstance;
    private List<Disk> hostDisks;
    private List<HostFileSystem> hostFiles;
    private List<EthernetPort> hostNetPorts;
    private List<Initiator> initiators;
    private String managedIpAddress;
    private Double memory;
    private String os;
    private String osVersion;
    private Double phisicalMemSize;
    private Double totalCapacity;
    private String totalCapacityUnit;
    private Double usedCapacity;
    private String usedCapacityUnit;
    private Double virtualMemSize;
    private String manufacturer;

    public Host() {
    }

    public Host(String mainType, String subType, String model) {
        this.setMainType(mainType);
        this.setSubType(subType);
        this.setProductModel(model);
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public Integer getCpuCoreNum() {
        return this.cpuCoreNum;
    }

    public String getCpuDesc() {
        return this.cpuDesc;
    }

    public Double getCpuFrequency() {
        return this.cpuFrequency;
    }

    public String getCpuFrequencyString() {
        return CapacityUnitUtil.formatValue(this.cpuFrequency);
    }

    public List<DatabaseInstance> getDatabaseInstance() {
        if (null == this.databaseInstance) {
            this.databaseInstance = new ArrayList<DatabaseInstance>();
        }
        return this.databaseInstance;
    }

    public List<EthernetPort> getHostNetPorts() {
        if (null == this.hostNetPorts) {
            this.hostNetPorts = new ArrayList<EthernetPort>();
        }
        return this.hostNetPorts;
    }

    public void setHostNetPorts(List<EthernetPort> hostNetPorts) {
        if (null == hostNetPorts) {
            hostNetPorts = new ArrayList<EthernetPort>();
        }
        this.getHostNetPorts().addAll(hostNetPorts);
    }

    public List<Initiator> getInitiators() {
        if (null == this.initiators) {
            this.initiators = new ArrayList<Initiator>();
        }
        return this.initiators;
    }

    public void setInitiators(List<Initiator> initiators) {
        if (null == initiators) {
            initiators = new ArrayList<Initiator>();
        }
        this.getInitiators().addAll(initiators);
    }

    public Integer getHostStatus() {
        return this.hostStatus;
    }

    public Integer getHostType() {
        return this.hostType;
    }

    public String getManagedIpAddress() {
        return this.managedIpAddress;
    }

    public Double getMemory() {
        return this.memory;
    }

    public String getOs() {
        return this.os;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public Double getPhisicalMemSize() {
        return this.phisicalMemSize;
    }

    public String getPhisicalMemSizeAndUnit() {
        return CapacityUnitUtil.getCapacityAndUnit(this.phisicalMemSize, CapabilityUnitType.MB);
    }

    public Double getTotalCapacity() {
        return this.totalCapacity;
    }

    public String getTotalCapacityUnit() {
        return this.totalCapacityUnit;
    }

    public Double getUsedCapacity() {
        return this.usedCapacity;
    }

    public String getUsedCapacityUnit() {
        return this.usedCapacityUnit;
    }

    public Double getVirtualMemSize() {
        return this.virtualMemSize;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public void setCpuCoreNum(Integer cpuCoreNum) {
        this.cpuCoreNum = cpuCoreNum == null ? Integer.valueOf(0) : cpuCoreNum;
    }

    public void setCpuDesc(String cpuDesc) {
        this.cpuDesc = cpuDesc;
    }

    public void setCpuFrequency(Double cpuFrequency) {
        this.cpuFrequency = cpuFrequency;
    }

    public void setDatabaseInstance(List<DatabaseInstance> databaseInstance) {
        if (null == databaseInstance) {
            databaseInstance = new ArrayList<DatabaseInstance>();
        }
        this.getDatabaseInstance().addAll(databaseInstance);
    }

    public List<Disk> getHostDisks() {
        if (null == this.hostDisks) {
            this.hostDisks = new ArrayList<Disk>();
        }
        return this.hostDisks;
    }

    public void setHostDisks(Collection<Disk> hostDisks) {
        if (null == hostDisks) {
            hostDisks = new ArrayList<Disk>();
        }
        this.getHostDisks().addAll(hostDisks);
    }

    public List<HostFileSystem> getHostFiles() {
        if (null == this.hostFiles) {
            this.hostFiles = new ArrayList<HostFileSystem>();
        }
        return this.hostFiles;
    }

    public void setHostFiles(Collection<HostFileSystem> hostFiles) {
        if (null == hostFiles) {
            hostFiles = new ArrayList<HostFileSystem>();
        }
        this.getHostFiles().addAll(hostFiles);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostSN() {
        return this.hostSN;
    }

    public void setHostSN(String hostSN) {
        this.hostSN = hostSN;
    }

    public void setHostStatus(Integer hostStatus) {
        this.hostStatus = hostStatus == null ? Integer.valueOf(0) : hostStatus;
    }

    public void setHostType(Integer hostType) {
        this.hostType = hostType == null ? Integer.valueOf(0) : hostType;
    }

    public void setManagedIpAddress(String managedIpAddress) {
        this.managedIpAddress = managedIpAddress;
    }

    public void setMemory(Double memory) {
        this.memory = memory;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setPhisicalMemSize(Double phisicalMemSize) {
        this.phisicalMemSize = phisicalMemSize;
    }

    public void setTotalCapacity(Double totalCapacity) {
        this.totalCapacity = totalCapacity;
    }

    public void setTotalCapacityUnit(String totalCapacityUnit) {
        this.totalCapacityUnit = totalCapacityUnit;
    }

    public void setUsedCapacity(Double usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    public void setUsedCapacityUnit(String usedCapacityUnit) {
        this.usedCapacityUnit = usedCapacityUnit;
    }

    public void setVirtualMemSize(Double virtualMemSize) {
        this.virtualMemSize = virtualMemSize;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Double getUsedCapacityRatio() {
        if (this.usedCapacity != null && this.totalCapacity != null && this.totalCapacity > 0.0) {
            Double ratio = this.usedCapacity / this.totalCapacity * 100.0;
            if (ratio > 100.0) {
                return 100.0;
            }
            return ratio;
        }
        return 0.0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.hostSN == null ? 0 : this.hostSN.hashCode());
        result = 31 * result + (this.totalCapacity == null ? 0 : this.totalCapacity.hashCode());
        result = 31 * result + (this.usedCapacity == null ? 0 : this.usedCapacity.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Host other = (Host)obj;
        return this.checkProp(other);
    }

    private boolean checkProp(Host other) {
        if (this.hostSN == null ? other.hostSN != null : !this.hostSN.equals(other.hostSN)) {
            return false;
        }
        if (!this.checkTotalCapacity(other)) {
            return false;
        }
        return this.checkYsedCapacity(other);
    }

    private boolean checkTotalCapacity(Host other) {
        return !(this.totalCapacity == null ? other.totalCapacity != null : !this.totalCapacity.equals(other.totalCapacity));
    }

    private boolean checkYsedCapacity(Host other) {
        return !(this.usedCapacity == null ? other.usedCapacity != null : !this.usedCapacity.equals(other.usedCapacity));
    }
}

