/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.cloud.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.rest.fusionsphere.adapt.IAdapter;
import com.huawei.ism.drm.rest.fusionsphere.adapt.IAdapterManager;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.cloud.model.CloudInformation;
import com.huawei.ism.drm.rest.fusionsphere.cloud.service.IFusionsphereRestService;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.FusionsphereUtil;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.RecoveryPlanPOIpSettingInfoExcelOperator;
import com.huawei.ism.drm.rest.fusionsphere.util.BaseRestUtils;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.poi.ss.usermodel.Workbook;

public class FusionsphereRestServiceImpl
extends AbsVRRestService
implements IFusionsphereRestService,
IAdapterManager {
    private static Log logger = LogFactory.getInstance(FusionsphereRestServiceImpl.class);
    private static final String DRM_BASE = "DRM_Base";
    private static final String RESOURCE_REFRESH_OPERATENAME = "resource_refresh_operateName";
    private static final String RESOURCE_REFRESH_OPERATEDETAIL = "resource_refresh_operateDetail";
    private Set<IAdapter> adapters = new HashSet<IAdapter>();

    @Override
    public void addAdapter(IAdapter adapter) {
        if (adapter != null) {
            this.adapters.add(adapter);
        }
    }

    @Override
    public String getFusionsphereBySite(String siteId) {
        logger.debug((Object)("FusionsphereRestServiceImpl:getFusionsphereBySite enter, siteId=" + siteId), 90160758786816L);
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("Parameter is empty, siteId=" + siteId), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)siteId)) {
            logger.error((Object)"SiteId is invalid, siteId: %s", new Object[]{siteId});
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(siteId);
        ArrayList<CloudInformation> cloudList = new ArrayList<CloudInformation>();
        ICloudService cloudService = (ICloudService)this.getBundleService("DRM_FusionShpere_Base", ICloudService.class.getName(), ICloudService.class);
        Page page = cloudService.pageQueryRegistedCloudsBySiteId(siteId, "name", 0, 1000, true, this.getCurrentUserId());
        logger.info((Object)("CloudAction: get CloudList from the site whose siteId = " + siteId), 90160758786816L);
        if (null != page) {
            ArrayList<CloudInformation> independRes;
            List resultList = page.getResult();
            Map<String, List<CloudInformation>> fcInFmMap = FusionsphereUtil.convertToCloudInfo(resultList, independRes = new ArrayList<CloudInformation>());
            if (VerifyUtil.isEmpty(fcInFmMap)) {
                cloudList.addAll(independRes);
            }
        } else {
            logger.warn((Object)("query cloud from site is null, siteId=" + siteId), 90160758787071L);
        }
        JSONArray cloudArray = FusionsphereUtil.parseCloudInfo(cloudList);
        JSONArray retArray = FusionsphereUtil.sortJsonArrayByName(cloudArray);
        logger.debug((Object)("FusionsphereRestServiceImpl:getFusionsphereBySite leave, size=" + retArray.size()), 90160758786816L);
        return retArray.toString();
    }

    @Override
    public Response refreshFusionsphere(String cloudSn) {
        logger.debug((Object)("FusionsphereRestServiceImpl:refreshFusionsphere enter, cloudSn=" + cloudSn), 90160758786816L);
        this.checkUserOperationAuthority(RESOURCE_REFRESH_OPERATENAME, 3, "ism.drm.site.resource.auth.management.operateID");
        if (VerifyUtil.isEmpty((String)cloudSn)) {
            logger.error((Object)("Parameter is empty, cloudSn=" + cloudSn), 90160758787071L);
            LegoCheckedException ex = new LegoCheckedException(1073947393L);
            this.generateRefreshCloudLog(null, ex);
            throw ex;
        }
        if (!ParamChecker.checkBase64((String)cloudSn)) {
            logger.error((Object)("Parameter invalid, cloudSn=" + cloudSn), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        String newCloudSn = BaseRestUtils.base64Decode(cloudSn);
        try {
            this.handleRefreshBussness(newCloudSn);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("refresh Cloud failed, cloudSn=" + newCloudSn), (Throwable)e, 90160758787071L);
            this.generateRefreshCloudLog(newCloudSn, e);
            throw e;
        }
        this.generateRefreshCloudLog(newCloudSn, null);
        logger.debug((Object)"FusionsphereRestServiceImpl:refreshFusionsphere leave.", 90160758786816L);
        return Response.ok().build();
    }

    private void handleRefreshBussness(String cloudSn) {
        this.checkUserResourceAuthority(cloudSn);
        ICloudService cloudService = (ICloudService)this.getBundleService("DRM_FusionShpere_Base", ICloudService.class.getName(), ICloudService.class);
        cloudService.refreshCloud(cloudSn, this.getCurrentUserName());
    }

    private void isRpEmpty(RecoveryPlan rp) {
        if (VerifyUtil.isEmpty((Object)rp)) {
            logger.error((Object)"rp is null.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
    }

    private void generateRefreshCloudLog(String cloudSn, LegoCheckedException ex) {
        String cloudName = "--";
        String cloudIp = "--";
        if (!VerifyUtil.isEmpty((String)cloudSn)) {
            try {
                NetworkEntity nEntity = this.getMo(NetworkEntity.class, "sn", cloudSn);
                if (null != nEntity) {
                    cloudName = nEntity.getName();
                    cloudIp = nEntity.getLinkIp();
                }
            }
            catch (Exception e) {
                logger.error((Object)("get cloud info failed, cloudSn=" + cloudSn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
        if (null != ex) {
            this.writeFailedOperationLogNoException(RESOURCE_REFRESH_OPERATENAME, 3, cloudName, (Exception)((Object)ex));
        } else {
            this.writeSucOperationLog(RESOURCE_REFRESH_OPERATENAME, 3, cloudName, RESOURCE_REFRESH_OPERATEDETAIL, new String[]{cloudName, cloudIp});
        }
    }

    @Override
    public Response exportProtectObjectIPSettingInfo(String planId) {
        logger.debug((Object)("RecoveryPlanRestServiceImpl:exportProtectObjectIPSettingInfo enter, planId=" + planId), 90160758786816L);
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"Failed to export excel, planId is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("recoveryPlan_exportProtectedObjectIPSettingInfo_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserAuthority(planId);
        IRecoveryPlanService recoveryplanservice = (IRecoveryPlanService)this.getBundleService(DRM_BASE, IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        RecoveryPlan rp = recoveryplanservice.getRecoveryPlan(planId);
        this.isRpEmpty(rp);
        try {
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            this.exportHelper(planId);
            this.writeSucOperationLog("recoveryPlan_exportProtectedObjectIPSettingInfo_operateName", SysoplogLevel.info.getValue(), rp.getName(), "", new String[0]);
        }
        catch (Exception le) {
            this.writeFailedOperationLog("recoveryPlan_exportProtectedObjectIPSettingInfo_operateName", SysoplogLevel.info.getValue(), rp.getName(), le);
        }
        return Response.ok().build();
    }

    private void exportHelper(String planId) {
        RecoveryPlanPOIpSettingInfoExcelOperator operator = new RecoveryPlanPOIpSettingInfoExcelOperator(this);
        FileOutputStream fileOutputStream = null;
        try {
            Workbook wb = operator.createExportExcel(planId);
            File excelFile = new File(this.getExportExcelFilePath());
            fileOutputStream = new FileOutputStream(excelFile);
            wb.write((OutputStream)fileOutputStream);
            operator.downloadFile(this.getResponse(), excelFile);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
            throw e;
        }
        catch (Exception ex) {
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e, 90160758784000L);
                }
            }
        }
    }

    public String getExportExcelFilePath() {
        boolean ret;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String exportExcelName = "ExportIPSettingInfo_" + df.format(new Date()) + ".xlsx";
        String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
        File file = new File(downloadPath);
        if (!file.exists() && !(ret = file.mkdir())) {
            logger.error((Object)"to creat dir failed.");
            throw new LegoCheckedException(-1L);
        }
        downloadPath = downloadPath + File.separator + exportExcelName;
        return downloadPath;
    }
}

