/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.cloud.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.sdk.model.CloudInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.rest.fusionsphere.cloud.model.CloudInformation;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.CompareJsonObjectByName;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.FusionsphereQueryPlanUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FusionsphereUtil {
    private static final Log logger = LogFactory.getInstance(FusionsphereUtil.class);

    private FusionsphereUtil() {
    }

    public static Map<String, List<CloudInformation>> convertToCloudInfo(List<CloudInfo> oriList, List<CloudInformation> destList) {
        logger.debug((Object)"convertToCloudInfo start");
        HashMap<String, List<CloudInformation>> rstMap = new HashMap<String, List<CloudInformation>>();
        if (null == oriList) {
            return rstMap;
        }
        for (CloudInfo drCloud : oriList) {
            CloudInformation cloudInfo = new CloudInformation();
            cloudInfo.setIp(drCloud.getIpAddress());
            cloudInfo.setPort(drCloud.getPort());
            cloudInfo.setCloudName(drCloud.getName());
            cloudInfo.setVersion(drCloud.getVersion());
            cloudInfo.setCloudStatus(String.valueOf(drCloud.getStatus()));
            cloudInfo.setCloudSn(drCloud.getDeviceSn());
            cloudInfo.setCloudType(FusionsphereUtil.getCloudTypeStr(drCloud.getResType()));
            cloudInfo.setCloudTypeBack(drCloud.getResType());
            cloudInfo.setParentResource(drCloud.getParentResource());
            if (drCloud.getResType().equals("DrVrm") && drCloud.getParentResource() != null) {
                ArrayList<CloudInformation> infrLst = (ArrayList<CloudInformation>)rstMap.get(drCloud.getParentResource());
                if (VerifyUtil.isEmpty((Collection)infrLst)) {
                    infrLst = new ArrayList<CloudInformation>();
                    rstMap.put(drCloud.getParentResource(), infrLst);
                }
                infrLst.add(cloudInfo);
                continue;
            }
            destList.add(cloudInfo);
        }
        return rstMap;
    }

    private static String getCloudTypeStr(String resType) {
        if ("DrFm".equals(resType)) {
            return "FusionManager";
        }
        if ("DrVrm".equals(resType)) {
            return "FusionCompute";
        }
        if ("DrFusionSphereOpenStack".equals(resType)) {
            return "OpenStack";
        }
        return "FusionCompute";
    }

    public static JSONArray parseCloudInfo(List<CloudInformation> cloudList) {
        logger.debug((Object)"parseCloudInfo start");
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty(cloudList)) {
            return array;
        }
        for (CloudInformation cloudInfo : cloudList) {
            if (null == cloudInfo) continue;
            array.add((Object)FusionsphereUtil.createBaseCloud(cloudInfo));
        }
        return array;
    }

    private static JSONObject createBaseCloud(CloudInformation cloudInfo) {
        logger.debug((Object)"createBaseCloud start");
        JSONObject object = new JSONObject();
        object.put((Object)"deviceSn", (Object)cloudInfo.getCloudSn());
        object.put((Object)"cloudName", (Object)cloudInfo.getCloudName());
        object.put((Object)"ipAddress", (Object)cloudInfo.getIp());
        object.put((Object)"port", (Object)cloudInfo.getPort());
        object.put((Object)"cloudStatus", (Object)cloudInfo.getCloudStatus());
        object.put((Object)"cloudType", (Object)cloudInfo.getCloudType());
        object.put((Object)"version", (Object)cloudInfo.getVersion());
        return object;
    }

    public static JSONArray sortJsonArrayByName(JSONArray jsonArray) {
        logger.debug((Object)"sortJsonArrayByName start");
        if (VerifyUtil.isEmpty((Collection)jsonArray)) {
            return jsonArray;
        }
        List list = jsonArray.subList(0, jsonArray.size());
        ArrayList<JSONObject> listsJsonObjects = new ArrayList<JSONObject>();
        for (Object obj : list) {
            listsJsonObjects.add(JSONObject.fromObject(obj));
        }
        Collections.sort(listsJsonObjects, new CompareJsonObjectByName("cloudName"));
        return FusionsphereQueryPlanUtil.changeJsonObjects(listsJsonObjects);
    }

    public static boolean isVmInProtectGroup(String vmUuid, ProtectGroup protectGroup, String cloudSn) {
        logger.debug((Object)"isVmInProtectGroup start");
        Set pos = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)pos)) {
            return false;
        }
        for (ProtectObject po : pos) {
            if (!vmUuid.equals(po.getMoUuid()) || !cloudSn.equals(po.getProviderSN())) continue;
            return true;
        }
        return false;
    }
}

