/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.cloud.util;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.vrm.model.IpAddress6;
import com.huawei.ism.drm.rest.fusionsphere.base.AbsVRRestService;
import com.huawei.ism.drm.rest.fusionsphere.cloud.service.FusionsphereRestServiceImpl;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RecoveryPlanPOIpSettingInfoExcelOperator {
    private static final String DRM_BASE = "DRM_Base";
    private static final int VM_COL_WIDTH = 8000;
    private static final int NIC_SET_COL_WIDTH = 6000;
    private static final int NET_COL_WIDTH = 4500;
    private static final int ROW_HEIGHT = 2000;
    private static final int ID_COL_WIDTH = 0;
    private static final int VRM_COL_NUM = 6;
    private static final int NIC_COL_NUM = 12;
    private static final int NIC_IPV6_COL_NUM = 20;
    private static final int IPV6_NULL_STRLENGTH_ONE = 26;
    private static final int IPV6_NULL_STRLENGTH_FIVE = 140;
    private static final Color BACK_GROUND = new Color(194, 214, 154);
    private static final int MOST_IPV6_NO = 5;
    private static final String DEFAULT_IP_SETTING = "N";
    private static Log logger = FELogFactory.getInstance((String)"ui");
    private AbsVRRestService fusionsphereRestService;

    public RecoveryPlanPOIpSettingInfoExcelOperator(FusionsphereRestServiceImpl fusionsphereRestService) {
        this.fusionsphereRestService = fusionsphereRestService;
    }

    public Workbook createExportExcel(String planId) {
        logger.debug((Object)"RecoveryPlanPOIpSettingInfoExcelOperator enter, to create Export Excel..");
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.ip.settings"));
        sheet.protectSheet("");
        this.createHeader(sheet);
        this.createDataArea(sheet, planId);
        sheet.setColumnWidth(0, 8000);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(2, 0);
        sheet.setColumnWidth(3, 0);
        sheet.setColumnWidth(4, 0);
        sheet.setColumnWidth(5, 6000);
        sheet.setColumnWidth(6, 6000);
        sheet.setColumnWidth(7, 4500);
        sheet.setColumnWidth(8, 4500);
        sheet.setColumnWidth(9, 4500);
        sheet.setColumnWidth(10, 6000);
        sheet.setColumnWidth(11, 6000);
        sheet.setColumnWidth(12, 6000);
        sheet.setColumnWidth(13, 6000);
        return wb;
    }

    private void createHeader(XSSFSheet sheet) {
        logger.debug((Object)"to create excel header..");
        XSSFCellStyle cs = this.createHeaderStyle(sheet);
        XSSFCellStyle csNote = this.createNoteStyle(sheet);
        XSSFRow row0 = sheet.createRow(0);
        XSSFRow row1 = sheet.createRow(1);
        XSSFRow row2 = sheet.createRow(2);
        row0.setHeight((short)2000);
        Cell cell = row0.createCell(0);
        String noteInfo = this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.notes") + "\n" + this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.notes.one") + "\n" + this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.notes.two") + "\n" + this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.notes.three") + "\n" + this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.notes.four") + "\n" + this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.notes.five") + "\n" + this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.notes.six");
        cell.setCellValue(noteInfo);
        cell.setCellStyle((CellStyle)csNote);
        CellRangeAddress cra = new CellRangeAddress(0, 0, 0, 13);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row1.createCell(0);
        cell.setCellValue(this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.vm.info"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(1, 1, 0, 5);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row1.createCell(6);
        cell.setCellValue(this.getText("com.huawei.ism.drm.rest.fusionsphere.cloud.util.config.network.info"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(1, 1, 6, 13);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        ArrayList<String> excelHeaderTextStrings = new ArrayList<String>();
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.protectobject.name");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.owning.protection.group");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.protectobject.id");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.recoveryplan.id");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.nic.sn");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.nic");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.enable.ipv4.address.settings");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.ip.type");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.ip.address");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.subnet.mask");
        String ipV6SubNetWorkLength = "com.huawei.ism.drm.rest.fusionsphere.cloud.util.ipv6.subnet.prefix";
        excelHeaderTextStrings.add(ipV6SubNetWorkLength);
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.default.gateway");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.primary.dns.server");
        excelHeaderTextStrings.add("com.huawei.ism.drm.rest.fusionsphere.cloud.util.secondary.dns.server");
        int colNumber = 0;
        for (String string : excelHeaderTextStrings) {
            cell = row2.createCell(colNumber);
            cell.setCellValue(this.getText(string));
            cell.setCellStyle((CellStyle)cs);
            cra = new CellRangeAddress(2, 2, colNumber, colNumber);
            this.setRangeBorder(sheet, cra);
            ++colNumber;
        }
    }

    private XSSFCellStyle createHeaderStyle(XSSFSheet sheet) {
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setFont((Font)font);
        return cs;
    }

    private XSSFCellStyle createNoteStyle(XSSFSheet sheet) {
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        cs.setAlignment(HorizontalAlignment.LEFT);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setFont((Font)font);
        cs.setWrapText(true);
        return cs;
    }

    private String getText(String string) {
        return this.fusionsphereRestService.getText(string);
    }

    private void setRangeBorder(XSSFSheet sheet, CellRangeAddress cra) {
        logger.debug((Object)"to set range border..");
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
    }

    private void createDataArea(XSSFSheet sheet, String planId) {
        XSSFCellStyle csDataLocked = this.createDataLockedAreaStyle(sheet);
        XSSFCellStyle csDataUnlocked = this.createDataUnlockedAreaStyle(sheet);
        int rowIndex = 3;
        String[] enableIpv4AddressSettings = new String[]{"Y", DEFAULT_IP_SETTING};
        String[] ipTypeSettings = new String[]{"IPV4", "IPV6"};
        List<Map<String, String>> dataMapList = this.getExcelNeedData(planId);
        dataMapList.addAll(this.getV6ExcelNeedData(planId));
        this.dataMapSort(dataMapList);
        for (int dataRow = 0; dataRow < dataMapList.size(); ++dataRow) {
            XSSFRow row = sheet.createRow(rowIndex + dataRow);
            Map<String, String> ipDataMap = dataMapList.get(dataRow);
            Cell[] cells = new Cell[14];
            for (int i = 0; i <= 13; ++i) {
                cells[i] = row.createCell(i);
            }
            cells[0].setCellValue(ipDataMap.get("protectobjectname"));
            cells[1].setCellValue(ipDataMap.get("protectgroupname"));
            cells[2].setCellValue(ipDataMap.get("protectobjectid"));
            cells[3].setCellValue(ipDataMap.get("planid"));
            cells[4].setCellValue(ipDataMap.get("nicsn"));
            cells[5].setCellValue(ipDataMap.get("nic"));
            cells[6].setCellValue(DEFAULT_IP_SETTING);
            Arrays.stream(Arrays.copyOfRange(cells, 0, 6)).forEach(cell -> cell.setCellStyle((CellStyle)csDataLocked));
            for (int zeroToFiveCol = 0; zeroToFiveCol < 6; ++zeroToFiveCol) {
                CellRangeAddress cra = new CellRangeAddress(rowIndex + dataRow, rowIndex + dataRow, zeroToFiveCol, zeroToFiveCol);
                this.setRangeBorder(sheet, cra);
            }
            String ipv6InfoStr = ipDataMap.get("ipv6InfoStr");
            if (!VerifyUtil.isEmpty((String)ipv6InfoStr)) {
                cells[7].setCellValue("IPV6");
                if (ipv6InfoStr.length() == 26) {
                    cells[8].setCellValue("");
                    Arrays.stream(Arrays.copyOfRange(cells, 10, 14)).forEach(cell -> cell.setCellValue(""));
                } else {
                    this.ipv6SetCellValue(cells, ipv6InfoStr, ipDataMap);
                }
            } else {
                this.ipv4SetCellValue(cells, ipDataMap);
            }
            Arrays.stream(Arrays.copyOfRange(cells, 6, 14)).forEach(cell -> cell.setCellStyle((CellStyle)csDataUnlocked));
            for (int sixToEleCol = 6; sixToEleCol < 12; ++sixToEleCol) {
                CellRangeAddress cra = new CellRangeAddress(rowIndex + dataRow, rowIndex + dataRow, sixToEleCol, sixToEleCol);
                this.setRangeBorder(sheet, cra);
            }
            this.setDropDownOptions(sheet, rowIndex, enableIpv4AddressSettings, dataRow, 6);
            this.setDropDownOptions(sheet, rowIndex, ipTypeSettings, dataRow, 7);
        }
    }

    private void dataMapSort(List<Map<String, String>> dataMapList) {
        dataMapList.sort((map1, map2) -> {
            boolean contain1 = map1.containsKey("ipv6InfoStr");
            boolean contain2 = map2.containsKey("ipv6InfoStr");
            return Boolean.compare(contain1, contain2);
        });
        dataMapList.sort((map1, map2) -> {
            String nic1 = (String)map1.get("nic");
            String nic2 = (String)map2.get("nic");
            return nic1.compareTo(nic2);
        });
        dataMapList.sort((map1, map2) -> {
            String po1 = (String)map1.get("protectobjectid");
            String po2 = (String)map2.get("protectobjectid");
            return po1.compareTo(po2);
        });
    }

    private void ipv6SetCellValue(Cell[] cells, String ipv6InfoStr, Map<String, String> ipDataMap) {
        List ipv6AddressList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)ipv6InfoStr), IpAddress6.class);
        if (null == ipv6AddressList) {
            logger.error((Object)"Ipv6AddressList is null.");
            throw new LegoCheckedException(2117645L);
        }
        ArrayList<String> ipList = new ArrayList<String>();
        ArrayList<String> subNetList = new ArrayList<String>();
        for (IpAddress6 ipAddress6 : ipv6AddressList) {
            ipList.add(ipAddress6.getIpv6Addr());
            subNetList.add(ipAddress6.getIpv6Prefix());
        }
        cells[8].setCellValue(RecoveryPlanPOIpSettingInfoExcelOperator.combineString(ipList, ","));
        cells[10].setCellValue(RecoveryPlanPOIpSettingInfoExcelOperator.combineString(subNetList, ","));
        String gatewayV6 = ipDataMap.get("gatewayV6");
        cells[11].setCellValue(gatewayV6 == null || "null".equals(gatewayV6) ? "" : gatewayV6);
        String setdnsV6 = ipDataMap.get("setdnsV6");
        cells[12].setCellValue(setdnsV6 == null || "null".equals(setdnsV6) ? "" : setdnsV6);
        String adddnsV6 = ipDataMap.get("adddnsV6");
        cells[13].setCellValue(adddnsV6 == null || "null".equals(adddnsV6) ? "" : adddnsV6);
    }

    private void ipv4SetCellValue(Cell[] cells, Map<String, String> ipDataMap) {
        cells[7].setCellValue("IPV4");
        String ip = ipDataMap.get("ip");
        cells[8].setCellValue(ip == null || "null".equals(ip) ? "" : ip);
        String netmask = ipDataMap.get("netmask");
        cells[9].setCellValue(netmask == null || "null".equals(netmask) ? "" : netmask);
        String gateway = ipDataMap.get("gateway");
        cells[11].setCellValue(gateway == null || "null".equals(gateway) ? "" : gateway);
        String setdns = ipDataMap.get("setdns");
        cells[12].setCellValue(setdns == null || "null".equals(setdns) ? "" : setdns);
        String adddns = ipDataMap.get("adddns");
        cells[13].setCellValue(adddns == null || "null".equals(adddns) ? "" : adddns);
    }

    private static String combineString(List<String> list, String split) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(split);
        }
        return sb.toString();
    }

    private void setDropDownOptions(XSSFSheet sheet, int rowIndex, String[] enableIpv4AddressSettings, int dataRow, int colume) {
        CellRangeAddressList addressList = new CellRangeAddressList(rowIndex + dataRow, rowIndex + dataRow, colume, colume);
        XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(sheet);
        XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(enableIpv4AddressSettings);
        XSSFDataValidation validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
        sheet.addValidationData((DataValidation)validation);
    }

    private XSSFCellStyle createDataUnlockedAreaStyle(XSSFSheet sheet) {
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setFillForegroundColor(new XSSFColor(BACK_GROUND));
        cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setLocked(false);
        return cs;
    }

    public List<Map<String, String>> getExcelNeedData(String planId) {
        ArrayList<Map<String, String>> dataToExcelList = new ArrayList<Map<String, String>>();
        IRecoveryPlanService recoveryplanservice = (IRecoveryPlanService)this.fusionsphereRestService.getBundleService(DRM_BASE, IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        RecoveryPlan plan = recoveryplanservice.queryRecoveryPlan(planId, true);
        if (null == plan) {
            logger.error((Object)("the plan is null, the planId is:" + planId));
            return dataToExcelList;
        }
        Set protectGroups = plan.getProtectGroups();
        if (null == protectGroups) {
            logger.error((Object)("the protectGroups of planId is null,the planId is:" + planId));
            return dataToExcelList;
        }
        return dataToExcelList;
    }

    private List<Map<String, String>> getV6ExcelNeedData(String planId) {
        ArrayList<Map<String, String>> dataToExcelList = new ArrayList<Map<String, String>>();
        IRecoveryPlanService recoveryplanservice = (IRecoveryPlanService)this.fusionsphereRestService.getBundleService(DRM_BASE, IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        RecoveryPlan plan = recoveryplanservice.queryRecoveryPlan(planId, true);
        if (null == plan) {
            logger.error((Object)("the plan is null, the planId is:" + planId));
            return dataToExcelList;
        }
        Set protectGroups = plan.getProtectGroups();
        if (null == protectGroups) {
            logger.error((Object)("the protectGroups of planId is null,the planId is:" + planId));
            return dataToExcelList;
        }
        return dataToExcelList;
    }

    private XSSFCellStyle createDataLockedAreaStyle(XSSFSheet sheet) {
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(HttpServletResponse response, File downloadFile) {
        if (downloadFile == null) {
            return;
        }
        String displayName = downloadFile.getName();
        response.setContentType("application/x-download");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, must-revalidate");
        response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadFile);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[bis.available()];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                logger.error((Object)"downloadFile", 653110170615808L);
            }
            catch (Throwable throwable) {
                RecoveryPlanPOIpSettingInfoExcelOperator.close(bis, bos, fileInput);
                if (!downloadFile.delete()) {
                    logger.error((Object)"delete file error", 653110170615808L);
                }
                throw throwable;
            }
            RecoveryPlanPOIpSettingInfoExcelOperator.close(bis, bos, fileInput);
            if (!downloadFile.delete()) {
                logger.error((Object)"delete file error", 653110170615808L);
            }
        }
        RecoveryPlanPOIpSettingInfoExcelOperator.close(bis, bos, fileInput);
        if (!downloadFile.delete()) {
            logger.error((Object)"delete file error", 653110170615808L);
        }
    }

    private static void close(BufferedInputStream bis, BufferedOutputStream bos, FileInputStream fileInput) {
        if (null != fileInput) {
            try {
                fileInput.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile", 653110170615808L);
            }
        }
    }
}

