/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.drp;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

public class CSVUtils {
    private static final Log LOGGER = LogFactory.getInstance(CSVUtils.class);

    public static void createCSVFile(List<String> headInfo, List<Object> infos, ByteArrayOutputStream baos) {
        if (null == baos || null == infos) {
            LOGGER.error((Object)"ByteArrayOutputStream or infos is NULL ", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        try {
            CSVUtils.writeHeader(headInfo, baos);
            CSVUtils.writeContent(infos, baos);
        }
        catch (IOException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Failed to createCSVFile.", (long)-1L, null, (Log)LOGGER);
        }
    }

    private static void writeHeader(List<String> headInfo, ByteArrayOutputStream baos) throws IOException {
        if (!VerifyUtil.isEmpty(headInfo)) {
            for (String headCol : headInfo) {
                CSVUtils.writeString(baos, headCol, false);
                if (headCol.equals(headInfo.get(headInfo.size() - 1))) continue;
                CSVUtils.writeString(baos, ",", false);
            }
            CSVUtils.writeString(baos, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeString(ByteArrayOutputStream dos, String data, boolean newLine) throws IOException {
        BufferedWriter bufferedWriter;
        block4: {
            bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)dos, "GB2312"));
                if (newLine) {
                    bufferedWriter.newLine();
                    break block4;
                }
                if (VerifyUtil.isEmpty((String)data)) {
                    bufferedWriter.write("");
                    break block4;
                }
                bufferedWriter.write(data);
            }
            catch (Throwable throwable) {
                CSVUtils.closeWriter(bufferedWriter);
                throw throwable;
            }
        }
        CSVUtils.closeWriter(bufferedWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeContent(List<Object> infos, ByteArrayOutputStream baos) throws IOException {
        try {
            for (Object info : infos) {
                CSVUtils.writeString(baos, info.toString(), false);
                CSVUtils.writeString(baos, null, true);
            }
        }
        finally {
            CSVUtils.closeOutPutStram(baos);
        }
    }

    private static void closeOutPutStram(OutputStream outputStream) {
        if (null != outputStream) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)("close stream exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
    }

    private static void closeWriter(Writer wt) {
        if (null != wt) {
            try {
                wt.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)("close writer exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
    }
}

