/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.drp;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.constant.cloudenum.ProtectTypeEnum;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GalaxVMRecoveryProxy {
    private static final int POLICY_TEMPLATE_TYPE_HOST_REPLICATION = 11;
    private RecoveryPlan plan;

    public GalaxVMRecoveryProxy(RecoveryPlan plan) {
        this.plan = plan;
    }

    public String getRepBundleName() {
        ProtectGroup pg = this.getProtectGroup();
        if (VerifyUtil.isEmpty((Object)pg)) {
            return "";
        }
        PolicyTemplate pt = pg.getTemplate();
        if (VerifyUtil.isEmpty((Object)pt)) {
            return "";
        }
        switch (pt.getType()) {
            case 11: {
                return "DRM_FusionShpere_HRA";
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 33: {
                return "DRM_FusionShpere_SRA";
            }
        }
        return "";
    }

    public String getProtectReplicationType() {
        PolicyTemplate pt = this.getProtectGroup().getTemplate();
        switch (pt.getType()) {
            case 11: {
                return ProtectTypeEnum.HOST_REPLICATION.getType();
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 33: {
                return ProtectTypeEnum.STORAGE_ARRAY.getType();
            }
        }
        return "";
    }

    private ProtectGroup getProtectGroup() {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)this.plan.getProtectGroups());
        if (null == pg) {
            throw new LegoCheckedException("pg in rp is empty, planId=" + this.plan.getPlanId());
        }
        return pg;
    }

    public List<ProtectObject> getPos() {
        return new ArrayList<ProtectObject>(this.getProtectGroup().getPolist());
    }

    public String getRecoverySiteId() {
        Set pgrSet = this.getProtectGroup().getReplicaList();
        Iterator iterator = pgrSet.iterator();
        if (iterator.hasNext()) {
            ProtectGroupReplica pgr = (ProtectGroupReplica)iterator.next();
            return pgr.getRecoverySite();
        }
        return "";
    }
}

