/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.csha;

import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.connector.http.RequestInvocation;
import com.huawei.sdk.connector.http.RestHttpClient;
import com.huawei.sdk.connector.utils.RequestUtil;
import com.huawei.sdk.csha.model.RecoveryPolicy;
import com.huawei.sdk.csha.model.request.CshaInstanceSearchReq;
import com.huawei.sdk.csha.model.response.CshaInstanceDetail;
import com.huawei.sdk.csha.model.response.CshaInstanceProgress;
import com.huawei.sdk.csha.model.response.ListCshaInstanceResponse;
import com.huawei.sdk.csha.model.response.ListCshaInstanceServerResponse;
import java.io.IOException;

public class CshaClient {
    private static final String BASE_URL = "ws/bcs/";
    private static final String INSTANCE_URL = "/instances/";

    public void hotMigration(String serviceInstanceId, RecoveryPolicy recoveryPolicy, Credential credential) throws ResponseException, ClientException, IOException {
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(BASE_URL + credential.getProjectId() + INSTANCE_URL + serviceInstanceId + "/action/hotMigration");
        invocation.setEntity((Object)recoveryPolicy);
        RestHttpClient client = new RestHttpClient(credential);
        client.post(invocation);
    }

    public void plannedMigration(String serviceInstanceId, RecoveryPolicy recoveryPolicy, Credential credential) throws ResponseException, ClientException, IOException {
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(BASE_URL + credential.getProjectId() + INSTANCE_URL + serviceInstanceId + "/action/plannedMigration");
        invocation.setEntity((Object)recoveryPolicy);
        RestHttpClient client = new RestHttpClient(credential);
        client.post(invocation);
    }

    public void disasterRecovery(String serviceInstanceId, RecoveryPolicy recoveryPolicy, Credential credential) throws ResponseException, ClientException, IOException {
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(BASE_URL + credential.getProjectId() + INSTANCE_URL + serviceInstanceId + "/action/diasterRecovery");
        invocation.setEntity((Object)recoveryPolicy);
        RestHttpClient client = new RestHttpClient(credential);
        client.post(invocation);
    }

    public void reProtection(String serviceInstanceId, RecoveryPolicy recoveryPolicy, Credential credential) throws ResponseException, ClientException, IOException {
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(BASE_URL + credential.getProjectId() + INSTANCE_URL + serviceInstanceId + "/action/reprotect");
        invocation.setEntity((Object)recoveryPolicy);
        RestHttpClient client = new RestHttpClient(credential);
        client.post(invocation);
    }

    public ListCshaInstanceResponse getCshaInstanceList(CshaInstanceSearchReq searchReq, Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(BASE_URL + credential.getProjectId() + "/instances?" + RequestUtil.buildQueryParamsStr((Object)searchReq));
        return (ListCshaInstanceResponse)client.get(invocation, ListCshaInstanceResponse.class);
    }

    public CshaInstanceDetail getCshaInstanceDetail(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(BASE_URL + credential.getProjectId() + INSTANCE_URL + serviceInstanceId);
        return (CshaInstanceDetail)client.get(invocation, CshaInstanceDetail.class);
    }

    public ListCshaInstanceServerResponse getCshaInstanceServers(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(BASE_URL + credential.getProjectId() + INSTANCE_URL + serviceInstanceId + "/servers");
        return (ListCshaInstanceServerResponse)client.get(invocation, ListCshaInstanceServerResponse.class);
    }

    public CshaInstanceProgress getCshaInstanceProgress(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(BASE_URL + credential.getProjectId() + INSTANCE_URL + serviceInstanceId + "/progress");
        return (CshaInstanceProgress)client.get(invocation, CshaInstanceProgress.class);
    }
}

