/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.constant.coreenum;

import java.util.Locale;

public class ServiceInstaceEnumDefine {

    public static enum SERVICEINSTANCE_OPERATE_TYPE {
        ADD_INSTANCE("add_instance"),
        ADD_SERVERS("add_servers"),
        ADD_VOLUMES("add_volumes"),
        DEL_INSTANCE("del_instance"),
        DEL_SERVERS("del_servers"),
        DEL_VOLUMES("del_volumes"),
        UPGRADE_INSTANCE("upgrade_instance"),
        DOWNGRADE_INSTANCE("downgrade_instance");

        private String value;

        private SERVICEINSTANCE_OPERATE_TYPE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isCurrent(String opType) {
            return this.getValue().equalsIgnoreCase(opType);
        }
    }

    public static enum SERVICEINSTANCE_ORDEREXECUTE_STATUS_E {
        EXECUTING("executing"),
        SUCCESSED("successed"),
        FAILED("failed");

        private String value;

        private SERVICEINSTANCE_ORDEREXECUTE_STATUS_E(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SERVICEINSTANCE_REPLICATION_TYPE_E {
        SYNCHRONIZE("synchronize"),
        ASYNCHRONIZE("asynchronize");

        private String value;

        private SERVICEINSTANCE_REPLICATION_TYPE_E(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SERVICEINSTANCE_TYPE_E {
        HYPERMETRO("hypermetro", "csha"),
        REPLICATION("replication", "csdr"),
        VHA("vha", "vha"),
        VHA_REPLICATION("hyperMetroReplication", "vha_csdr"),
        CSHA_REPLICATION("IntraCityHyperMetroReplication", "csha_csdr");

        private String value;
        private String frontValue;

        private SERVICEINSTANCE_TYPE_E(String value, String frontValue) {
            this.value = value;
            this.frontValue = frontValue;
        }

        public String getValue() {
            return this.value;
        }

        public String getFrontValue() {
            return this.frontValue;
        }

        public static SERVICEINSTANCE_TYPE_E getTypeFromValue(String value) {
            for (SERVICEINSTANCE_TYPE_E type : SERVICEINSTANCE_TYPE_E.values()) {
                if (!type.isCurrent(value)) continue;
                return type;
            }
            return null;
        }

        public static String getServiceIdFromServiceType(String value) {
            SERVICEINSTANCE_TYPE_E type = SERVICEINSTANCE_TYPE_E.getTypeFromValue(value);
            if (type != null) {
                return type.getFrontValue();
            }
            return null;
        }

        public static String getFrontInstanceType(String instanceProtectType) {
            if (instanceProtectType == null) {
                return "";
            }
            SERVICEINSTANCE_TYPE_E typeEnum = SERVICEINSTANCE_TYPE_E.getTypeFromValue(instanceProtectType);
            if (typeEnum == null) {
                return "";
            }
            if (typeEnum == VHA_REPLICATION || typeEnum == CSHA_REPLICATION) {
                return REPLICATION.getFrontValue().toUpperCase(Locale.ENGLISH);
            }
            return typeEnum.getFrontValue().toUpperCase(Locale.ENGLISH);
        }

        public boolean isCurrent(String instanceType) {
            return this.getValue().equals(instanceType) || this.getFrontValue().equals(instanceType);
        }
    }

    public static enum SERVICEINSTANCE_STATUS_E {
        NORMAL("normal"),
        DELETING("deleting"),
        ERR_DELETE("err-delete"),
        LOCKED("locked"),
        PLANED_MIGRATION_RUNNING("switchovering"),
        PLANED_MIGRATION_FAILED("err-switchover"),
        PLANED_MIGRATION_COMPLETED("switchoverd"),
        PLANED_MIGRATION_PAUSED("paused-switchover"),
        HOT_MIGRATION_RUNNING("hotmigrationing"),
        HOT_MIGRATION_FAILED("err-hotmigration"),
        DISASTER_RECOVERY_RUNNING("failovering"),
        DISASTER_RECOVERY_COMPLETED("failovered"),
        DISASTER_RECOVERY_FAILED("err-failover"),
        REPROTECT_FAILED("err-reprotect"),
        REPROTECT_RUNNING("reprotecting"),
        TESTING("testing"),
        ERR_TEST("err-test"),
        TESTED("tested"),
        CLEARING("clearing"),
        ERR_CLEAR("err-clear"),
        MAINTAIN("maintain"),
        ERR_MODIFY_TYPE("err-modify-type");

        private String value;

        private SERVICEINSTANCE_STATUS_E(String value) {
            this.value = value;
        }

        public static SERVICEINSTANCE_STATUS_E getType(String value) {
            SERVICEINSTANCE_STATUS_E enumType = null;
            for (SERVICEINSTANCE_STATUS_E type : SERVICEINSTANCE_STATUS_E.values()) {
                if (!type.getValue().equals(value)) continue;
                enumType = type;
                break;
            }
            return enumType;
        }

        public String getValue() {
            return this.value;
        }
    }
}

