/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.sdk.model;

import com.huawei.ism.drm.common.sdk.model.ProcessDefinitionTemplate;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import java.util.Map;

public class RecoveryProcessDefTemplate
extends ProcessDefinitionTemplate {
    public static final String PLAN_EXEC_TYPE_KEY = "procType";
    public static final String APP_TYPE_KEY = "appType";
    public static final String REPLICATION_TYPE_KEY = "protectionType";
    public static final String RECOVERY_TARGET_TYPE = "recoveryTargetType";
    public static final String VERSION_KEY = "version";

    public static String generateTemplateKey(DrmEnumDefine.APP_TYPE appType, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType, int repType) {
        return RecoveryProcessDefTemplate.generateTemplateKey(appType, execType, repType, null);
    }

    public static String generateTemplateKey(DrmEnumDefine.APP_TYPE appType, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType, int protectionType, DrmEnumDefine.RECOVERY_TARGET_TYPE recoveryTargetType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(appType.getValue());
        buffer.append(":");
        buffer.append(execType.getValue());
        buffer.append(":");
        buffer.append(protectionType);
        if (null != recoveryTargetType) {
            buffer.append(":");
            buffer.append(recoveryTargetType.getType());
        }
        return buffer.toString();
    }

    @Override
    public String getTemplateKey() {
        Map<String, String> processKeys = this.getProcessKeys();
        String appType = processKeys.get(APP_TYPE_KEY);
        String execType = processKeys.get(PLAN_EXEC_TYPE_KEY);
        String repType = processKeys.get(REPLICATION_TYPE_KEY);
        String recoveryTargetType = processKeys.get(RECOVERY_TARGET_TYPE);
        StringBuffer buffer = new StringBuffer();
        buffer.append(appType);
        buffer.append(":");
        buffer.append(execType);
        buffer.append(":");
        buffer.append(repType);
        if (null != recoveryTargetType) {
            buffer.append(":");
            buffer.append(recoveryTargetType);
        }
        return buffer.toString();
    }

    public boolean equals(Object template) {
        if (null == template) {
            return false;
        }
        if (!(template instanceof RecoveryProcessDefTemplate)) {
            return false;
        }
        Map<String, String> processKeys = this.getProcessKeys();
        String appType = processKeys.get(APP_TYPE_KEY);
        String execType = processKeys.get(PLAN_EXEC_TYPE_KEY);
        String repType = processKeys.get(REPLICATION_TYPE_KEY);
        String recoveryTargetType = processKeys.get(RECOVERY_TARGET_TYPE);
        Map<String, String> objProcessKeys = ((RecoveryProcessDefTemplate)template).getProcessKeys();
        String objAppType = objProcessKeys.get(APP_TYPE_KEY);
        String objExecType = objProcessKeys.get(PLAN_EXEC_TYPE_KEY);
        String objRepType = objProcessKeys.get(REPLICATION_TYPE_KEY);
        String objRecoveryTargetType = objProcessKeys.get(RECOVERY_TARGET_TYPE);
        boolean isEqual = null != appType && null != objAppType && appType.equals(objAppType);
        isEqual = isEqual && null != execType && null != objExecType && execType.equals(objExecType);
        isEqual = isEqual && null != repType && null != objRepType && repType.equals(objRepType);
        isEqual = isEqual && null != recoveryTargetType && null != objRecoveryTargetType && recoveryTargetType.equals(objRecoveryTargetType);
        return isEqual;
    }

    public int hashCode() {
        return this.getTemplateKey().hashCode();
    }
}

