/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.schedule.sdk.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ScheduleProtectedType {
    SNAPSHOT(2),
    HYPERCDP(100),
    CLOUD_BACKUP(101),
    NAS_SNAPSHOT(14),
    NAS_HYPERVAULT(17),
    NAS_HYPERMETROVAULT(28);

    public static final Map<Integer, Integer> SCHEDULE_TO_LOCAL_REPLICA_MAP;
    private int value;

    private ScheduleProtectedType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static Set<Integer> getAllProtectedTypes() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (ScheduleProtectedType type : ScheduleProtectedType.values()) {
            set.add(type.getValue());
        }
        return set;
    }

    public static boolean isSameType(int replicaType, int protectedType) {
        if (protectedType == -1) {
            return true;
        }
        Integer type = SCHEDULE_TO_LOCAL_REPLICA_MAP.get(protectedType);
        if (null == type) {
            return false;
        }
        return type == replicaType;
    }

    static {
        SCHEDULE_TO_LOCAL_REPLICA_MAP = new HashMap<Integer, Integer>();
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(SNAPSHOT.getValue(), 3);
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(HYPERCDP.getValue(), 4);
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(CLOUD_BACKUP.getValue(), 101);
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(16, 5);
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(14, 8);
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(1, 2);
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(NAS_SNAPSHOT.getValue(), 8);
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(NAS_HYPERVAULT.getValue(), 3);
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(NAS_HYPERMETROVAULT.getValue(), 3);
    }
}

