/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.template.sdk.service;

import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemlate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPolicyTemplateFilter
extends AbstractPolicyTemlate
implements IPolicyTemplateFilter {
    public static final String CONCURRENT_3DC = "CONCURRENT_3DC";
    public static final String SITE_A_3DC = "SITE_A_3DC";
    public static final String SITE_B_3DC = "SITE_B_3DC";
    public static final String SITE_C_3DC = "SITE_C_3DC";
    public static final String PO_LIST = "PO_LIST";
    public static final String PRODUCT_DEVSN = "PRODUCT_DEVSN";
    public static final String TARGET_DEVSN = "TARGET_DEVSN";
    public static final String POLICY_TEMPLATE_CONTEXT = "temp_policy_template_context";
    private static final Log logger = LogFactory.getInstance(AbstractPolicyTemplateFilter.class);
    private ThreadLocal<Map<String, Object>> filterContext = new AbstractPolicyTemlate.ThreadLocalMapContainer<String, Object>();

    public Map<String, Object> getFilterContext() {
        return this.filterContext.get();
    }

    protected String getDevAndLun(String deviceId, String lunId) {
        return deviceId + ":" + lunId;
    }

    protected String checkSameSrcDevice(List<ProtectObject> protectObjectSet) {
        HashSet<String> providerSN = new HashSet<String>();
        String arraySn = "";
        for (ProtectObject po : protectObjectSet) {
            for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
                arraySn = info.getResourceProviderSN();
                providerSN.add(arraySn);
            }
        }
        if (providerSN.isEmpty()) {
            logger.error((Object)"System database not hava ProtectObject's storage resource message", 90160758786897L);
            throw new LegoCheckedException(1073947719L);
        }
        if (providerSN.size() != 1) {
            logger.error((Object)("The ProtectObject's device not the same" + StringUtil.arrayToString((Object[])providerSN.toArray())), 90160758786897L);
            throw new LegoCheckedException(1073948192L);
        }
        return arraySn;
    }

    protected List<ProtectObjectStorageInfo> getAllStorageInfo(List<ProtectObject> protectObjects) {
        ArrayList<ProtectObjectStorageInfo> allInfo = new ArrayList<ProtectObjectStorageInfo>();
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty(po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                if (allInfo.contains(posi)) continue;
                allInfo.add(posi);
            }
        }
        return allInfo;
    }

    protected String getSetStr(Set<String> set) {
        StringBuilder sbBuilder = new StringBuilder();
        if (VerifyUtil.isEmpty(set)) {
            return sbBuilder.toString();
        }
        for (String str : set) {
            sbBuilder.append(str).append(",");
        }
        sbBuilder.replace(sbBuilder.length() - 1, sbBuilder.length(), "");
        return sbBuilder.toString();
    }

    @Override
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        return null;
    }

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        return false;
    }

    public List<ProtectLocationPath> getReplicationProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatchWithoutReplica(protectObjects);
        String productDevSn = (String)this.getFilterContext().get(PRODUCT_DEVSN);
        String targetDevSn = (String)this.getFilterContext().get(TARGET_DEVSN);
        String productSite = this.getSiteByArraySn(productDevSn);
        String targetSite = this.getSiteByArraySn(targetDevSn);
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.PROTECT_LOCATION.A.getValue(), productDevSn, productSite, productDevSn, productSite));
        path.add(this.constructSitePath(DrmEnumDefine.PROTECT_LOCATION.A_B.getValue(), productDevSn, productSite, targetDevSn, targetSite));
        return path;
    }

    protected String getSiteByArraySn(String deviceSN) {
        Site site = this.getSiteByDeviceSN(deviceSN);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("getSiteByArraySn error, site is null, deviceSN:" + deviceSN), 90160758787071L);
            return null;
        }
        return site.getSiteId();
    }

    protected Site getSiteByDeviceSN(String deviceSN) {
        if (VerifyUtil.isEmpty((String)deviceSN)) {
            logger.error((Object)("deviceSN is empty!deviceSN:" + deviceSN));
            return null;
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            return this.getSiteService().getSiteById(drResource.getSiteId());
        }
        return null;
    }

    protected ProtectLocationPath constructSitePath(int location, String productDevSn, String productSite, String targetDevSn, String targetSite) {
        logger.debug((Object)("constructSitePath.location:" + location + ",productDevSn:" + productDevSn + ",productSite:" + productSite + ",targetDevSn:" + targetDevSn));
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        ProtectLocationPath protectLocation = new ProtectLocationPath();
        protectLocation.setProtectLocation(location);
        protectLocation.setProtectedStorageSN(productDevSn);
        protectLocation.setRecoveryStorageSN(targetDevSn);
        protectLocation.setProtectedSiteId(productSite);
        protectLocation.setRecoverySiteId(targetSite);
        protectLocation.setProtectedSiteName(siteService.getSiteById(productSite).getName());
        protectLocation.setRecoverySiteName(siteService.getSiteById(targetSite).getName());
        return protectLocation;
    }
}

