/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.sdk.model;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FtpServerInfo
implements Serializable {
    private static final long serialVersionUID = -4573656330013602485L;
    private String ftpServerId;
    private String ip;
    private String ftpUserName;
    private String ftpPassword;
    private String dataPassword;
    private int port;
    private boolean autoBackupFlag;
    private String runTime;
    private String baseDir;
    private int maxStoredDay;
    private String hostKey;

    public String getDataPassword() {
        return this.dataPassword;
    }

    public void setDataPassword(String dataPassword) {
        this.dataPassword = dataPassword;
    }

    public String getFtpUserName() {
        return this.ftpUserName;
    }

    public void setFtpUserName(String ftpUserName) {
        this.ftpUserName = ftpUserName;
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public void setFtpPassword(String ftpPassword) {
        this.ftpPassword = ftpPassword;
    }

    public String getFtpServerId() {
        return this.ftpServerId;
    }

    public void setFtpServerId(String ftpServerId) {
        this.ftpServerId = ftpServerId;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isAutoBackupFlag() {
        return this.autoBackupFlag;
    }

    public void setAutoBackupFlag(boolean autoBackupFlag) {
        this.autoBackupFlag = autoBackupFlag;
    }

    public String getRunTime() {
        return this.runTime;
    }

    public void setRunTime(String runTime) {
        this.runTime = runTime;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public int getMaxStoredDay() {
        return this.maxStoredDay;
    }

    public void setMaxStoredDay(int maxStoredDay) {
        this.maxStoredDay = maxStoredDay;
    }

    public String getHostKey() {
        return this.hostKey;
    }

    public void setHostKey(String hostKey) {
        this.hostKey = hostKey;
    }

    public void update(FtpServerInfo info, boolean ftpPwdChange, boolean dataPwdChange) {
        this.ip = info.getIp();
        this.ftpUserName = info.getFtpUserName();
        if (ftpPwdChange) {
            this.ftpPassword = info.getFtpPassword();
        }
        if (dataPwdChange) {
            this.dataPassword = info.getDataPassword();
        }
        this.port = info.getPort();
        this.autoBackupFlag = info.isAutoBackupFlag();
        this.hostKey = info.getHostKey();
    }

    public void update(FtpServerInfo info) {
        this.baseDir = info.getBaseDir();
        this.ip = info.getIp();
        this.ftpUserName = info.getFtpUserName();
        this.ftpPassword = info.getFtpPassword();
        this.port = info.getPort();
        this.autoBackupFlag = info.isAutoBackupFlag();
        this.hostKey = info.getHostKey();
    }

    public boolean isParaValid(boolean changePwd) {
        if (VerifyUtil.isEmpty((String)this.ftpUserName) || VerifyUtil.isEmpty((String)this.ftpServerId) && VerifyUtil.isEmpty((String)this.ftpPassword)) {
            return false;
        }
        if (this.checkPassword(changePwd)) {
            return false;
        }
        if (null != this.ftpUserName && !this.between(this.ftpUserName.length(), 1, 255)) {
            return false;
        }
        if (VerifyUtil.isEmpty((String)this.runTime) || VerifyUtil.isEmpty((String)this.baseDir) || VerifyUtil.isEmpty((Object)this.maxStoredDay)) {
            return false;
        }
        String ipType = AddressUtil.ipType((String)this.ip);
        boolean isValidIP = false;
        if ("IPV4".equals(ipType)) {
            if (this.isIpValid()) {
                isValidIP = true;
            }
        } else if ("IPV6".equals(ipType)) {
            if (Ipv6AddressUtil.isValidIPv6((String)this.ip)) {
                isValidIP = true;
            }
        } else {
            isValidIP = false;
        }
        return this.isPortValid() && isValidIP && this.isAutoBackFlagValid();
    }

    private boolean checkPassword(boolean changePwd) {
        return changePwd && null != this.ftpPassword && !this.between(this.ftpPassword.length(), 1, 512);
    }

    private boolean between(int n, int s, int e) {
        return s <= n && n <= e;
    }

    private boolean isIpValid() {
        if (VerifyUtil.isEmpty((String)this.ip) || this.ip.startsWith("127")) {
            return false;
        }
        String reg = "(([1-9])|([1-9]\\d)|([1]\\d{2})|(22[0-3])|(2[0-1]\\d))(\\.((\\d)|([1-9]\\d)|([1]\\d{2})|([2][0-4]\\d)|([2][5][0-5]))){2}(\\.(([1-9])|([1-9]\\d)|([1]\\d{2})|([2][0-4]\\d)|([2][5][0-5])))";
        Matcher matcher = Pattern.compile(reg).matcher(Normalizer.normalize(this.ip, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    private boolean isAutoBackFlagValid() {
        return !VerifyUtil.isEmpty((Object)this.autoBackupFlag);
    }

    private boolean isPortValid() {
        if (VerifyUtil.isEmpty((Object)this.port)) {
            return false;
        }
        return this.port >= 1 && this.port <= 65535;
    }
}

