/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public final class RecoveryOperationController {
    private static Log logger = LogFactory.getInstance(RecoveryOperationController.class);
    private static final int IS_ALLOWED = 0;
    private static final int IS_FORBIDDEN = 1;
    private static final int IS_NA = 3;
    private static Map<String, Integer> operationStatusMap = new HashMap<String, Integer>();

    private RecoveryOperationController() {
    }

    public static void checkOperation(DrmEnumDefine.RECOVERY_PLAN_STATUS_E status, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE operation) {
        if (RecoveryOperationController.isForbidden(status, operation)) {
            throw new LegoCheckedException(1073948693L);
        }
    }

    public static boolean isForbidden(DrmEnumDefine.RECOVERY_PLAN_STATUS_E status, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE operation) {
        if (null == status || null == operation) {
            String errorMsg = "RecoveryPlan status or operation is null.";
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        String key = RecoveryOperationController.generateKey(status, operation);
        if (!operationStatusMap.containsKey(key)) {
            String errorMsg = "The RecoveryPlan status operation map is not configured";
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        return 0 != operationStatusMap.get(key);
    }

    private static String generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E status, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE operation) {
        return status.getValue() + ":" + operation.getValue();
    }

    static {
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.HOT_MIGRATION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.HOT_MIGRATION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.HOT_MIGRATION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.HOT_MIGRATION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.HOT_MIGRATION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_PAUSED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.HOT_MIGRATION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.HOT_MIGRATION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_RUNNING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MODIFY_BASIC_INFO), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SNAPSHOT_ROLLBACK), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 3);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.SWAP_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.SWAP), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNTING_REPLICA, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNTING_REPLICA, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.UMOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.UMOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.UMOUNT_REPLICA), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.UMOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNTING_REPLICA, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.UMOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNTING_REPLICA, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.UMOUNT_REPLICA), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DELETE_RECOVERY_PLAN), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNTING_REPLICA, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNTING_REPLICA, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.EDIT_RECOVERY_PROCESSOR), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 0);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNTING_REPLICA, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNTING_REPLICA, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.MOUNT_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
        operationStatusMap.put(RecoveryOperationController.generateKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.UMOUNT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.MOIFY_RECOVERY_SETTING), 1);
    }
}

