/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.openstack;

import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.rest.fusionsphere.openstack.UpdateProtectGroupVolumeInfo;
import com.huawei.ism.drm.rest.fusionsphere.openstack.model.RegionConfigVo;
import com.huawei.ism.drm.rest.fusionsphere.openstack.model.RegionVO;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public interface IOpenStackRestService {
    @POST
    @Path(value="/volumes/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getVmVolumeInfo(@QueryParam(value="regionId") String var1, @QueryParam(value="projectId") String var2, Set<String> var3);

    @GET
    @Path(value="/{openstackId}/volumeTypes")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String getVolumeType(@QueryParam(value="regionId") String var1, @QueryParam(value="projectId") String var2, @QueryParam(value="srcRegionId") String var3, @QueryParam(value="srcProjectId") String var4, @QueryParam(value="srcVolumeTypeName") String var5);

    @GET
    @Path(value="/{openstackId}/regions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String queryOpenstackRegions(@PathParam(value="openstackId") String var1);

    @POST
    @Path(value="/{openstackId}/regions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addOpenstackRegions(@PathParam(value="openstackId") String var1, List<RegionVO> var2);

    @PUT
    @Path(value="/{openstackId}/regions/{regionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateOpenstackRegions(@PathParam(value="openstackId") String var1, @PathParam(value="regionId") String var2, RegionVO var3);

    @DELETE
    @Path(value="/{openstackId}/regions/{regionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteOpenstackRegions(@PathParam(value="openstackId") String var1, @PathParam(value="regionId") String var2);

    @GET
    @Path(value="/{openstackId}/regions/{regionId}/configs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String queryOpenstackRegionsConfigs(@PathParam(value="openstackId") String var1, @PathParam(value="regionId") String var2);

    @PUT
    @Path(value="/{openstackId}/regions/{regionId}/configs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateOpenstackRegionsConfigs(@PathParam(value="openstackId") String var1, @PathParam(value="regionId") String var2, RegionConfigVo var3);

    @GET
    @Path(value="/{openstackId}/projects")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String queryOpenstackProjects(@PathParam(value="openstackId") String var1, @QueryParam(value="enabled") Boolean var2);

    @GET
    @Path(value="/{openstackId}/availabilityZones")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String queryOpenstackAZs(@PathParam(value="openstackId") String var1, @QueryParam(value="regionId") String var2, @QueryParam(value="projectId") String var3, @QueryParam(value="zoneState") Boolean var4);

    @GET
    @Path(value="/volumes/poVolumeInfos")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getPoVolumeInfos(@QueryParam(value="protectGroupId") String var1);

    @PUT
    @Path(value="/volumes/updatePoVolumeInfos")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePoVolumeInfos(@QueryParam(value="protectGroupId") String var1, UpdateProtectGroupVolumeInfo var2);

    @GET
    @Path(value="/placeholderVms")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getAvailablePlaceholderVms(@QueryParam(value="planId") String var1);

    @GET
    @Path(value="/networks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getAvailableTestNetWorksByVm(@QueryParam(value="planId") String var1, @QueryParam(value="poUuid") String var2);

    @GET
    @Path(value="/subnets")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getAvailableTestSubNetByNetWork(@QueryParam(value="planId") String var1, @QueryParam(value="networkId") String var2);

    @POST
    @Path(value="/{openstackUuid}/azpairs/action/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAvabilableMapping(@PathParam(value="openstackUuid") String var1, OpenStackAvailabilityZoneMapping var2);

    @DELETE
    @Path(value="/{openstackUuid}/azpairs/action/delete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteAvabilableMapping(@PathParam(value="openstackUuid") String var1, List<OpenStackAvailabilityZoneMapping> var2);

    @GET
    @Path(value="/{openstackUuid}/azpairs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAvabilableMapping(@PathParam(value="openstackUuid") String var1, @QueryParam(value="type") String var2);

    @POST
    @Path(value="/{openstackUuid}/voltypepairs/action/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createVolTypeMapping(@PathParam(value="openstackUuid") String var1, List<OpenStackVolTypeMapping> var2);

    @GET
    @Path(value="/{openstackUuid}/voltypepairs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getVolTypeMapping(@PathParam(value="openstackUuid") String var1);

    @DELETE
    @Path(value="/{openstackUuid}/voltypepairs/action/delete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteVolTypeMapping(@PathParam(value="openstackUuid") String var1, List<OpenStackVolTypeMapping> var2);

    @PUT
    @Path(value="/reMappingVol")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String reMappingVols(@QueryParam(value="protectGroupId") String var1);

    @PUT
    @Path(value="/{openstackUuid}/voltypepairs/action/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateVolTypeMapping(@PathParam(value="openstackUuid") String var1, List<OpenStackVolTypeMapping> var2);

    @GET
    @Path(value="/hwStackInfo")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String queryHwStackInfo();

    @GET
    @Path(value="/{planId}/action/recoveryRegionAZ")
    @Produces(value={"application/json"})
    public String queryRecoveryRegionAz(@PathParam(value="planId") String var1);
}

