/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.fusionsphere.openstack;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.model.OpenStackServiceEndPoint;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackConsts;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZone;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackNetwork;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStoragePoolRemoteDevInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStorageResourcePool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackSubnet;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.model.RegionConfig;
import com.huawei.ism.drm.openstack.sdk.service.IOpenStackProtectionService;
import com.huawei.ism.drm.openstack.sdk.service.IOpenStackRecoveryService;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.rest.fusionsphere.openstack.IOpenStackRestService;
import com.huawei.ism.drm.rest.fusionsphere.openstack.UpdateProtectGroupVolumeInfo;
import com.huawei.ism.drm.rest.fusionsphere.openstack.model.RegionConfigVo;
import com.huawei.ism.drm.rest.fusionsphere.openstack.model.RegionVO;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

public class OpenStackRestServiceImpl
extends AbstractRestService
implements IOpenStackRestService {
    private static final Log logger = LogFactory.getInstance(OpenStackRestServiceImpl.class);
    private String trace = " trace ";

    @Override
    public String queryOpenstackRegions(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"The openstackUuid is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{openstackUuid});
        return this.getRegionStr(openstackUuid);
    }

    private String getRegionStr(String openstackUuid) {
        logger.trace((Object)"enter getRegionStr");
        IOpenstackResourceService resService = this.getResourceService();
        List regionList = resService.getRegionFromDB(openstackUuid);
        HashMap<String, OpenStackRegion> regionMap = new HashMap<String, OpenStackRegion>();
        if (!VerifyUtil.isEmpty((Collection)regionList)) {
            for (OpenStackRegion openStackRegion : regionList) {
                regionMap.put(OpenStackRestServiceImpl.getIdFromUuid(openStackRegion.getUuid()), openStackRegion);
            }
        }
        List currentEndPointList = resService.getEndPointFromDB(openstackUuid);
        HashMap<String, ArrayList<OpenStackServiceEndPoint>> regionEndPointMap = new HashMap<String, ArrayList<OpenStackServiceEndPoint>>();
        if (!VerifyUtil.isEmpty((Collection)currentEndPointList)) {
            for (OpenStackServiceEndPoint openStackServiceEndPoint : currentEndPointList) {
                ArrayList<OpenStackServiceEndPoint> list = (ArrayList<OpenStackServiceEndPoint>)regionEndPointMap.get(OpenStackRestServiceImpl.getIdFromUuid(openStackServiceEndPoint.getRegionUuid()));
                if (VerifyUtil.isEmpty((Collection)list)) {
                    list = new ArrayList<OpenStackServiceEndPoint>();
                    regionEndPointMap.put(OpenStackRestServiceImpl.getIdFromUuid(openStackServiceEndPoint.getRegionUuid()), list);
                }
                list.add(openStackServiceEndPoint);
            }
        }
        JSONArray array = new JSONArray();
        for (Map.Entry entry : regionEndPointMap.entrySet()) {
            String regionId = (String)entry.getKey();
            List list = (List)entry.getValue();
            OpenStackRegion region = (OpenStackRegion)regionMap.get(regionId);
            if (VerifyUtil.isEmpty((Object)region)) continue;
            JSONObject json = new JSONObject();
            json.put((Object)"regionId", (Object)region.getUuid());
            json.put((Object)"description", (Object)region.getName());
            JSONArray services = new JSONArray();
            for (OpenStackServiceEndPoint openStackServiceEndPoint : list) {
                JSONObject service = new JSONObject();
                service.put((Object)"serviceType", (Object)openStackServiceEndPoint.getServiceType());
                service.put((Object)"serviceUrl", (Object)openStackServiceEndPoint.getServiceUrl());
                services.add((Object)service);
            }
            json.put((Object)"services", (Object)services);
            array.add((Object)json);
        }
        return array.toString();
    }

    @Override
    public Response addOpenstackRegions(String openstackUuid, List<RegionVO> regions) {
        this.handleRegion(openstackUuid, regions, "resource_add_regionServices_operateName", 1);
        return Response.ok().build();
    }

    @Override
    public Response updateOpenstackRegions(String openstackUuid, String regionId, RegionVO regionVO) {
        ArrayList<RegionVO> regions = new ArrayList<RegionVO>();
        regionVO.setRegionId(regionId);
        regions.add(regionVO);
        this.handleRegion(openstackUuid, regions, "resource_modify_regionServices_operateName", 2);
        return Response.ok().build();
    }

    @Override
    public Response deleteOpenstackRegions(String openstackUuid, String regionId) {
        ArrayList<RegionVO> regions = new ArrayList<RegionVO>();
        RegionVO regionVO = new RegionVO();
        regionVO.setRegionId(regionId);
        regions.add(regionVO);
        this.handleRegion(openstackUuid, regions, "resource_delete_regionServices_operateName", 2);
        return Response.ok().build();
    }

    private void handleRegion(String openstackUuid, List<RegionVO> regions, String operateName, int level) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackUuid is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(regions)) {
            logger.error((Object)"Regions is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority(operateName, level, "ism.drm.site.resource.auth.management.operateID");
        this.checkUserMoAuthority(operateName, level, new String[]{openstackUuid});
        ArrayList<String> regionIdList = new ArrayList<String>();
        try {
            HashMap<String, List<OpenStackServiceEndPoint>> regionServiceMap = new HashMap<String, List<OpenStackServiceEndPoint>>();
            for (RegionVO regionVO : regions) {
                String regionId = regionVO.getRegionId();
                if (regionId.contains(":")) {
                    regionId = regionId.split(":")[1];
                }
                if (!ParamChecker.checkGeneralId((String)regionId)) {
                    logger.error((Object)("RegionId is invalid, regionId=" + regionId), 90160758786989L);
                    throw new LegoCheckedException(1073947393L);
                }
                List<OpenStackServiceEndPoint> services = regionVO.getServices();
                regionServiceMap.put(regionId, services);
                regionIdList.add(regionId);
            }
            IOpenstackResourceService resService = this.getResourceService();
            resService.updateRegionService(openstackUuid, regionServiceMap);
            this.writeSucOperationLog(operateName, level, ((Object)regionIdList).toString(), null, new String[]{((Object)regionIdList).toString()});
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog(operateName, level, ((Object)regionIdList).toString(), (Exception)((Object)e));
        }
    }

    @Override
    public String queryOpenstackRegionsConfigs(String openstackUuid, String regionId) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackUuid is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)regionId)) {
            logger.error((Object)"The regionId is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)regionId)) {
            logger.error((Object)("The regionId is invalid, regionId=" + regionId), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{openstackUuid});
        return this.getRegionConfig(openstackUuid, regionId);
    }

    @Override
    public String updateOpenstackRegionsConfigs(String openstackUuid, String regionId, RegionConfigVo configVo) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackUuid is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)regionId)) {
            logger.error((Object)"The regionId is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)regionId)) {
            logger.error((Object)("The regionId is invalid, regionId=" + regionId), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)configVo)) {
            logger.error((Object)"configVo is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_modify_regionServices_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        this.checkUserMoAuthority("resource_modify_regionServices_operateName", 1, new String[]{openstackUuid});
        OpenStackRegion findRegion = null;
        try {
            IOpenstackResourceService resService = this.getResourceService();
            List regionList = resService.getRegionFromDB(openstackUuid);
            if (!VerifyUtil.isEmpty((Collection)regionList)) {
                for (OpenStackRegion openStackRegion : regionList) {
                    if (!regionId.equals(OpenStackRestServiceImpl.getIdFromUuid(openStackRegion.getUuid()))) continue;
                    findRegion = openStackRegion;
                    RegionConfig regionConfig = openStackRegion.getRegionConfig();
                    regionConfig.setIsSwitchNetwork(null != configVo && null != configVo.getSwitchNetwork() ? configVo.getSwitchNetwork().booleanValue() : regionConfig.getIsSwitchNetwork());
                    regionConfig.setSupportSharedVolumes(null != configVo && null != configVo.getSupportSharedVolumes() ? configVo.getSupportSharedVolumes().booleanValue() : regionConfig.getSupportSharedVolumes());
                    openStackRegion.setRegionConfig(regionConfig);
                    resService.updateRegion(findRegion);
                }
            }
            if (null == findRegion) {
                logger.error((Object)("regionId:" + regionId + " not find!"), 90160758786989L);
                throw new LegoCheckedException(1073947393L);
            }
            this.writeSucOperationLog("resource_modify_regionServices_operateName", 1, regionId, null, new String[]{OpenStackRestServiceImpl.getIdFromUuid(findRegion.getUuid())});
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("resource_modify_regionServices_operateName", 1, regionId, (Exception)((Object)e));
        }
        if (null == findRegion) {
            return new JSONObject().toString();
        }
        return findRegion.getConfig();
    }

    private String getRegionConfig(String openstackUuid, String regionId) {
        logger.trace((Object)"enter getRegionConfig");
        IOpenstackResourceService resService = this.getResourceService();
        List regionList = resService.getRegionFromDB(openstackUuid);
        String config = null;
        if (!VerifyUtil.isEmpty((Collection)regionList)) {
            for (OpenStackRegion openStackRegion : regionList) {
                if (!regionId.equals(OpenStackRestServiceImpl.getIdFromUuid(openStackRegion.getUuid()))) continue;
                config = openStackRegion.getConfig();
            }
        }
        if (VerifyUtil.isEmpty(config)) {
            config = new JSONObject().toString();
        }
        return config;
    }

    public static String getIdFromUuid(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            return null;
        }
        if (uuid.contains(":")) {
            uuid = uuid.split(":")[1];
        }
        return uuid;
    }

    @Override
    public String queryOpenstackProjects(String openstackUuid, Boolean enabled) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackUuid is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{openstackUuid});
        return this.getProjectsStr(openstackUuid, enabled);
    }

    private String getProjectsStr(String openstackUuid, Boolean enabled) {
        logger.trace((Object)"enter getProjectsStr");
        IOpenstackResourceService resService = this.getResourceService();
        List projList = resService.getProjectFromDB(openstackUuid, enabled);
        JSONArray array = new JSONArray();
        for (OpenStackProject proj : projList) {
            JSONObject json = new JSONObject();
            json.put((Object)"projectId", (Object)proj.getUuid());
            json.put((Object)"projectName", (Object)proj.getName());
            json.put((Object)"description", (Object)proj.getDescription());
            json.put((Object)"enabled", (Object)proj.getEnabled());
            array.add((Object)json);
        }
        return array.toString();
    }

    @Override
    public String queryOpenstackAZs(String openstackUuid, String regionUuid, String projectUuid, Boolean zoneState) {
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            logger.error((Object)("Params is empty, openstackUuid=" + openstackUuid + ", regionUuid=" + regionUuid + ", projectUuid=" + projectUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!(ParamChecker.checkGeneralId((String)openstackUuid) && ParamChecker.checkGeneralId((String)regionUuid) && ParamChecker.checkGeneralId((String)projectUuid))) {
            logger.error((Object)("Params is invalid, openstackUuid=" + openstackUuid + ", regionUuid=" + regionUuid + ", projectUuid=" + projectUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{openstackUuid});
        return this.getAzStr(openstackUuid, regionUuid, projectUuid, zoneState);
    }

    private String getAzStr(String openstackUuid, String regionUuid, String projectUuid, Boolean zoneState) {
        IOpenstackResourceService resService = this.getResourceService();
        List azList = resService.getAvailabilityZones(openstackUuid, regionUuid, projectUuid, zoneState);
        JSONArray array = new JSONArray();
        for (OpenStackAvailabilityZone az : azList) {
            JSONObject json = new JSONObject();
            json.put((Object)"zoneState", (Object)az.getZoneAvailable());
            json.put((Object)"zoneName", (Object)az.getName());
            array.add((Object)json);
        }
        return array.toString();
    }

    private IOpenstackResourceService getResourceService() {
        logger.trace((Object)"enter getResourceService");
        IOpenstackResourceService resService = (IOpenstackResourceService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenstackResourceService.class.getName(), IOpenstackResourceService.class);
        return resService;
    }

    @Override
    public String getVmVolumeInfo(String regionUuid, String projectUuid, Set<String> vmUuidsSet) {
        logger.trace((Object)("enter getVmVolumeInfo" + this.trace));
        if (VerifyUtil.isEmpty((String)regionUuid)) {
            logger.error((Object)"regionId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)regionUuid)) {
            logger.error((Object)"regionId is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)projectUuid)) {
            logger.error((Object)"projectId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)projectUuid)) {
            logger.error((Object)"projectId is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        JSONArray result = new JSONArray();
        if (VerifyUtil.isEmpty(vmUuidsSet)) {
            return result.toString();
        }
        if (!ParamChecker.checkList(vmUuidsSet, ParamChecker::checkGeneralId, (int)256)) {
            logger.error((Object)"moUuids is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        String[] vmUuids = vmUuidsSet.toArray(new String[0]);
        String providerSN = "";
        String[] array = vmUuids[0].split(":");
        if (array.length > 0) {
            providerSN = array[0];
        }
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{providerSN});
        List volumes = ((IVolumeService)this.getBundleService("DRM_FusionSphere_Openstack", IVolumeService.class.getName(), IVolumeService.class)).getVolumesByVm(regionUuid, projectUuid, false, vmUuids);
        List vms = ((IVirtualMachineService)this.getBundleService("DRM_FusionSphere_Openstack", IVirtualMachineService.class.getName(), IVirtualMachineService.class)).queryVmByUuids(regionUuid, projectUuid, vmUuids);
        if (VerifyUtil.isEmpty((Collection)vms)) {
            return result.toString();
        }
        for (OpenStackVM vm : vms) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"moUuid", (Object)vm.getUuid());
            obj.put((Object)"moName", (Object)vm.getName());
            JSONArray volumeInfos = new JSONArray();
            for (OpenStackVolume volume : volumes) {
                volume.generateAttachmentInfo();
                if (!volume.getAttachVmUuids().contains(vm.getUuid())) continue;
                JSONObject volumeInfo = new JSONObject();
                volumeInfo.put((Object)"volumeId", (Object)volume.getUuid());
                volumeInfo.put((Object)"volumeName", (Object)volume.getName());
                volumeInfo.put((Object)"volumeType", (Object)volume.getVolType());
                volumeInfos.add((Object)volumeInfo);
            }
            obj.put((Object)"volumes", (Object)volumeInfos);
            result.add((Object)obj);
        }
        return result.toString();
    }

    @Override
    public String getVolumeType(String drRegionUuid, String drProjectUuid, String srcRegionUuid, String srcProjectUuid, String srcVolTypeName) {
        logger.trace((Object)("enter getVolumeType" + this.trace));
        if (VerifyUtil.isEmpty((String)drProjectUuid) || VerifyUtil.isEmpty((String)drRegionUuid) || VerifyUtil.isEmpty((String)srcRegionUuid) || VerifyUtil.isEmpty((String)srcProjectUuid) || VerifyUtil.isEmpty((String)srcVolTypeName)) {
            logger.error((Object)"param is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!(ParamChecker.checkGeneralId((String)drRegionUuid) && ParamChecker.checkGeneralId((String)drProjectUuid) && ParamChecker.checkGeneralId((String)srcRegionUuid) && ParamChecker.checkGeneralId((String)srcProjectUuid) && ParamChecker.checkVolumeType((String)srcVolTypeName))) {
            logger.error((Object)"param is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = srcRegionUuid.split(":")[0];
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryRes_operateName", 2, new String[]{openstackUuid});
        IVolumeService volService = (IVolumeService)this.getBundleService("DRM_FusionSphere_Openstack", IVolumeService.class.getName(), IVolumeService.class);
        List result = volService.getVolumeTypes(drRegionUuid, drProjectUuid);
        if (VerifyUtil.isEmpty((Collection)result)) {
            logger.error((Object)("get volume type failed:region=" + drRegionUuid + " projectUuid=" + drProjectUuid));
            return "[]";
        }
        if (VerifyUtil.isEmpty((String)srcVolTypeName)) {
            logger.error((Object)("volume type is empty:srcVolTypeName=" + srcVolTypeName));
            return JSONArray.fromObject((Object)result).toString();
        }
        String srcVolTypeUuid = this.getVolTypeUuid(openstackUuid, srcRegionUuid, srcProjectUuid, srcVolTypeName);
        OpenStackVolumeType srcVolType = volService.getVolumeTypeByUuid(srcRegionUuid, srcProjectUuid, srcVolTypeUuid);
        return this.getAvalibleVolumeType(drRegionUuid, drProjectUuid, srcVolType, openstackUuid, result);
    }

    private String getVolTypeUuid(String openstackUuid, String regionUuid, String projectUuid, String volTypeName) {
        logger.trace((Object)("enter getVolTypeUuid" + this.trace));
        ArrayList<String> props = new ArrayList<String>();
        props.add(regionUuid);
        props.add(projectUuid);
        props.add(volTypeName);
        int prime = 31;
        int hashcode = 1;
        for (String prop : props) {
            hashcode = 31 * hashcode + (prop == null ? 0 : prop.hashCode());
        }
        return openstackUuid + ":" + hashcode;
    }

    private String getAvalibleVolumeType(String drRegionUuid, String drProjectUuid, OpenStackVolumeType srcVolType, String openstackUuid, List<OpenStackVolumeType> result) {
        logger.trace((Object)("enter getAvalibleVolumeType" + this.trace));
        if (null == srcVolType) {
            logger.error((Object)"src volume type is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String extraSpecs = srcVolType.getExtraSpecs();
        logger.debug((Object)("srouce voltype extraSpecs:" + extraSpecs));
        JSONObject obj = JSONObject.fromObject((Object)extraSpecs);
        boolean isExistKey = obj.containsKey((Object)"hw:localdev");
        if (!isExistKey) {
            logger.error((Object)("volume type is not config hw:localdev , volume type is " + srcVolType.getName()));
            throw new LegoCheckedException(1073948129L);
        }
        String localdevSn = obj.getString("hw:localdev");
        if (null == localdevSn) {
            logger.error((Object)"localdevSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean isRDM = this.isPassthrough(obj);
        OpenStackStorageResourcePool localPool = null;
        List localPools = ((IVolumeService)this.getBundleService("DRM_FusionSphere_Openstack", IVolumeService.class.getName(), IVolumeService.class)).getStorageResourcePools(openstackUuid, srcVolType.getRegionUuid(), srcVolType.getProjUuid());
        for (OpenStackStorageResourcePool pool : localPools) {
            if (!localdevSn.equals(pool.getLocalDevSn())) continue;
            localPool = pool;
            break;
        }
        if (null == localPool || VerifyUtil.isEmpty((String)localPool.getRemoteDevsStr())) {
            logger.error((Object)("there is no pool match localdevSn:" + localdevSn));
            return "[]";
        }
        List remotePools = ((IVolumeService)this.getBundleService("DRM_FusionSphere_Openstack", IVolumeService.class.getName(), IVolumeService.class)).getStorageResourcePools(openstackUuid, drRegionUuid, drProjectUuid);
        if (VerifyUtil.isEmpty((Collection)remotePools)) {
            logger.error((Object)("there is no match pool in remote:drRegionUuid=" + drRegionUuid + " drProjectUuid=" + drProjectUuid));
            return "[]";
        }
        Map<String, String> poolAndLinktypeMap = this.getResoucePoolMap(localPool, remotePools);
        logger.info((Object)("remote device Info:" + poolAndLinktypeMap));
        this.filterVolumeType(result, isRDM, poolAndLinktypeMap);
        return this.constructVolTypeJSONStr(result);
    }

    private String constructVolTypeJSONStr(List<OpenStackVolumeType> volTypeList) {
        logger.trace((Object)"enter constructVolTypeJSONStr");
        JSONArray array = new JSONArray();
        for (OpenStackVolumeType volType : volTypeList) {
            JSONObject json = new JSONObject();
            json.put((Object)"volumeTypeId", (Object)volType.getUuid());
            json.put((Object)"volumeTypeName", (Object)volType.getName());
            json.put((Object)"extraSpecs", (Object)volType.getExtraSpecs());
            array.add((Object)json);
        }
        return array.toString();
    }

    private void filterVolumeType(List<OpenStackVolumeType> result, boolean isRDM, Map<String, String> poolAndLinktypeMap) {
        Iterator<OpenStackVolumeType> itrator = result.iterator();
        while (itrator.hasNext()) {
            OpenStackVolumeType remoteType = itrator.next();
            JSONObject json = JSONObject.fromObject((Object)remoteType.getExtraSpecs());
            boolean isExistKey = json.containsKey((Object)"hw:localdev");
            if (!isExistKey) {
                logger.error((Object)("volume type is not config hw:localdev , volume type is " + remoteType.getName()));
                itrator.remove();
                continue;
            }
            Object remotedevSn = json.get("hw:localdev");
            if (null == remotedevSn) {
                logger.error((Object)"remotedevSn is empty.");
                itrator.remove();
                continue;
            }
            if (poolAndLinktypeMap.containsKey(remotedevSn) && isRDM == this.isPassthrough(json)) {
                if (poolAndLinktypeMap.get(remotedevSn).indexOf("FC") <= -1) continue;
                remoteType.setSupportFC(true);
                continue;
            }
            itrator.remove();
        }
    }

    private Map<String, String> getResoucePoolMap(OpenStackStorageResourcePool localPool, List<OpenStackStorageResourcePool> remotePools) {
        logger.trace((Object)"enter getResoucePoolMap");
        localPool.generateRemoteDevInfo();
        HashMap<String, String> remotePoolMap = new HashMap<String, String>();
        block0: for (OpenStackStorageResourcePool remotePool : remotePools) {
            for (OpenStackStoragePoolRemoteDevInfo o : localPool.getRemoteDevs()) {
                if (null == o.getDevSn() || !o.getDevSn().equals(remotePool.getLocalDevSn())) continue;
                remotePoolMap.put(remotePool.getLocalDevSn(), o.getLinkType());
                continue block0;
            }
        }
        return remotePoolMap;
    }

    private boolean isPassthrough(JSONObject obj) {
        try {
            return obj.getBoolean("hw:passthrough");
        }
        catch (Exception e) {
            logger.error((Object)("parse isPassthrough error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
    }

    @Override
    public String getPoVolumeInfos(String protectGroupId) {
        logger.trace((Object)("enter getPoVolumeInfos" + this.trace));
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            logger.error((Object)"protectGroupId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)protectGroupId)) {
            logger.error((Object)"protectGroupId is incorrect");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("protectedGroup_query_operateName", 2, "ism.drm.protectgroup.auth.scan");
        this.checkUserBizObjAuthority("protectedGroup_query_operateName", 2, protectGroupId);
        String result = ((IOpenStackProtectionService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenStackProtectionService.class.getName(), IOpenStackProtectionService.class)).getPoVolumeInfos(protectGroupId);
        return result;
    }

    @Override
    public Response updatePoVolumeInfos(String protectGroupId, UpdateProtectGroupVolumeInfo modifyVolumes) {
        logger.trace((Object)("enter updatePoVolumeInfos" + this.trace));
        Optional errorMessage = ParamChecker.checkNotEmptyParam((String)"protectGroupId", (Object)protectGroupId, ParamChecker::checkGeneralId);
        if (errorMessage.isPresent()) {
            logger.error(errorMessage.get());
            throw new LegoCheckedException((String)errorMessage.get());
        }
        this.checkUpdateProtectGroupVolumeInfo(modifyVolumes);
        Set<ProtectedVolumeInfo> removedVolumes = modifyVolumes.getRemovedVolumes();
        Set<ProtectedVolumeInfo> addedVolumes = modifyVolumes.getAddedVolumes();
        ProtectGroup pg = this.getProtectGroupService().getProtectGroupByID(protectGroupId, false);
        if (null == pg) {
            logger.error((Object)"protectgroup is not exist", 90160758786989L);
            throw new LegoCheckedException(2117645L);
        }
        if (pg.getTemplate().getType() == 25) {
            throw new LegoCheckedException(1073947453L);
        }
        if (pg.isInvalid() || "true".equals(pg.getProps().get("OBJ_DELETE_ERROR"))) {
            logger.error((Object)("the pg is invalid ,cant update volumes:pgName=" + pg.getName()));
            throw new LegoCheckedException(1073948195L);
        }
        boolean allTypeExist = this.checkVolTypeExist(addedVolumes);
        if (!allTypeExist) {
            logger.error((Object)("some volume is not set volumeType:" + addedVolumes), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("protectedGroup_modifyVolume_operateName", 2, "ism.drm.protectgroup.auth.modify");
        this.checkUserBizObjAuthority("protectedGroup_modifyVolume_operateName", 3, protectGroupId);
        try {
            logger.debug((Object)("start updateVolumeInProtectGroup groupid=" + protectGroupId));
            ((IOpenStackProtectionService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenStackProtectionService.class.getName(), IOpenStackProtectionService.class)).updateVolumeInProtectGroup(protectGroupId, removedVolumes, addedVolumes);
            this.writeSucOperationLog("protectedGroup_modifyVolume_operateName", 2, pg.getName(), "", new String[0]);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("protectedGroup_modifyVolume_operateName", 2, pg.getName(), (Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)("refresh vcenter error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.writeFailedOperationLog("protectedGroup_modifyVolume_operateName", 2, pg.getName(), (Exception)((Object)new LegoCheckedException(-1L)));
        }
        return Response.ok().build();
    }

    private void checkUpdateProtectGroupVolumeInfo(UpdateProtectGroupVolumeInfo modifyVolumes) {
        if (VerifyUtil.isEmpty((Object)modifyVolumes)) {
            logger.error((Object)"modifyVolumes is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Set<ProtectedVolumeInfo> removedVolumes = modifyVolumes.getRemovedVolumes();
        Set<ProtectedVolumeInfo> addedVolumes = modifyVolumes.getAddedVolumes();
        if (VerifyUtil.isEmpty(removedVolumes) && VerifyUtil.isEmpty(addedVolumes)) {
            logger.error((Object)"remove and add volume are empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkList(removedVolumes, volInfo -> !VerifyUtil.isEmpty((String)volInfo.getPoUuid()) && ParamChecker.checkGeneralId((String)volInfo.getPoUuid()) && !VerifyUtil.isEmpty((String)volInfo.getVolumeId()) && ParamChecker.checkGeneralId((String)volInfo.getVolumeId()), (int)60)) {
            logger.error((Object)"removedVolumes is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkList(addedVolumes, volInfo -> !VerifyUtil.isEmpty((String)volInfo.getPoUuid()) && ParamChecker.checkGeneralId((String)volInfo.getPoUuid()) && !VerifyUtil.isEmpty((String)volInfo.getVolumeId()) && ParamChecker.checkGeneralId((String)volInfo.getVolumeId()), (int)60)) {
            logger.error((Object)"addedVolumes is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean checkVolTypeExist(Set<ProtectedVolumeInfo> addedVolumes) {
        if (VerifyUtil.isEmpty(addedVolumes)) {
            return true;
        }
        for (ProtectedVolumeInfo volumeInfo : addedVolumes) {
            if (!VerifyUtil.isEmpty((String)volumeInfo.getDrVolumeType()) && ParamChecker.checkVolumeType((String)volumeInfo.getDrVolumeType())) continue;
            logger.error((Object)("volume type is not set or incorrect: volumeId=" + volumeInfo.getVolumeId()));
            return false;
        }
        return true;
    }

    @Override
    public String getAvailablePlaceholderVms(String planId) {
        logger.trace((Object)("enter getAvailablePlaceholderVms" + this.trace));
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"param is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)planId)) {
            logger.error((Object)"PlanId is invalid!");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan plan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (null == plan) {
            logger.error((Object)"recoveryplan is not exist");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)plan.getProtectGroups());
        if (null == pg) {
            logger.error((Object)"pg in recoveryplan is not exist");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, planId);
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projUuid = (String)pg.getProps().get("drProjectId");
        String azName = (String)pg.getProps().get("drZoneName");
        List vms = ((IOpenStackRecoveryService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenStackRecoveryService.class.getName(), IOpenStackRecoveryService.class)).getAvailablePlaceHoldVms(planId, regionUuid, projUuid, azName);
        JSONArray result = new JSONArray();
        if (null == vms) {
            return result.toString();
        }
        for (OpenStackVM vm : vms) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"uuid", (Object)vm.getUuid());
            obj.put((Object)"name", (Object)vm.getName());
            result.add((Object)obj);
        }
        return result.toString();
    }

    @Override
    public String getAvailableTestNetWorksByVm(String planId, String poUuid) {
        logger.trace((Object)("enter getAvailableTestNetWorksByVm" + this.trace));
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)poUuid)) {
            logger.error((Object)"param is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)planId) || !ParamChecker.checkGeneralId((String)poUuid)) {
            logger.error((Object)"Invalid planId or poUuid!");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan plan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (null == plan) {
            logger.error((Object)"recoveryplan is not exist");
            throw new LegoCheckedException(2117645L);
        }
        String holdonVuUuid = this.getHoldOnVmSetting(poUuid, plan);
        ProtectGroup pg = this.checkProtectGroupOnGetNetWork(poUuid, plan);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, planId);
        String openstackUuid = pg.getPoProviderSN();
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projUuid = (String)pg.getProps().get("drProjectId");
        List netWorks = ((IOpenStackRecoveryService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenStackRecoveryService.class.getName(), IOpenStackRecoveryService.class)).getAvailableTestNetWorksByVm(openstackUuid, regionUuid, projUuid, holdonVuUuid);
        JSONArray result = new JSONArray();
        if (null == netWorks || netWorks.isEmpty()) {
            return result.toString();
        }
        for (OpenStackNetwork netWork : netWorks) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"networkId", (Object)netWork.getUuid());
            obj.put((Object)"networkName", (Object)(VerifyUtil.isEmpty((String)netWork.getName()) ? netWork.getUuid() : netWork.getName()));
            result.add((Object)obj);
        }
        return result.toString();
    }

    private String getHoldOnVmSetting(String poUuid, RecoveryPlan plan) {
        String holdonVuUuid = "";
        for (RecoverySetting setting : plan.getRecoverySettings()) {
            if (!poUuid.equals(setting.getOwnerId()) || !"PLACEHOLDVM".equals(setting.getName())) continue;
            holdonVuUuid = setting.getValue();
            break;
        }
        if (VerifyUtil.isEmpty((String)holdonVuUuid)) {
            logger.error((Object)("can not set holdon vm:" + poUuid));
            throw new LegoCheckedException(1073947393L);
        }
        return holdonVuUuid;
    }

    private ProtectGroup checkProtectGroupOnGetNetWork(String poUuid, RecoveryPlan plan) {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)plan.getProtectGroups());
        if (null == pg) {
            logger.error((Object)"pg in recoveryplan is not exist");
            throw new LegoCheckedException(1073947393L);
        }
        boolean poExist = false;
        for (ProtectObject po : pg.getPolist()) {
            if (!poUuid.equals(po.getUuid())) continue;
            poExist = true;
            break;
        }
        if (!poExist) {
            logger.error((Object)("po is not exist:" + poUuid));
            throw new LegoCheckedException(1073947393L);
        }
        return pg;
    }

    @Override
    public String getAvailableTestSubNetByNetWork(String planId, String networkId) {
        logger.trace((Object)("enter getAvailableTestSubNetByNetWork" + this.trace));
        if (!ParamChecker.checkGeneralId((String)planId) || !ParamChecker.checkGeneralId((String)networkId)) {
            logger.error((Object)"Invalid planId or networkId!");
            return new JSONArray().toString();
        }
        ProtectGroup pg = this.checkRecoveryPlanAndNetwork(planId, networkId);
        this.checkUserOperationAuthority("recoveryPlan_query_operateName", 2, "ism.drm.drp.auth.scan");
        this.checkUserBizObjAuthority("recoveryPlan_query_operateName", 2, planId);
        String openstackUuid = pg.getPoProviderSN();
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projUuid = (String)pg.getProps().get("drProjectId");
        List subNets = ((IOpenStackRecoveryService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenStackRecoveryService.class.getName(), IOpenStackRecoveryService.class)).getAvailableTestSubNetByNetWork(openstackUuid, regionUuid, projUuid, networkId);
        JSONArray array = new JSONArray();
        if (null == subNets || subNets.isEmpty()) {
            return array.toString();
        }
        for (OpenStackSubnet subNet : subNets) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"subnetId", (Object)subNet.getUuid());
            obj.put((Object)"subnetName", (Object)(VerifyUtil.isEmpty((String)subNet.getName()) ? subNet.getUuid() : subNet.getName()));
            array.add((Object)obj);
        }
        return array.toString();
    }

    private ProtectGroup checkRecoveryPlanAndNetwork(String planId, String networkId) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)networkId)) {
            logger.error((Object)"param is empty");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan plan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (null == plan) {
            logger.error((Object)"recoveryplan is not exist");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)plan.getProtectGroups());
        if (null == pg) {
            logger.error((Object)"pg in recoveryplan is not exist");
            throw new LegoCheckedException(2117645L);
        }
        return pg;
    }

    private IRecoveryPlanService getRecoveryPlanService() {
        logger.trace((Object)"enter getRecoveryPlanService");
        return (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
    }

    private IProtectGroupService getProtectGroupService() {
        logger.trace((Object)"enter getProtectGroupService");
        return (IProtectGroupService)this.getBundleService("DRM_Base", IProtectGroupService.class.getName(), IProtectGroupService.class);
    }

    @Override
    public Response createAvabilableMapping(String openstackUuid, OpenStackAvailabilityZoneMapping mapping) {
        if (VerifyUtil.isEmpty((Object)mapping) || VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackId or param is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_createAzPair_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        this.checkUserMoAuthority("resource_createAzPair_operateName", 1, new String[]{openstackUuid});
        IOpenstackResourceService resService = this.getResourceService();
        if (VerifyUtil.isEmpty((Collection)resService.getRegionFromDB(openstackUuid))) {
            logger.error((Object)"openstackUuid does not exists.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkObjectRule(mapping);
        if (OpenStackAvailabilityZoneMapping.checkObjectRepeat((OpenStackAvailabilityZoneMapping)mapping)) {
            logger.error((Object)"AZ or Region repeat in parameter.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        List availabilityZoneMappings = resService.getAvailabilityZoneMappingsFromDB(openstackUuid);
        if (null != availabilityZoneMappings && 256 <= availabilityZoneMappings.size()) {
            logger.error((Object)"add AZ Pair error: exceed specify limits. Current and limited quantity are [%s,%s].", new Object[]{availabilityZoneMappings.size(), 256});
            throw new SpecCheckedException("cloud_AZMapping_quantity", (long)availabilityZoneMappings.size(), 256L);
        }
        if (OpenStackAvailabilityZoneMapping.checkObjectRepeatFromDB((OpenStackAvailabilityZoneMapping)mapping, (List)availabilityZoneMappings)) {
            logger.error((Object)"AZ Pair exits in DB.", 90160758786989L);
            throw new LegoCheckedException(1073948128L);
        }
        mapping.setUuid(openstackUuid + ":" + this.getRandom());
        try {
            resService.saveAvailabilityZoneMappingInDB(mapping);
            this.writeSucOperationLog("resource_createAzPair_operateName", 1, openstackUuid, null, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("resource_createAzPair_operateName", 1, openstackUuid, (Exception)((Object)e));
        }
        return Response.ok().build();
    }

    private void checkObjectRule(OpenStackAvailabilityZoneMapping mapping) {
        if (!OpenStackAvailabilityZoneMapping.isTypeExist((String)mapping.getType())) {
            logger.error((Object)"type does not meet the specification.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!mapping.checkAZObject()) {
            logger.error((Object)"AZ does not meet the specification.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)mapping.getType()) == ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO) {
            mapping.setSecondRegion(mapping.getPrimaryRegion());
            mapping.setSecondRegionId(mapping.getPrimaryRegionId());
        }
        if (!mapping.checkRegionObject()) {
            logger.error((Object)"Region does not meet the specification.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    public Response deleteAvabilableMapping(String openstackUuid, List<OpenStackAvailabilityZoneMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            logger.error((Object)"param is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (mappings.size() > 256) {
            logger.error((Object)"The size of mappings exceeds the limit, size: %s, limit: %s", new Object[]{mappings.size(), 256});
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackId is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_deleteAzPair_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        this.checkUserMoAuthority("resource_deleteAzPair_operateName", 2, new String[]{openstackUuid});
        IOpenstackResourceService resService = this.getResourceService();
        try {
            resService.deleteAvailabilityZoneMappingInDB(mappings);
            this.writeSucOperationLog("resource_deleteAzPair_operateName", 2, openstackUuid, null, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("resource_deleteAzPair_operateName", 2, openstackUuid, (Exception)((Object)e));
        }
        return Response.ok().build();
    }

    @Override
    public Response getAvabilableMapping(String openstackUuid, String type) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackId is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryAzPair_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryAzPair_operateName", 2, new String[]{openstackUuid});
        ArrayList<Map<String, Object>> lists = new ArrayList<Map<String, Object>>();
        try {
            IOpenstackResourceService resService = this.getResourceService();
            List mappings = resService.getAvailabilityZoneMappingsFromDB(openstackUuid);
            if (VerifyUtil.isEmpty((String)type)) {
                for (OpenStackAvailabilityZoneMapping mapping : mappings) {
                    lists.add(mapping.toMap());
                }
            } else {
                if (!OpenStackAvailabilityZoneMapping.isTypeExist((String)type)) {
                    logger.error((Object)"type is not in DB", 90160758786989L);
                    throw new LegoCheckedException(1073947393L);
                }
                this.getAzMappiengByType(type, lists, mappings);
            }
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("resource_queryAzPair_operateName", 2, openstackUuid, (Exception)((Object)e));
        }
        return Response.ok().entity((Object)JSONArray.fromObject(lists).toString()).build();
    }

    private void getAzMappiengByType(String type, List<Map<String, Object>> lists, List<OpenStackAvailabilityZoneMapping> mappings) {
        for (OpenStackAvailabilityZoneMapping mapping : mappings) {
            if (VerifyUtil.isEmpty((String)mapping.getType())) {
                logger.error((Object)"type is not in DB", 90160758786989L);
                continue;
            }
            if (!type.toLowerCase(Locale.US).equals(mapping.getType().toLowerCase(Locale.US))) continue;
            lists.add(mapping.toMap());
        }
    }

    @Override
    public Response createVolTypeMapping(String openstackUuid, List<OpenStackVolTypeMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            logger.error((Object)"param is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (mappings.size() > 512) {
            logger.error((Object)"The size of mappings exceeds the limit, size: %s, limit: %s", new Object[]{mappings.size(), 512});
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackId is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        IOpenstackResourceService resService = this.getResourceService();
        if (VerifyUtil.isEmpty((Collection)resService.getRegionFromDB(openstackUuid))) {
            logger.error((Object)"openstackUuid does not exists.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        for (OpenStackVolTypeMapping mapping : mappings) {
            if (!mapping.checkObject()) {
                logger.error((Object)"voltype does not meet the specification.", 90160758786989L);
                throw new LegoCheckedException(1073947393L);
            }
            if (mapping.getPriority() <= 1000 && mapping.getPriority() >= 0) continue;
            logger.error((Object)("create volumeType failed. Priority range is not 1-1000.Priority=" + mapping.getPriority()));
            throw new LegoCheckedException(1073948155L);
        }
        if (OpenStackVolTypeMapping.checkVolTypeListRepeat(mappings)) {
            logger.error((Object)"volType repeat in parameter.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_createVolTypePair_operateName", 1, "ism.drm.site.resource.auth.management.operateID");
        this.checkUserMoAuthority("resource_createVolTypePair_operateName", 1, new String[]{openstackUuid});
        try {
            List volTypeMappings = resService.getVolTypeMappingsFromDB(openstackUuid);
            if (null != volTypeMappings && 512 < volTypeMappings.size() + mappings.size()) {
                logger.error((Object)"add volume type mappings error: exceed specify limits. Added, current and limited quantity are [%s,%s,%s].", new Object[]{mappings.size(), volTypeMappings.size(), 512});
                throw new SpecCheckedException("cloud_volTypeMapping_quantity", (long)volTypeMappings.size(), 512L);
            }
            String isExistsVolTypePair = OpenStackVolTypeMapping.checkSameByVolTypeMapping(mappings, (List)volTypeMappings);
            if (!VerifyUtil.isEmpty((String)isExistsVolTypePair)) {
                logger.error((Object)("volType Pair(" + isExistsVolTypePair + ") exits in DB."), 90160758786989L);
                throw new LegoCheckedException(1073948123L, new String[]{isExistsVolTypePair});
            }
            mappings.stream().filter(map -> map.getPriority() == 0).forEach(map -> map.setPriority(1));
            boolean isExistSamePriority = OpenStackVolTypeMapping.checkSamePriorityByVolTypeMapping(mappings, (List)volTypeMappings);
            if (isExistSamePriority) {
                logger.error((Object)"Added volumeType mapping has same priority with AZ in DB.", 90160758786989L);
                throw new LegoCheckedException(1073948156L);
            }
            for (OpenStackVolTypeMapping mapping : mappings) {
                mapping.setUuid(openstackUuid + ":" + this.getRandom());
                if (mapping.getPriority() != 0) continue;
                mapping.setPriority(1);
            }
            resService.saveVolTypeMappingInDB(mappings);
            this.writeSucOperationLog("resource_createVolTypePair_operateName", 1, openstackUuid, null, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("resource_createVolTypePair_operateName", 1, openstackUuid, (Exception)((Object)e));
        }
        return Response.ok().build();
    }

    @Override
    public Response getVolTypeMapping(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackId is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_queryVolTypePair_operateName", 2, "ism.drm.site.auth.scan");
        this.checkUserMoAuthority("resource_queryVolTypePair_operateName", 2, new String[]{openstackUuid});
        String jsonMappings = null;
        try {
            IOpenstackResourceService resService = this.getResourceService();
            List mappings = resService.getVolTypeMappingsFromDB(openstackUuid);
            jsonMappings = OpenStackVolTypeMapping.convertToJson((List)mappings);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("resource_queryVolTypePair_operateName", 2, openstackUuid, (Exception)((Object)e));
        }
        return Response.ok().entity((Object)jsonMappings).build();
    }

    @Override
    public Response deleteVolTypeMapping(String openstackUuid, List<OpenStackVolTypeMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            logger.error((Object)"param is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (mappings.size() > 512) {
            logger.error((Object)"The size of mappings exceeds the limit, size: %s, limit: %s", new Object[]{mappings.size(), 512});
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackId is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)("The openstackUuid is invalid, openstackUuid=" + openstackUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("resource_deleteVolTypePair_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        this.checkUserMoAuthority("resource_deleteVolTypePair_operateName", 2, new String[]{openstackUuid});
        try {
            IOpenstackResourceService resService = this.getResourceService();
            resService.deleteVolTypeMappingInDB(mappings);
            this.writeSucOperationLog("resource_deleteVolTypePair_operateName", 2, openstackUuid, null, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("resource_deleteVolTypePair_operateName", 2, openstackUuid, (Exception)((Object)e));
        }
        return Response.ok().build();
    }

    @Override
    public String reMappingVols(String protectGroupId) {
        logger.trace((Object)("enter reMappingVols" + this.trace));
        Optional errorMessage = ParamChecker.checkNotEmptyParam((String)"protectGroupId", (Object)protectGroupId, ParamChecker::checkGeneralId);
        if (errorMessage.isPresent()) {
            logger.error(errorMessage.get());
            throw new LegoCheckedException((String)errorMessage.get());
        }
        ProtectGroup pg = this.checkReMappingVols(protectGroupId);
        long taskId = 0L;
        try {
            logger.debug((Object)("start reMappingVols groupid=" + protectGroupId));
            taskId = ((IOpenStackProtectionService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenStackProtectionService.class.getName(), IOpenStackProtectionService.class)).reMappingVols(protectGroupId, this.getCurrentUser().getUserName());
            this.writeSucOperationLog("protectedGroup_modifyVolume_operateName", 2, pg.getName(), "", new String[0]);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("protectedGroup_modifyVolume_operateName", 2, pg.getName(), (Exception)((Object)e));
        }
        JSONObject result = new JSONObject();
        result.put((Object)"task_id", (Object)String.valueOf(taskId));
        return result.toString();
    }

    private ProtectGroup checkReMappingVols(String protectGroupId) {
        boolean isStatusAvailable;
        ProtectGroup pg = this.getProtectGroupService().getProtectGroupByID(protectGroupId, false);
        if (null == pg) {
            logger.error((Object)"protectgroup is not exist", 90160758786989L);
            throw new LegoCheckedException(2117645L);
        }
        int status = pg.getStatus();
        boolean bl = isStatusAvailable = DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus() == status || DrmEnumDefine.PROTECT_GROUP_STATUS.RUNNING.getStatus() == status;
        if (!isStatusAvailable) {
            logger.error((Object)("protectgroup status is not normal: status=" + pg.getStatus()), 90160758786989L);
            throw new LegoCheckedException(1073948178L);
        }
        if (!OpenstackConsts.OPENSTACK_NEEDREATTACH_TYPES.contains(pg.getTemplate().getType())) {
            throw new LegoCheckedException(1073947453L);
        }
        String regionUuid = pg.getProperty("regionId");
        String originalRegionUuid = pg.getProperty("originalAvailableRegion");
        if (!(34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType() || Objects.equals(regionUuid, originalRegionUuid))) {
            logger.error((Object)("vha+csdr after reprotect not support remapping vols origioal region uuid:" + originalRegionUuid + " current region uuid:" + regionUuid));
            throw new LegoCheckedException(1073948148L);
        }
        if (pg.isInvalid() || "true".equals(pg.getProps().get("OBJ_DELETE_ERROR"))) {
            logger.error((Object)("the pg is invalid ,cant reMappingVols:pgName=" + pg.getName()));
            throw new LegoCheckedException(1073948195L);
        }
        this.checkUserOperationAuthority("protectedGroup_modifyVolume_operateName", 2, "ism.drm.protectgroup.auth.modify");
        this.checkUserBizObjAuthority("protectedGroup_modifyVolume_operateName", 3, protectGroupId);
        return pg;
    }

    private String getRandom() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() == 1) {
                hv = "0" + hv;
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    @Override
    public Response updateVolTypeMapping(String openstackUuid, List<OpenStackVolTypeMapping> mappings) {
        this.checkMapAndOpenstackUuid(openstackUuid, mappings);
        this.checkUserOperationAuthority("resource_createVolTypePair_operateName", 2, "ism.drm.site.resource.auth.management.operateID");
        this.checkUserMoAuthority("resource_createVolTypePair_operateName", 2, new String[]{openstackUuid});
        try {
            IOpenstackResourceService resService = this.getResourceService();
            List mappingsInDB = resService.getVolTypeMappingsFromDB(openstackUuid);
            this.checkUpdateVolType(mappings, mappingsInDB);
            ArrayList<OpenStackVolTypeMapping> updateMappingsInDB = new ArrayList<OpenStackVolTypeMapping>();
            HashMap<String, OpenStackVolTypeMapping> updateMappingsMap = new HashMap<String, OpenStackVolTypeMapping>();
            for (OpenStackVolTypeMapping volumeTypeInDB : mappingsInDB) {
                updateMappingsMap.put(volumeTypeInDB.getMoId().toString(), volumeTypeInDB);
            }
            for (OpenStackVolTypeMapping updateVolumeType : mappings) {
                if (updateMappingsMap.get(updateVolumeType.getMoId().toString()) != null) {
                    OpenStackVolTypeMapping tempUpdateVolumeType = (OpenStackVolTypeMapping)updateMappingsMap.get(updateVolumeType.getMoId().toString());
                    this.checkVolumeTypeAndPriority(tempUpdateVolumeType);
                    tempUpdateVolumeType.setPriority(updateVolumeType.getPriority());
                    tempUpdateVolumeType.setDomainModelId("");
                    tempUpdateVolumeType.setDomainProductId("");
                    HashSet childMos = new HashSet();
                    tempUpdateVolumeType.setChildMos(childMos);
                    updateMappingsInDB.add(tempUpdateVolumeType);
                    continue;
                }
                throw new LegoCheckedException(2117645L);
            }
            resService.updateVolTypeMappingInDB(updateMappingsInDB);
            this.writeSucOperationLog("resource_updateVolTypePair_operateName", 1, openstackUuid, null, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLog("resource_updateVolTypePair_operateName", 2, openstackUuid, (Exception)((Object)e));
            throw e;
        }
        return Response.ok().build();
    }

    private void checkMapAndOpenstackUuid(String openstackUuid, List<OpenStackVolTypeMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            logger.error((Object)"update openStack volumeType mapping failed.OpenStackVolTypeMapping is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (mappings.size() > 512) {
            logger.error((Object)"The size of mappings exceeds the limit, size: %s, limit: %s", new Object[]{mappings.size(), 512});
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"update openStack volumeType mapping failed.openstackId is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkGeneralId((String)openstackUuid)) {
            logger.error((Object)"The openstackUuid is invalid, openstackUuid=%s", new Object[]{openstackUuid, 90160758786989L});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkUpdateVolType(List<OpenStackVolTypeMapping> mappings, List<OpenStackVolTypeMapping> mappingsInDB) {
        Map mappingsInDBMaps = mappingsInDB.stream().collect(Collectors.toMap(OpenStackVolTypeMapping::getMoId, Function.identity(), (keyOld, keyNew) -> keyNew));
        mappings.forEach(item -> {
            OpenStackVolTypeMapping mapInDB = (OpenStackVolTypeMapping)mappingsInDBMaps.get(item.getMoId());
            item.setPrimaryVolType(mapInDB.getPrimaryVolType());
            item.setSecondVolType(mapInDB.getSecondVolType());
            item.setPrimaryAzId(mapInDB.getPrimaryAzId());
            item.setSecondAzId(mapInDB.getSecondAzId());
            item.setType(mapInDB.getType());
        });
        boolean isExistSamePriority = OpenStackVolTypeMapping.checkSamePriorityByVolTypeMapping(mappings, mappingsInDB);
        if (isExistSamePriority) {
            logger.error((Object)"Updated volumeType mapping has same priority with AZ in DB.", 90160758786989L);
            throw new LegoCheckedException(1073948156L);
        }
    }

    private void checkVolumeTypeAndPriority(OpenStackVolTypeMapping tempUpdateVolumeType) {
        if (tempUpdateVolumeType.getPriority() > 1000 || tempUpdateVolumeType.getPriority() < 0) {
            logger.error((Object)("check volumeType and priority failed. Priority range is not 1-1000.Priority=" + tempUpdateVolumeType.getPriority()));
            throw new LegoCheckedException(1073948155L);
        }
    }

    @Override
    public String queryHwStackInfo() {
        this.checkUserOperationAuthority("resource_queryRes_operateName", 2, "ism.drm.site.auth.scan");
        return this.getResourceService().queryHwStackInfo().toString();
    }

    @Override
    public String queryRecoveryRegionAz(String planId) {
        if (VerifyUtil.isEmpty((String)planId) || !ParamChecker.checkGeneralId((String)planId)) {
            logger.error((Object)"the planId is invalid ,planId=%s", new Object[]{planId});
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            logger.error((Object)"recoveryPlan is invalid ,planId=%s", new Object[]{planId});
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserBizObjAuthority("recoveryPlan_do_operateName", 2, planId);
        this.checkUserOperationAuthority("recoveryPlan_do_operateName", 2, "ism.drm.drp.local.auth.rollback");
        IOpenStackRecoveryService iOpenStackRecoveryService = (IOpenStackRecoveryService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenStackRecoveryService.class.getName(), IOpenStackRecoveryService.class);
        return iOpenStackRecoveryService.getRecoveryRegionAz(recoveryPlan);
    }
}

