/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.openstack.adapt;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.galax.sdk.service.IResScopeService;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.rest.fusionsphere.adapt.IAdapter;
import com.huawei.ism.drm.rest.fusionsphere.adapt.IAdapterManager;
import com.huawei.ism.drm.rest.fusionsphere.cloud.util.FusionsphereUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.List;

public class OpenStackAdapter
implements IAdapter {
    protected static final String GALAX_BUNDLE_NAME = "DRM_FusionShpere_Base";
    private static Log logger = LogFactory.getInstance(OpenStackAdapter.class);
    private static final String DRM_BASE = "DRM_Base";
    private List<IAdapterManager> managers;

    public List<IAdapterManager> getManagers() {
        return this.managers;
    }

    public void setManagers(List<IAdapterManager> managers) {
        this.managers = managers;
    }

    public void initialize() {
        if (this.managers != null) {
            for (IAdapterManager manager : this.managers) {
                manager.addAdapter((IAdapter)this);
            }
        } else {
            logger.error((Object)"managers is null");
        }
    }

    public <T> T getBundleService(String bundleName, String serviceName, Class<T> serviceClass) {
        return (T)ServiceLocator.getBundleService((String)bundleName, (String)serviceName, serviceClass);
    }

    private IProtectGroupService getProctectGroupService() {
        return this.getBundleService(DRM_BASE, IProtectGroupService.class.getName(), IProtectGroupService.class);
    }

    public String queryVms(String cloudSn, Integer[] pageInfo, boolean isAsc, String oderBy, Long userId) {
        NetworkEntity entity = this.getMo(NetworkEntity.class, "sn", cloudSn);
        if (null == entity) {
            logger.error((Object)("cloud object is not exist, cloudSn=" + cloudSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        if (!"ism.drm.deviceType.fusionsphereopenstack.subType".equals(entity.getSubType())) {
            return null;
        }
        return this.getOpenstackVmInfos(cloudSn, pageInfo, isAsc, oderBy, userId);
    }

    protected <T extends ManagedObject> T getMo(Class<T> clazz, String property, Object value) {
        IResScopeService resScopeService = this.getBundleService(GALAX_BUNDLE_NAME, IResScopeService.class.getName(), IResScopeService.class);
        if (null == resScopeService) {
            logger.error((Object)"IResScopeService is null", 90160758787071L);
            throw new LegoCheckedException(1073947395L);
        }
        return (T)resScopeService.getMo(clazz, property, value);
    }

    private String getOpenstackVmInfos(String cloudSn, Integer[] pageInfo, boolean isAsc, String oderBy, Long userId) {
        Integer pageSize = pageInfo[0];
        Integer startPage = pageInfo[1];
        Page page = this.getBundleService("DRM_FusionSphere_Openstack", IVirtualMachineService.class.getName(), IVirtualMachineService.class).pageQueryVmsByOpenstackUuid(cloudSn, oderBy, startPage.intValue(), pageSize.intValue(), isAsc);
        JSONObject jsonObject = new JSONObject();
        if (null == page) {
            logger.error((Object)("result of page query vm is null, cloudSn=" + cloudSn), 90160758787071L);
            return jsonObject.toString();
        }
        List vmList = page.getResult();
        if (VerifyUtil.isEmpty((Collection)vmList)) {
            logger.error((Object)("result of page query vm is null, cloudSn=" + cloudSn), 90160758787071L);
            return new JSONObject().toString();
        }
        List protectGroups = this.getProctectGroupService().getAllProtectGroupBasicInfo(userId, false, false, true);
        JSONArray jsonArray = new JSONArray();
        for (OpenStackVM vm : vmList) {
            JSONObject json = new JSONObject();
            json.put((Object)"name", (Object)vm.getName());
            json.put((Object)"osStatus", (Object)vm.getStatus());
            json.put((Object)"regionId", (Object)vm.getRegionName());
            json.put((Object)"projectName", (Object)vm.getProjName());
            json.put((Object)"zoneName", (Object)vm.getAzName());
            JSONArray groupIDArray = new JSONArray();
            JSONArray groupNameArray = new JSONArray();
            if (!VerifyUtil.isEmpty((Collection)protectGroups)) {
                for (ProtectGroup protectGroup : protectGroups) {
                    if (!FusionsphereUtil.isVmInProtectGroup((String)vm.getUuid(), (ProtectGroup)protectGroup, (String)cloudSn)) continue;
                    groupIDArray.add((Object)protectGroup.getUuid());
                    groupNameArray.add((Object)protectGroup.getName());
                }
            }
            json.put((Object)"protectgroupId", (Object)groupIDArray);
            json.put((Object)"protectgroupName", (Object)groupNameArray);
            jsonArray.add((Object)json);
        }
        jsonObject.put((Object)"totalCount", (Object)page.getTotalCount());
        jsonObject.put((Object)"records", (Object)jsonArray);
        return jsonObject.toString();
    }
}

