/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.network.sdk.model;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPv6Address {
    private String address;
    private String prefix;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        if (!Ipv6AddressUtil.isIPv6Address(address)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.address = address;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (VerifyUtil.isEmpty(prefix)) {
            throw new LegoCheckedException(1073947393L);
        }
        String reg = "^([1-9]?\\d|1[01]\\d|12[0-8])$";
        prefix = Normalizer.normalize(prefix, Normalizer.Form.NFKC);
        Matcher matcher = Pattern.compile(reg).matcher(prefix);
        if (!matcher.matches()) {
            throw new LegoCheckedException(1073947393L);
        }
        this.prefix = prefix;
    }

    public boolean isEqual(IPv6Address other) {
        if (this.address == null || this.prefix == null) {
            return false;
        }
        return Ipv6AddressUtil.fillIpv6(this.address, ":").equals(Ipv6AddressUtil.fillIpv6(other.getAddress(), ":")) && this.prefix.equals(other.getPrefix());
    }
}

