/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp.abs;

import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.snmp.SnmpTarget;
import com.huawei.lego.com.south.snmp.abs.SnmpTimeoutPolicy;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.Serializable;

public abstract class AbstractSnmpAPI
implements Serializable {
    private static final long serialVersionUID = -6503561166038034536L;
    private SnmpTimeoutPolicy timeoutPolicy = new SnmpTimeoutPolicy();
    private SnmpTarget snmpTarget = new SnmpTarget();

    public SnmpEnum.SnmpVersion getSnmpVersion() {
        return SnmpEnum.SnmpVersion.getSnmpVersion(this.snmpTarget.getSnmpVersion());
    }

    public SnmpTimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public void setTimeoutPolicy(SnmpTimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public void setSnmpVersion(SnmpEnum.SnmpVersion snmpVersion) {
        if (snmpVersion == SnmpEnum.SnmpVersion.ILLEGAL) {
            throw new LegoUncheckedException("wrong snmp version.");
        }
        this.snmpTarget.setSnmpVersion(snmpVersion.getValue());
    }

    public String getTargetHost() {
        return this.snmpTarget.getTargetHost();
    }

    public void setTargetHost(String targetHost) {
        this.snmpTarget.setTargetHost(targetHost);
    }

    public int getTargetPort() {
        return this.snmpTarget.getTargetPort();
    }

    public void setTargetPort(int port) {
        this.snmpTarget.setTargetPort(port);
    }

    public int getTimeout() {
        return this.snmpTarget.getTimeout();
    }

    public void setTimeout(int timeout) {
        this.snmpTarget.setTimeout(timeout);
    }

    public int getRetries() {
        return this.snmpTarget.getRetries();
    }

    public void setRetries(int retries) {
        this.snmpTarget.setRetries(retries);
    }

    public String getCommunity() {
        return this.snmpTarget.getCommunity();
    }

    public void setCommunity(String community) {
        this.snmpTarget.setCommunity(community);
    }

    public String getWriteCommunity() {
        return this.snmpTarget.getWriteCommunity();
    }

    public void setWriteCommunity(String community) {
        this.snmpTarget.setWriteCommunity(community);
    }

    public String getAuthPassword() {
        return this.snmpTarget.getAuthPassword();
    }

    public void setAuthPassword(String authPwd) {
        this.snmpTarget.setAuthPassword(authPwd);
    }

    public SnmpEnum.AuthProtocol getAuthProtocol() {
        return SnmpEnum.AuthProtocol.getAuthProtocol(this.snmpTarget.getAuthProtocol());
    }

    public void setAuthProtocol(SnmpEnum.AuthProtocol authProtocol) {
        if (authProtocol == SnmpEnum.AuthProtocol.ILLEGAL) {
            throw new LegoUncheckedException("wrong auth protocol.");
        }
        this.snmpTarget.setAuthProtocol(authProtocol.getValue());
    }

    public String getPrivPassword() {
        return this.snmpTarget.getPrivPassword();
    }

    public void setPrivPassword(String privPwd) {
        this.snmpTarget.setPrivPassword(privPwd);
    }

    public SnmpEnum.PrivProtocol getPrivProtocol() {
        return SnmpEnum.PrivProtocol.getPrivProtocol(this.snmpTarget.getPrivProtocol());
    }

    public void setPrivProtocol(SnmpEnum.PrivProtocol privProtocol) {
        if (privProtocol == SnmpEnum.PrivProtocol.ILLEGAL) {
            throw new LegoUncheckedException("wrong priv protocol.");
        }
        this.snmpTarget.setPrivProtocol(privProtocol.getValue());
    }

    public String getContextID() {
        return this.snmpTarget.getContextID();
    }

    public void setContextID(String contextID) {
        this.snmpTarget.setContextID(contextID);
    }

    public String getContextName() {
        return this.snmpTarget.getContextName();
    }

    public void setContextName(String contextName) {
        this.snmpTarget.setContextName(contextName);
    }

    public byte[] getEngineID() {
        return this.snmpTarget.getEngineID();
    }

    public void setEngineID(byte[] engineID) {
        this.snmpTarget.setEngineID(engineID);
    }

    public String getSecurityName() {
        return this.snmpTarget.getPrincipal();
    }

    public void setSecurityName(String securityName) {
        this.snmpTarget.setPrincipal(securityName);
    }

    public SnmpEnum.SecurityLevel getSecurityLevel() {
        return SnmpEnum.SecurityLevel.getSecurityLevel(NumberUtil.convertToInteger(this.snmpTarget.getSecurityLevel()));
    }

    public void setSecurityLevel(SnmpEnum.SecurityLevel securityLevel) {
        this.snmpTarget.setSecurityLevel((byte)securityLevel.getValue());
    }

    public SnmpEnum.SecurityModel getSecurityModel() {
        return SnmpEnum.SecurityModel.getSecurityModel(this.snmpTarget.getSecurityModel());
    }

    public void setSecurityModel(SnmpEnum.SecurityModel securityModel) {
        this.snmpTarget.setSecurityModel(securityModel.getValue());
    }

    public int getMaxNumRows() {
        return this.snmpTarget.getMaxNumRows();
    }

    public void setMaxNumRows(int maxNumRows) {
        this.snmpTarget.setMaxNumRows(maxNumRows);
    }

    public int getMaxRepetitions() {
        return this.snmpTarget.getMaxRepetitions();
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.snmpTarget.setMaxRepetitions(maxRepetitions);
    }

    public int getNonRepeaters() {
        return this.snmpTarget.getNonRepeaters();
    }

    public void setNonRepeaters(int i) {
        this.snmpTarget.setNonRepeaters(i);
    }

    public int getErrorCode() {
        return this.snmpTarget.getErrorCode();
    }

    public void setErrorCode(int errorCode) {
        this.snmpTarget.setErrorCode(errorCode);
    }

    protected SnmpTarget getSnmpTarget() {
        return this.snmpTarget;
    }
}

