/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp.util;

import com.huawei.lego.com.south.sdk.model.LegoSnmpOID;
import com.huawei.lego.com.south.sdk.model.LegoSnmpVar;
import com.huawei.lego.com.south.sdk.model.LegoSnmpVarBind;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.snmp.abs.Property;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.nio.charset.Charset;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public final class SnmpUtil {
    private static final Log logger = LogFactory.getInstance(SnmpUtil.class);
    private static final int VALUE_2 = 2;
    private static final int VALUE_16 = 16;

    private SnmpUtil() {
    }

    public static OID getAuthProtocol(SnmpEnum.AuthProtocol ap) {
        if (ap.equals((Object)SnmpEnum.AuthProtocol.MD5_AUTH)) {
            return AuthMD5.ID;
        }
        if (ap.equals((Object)SnmpEnum.AuthProtocol.SHA1_AUTH)) {
            return AuthSHA.ID;
        }
        if (ap.equals((Object)SnmpEnum.AuthProtocol.SHA2_AUTH)) {
            return new OID("1.3.6.1.6.3.10.1.1.5");
        }
        return null;
    }

    public static OID getPrivProtocol(SnmpEnum.PrivProtocol pp) {
        if (pp.equals((Object)SnmpEnum.PrivProtocol.CBC_DES)) {
            return PrivDES.ID;
        }
        if (pp.equals((Object)SnmpEnum.PrivProtocol.CBC_3DES)) {
            return Priv3DES.ID;
        }
        if (pp.equals((Object)SnmpEnum.PrivProtocol.CFB_AES) || pp.equals((Object)SnmpEnum.PrivProtocol.CFB_AES_128)) {
            return PrivAES128.ID;
        }
        if (pp.equals((Object)SnmpEnum.PrivProtocol.CFB_AES_192)) {
            return PrivAES192.ID;
        }
        if (pp.equals((Object)SnmpEnum.PrivProtocol.CFB_AES_256)) {
            return PrivAES256.ID;
        }
        return null;
    }

    public static int getSecurityLevel(SnmpEnum.SecurityLevel level) {
        if (level.equals((Object)SnmpEnum.SecurityLevel.AUTH_NOPRIV)) {
            return 2;
        }
        if (level.equals((Object)SnmpEnum.SecurityLevel.AUTH_PRIV)) {
            return 3;
        }
        if (level.equals((Object)SnmpEnum.SecurityLevel.NOAUTH_NOPRIV)) {
            return 1;
        }
        return SnmpEnum.SecurityLevel.ILLEGAL.getValue();
    }

    public static OctetString createOctetString(String s) {
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString((String)s.substring(2), (char)':') : new OctetString(s);
        return octetString;
    }

    public static LegoSnmpVarBind[] convert(VariableBinding[] variables) {
        if (null == variables) {
            return new LegoSnmpVarBind[0];
        }
        LegoSnmpVarBind[] snmpVariables = new LegoSnmpVarBind[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            VariableBinding variableBinding = variables[i];
            OID oid = variableBinding.getOid();
            LegoSnmpOID snmpoid = new LegoSnmpOID(SnmpEnum.SnmpType.getSnmpType(oid.getSyntax()), oid.toString());
            Variable variable = variableBinding.getVariable();
            String varval = variable.toString();
            if (variable instanceof OctetString) {
                varval = SnmpUtil.getString(variable.toString());
            }
            LegoSnmpVar snmpvar = new LegoSnmpVar(SnmpEnum.SnmpType.getSnmpType(variable.getSyntax()), varval);
            snmpVariables[i] = new LegoSnmpVarBind(snmpoid, snmpvar);
        }
        return snmpVariables;
    }

    private static String getString(String hexString) {
        try {
            String[] hexArr = hexString.split(":");
            byte[] bytes = new byte[hexArr.length - 1];
            for (int i = 0; i < hexArr.length - 1; ++i) {
                bytes[i] = Byte.parseByte(hexArr[i], 16);
            }
            return new String(bytes, Charset.defaultCharset());
        }
        catch (Exception e) {
            logger.error("getString error.error:" + ExceptionUtil.getErrorMessage(e));
            return hexString;
        }
    }

    public static VariableBinding getVB(Property prop) {
        switch (prop.getType()) {
            case 6: {
                return new VariableBinding(new OID(prop.getName()), (Variable)new OID(prop.getValue()));
            }
            case 2: {
                int i = NumberUtil.convertToInteger(prop.getValue());
                return new VariableBinding(new OID(prop.getName()), (Variable)new Integer32(i));
            }
            case 4: {
                return new VariableBinding(new OID(prop.getName()), (Variable)new OctetString(prop.getValue()));
            }
            case 66: {
                int gi = NumberUtil.convertToInteger(prop.getValue());
                return new VariableBinding(new OID(prop.getName()), (Variable)new Gauge32((long)gi));
            }
        }
        return SnmpUtil.chek(prop);
    }

    private static VariableBinding chek(Property prop) {
        switch (prop.getType()) {
            case 65: {
                int ci = NumberUtil.convertToInteger(prop.getValue());
                return new VariableBinding(new OID(prop.getName()), (Variable)new Counter32((long)ci));
            }
            case 70: {
                int ci64 = NumberUtil.convertToInteger(prop.getValue());
                return new VariableBinding(new OID(prop.getName()), (Variable)new Counter64((long)ci64));
            }
            case 5: {
                return new VariableBinding(new OID(prop.getName()), (Variable)new Null());
            }
            case 67: {
                return new VariableBinding(new OID(prop.getName()), (Variable)new TimeTicks(System.currentTimeMillis()));
            }
            case 64: {
                return new VariableBinding(new OID(prop.getName()), (Variable)new IpAddress(prop.getValue()));
            }
        }
        return null;
    }

    public static synchronized USM getUsm() {
        USM usm = (USM)SecurityModels.getInstance().getSecurityModel(new Integer32(3));
        if (usm == null) {
            usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        }
        return usm;
    }
}

