/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.base.service;

import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.base.model.ServiceInfo;
import com.huawei.lego.core.sdk.base.service.IAppServiceHelper;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class LocalAppServiceHelper
implements IAppServiceHelper {
    private static Map<String, Class> classMap = new ConcurrentHashMap<String, Class>();
    private static long errorCode = -1L;
    private Log log = LogFactory.getInstance(this);

    @Override
    public Object query(ApplicationContext bundleContext, ServiceInfo info) {
        Collection objects;
        Iterator iterator;
        if (null == bundleContext || null == info || null == info.getInterfaceName()) {
            throw new NullPointerException();
        }
        Object object = null;
        Class<?> lass = classMap.get(info.getInterfaceName());
        if (lass == null) {
            try {
                lass = Class.forName(info.getInterfaceName());
                classMap.put(info.getInterfaceName(), lass);
            }
            catch (ClassNotFoundException e) {
                this.log.info("LocalAppServiceHelper query by interface:" + info.getInterfaceName() + "  " + ExceptionUtil.getErrorMessage(e));
                ExceptionUtil.rethrowException(e, "LocalAppServiceHelper query by interface: ", errorCode, null);
            }
        }
        if ((iterator = (objects = bundleContext.getBeansOfType((Class)lass).values()).iterator()).hasNext()) {
            Object ob = iterator.next();
            return ob;
        }
        try {
            object = bundleContext.getBean(info.getName());
        }
        catch (BeansException e) {
            this.log.info("LocalAppServiceHelper query by name:" + info.getInterfaceName() + "  name:" + info.getName());
            object = bundleContext.getBean(this.toLowerCaseFirstOne(info.getName()));
        }
        return object;
    }

    public String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    @Override
    public void register(ApplicationContext bundleContext, AppInfo info) {
    }
}

