/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.mediation.synchronize.snmp;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.AbstractSnmpSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.SnmpProcessParamInfo;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.model.SnmpSynchronizeParameter;
import com.huawei.lego.core.sdk.mediation.synchronize.util.SynchronizeUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SnmpSubManagedObjectSynchronizer
extends AbstractSnmpSynchronizer {
    private static final Log LOGGER = LogFactory.getInstance(SnmpSubManagedObjectSynchronizer.class);

    @Override
    protected MoListOrMap constructManagedObjects(List<String[]> mibValueResultList, MoListOrMap parentMoListOrMap, SnmpSynchronizeParameter snmpSynchronizeParameter) {
        if (null == parentMoListOrMap) {
            LOGGER.info((Object)"parentMoListOrMap is : null", 200L);
        } else {
            LOGGER.info((Object)("parentMoListOrMap is : " + parentMoListOrMap), 200L);
        }
        int referredOidSequence = -1;
        String referredOid = snmpSynchronizeParameter.getReferredOid();
        if (StringUtils.hasText((String)referredOid)) {
            referredOidSequence = super.getTargetOidList().indexOf(referredOid);
            Assert.isTrue((referredOidSequence != -1 ? 1 : 0) != 0, (String)"referredOidSequence is -1");
        }
        int referingOidSequence = -1;
        String referingOid = snmpSynchronizeParameter.getReferingOid();
        if (StringUtils.hasText((String)referingOid)) {
            referingOidSequence = super.getTargetOidList().indexOf(referingOid);
            Assert.isTrue((referingOidSequence != -1 ? 1 : 0) != 0, (String)"referingOidSequence is -1");
        }
        HashMap<String, ManagedObject> resultMoMap = new HashMap<String, ManagedObject>();
        ArrayList<ManagedObject> resultMoList = new ArrayList<ManagedObject>();
        String[] propertyNameArray = super.getOidPropertyNameMap().values().toArray(new String[super.getOidPropertyNameMap().values().size()]);
        String[] propertyTypeArray = super.getOidPropertyTypeMap().values().toArray(new String[super.getOidPropertyTypeMap().values().size()]);
        for (String[] snmpValues : mibValueResultList) {
            ManagedObject halfConstructMo = snmpSynchronizeParameter.getTargetMo().clone();
            SnmpProcessParamInfo param = new SnmpProcessParamInfo();
            param.setPropertyNameArray(propertyNameArray);
            param.setPropertyTypeArray(propertyTypeArray);
            param.setSnmpValues(snmpValues);
            this.processOneLine(parentMoListOrMap, new int[]{referredOidSequence, referingOidSequence}, resultMoMap, param, halfConstructMo);
            this.constructManagedObject(halfConstructMo);
            if (referingOidSequence == -1 && null != parentMoListOrMap) {
                ManagedObject parentMo = parentMoListOrMap.getMo();
                if (parentMo != null) {
                    parentMo.addChildMo(halfConstructMo);
                } else {
                    LOGGER.error((Object)("referingOidSequence is -1 and parentMo is null, parentMoListOrMap is : " + parentMoListOrMap), 200L);
                }
            }
            if (referredOidSequence != -1) continue;
            resultMoList.add(halfConstructMo);
        }
        MoListOrMap resultMoListOrMap = this.buildResult(parentMoListOrMap, snmpSynchronizeParameter, referredOidSequence, resultMoMap, resultMoList);
        return resultMoListOrMap;
    }

    private MoListOrMap buildResult(MoListOrMap parentMoListOrMap, SnmpSynchronizeParameter snmpSynchronizeParameter, int referredOidSequence, Map<String, ManagedObject> resultMoMap, List<ManagedObject> resultMoList) {
        MoListOrMap resultMoListOrMap = new MoListOrMap();
        if (referredOidSequence == -1) {
            resultMoListOrMap.setMoCollection(resultMoList);
        } else {
            resultMoListOrMap.setMoMap(resultMoMap);
        }
        LOGGER.info((Object)("resultMoListOrMap in list synchronizer is : " + resultMoListOrMap), 200L);
        resultMoListOrMap = super.postProcessAfterConstructMo(snmpSynchronizeParameter, parentMoListOrMap, resultMoListOrMap);
        LOGGER.info((Object)("resultMoListOrMap in list synchronizer after post process is : " + resultMoListOrMap), 200L);
        return resultMoListOrMap;
    }

    private void constructManagedObject(ManagedObject halfConstructMo) {
        for (Map.Entry<String, String> entry : super.getPropertyNameReferenceMap().entrySet()) {
            String referingPropertyName = entry.getKey();
            String referredPropertyName = entry.getValue();
            try {
                Class<?> moClass = halfConstructMo.getClass();
                Method refMethod = moClass.getMethod("get" + SynchronizeUtil.formatPropertyName(referredPropertyName), new Class[0]);
                Method propertySetMethod = moClass.getMethod("set" + SynchronizeUtil.formatPropertyName(referingPropertyName), refMethod.getReturnType());
                propertySetMethod.invoke((Object)halfConstructMo, refMethod.invoke((Object)halfConstructMo, new Object[0]));
            }
            catch (Exception e) {
                LOGGER.error((Object)("exception when constructManagedObject, referredPropertyName is : " + referredPropertyName + ", referingPropertyName is : " + referingPropertyName + ExceptionUtil.getErrorMessage(e)), 200L);
            }
        }
    }

    private void processOneLine(MoListOrMap parentMoListOrMap, int[] referredAReferingOidSequence, Map<String, ManagedObject> resultMoMap, SnmpProcessParamInfo param, ManagedObject halfConstructMo) {
        String[] propertyNameArray = param.getPropertyNameArray();
        String[] propertyTypeArray = param.getPropertyTypeArray();
        String[] snmpValues = param.getSnmpValues();
        for (int i = 0; i < snmpValues.length; ++i) {
            String mibValue = snmpValues[i];
            String propertyName = propertyNameArray[i];
            String propertyType = propertyTypeArray[i];
            try {
                super.populateMoPropertyValue(mibValue, propertyType, propertyName, halfConstructMo);
            }
            catch (Exception e) {
                LOGGER.error((Object)("exception when construct mo, propertyType is : " + propertyType + ", propertyName is : " + propertyName + ", halfConstructMo is " + halfConstructMo + ExceptionUtil.getErrorMessage(e)), 200L);
            }
            int referredOidSequence = referredAReferingOidSequence[0];
            int referingOidSequence = referredAReferingOidSequence[1];
            this.processMaxDepth(parentMoListOrMap, referingOidSequence, halfConstructMo, i, mibValue);
            if (i != referredOidSequence) continue;
            resultMoMap.put(mibValue, halfConstructMo);
        }
    }

    private void processMaxDepth(MoListOrMap parentMoListOrMap, int referingOidSequence, ManagedObject halfConstructMo, int i, String mibValue) {
        if (i == referingOidSequence) {
            Map<String, ManagedObject> parentMoMap = null;
            if (null != parentMoListOrMap) {
                parentMoMap = parentMoListOrMap.getMoMap();
            }
            if (parentMoMap != null) {
                ManagedObject parentMo = parentMoListOrMap.getMoMap().get(mibValue);
                if (parentMo != null) {
                    parentMo.addChildMo(halfConstructMo);
                } else {
                    LOGGER.error((Object)("parentMo is null, mappings is : " + parentMoListOrMap.getMoMap() + ", mibValue is : " + mibValue), 200L);
                }
            } else {
                LOGGER.error((Object)("parentMoMap is null, parentMoListOrMap is : " + parentMoListOrMap + ", mibValue is : " + mibValue), 200L);
            }
        }
    }
}

