/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.FieldGetter;
import com.huawei.lego.core.sdk.util.FieldPutter;
import com.huawei.lego.core.sdk.util.NonNullFilter;
import java.io.Closeable;
import java.nio.file.Path;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class CommonUtil {
    private static final Log logger = LogFactory.getInstance(CommonUtil.class);
    private static final long MAX_SLEEP_TIME = 86400000L;
    private static final int MAX_COLUMN_NAME_LENGTH = 1024;

    private CommonUtil() {
    }

    public static void close(Closeable closed) {
        try {
            if (null != closed) {
                closed.close();
            }
        }
        catch (Exception ex) {
            logger.error("Exception while Closeable closed." + ExceptionUtil.getErrorMessage(ex));
        }
    }

    public static void destroyProcess(Process process) {
        try {
            if (null != process) {
                process.destroy();
            }
        }
        catch (Exception e) {
            logger.error("Destroying process failed." + ExceptionUtil.getErrorMessage(e));
        }
    }

    public static void sleep(long millis) {
        if (0L >= millis || 86400000L < millis) {
            logger.error((Object)("Invalid parameter. Time:" + millis), 0L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            TimeUnit.MILLISECONDS.sleep(millis);
        }
        catch (Exception e) {
            logger.error((Object)("Pausing thread failed. Millis:" + millis + ExceptionUtil.getErrorMessage(e)), 0L);
        }
    }

    public static void sleep(long duration, TimeUnit unit) {
        CommonUtil.sleep(unit.toMillis(duration));
    }

    public static boolean isValidDbColumn(String dbColumn) {
        if (dbColumn == null || dbColumn.length() == 0 || dbColumn.length() > 1024) {
            return false;
        }
        String regex = "^[a-zA-Z_0-9]*$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(Normalizer.normalize(dbColumn, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    public static <T> T getFirstElement(Collection<T> elements) {
        if (null == elements || elements.isEmpty()) {
            return null;
        }
        for (T element : elements) {
            if (null == element) continue;
            return element;
        }
        return null;
    }

    public static <T> List<T> getOrEmpty(List<T> list) {
        return CommonUtil.getOrEmpty(list, true);
    }

    public static <T> List<T> getOrEmpty(List<T> list, boolean nonNull) {
        if (list == null) {
            list = Collections.emptyList();
        }
        if (nonNull) {
            list = list.stream().filter(new NonNullFilter()).collect(Collectors.toList());
        }
        return list;
    }

    public static <I, O> List<O> get(List<I> list, FieldGetter<I, O> mapper) {
        return list.stream().map((Function)Objects.requireNonNull(mapper)).collect(Collectors.toList());
    }

    public static <I, O> List<O> get(List<I> list, String fieldName, Class<O> fieldType) {
        return list.stream().map(new FieldGetter(fieldName, fieldType)).collect(Collectors.toList());
    }

    public static <I, O, E extends I> List<O> put(List<? extends I> list, Class<O> ownerType, Class<I> fieldType, String fieldName) {
        return list.stream().map(new FieldPutter<I, O>(ownerType, fieldType, fieldName)).collect(Collectors.toList());
    }

    public static <E> E requireNonNull(E e, long errorCode, String ... parameter) {
        if (e == null) {
            throw new LegoCheckedException(errorCode, parameter);
        }
        return e;
    }

    public static DocumentBuilder createDocumentBuilder(boolean perfect) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        if (perfect) {
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        dbf.setValidating(true);
        return dbf.newDocumentBuilder();
    }

    public static SAXReader createSAXReader() throws SAXException {
        SAXReader saxReader = new SAXReader();
        CommonUtil.setSecurityFeatures(saxReader);
        return saxReader;
    }

    public static List<?> loadXmlData(Path path, String xpath) {
        try {
            Document document = CommonUtil.createSAXReader().read(path.toFile());
            return document.selectNodes(xpath);
        }
        catch (DocumentException | SAXException e) {
            logger.error((Object)"fail to parse xml", e);
            return Collections.emptyList();
        }
    }

    public static List<Node> getNodes(Element parent, String xPath) {
        ArrayList<Node> returnedNodes = new ArrayList<Node>();
        List nodes = parent.selectNodes(xPath);
        if (null != nodes && !nodes.isEmpty()) {
            for (Node node : nodes) {
                returnedNodes.add(node);
            }
        }
        return returnedNodes;
    }

    public static void setSecurityFeatures(SAXReader reader) throws SAXException {
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    public static void setSecurityFeatures(SAXParserFactory factory) throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException {
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    public static void setSecurityFeatures(DocumentBuilderFactory factory) throws ParserConfigurationException {
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }
}

