/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ReflectUtil;
import java.util.function.Function;

public class FieldPutter<I, O>
implements Function<Object, O> {
    private static final Log logger = LogFactory.getInstance(FieldPutter.class);
    private Class<O> ownerType;
    private Class<I> fieldType;
    private String fieldName;

    public FieldPutter(Class<O> ownerType, Class<I> fieldType, String fieldName) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.ownerType = ownerType;
    }

    @Override
    public O apply(Object t) {
        O o = this.create();
        if (o == null) {
            return null;
        }
        boolean done = ReflectUtil.set(o, ReflectUtil.setter(this.ownerType, this.fieldName, this.fieldType), t);
        done = done || ReflectUtil.set(o, ReflectUtil.field(this.ownerType, this.fieldName, this.fieldType), t);
        return (O)(done ? o : null);
    }

    private O create() {
        O o;
        try {
            o = this.ownerType.newInstance();
        }
        catch (InstantiationException e) {
            logger.trace(e);
            o = null;
        }
        catch (IllegalAccessException e) {
            logger.trace(e);
            o = null;
        }
        return o;
    }
}

