/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;

public class LegoCmdUtil {
    private static final Log LOGGER = LogFactory.getInstance(LegoCmdUtil.class);
    private static final int FAIL_FLAG = -1;
    private static final long THRITY_MINUTES = 1800000L;

    public static void runbatParams(String path, String[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append("cmd /c start /b ");
        sb.append(path.replace("\\/", "/").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" " + param);
            }
        }
        LegoCmdUtil.runbat(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runbat(String cmd) {
        BufferedReader bufferedReader;
        InputStream in;
        Process child;
        block7: {
            LOGGER.debug((Object)("Run Windows Program:" + cmd), 200L);
            Runtime runtime = Runtime.getRuntime();
            child = null;
            in = null;
            bufferedReader = null;
            try {
                child = runtime.exec(cmd);
                in = child.getInputStream();
                int isSuccessful = 0;
                bufferedReader = new BufferedReader(new InputStreamReader(in, Charset.defaultCharset()));
                LegoCmdUtil.printLineStr(bufferedReader);
                isSuccessful = LegoCmdUtil.waitProcessExecuteWithTimeout(child);
                if (0 == isSuccessful) break block7;
                LOGGER.error("The executing result is not normal. Result:" + isSuccessful);
            }
            catch (IOException e) {
                try {
                    LOGGER.error((Object)("Executing windows command failed. cmd: " + cmd), e);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(bufferedReader);
                    CommonUtil.close(in);
                    if (child != null) {
                        child.destroy();
                    }
                    throw throwable;
                }
                CommonUtil.close(bufferedReader);
                CommonUtil.close(in);
                if (child != null) {
                    child.destroy();
                }
            }
        }
        CommonUtil.close(bufferedReader);
        CommonUtil.close(in);
        if (child != null) {
            child.destroy();
        }
    }

    private static void printLineStr(BufferedReader bufferedReader) throws IOException {
        int tempChar;
        StringBuffer strBuffer = new StringBuffer();
        while ((tempChar = bufferedReader.read()) != -1) {
            if ((char)tempChar != '\n' && (char)tempChar != '\r') {
                strBuffer.append((char)tempChar);
                continue;
            }
            if (!strBuffer.toString().trim().isEmpty()) {
                LOGGER.debug((Object)strBuffer.toString().trim(), 200L);
            }
            strBuffer = new StringBuffer();
        }
        if (!strBuffer.toString().trim().isEmpty()) {
            LOGGER.debug((Object)strBuffer.toString().trim(), 200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runShell(String shStr) {
        LineNumberReader input;
        InputStreamReader ir;
        Process process;
        block10: {
            block9: {
                LOGGER.debug((Object)("Linux Shell CMD: " + shStr), 200L);
                process = null;
                ir = null;
                input = null;
                try {
                    int result;
                    int tempChar;
                    process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shStr}, null, null);
                    ir = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
                    input = new LineNumberReader(ir);
                    StringBuffer sb = new StringBuffer();
                    while ((tempChar = input.read()) != -1) {
                        LegoCmdUtil.readChar(tempChar, sb);
                    }
                    if (!sb.toString().trim().isEmpty()) {
                        LOGGER.debug(sb.toString().trim());
                    }
                    if ((result = LegoCmdUtil.waitProcessExecuteWithTimeout(process)) != 0) {
                        LOGGER.error("The executing result is not normal. Result:" + result);
                        CommonUtil.close(input);
                        break block9;
                    }
                    CommonUtil.close(input);
                    break block10;
                }
                catch (Exception e) {
                    LOGGER.error("Executing linux command failed. Cmd: " + shStr + ExceptionUtil.getErrorMessage(e));
                    return;
                }
            }
            CommonUtil.close(ir);
            if (process == null) return;
            process.destroy();
            return;
        }
        CommonUtil.close(ir);
        if (process == null) return;
        process.destroy();
        return;
        finally {
            CommonUtil.close(input);
            CommonUtil.close(ir);
            if (process != null) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitProcessExecuteWithTimeout(Process process) {
        int result = -1;
        ProcessWorker worker = new ProcessWorker(process);
        try {
            worker.start();
            worker.join(1800000L);
            result = worker.getRetValue();
            if (Integer.MIN_VALUE == result) {
                result = -1;
            }
        }
        catch (Exception ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
        }
        finally {
            if (null != process) {
                process.destroy();
                process = null;
            }
        }
        return result;
    }

    private static void readChar(int tempChar, StringBuffer sb) {
        if ((char)tempChar != '\n' && (char)tempChar != '\r') {
            sb.append((char)tempChar);
        } else if (!sb.toString().trim().isEmpty()) {
            LOGGER.debug((Object)sb.toString().trim(), 200L);
        }
    }

    private static class ProcessWorker
    extends Thread {
        private final Process process;
        private int retValue = Integer.MIN_VALUE;

        public ProcessWorker(Process process) {
            this.process = process;
        }

        public int getRetValue() {
            return this.retValue;
        }

        @Override
        public void run() {
            try {
                this.retValue = this.process.waitFor();
            }
            catch (Exception e) {
                LOGGER.error("Executing waitFor failed." + ExceptionUtil.getErrorMessage(e));
            }
        }
    }
}

