/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.iam;

import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.connector.http.HttpMethod;
import com.huawei.sdk.connector.http.RequestInvocation;
import com.huawei.sdk.connector.http.RestHttpClient;
import com.huawei.sdk.connector.model.RespEntity;
import com.huawei.sdk.iam.model.Auth;
import com.huawei.sdk.iam.model.Token;
import com.huawei.sdk.iam.model.TokenInfo;
import com.huawei.sdk.iam.model.TokenRequestBody;
import com.huawei.sdk.iam.model.TokenResponseBody;
import java.io.IOException;
import java.util.Objects;
import org.apache.hc.core5.http.Header;

public class IamClient {
    public TokenInfo getTokenId(Credential credential, Auth auth) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl("/v3/auth/tokens");
        invocation.setHeader("Content-Type", "application/json;charset=utf8");
        TokenRequestBody tokenRequestBody = new TokenRequestBody();
        tokenRequestBody.setAuth(auth);
        invocation.setEntity((Object)tokenRequestBody);
        RespEntity respEntity = client.invokeWithEntity(HttpMethod.POST, invocation, TokenResponseBody.class);
        Header[] headers = respEntity.getHeaders();
        Token token = ((TokenResponseBody)respEntity.getEntity()).getToken();
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.setIssuedAt(token.getIssueAt());
        tokenInfo.setExpiresAt(token.getExpiresAt());
        for (Header header : headers) {
            if (!Objects.equals(header.getName(), "X-Subject-Token")) continue;
            tokenInfo.setTokenId(header.getValue());
            break;
        }
        return tokenInfo;
    }
}

