/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.base;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.drm.cloudservice.bo.DelTaskRequest;
import com.huawei.ism.drm.cloudservice.bo.VerifyServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.RedirectRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.enums.TaskNameCode;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.util.InstanceTypeConverter;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.VerifyServerResultBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;

public class ToolRestServiceImpl
extends RedirectRestService {
    private static final Log logger = LogFactory.getInstance(ToolRestServiceImpl.class);
    private static final int TARGET_NAME_MAX_LENGTH = 32;
    private static final int MAX_TASK_BATCH_SIZE = 256;

    public Response queryProjectBackTask(String projectId, int marker, int limit, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType, String taskName, String targetName) {
        String statusParam = this.getHttpServletRequest().getParameter("status");
        this.recordRequestLog(new StringBuffer("projectId is ").append(projectId).append(",status is : ").append(statusParam).append(", marker : ").append(marker).append(", limit :").append(limit).append(", taskName : ").append(taskName).append(", targetName : ").append(targetName).toString());
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        marker = marker < 1 ? 1 : marker;
        limit = limit < 1 || limit > 512 ? 512 : limit;
        JSONObject returnJson = new JSONObject();
        JSONArray json = new JSONArray();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("createUser", projectId);
        paramMap.put("DESC", "startTime");
        String targetType = this.getHttpServletRequest().getParameter("instance_type");
        if ("ark".equals(targetType)) {
            paramMap.put("type", targetType);
        } else if (this.checkInstanceType(instanceType, paramMap, targetType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is incorrect.");
        }
        if (!(this.checkStatusParam(statusParam, paramMap) && this.checkTaskName(taskName, paramMap) && this.checkTargetName(targetName, paramMap))) {
            returnJson.put((Object)"tasks", (Object)json);
            returnJson.put((Object)"total_count", (Object)0);
            return this.getResponse(Response.Status.OK, returnJson);
        }
        Paging paging = this.getBackTaskService().queryTasks(paramMap, --marker, limit);
        if (null == paging) {
            return this.getResponse(Response.Status.OK, returnJson);
        }
        List list = paging.getData();
        for (BackTask task : list) {
            json.add((Object)this.bulidBackTaskJson(task));
        }
        returnJson.put((Object)"tasks", (Object)json);
        returnJson.put((Object)"total_count", (Object)paging.getiCount());
        return this.getResponse(Response.Status.OK, returnJson);
    }

    private boolean checkInstanceType(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType, Map<String, Object> paramMap, String targetType) {
        String instanceTypeName;
        String string = instanceTypeName = instanceType == null ? targetType : null;
        if (instanceTypeName != null && (instanceType = InstanceTypeConverter.new2Enum(instanceTypeName)) == null) {
            return true;
        }
        if (instanceType != null) {
            paramMap.put("type", instanceType.getValue());
        }
        return false;
    }

    private boolean checkStatusParam(String statusParam, Map<String, Object> paramMap) {
        if (!VerifyUtil.isEmpty((String)statusParam)) {
            int status;
            if (statusParam.equalsIgnoreCase("success")) {
                status = CommonConstant.BACKTASK_RESULT_SUCCESS;
            } else if (statusParam.equalsIgnoreCase("failed")) {
                status = CommonConstant.BACKTASK_RESULT_FAIL;
            } else if (statusParam.equalsIgnoreCase("running")) {
                status = CommonConstant.BACKTASK_RESULT_PROCESS;
            } else {
                return false;
            }
            paramMap.put("taskResult", status);
        }
        return true;
    }

    private boolean checkTaskName(String taskName, Map<String, Object> paramMap) {
        if (!VerifyUtil.isEmpty((String)taskName)) {
            if (!TaskNameCode.isContain(taskName)) {
                logger.error((Object)"taskName is error:%s", new Object[]{taskName});
                return false;
            }
            paramMap.put("taskName", taskName);
        }
        return true;
    }

    private boolean checkTargetName(String targetName, Map<String, Object> paramMap) {
        if (!VerifyUtil.isEmpty((String)targetName)) {
            if ((targetName = targetName.trim()).length() > 32) {
                logger.error((Object)"targetName length too long, value:%s", new Object[]{targetName});
                return false;
            }
            String pattern = "^[\\u4e00-\\u9fa5_a-zA-Z0-9-]+$";
            if (!(targetName = Normalizer.normalize(targetName, Normalizer.Form.NFKC)).matches(pattern)) {
                logger.error((Object)"targetName invalid, value:%s", new Object[]{targetName});
                return false;
            }
            paramMap.put("targetName", targetName);
        }
        return true;
    }

    private JSONObject bulidBackTaskJson(BackTask task) {
        JSONObject progressJson = new JSONObject();
        progressJson.put((Object)"id", (Object)task.getTaskId().toString());
        progressJson.put((Object)"name", (Object)task.getTaskName());
        progressJson.put((Object)"target_name", (Object)task.getTargetName());
        progressJson.put((Object)"start_time", (Object)ToolRestServiceImpl.formatDate(task.getStartTime()));
        if (null == task.getEndTime()) {
            progressJson.put((Object)"end_time", (Object)"");
        } else {
            progressJson.put((Object)"end_time", (Object)ToolRestServiceImpl.formatDate(task.getEndTime()));
        }
        int status = task.getTaskResult();
        if (CommonConstant.BACKTASK_RESULT_SUCCESS == status) {
            progressJson.put((Object)"status", (Object)"success");
        } else if (CommonConstant.BACKTASK_RESULT_FAIL == status) {
            progressJson.put((Object)"status", (Object)"failed");
        } else if (CommonConstant.BACKTASK_RESULT_PROCESS == status) {
            progressJson.put((Object)"status", (Object)"running");
        } else {
            progressJson.put((Object)"status", (Object)(status + ""));
        }
        String taskDetail = task.getTaskDetail();
        progressJson.put((Object)"task_detail", (Object)(taskDetail == null ? "" : taskDetail));
        String[] taskDetailParas = task.getTaskDetailParas();
        progressJson.put((Object)"task_detail_param", (Object)(taskDetailParas == null ? new String[]{} : taskDetailParas));
        return progressJson;
    }

    private static String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeContent = dateFormat.format(date);
        String timeZoneStr = " " + TimeUtil.getDefaultTimeZone((Date)date);
        timeContent = timeContent + timeZoneStr;
        return timeContent;
    }

    public Response queryBackTaskByTaskId(String taskId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType, String projectId) {
        long taskIdToLong;
        this.recordRequestLog("taskId:" + taskId);
        if (VerifyUtil.isEmpty((String)taskId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "task_id is empty.");
        }
        try {
            taskIdToLong = Long.parseLong(taskId);
        }
        catch (NumberFormatException e) {
            return this.wrong(Response.Status.BAD_REQUEST, "task_id illegal.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        BackTask task = this.getBackTaskService().readTask(taskIdToLong);
        if (null == task || (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(task.getType()) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(task.getType())) && instanceType != null && !ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(instanceType.getValue())) {
            return this.wrong(Response.Status.NOT_FOUND, "task not exits task id is : " + taskId);
        }
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(task.getType()) && instanceType != null && !instanceType.getValue().equals(task.getType())) {
            return this.wrong(Response.Status.NOT_FOUND, "task not exits task id is : " + taskId);
        }
        if (!this.isTaskBelongToProjectId(projectId, task)) {
            return this.wrong(Response.Status.NOT_FOUND, "task not exits task id is : " + taskId);
        }
        JSONObject progressJson = this.bulidBackTaskJson(task);
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"task", (Object)progressJson);
        return this.getResponse(Response.Status.OK, returnJson);
    }

    private boolean isTaskBelongToProjectId(String projectId, BackTask task) {
        return projectId == null || projectId.equals(task.getCreateUser());
    }

    public Response deleteProjectTasks(String projectId, DelTaskRequest request, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        Set<Long> taskIds;
        this.recordRequestLog("deleteProjectTasks , the projectId : " + projectId + ", the DelTaskRequest body: " + (null == request ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (null == request || null == request.getDelTasks() || request.getDelTasks().size() == 0) {
            return this.wrong(Response.Status.BAD_REQUEST, "del_tasks is empty.");
        }
        if (request.getDelTasks().size() > 256) {
            return this.wrong(Response.Status.BAD_REQUEST, "too many tasks in request.");
        }
        IBackTaskService service = this.getBackTaskService();
        List<BatchOperation> bathOprLst = this.getDeleteTasks(service, taskIds = this.getTaskIds(request), projectId, instanceType);
        if (VerifyUtil.isEmpty(bathOprLst)) {
            logger.error((Object)("can not find the tasks to delete!, projectId:" + projectId + "taskIds:" + taskIds));
            throw new LegoCheckedException(201L);
        }
        try {
            BatchOperationResult batchOperationResult = service.deleteTask(bathOprLst);
            this.batchOptLog(batchOperationResult, "backendTask_delete_operateName", 2, "Cloud DR Service");
            return this.getResponse(Response.Status.OK, "delete backtasks success");
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("backendTask_delete_operateName", 2, projectId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("backendTask_delete_operateName", 2, projectId, (Exception)((Object)new LegoCheckedException(-1L)), "Cloud DR Service");
            throw e;
        }
    }

    private Set<Long> getTaskIds(DelTaskRequest request) {
        List<String> taskIds = request.getDelTasks();
        HashSet<Long> backTaskIds = new HashSet<Long>();
        for (String id : taskIds) {
            try {
                long taskIdToLong = Long.parseLong(id);
                backTaskIds.add(taskIdToLong);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("request task_id illegal, task_id is: " + id));
            }
        }
        return backTaskIds;
    }

    private List<BatchOperation> getDeleteTasks(IBackTaskService service, Set<Long> taskIds, String projectId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (long taskId : taskIds) {
            BackTask backTask;
            try {
                backTask = service.readTask(taskId);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 201L) continue;
                this.writeFailedOperationLogNoException("backendTask_delete_operateName", 2, projectId, (Exception)((Object)e), "Cloud DR Service");
                throw e;
            }
            if (VerifyUtil.isEmpty((Object)backTask) || CommonConstant.BACKTASK_RESULT_PROCESS == backTask.getTaskResult() || instanceType != null && !instanceType.getValue().equals(backTask.getType()) || !projectId.equals(backTask.getCreateUser())) continue;
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(taskId);
            tempBatch.setTargetName(backTask.getTargetName());
            tempBatch.setTaskName(backTask.getTaskName());
            bathOprLst.add(tempBatch);
        }
        return bathOprLst;
    }

    public Response verifyServers(String projectId, VerifyServersRequest request, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        this.recordRequestLog("verifyServers , the projectId : " + projectId + ", the request body: " + (null == request ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (null == request) {
            return this.wrong(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        if (!this.isValidVerifyRequestParam(request, instanceType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        List azMappings = this.getOpenstackResourceService().getVHACSDRMapping(request.getRegionName(), instanceType);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("projectId", projectId);
        paramMap.put("regionName", request.getRegionName());
        paramMap.put("drProjectId", request.getRemoteProjectId());
        paramMap.put("drRegionName", request.getRemoteRegionName());
        paramMap.put("drZoneName", request.getRemoteAvailableZone());
        paramMap.put("prod_region_drZoneName", request.getDrAvailableZone());
        VerifyServerResultBO verifyResult = this.getInstanceService().verifyServers(paramMap, request.getRemoteAvailableZone(), instanceType.getValue(), request.getServers(), azMappings);
        JSONObject result = JSONObject.fromObject((Object)verifyResult);
        JSONArray resultArray = result.getJSONArray("check_errors");
        if (resultArray != null) {
            for (int i = 0; i < resultArray.toArray().length; ++i) {
                JSONObject resultJson = resultArray.getJSONObject(i);
                JSONArray servers = resultJson.getJSONArray("server_ids");
                if (servers != null && !servers.isEmpty()) continue;
                resultJson.remove((Object)"server_ids");
            }
        }
        return this.getResponse(Response.Status.OK, result);
    }

    private boolean isValidVerifyRequestParam(VerifyServersRequest request, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        String regionName = request.getRegionName();
        String rometeRegionName = request.getRemoteRegionName();
        String remoteProjectId = request.getRemoteProjectId();
        String remoteAzName = request.getRemoteAvailableZone();
        if (VerifyUtil.isEmpty((String)regionName)) {
            logger.error((Object)"regionName is null");
            return false;
        }
        if (!ParamChecker.checkGeneralId((String)regionName)) {
            logger.error((Object)"regionName is incorrect");
            return false;
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION == instanceType || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION == instanceType || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION == instanceType) {
            if (VerifyUtil.isEmpty((String)rometeRegionName)) {
                logger.error((Object)"rometeRegionName is null");
                return false;
            }
            if (!ParamChecker.checkGeneralId((String)rometeRegionName)) {
                logger.error((Object)"rometeRegionName is incorrect");
                return false;
            }
            if (VerifyUtil.isEmpty((String)remoteProjectId)) {
                logger.error((Object)"remoteProjectId is null");
                return false;
            }
            if (!ParamChecker.checkGeneralId((String)remoteProjectId)) {
                logger.error((Object)"remoteProjectId is incorrect");
                return false;
            }
            if (VerifyUtil.isEmpty((String)remoteAzName)) {
                logger.error((Object)"remoteAzName is null");
                return false;
            }
            if (!ParamChecker.checkGeneralId((String)remoteAzName)) {
                logger.error((Object)"remoteAzName is incorrect");
                return false;
            }
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION == instanceType) {
            if (VerifyUtil.isEmpty((String)request.getDrAvailableZone())) {
                logger.error((Object)"csha_remoteAzName is null");
                return false;
            }
            if (!ParamChecker.checkGeneralId((String)request.getDrAvailableZone())) {
                logger.error((Object)"csha_remoteAzName is incorrect");
                return false;
            }
        }
        return this.isValidServersParam(request.getServers(), instanceType);
    }

    private boolean isValidServersParam(List<ServerBO> servers, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        if (VerifyUtil.isEmpty(servers)) {
            logger.error((Object)"server list is null");
            return false;
        }
        if (servers.size() > 256) {
            logger.error((Object)"servers in server list is more than 256");
            return false;
        }
        for (ServerBO server : servers) {
            if (VerifyUtil.isEmpty((String)server.getServerId())) {
                logger.error((Object)"serverId is null");
                return false;
            }
            if (!ParamChecker.checkGeneralId((String)server.getServerId())) {
                logger.error((Object)"serverId is incorrect");
                return false;
            }
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION == instanceType || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION == instanceType || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION == instanceType) {
                if (VerifyUtil.isEmpty((String)server.getOccupiedServerId())) {
                    logger.error((Object)"occupiedServerId is null");
                    return false;
                }
                if (!ParamChecker.checkGeneralId((String)server.getOccupiedServerId())) {
                    logger.error((Object)"occupiedServerId is incorrect");
                    return false;
                }
            }
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION == instanceType) {
                if (VerifyUtil.isEmpty((String)server.getCshaOccupiedServerId())) {
                    logger.error((Object)"csha_occupiedServerId is null");
                    return false;
                }
                if (!ParamChecker.checkGeneralId((String)server.getCshaOccupiedServerId())) {
                    logger.error((Object)"csha_occupiedServerId is incorrect");
                    return false;
                }
            }
            if (this.isValidVolumesParam(server.getVolumes())) continue;
            return false;
        }
        return true;
    }

    private boolean isValidVolumesParam(List<VolumeBO> volumes) {
        if (VerifyUtil.isEmpty(volumes)) {
            logger.error((Object)"Server volumes is empty.");
            return false;
        }
        if (volumes.size() > 60) {
            logger.error((Object)"volumes of server is more than 60");
            return false;
        }
        for (VolumeBO vol : volumes) {
            if (VerifyUtil.isEmpty((String)vol.getVolumeId())) {
                logger.error((Object)"volId is null");
                return false;
            }
            if (!ParamChecker.checkGeneralId((String)vol.getVolumeId())) {
                logger.error((Object)"volId is incorrect");
                return false;
            }
            if (!ParamChecker.checkVolumeType((String)vol.getVolumeType())) {
                logger.error((Object)"vol_type is incorrect");
                return false;
            }
            if (ParamChecker.checkVolumeType((String)vol.getDrVolumeType())) continue;
            logger.error((Object)"remote_vol_type is incorrect");
            return false;
        }
        return true;
    }
}

