/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs;

import com.huawei.csr.framework.core.context.RequestContext;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.service.QuotaService;
import com.huawei.ism.drm.cert.sdk.model.CertificateContent;
import com.huawei.ism.drm.cert.sdk.model.CertificateOperateStatus;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateTaskData;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateTaskStatus;
import com.huawei.ism.drm.cert.sdk.service.ISysCertRmiService;
import com.huawei.ism.drm.cloudservice.bo.AddServersRequest;
import com.huawei.ism.drm.cloudservice.bo.AddVolumeToVmRequest;
import com.huawei.ism.drm.cloudservice.bo.AlarmOperationRequest;
import com.huawei.ism.drm.cloudservice.bo.CreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.bo.DelTaskRequest;
import com.huawei.ism.drm.cloudservice.bo.DelVolumeFromVmRequest;
import com.huawei.ism.drm.cloudservice.bo.PolicyRequest;
import com.huawei.ism.drm.cloudservice.bo.RecoveryContinueRequest;
import com.huawei.ism.drm.cloudservice.bo.RecoveryPolicy;
import com.huawei.ism.drm.cloudservice.bo.SftpPolicy;
import com.huawei.ism.drm.cloudservice.bo.SftpPolicyRequest;
import com.huawei.ism.drm.cloudservice.bo.SftpServerInfoRequest;
import com.huawei.ism.drm.cloudservice.bo.SftpServiceOperateStatus;
import com.huawei.ism.drm.cloudservice.bo.UnitePasswordInfo;
import com.huawei.ism.drm.cloudservice.bo.UpdateInstanceRequest;
import com.huawei.ism.drm.cloudservice.bo.UpdateProjectQuotaRequest;
import com.huawei.ism.drm.cloudservice.bo.UpdateServerRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseCloudRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.base.BaseRestServiceImpl;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.base.ToolRestServiceImpl;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.FeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.QuotaUtilService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BatchSubscriptionRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddVolumeToVmRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsCreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsVerifyServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.Subscription;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.AppRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.constants.ApplicationEnumDefine;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.ApplicationQuotaPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.CreateApplicationPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.CreateServiceInstancePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.ServiceInstanceQuotaPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.TaskVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.util.I18N;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.util.InstanceTypeConverter;
import com.huawei.ism.drm.cloudservice.web.security.ScopeCheck;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.AlarmRecord;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.SynProgressInfo;
import com.huawei.ism.drm.openstack.sdk.service.ICloudServiceFaultService;
import com.huawei.ism.drm.openstack.sdk.service.IOpenStackRecoveryService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IUnitePasswordService;
import com.huawei.ism.drm.rest.service.framework.user.service.UserRestServiceValidator;
import com.huawei.ism.drm.system.cfgdata.sdk.model.FtpServerInfo;
import com.huawei.ism.drm.system.cfgdata.sdk.model.TaskResult;
import com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupService;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Account;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.BackTaskState;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.meter.service.MeterService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public class BcsRestServiceImpl
extends BaseCloudRestService {
    private static final Log logger = LogFactory.getInstance(BcsRestServiceImpl.class);
    private static final String SFTP_PROTOCOL = "SFTP";
    private static final int MIN_PASSWORD_LENGTH = 8;
    private static final int MAX_PASSWORD_LENGTH = 64;
    private static final int MAX_SUBSCRIPTION_BATCH_SIZE = 3000;
    private static final Map<String, List<String>> OPERATE_MAPPINGS = BcsRestServiceImpl.getOperateMappings();
    private static final HashMap<Long, String> MANAGEONE_ERRORCODE_MAP = BcsRestServiceImpl.getManageOneErrorCodeMap();
    private IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
    private I18N i18n;
    private QuotaUtilService quotaUtilService;
    private AppRestService appRestService;

    public AppRestService getAppRestService() {
        return this.appRestService;
    }

    public void setAppRestService(AppRestService appRestService) {
        this.appRestService = appRestService;
    }

    public I18N getI18n() {
        return this.i18n;
    }

    public void setI18n(I18N i18n) {
        this.i18n = i18n;
    }

    public QuotaUtilService getQuotaUtilService() {
        return this.quotaUtilService;
    }

    public void setQuotaUtilService(QuotaUtilService quotaUtilService) {
        this.quotaUtilService = quotaUtilService;
    }

    private static HashMap<Long, String> getManageOneErrorCodeMap() {
        HashMap<Long, String> manageOneErrorCodeMap = new HashMap<Long, String>();
        manageOneErrorCodeMap.put(1073947393L, "backup-1120");
        manageOneErrorCodeMap.put(1073947450L, "backup-2021");
        manageOneErrorCodeMap.put(1073948931L, "backup-2022");
        manageOneErrorCodeMap.put(606L, "backup-1001");
        return manageOneErrorCodeMap;
    }

    private static Map<String, List<String>> getOperateMappings() {
        HashMap<String, List<String>> mappings = new HashMap<String, List<String>>();
        mappings.put("apply", Arrays.asList("add_instance", "add_application"));
        mappings.put("modify", Arrays.asList("add_servers", "del_servers", "add_volumes", "del_volumes", "upgrade_instance", "downgrade_instance", "add_instances", "remove_instance"));
        mappings.put("delete", Arrays.asList("del_instance", "delete_application"));
        return Collections.unmodifiableMap(mappings);
    }

    public RequestContext getRequestContext() {
        RequestContext context = new RequestContext();
        context.setProjectId(this.getUserProjectId());
        String user = (String)this.getRequest().getAttribute("iam-x-auth-user-json");
        if (VerifyUtil.isEmpty((String)user)) {
            user = super.getUserJson();
        }
        JSONObject userObj = JSONObject.fromObject((Object)user);
        context.setUserId(userObj.getString("id"));
        context.setUserName(userObj.getString("name"));
        context.setUserDomain(userObj.getString("domain"));
        context.setAuthToken((String)this.getRequest().getAttribute("auth-token"));
        return context;
    }

    @GET
    @Path(value="/{project_id}/instances")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryServiceInstanceList(@PathParam(value="project_id") String projectId, @DefaultValue(value="1") @QueryParam(value="marker") int marker, @DefaultValue(value="512") @QueryParam(value="limit") int limit) {
        return this.redirect(BaseRestServiceImpl.class).queryServiceInstanceList(projectId, marker, limit, null);
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryServiceInstance(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId) {
        return this.redirect(BaseRestServiceImpl.class).queryServiceInstance(projectId, instanceId, null);
    }

    @PUT
    @Path(value="/{project_id}/instances/{instance_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response updateServiceInstBasicInfo(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, UpdateInstanceRequest request) {
        return this.redirect(BaseRestServiceImpl.class).updateServiceInstBasicInfo(projectId, instanceId, request);
    }

    @POST
    @Path(value="/{project_id}/instances/{instance_id}/policy/action/modify")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response modifyPolicy(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, PolicyRequest request) {
        return this.redirect(BaseRestServiceImpl.class).modifyPolicy(projectId, instanceId, request);
    }

    @POST
    @Path(value="/{project_id}/instances/{instance_id}/action/check")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response checkServiceInstance(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId) {
        return this.redirect(BaseRestServiceImpl.class).checkServiceInstance(projectId, instanceId);
    }

    @POST
    @Path(value="/{project_id}/instances/{instance_id}/action/test")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response test(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId) {
        return this.redirect(BaseRestServiceImpl.class).test(projectId, instanceId);
    }

    @POST
    @Path(value="/{project_id}/instances/{instance_id}/action/clear")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response clear(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId) {
        return this.redirect(BaseRestServiceImpl.class).clear(projectId, instanceId);
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}/servers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryVMList(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, @DefaultValue(value="1") @QueryParam(value="marker") int marker, @DefaultValue(value="512") @QueryParam(value="limit") int limit) {
        return this.redirect(BaseRestServiceImpl.class).queryVMList(projectId, instanceId, marker, limit);
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}/servers/{server_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryVM(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, @PathParam(value="server_id") String serverId) {
        return this.redirect(BaseRestServiceImpl.class).queryVM(projectId, instanceId, serverId);
    }

    @PUT
    @Path(value="/{project_id}/instances/{instance_id}/servers/{server_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response updateServerInfo(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, @PathParam(value="server_id") String serverId, UpdateServerRequest updateServerRequest) {
        return this.redirect(BaseRestServiceImpl.class).updateServerInfo(projectId, instanceId, serverId, updateServerRequest);
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}/servers/{server_id}/volumes")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryVolumeListByServerId(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, @PathParam(value="server_id") String serverId) {
        return this.redirect(BaseRestServiceImpl.class).queryVolumeListByServerId(projectId, instanceId, serverId);
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}/recovery-logs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryRecoveryLogs(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, @DefaultValue(value="1") @QueryParam(value="marker") int marker, @DefaultValue(value="512") @QueryParam(value="limit") int limit) {
        return this.redirect(BaseRestServiceImpl.class).queryLogsByType(projectId, instanceId, marker, limit, false);
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}/recovery-logs/{log_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryRecoveryLog(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, @PathParam(value="log_id") String logId) {
        return this.redirect(BaseRestServiceImpl.class).queryRecoveryLog(projectId, instanceId, logId);
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}/replication-logs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryReplicationLogs(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, @DefaultValue(value="1") @QueryParam(value="marker") int marker, @DefaultValue(value="512") @QueryParam(value="limit") int limit) {
        return this.redirect(BaseRestServiceImpl.class).queryLogsByType(projectId, instanceId, marker, limit, true);
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}/replication-logs/{log_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryReplicationLog(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, @PathParam(value="log_id") String logId) {
        return this.redirect(BaseRestServiceImpl.class).queryReplicationLog(projectId, instanceId, logId);
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}/progress")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryInstanceSynProgress(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId) {
        this.recordRequestLog("query InstanceSynProgress , the projectId : " + projectId + " ,the instanceId : " + instanceId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is incorrect.");
        }
        SynProgressInfo progress = this.getInstanceService().queryInstanceSynProgress(projectId, instanceId);
        if (null == progress) {
            return this.wrong(Response.Status.NOT_FOUND, "instance progress not found.");
        }
        JSONObject jsonResult = JSONObject.fromObject((Object)progress);
        return this.getResponse(Response.Status.OK, jsonResult);
    }

    @GET
    @Path(value="/{project_id}/tasks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryProjectBackTask(@PathParam(value="project_id") String projectId, @DefaultValue(value="1") @QueryParam(value="marker") int marker, @DefaultValue(value="512") @QueryParam(value="limit") int limit, @QueryParam(value="taskName") String taskName, @QueryParam(value="targetName") String targetName) {
        return this.redirect(ToolRestServiceImpl.class).queryProjectBackTask(projectId, marker, limit, null, taskName, targetName);
    }

    @GET
    @Path(value="/{project_id}/tasks/{task_id}/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryBackTaskByTaskId(@PathParam(value="project_id") String projectId, @PathParam(value="task_id") String taskId, @QueryParam(value="instance_type") String instanceType) {
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E type = InstanceTypeConverter.new2Enum(instanceType, true);
        return this.redirect(ToolRestServiceImpl.class).queryBackTaskByTaskId(taskId, type, projectId);
    }

    @POST
    @Path(value="/{project_id}/tasks/action/delete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response deleteProjectTasks(@PathParam(value="project_id") String projectId, DelTaskRequest request) {
        return this.redirect(ToolRestServiceImpl.class).deleteProjectTasks(projectId, request, null);
    }

    @GET
    @Path(value="/config/az/pairs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryAzPairs() {
        this.recordRequestLog("query az pairs");
        String regionId = this.getHttpServletRequest().getParameter("region");
        if (regionId == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "region is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)regionId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "region is incorrect.");
        }
        String instanceType = this.getHttpServletRequest().getParameter("instance_type");
        String protectType = this.getHttpServletRequest().getParameter("protect_type");
        String insanceTransfer = this.transferForCSDR(instanceType, protectType);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getFrontValue().equals(insanceTransfer)) {
            instanceType = insanceTransfer;
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getFrontValue().equals(insanceTransfer)) {
            instanceType = insanceTransfer;
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION == InstanceTypeConverter.new2Enum(instanceType) && protectType != null && !"vha_csdr".equals(protectType) && !"csha_csdr".equals(protectType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "protect_type is not correct.");
        }
        FeatureRestService service = this.redirect(instanceType);
        if (service == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is incorrect.");
        }
        return service.queryAzPairs(regionId);
    }

    @GET
    @Path(value="/{project_id}/servers/{server_id}/os-placeholder-servers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryAvailableOsPlaceholderServers(@PathParam(value="project_id") String projectId, @PathParam(value="server_id") String serverId, @QueryParam(value="region") String regionId, @QueryParam(value="remote_region") String remoteRegionId, @QueryParam(value="remote_project_id") String remoteProjectId, @QueryParam(value="remote_available_zone") String remoteAzName, @QueryParam(value="protect_type") String protectType) {
        this.recordRequestLog("query available os placeholder servers. projectId:" + projectId + ",serverId:" + serverId + ",regionId:" + regionId + ",remoteRegionId:" + remoteRegionId + ",remoteAzName:" + remoteAzName);
        Map<String, String> paramCheckMap = this.buildParamMap(projectId, serverId, regionId, remoteAzName);
        Optional errorMessage = ParamChecker.checkNotEmptyParam(paramCheckMap, ParamChecker::checkGeneralId);
        if (errorMessage.isPresent()) {
            return this.wrong(Response.Status.BAD_REQUEST, (String)errorMessage.get());
        }
        String instanceType = this.getHttpServletRequest().getParameter("instance_type");
        if (VerifyUtil.isEmpty((String)instanceType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is empty.");
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(instanceType)) {
            if (VerifyUtil.isEmpty((String)remoteRegionId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "remoteRegionId is empty.");
            }
            if (!ParamChecker.checkGeneralId((String)remoteRegionId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "remoteRegionId is incorrect.");
            }
            if (VerifyUtil.isEmpty((String)remoteProjectId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "remoteProjectId is empty.");
            }
            if (!ParamChecker.checkGeneralId((String)remoteProjectId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "remoteProjectId is incorrect.");
            }
        }
        if (protectType != null && !"csha_csdr".equals(protectType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "protect_type parameter is wrong.");
        }
        FeatureRestService service = this.redirect(instanceType);
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E serviceInstanceType = InstanceTypeConverter.new2Enum(instanceType);
        if (service == null || serviceInstanceType == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is incorrect.");
        }
        if ("csha_csdr".equals(protectType) && !this.checkCshaCsdrAzAvaiable(instanceType, regionId, remoteRegionId, remoteAzName)) {
            throw new LegoCheckedException(1073949724L, "remoteAzName is incorrect.");
        }
        return service.queryAvailableOsPlaceholderServers(serviceInstanceType.getValue(), serverId, projectId, remoteProjectId, service.initOpenStackAvailabilityZoneMapping(regionId, remoteRegionId, remoteAzName));
    }

    private Map<String, String> buildParamMap(String projectId, String serverId, String regionId, String remoteAzName) {
        HashMap<String, String> paramCheckMap = new HashMap<String, String>();
        paramCheckMap.put("project_id", projectId);
        paramCheckMap.put("server_id", serverId);
        paramCheckMap.put("regionId", regionId);
        paramCheckMap.put("remoteAzName", remoteAzName);
        return paramCheckMap;
    }

    private boolean checkCshaCsdrAzAvaiable(String instanceType, String regionId, String remoteRegionId, String remoteAzName) {
        List availableAZMapping = this.getOpenstackResourceService().getVHACSDRMapping(regionId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION);
        if (VerifyUtil.isEmpty((Collection)availableAZMapping)) {
            return false;
        }
        boolean isExistRingAz = false;
        for (int i = 0; i < availableAZMapping.size(); ++i) {
            Map currentMapping = (Map)availableAZMapping.get(i);
            String primaryRegionId = (String)currentMapping.get("primary_region_id");
            String drRregionId = (String)currentMapping.get("second_region_id");
            String primaryAzId = (String)currentMapping.get("primary_az_id");
            String drZzId = (String)currentMapping.get("second_az_id");
            String sameRegionDrZzId = (String)currentMapping.get("dr_second_az_id");
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue().equals(instanceType)) {
                if (primaryRegionId.equals(regionId) && drRregionId.equals(remoteRegionId) && drZzId.equals(remoteAzName)) {
                    isExistRingAz = true;
                    break;
                }
                if (!primaryRegionId.equals(remoteRegionId) || !drRregionId.equals(regionId) || !primaryAzId.equals(remoteAzName)) continue;
                isExistRingAz = true;
                break;
            }
            if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getFrontValue().equals(instanceType) || !primaryRegionId.equals(regionId) && !drRregionId.equals(regionId) || !sameRegionDrZzId.equals(remoteAzName) && !primaryAzId.equals(remoteAzName)) continue;
            isExistRingAz = true;
            break;
        }
        return isExistRingAz;
    }

    private String transferForCSDR(String instanceType, String protectType) {
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION == InstanceTypeConverter.new2Enum(instanceType) && protectType != null && "vha_csdr".equals(protectType)) {
            instanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getFrontValue();
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION == InstanceTypeConverter.new2Enum(instanceType) && protectType != null && "csha_csdr".equals(protectType)) {
            instanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getFrontValue();
        } else if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION == InstanceTypeConverter.new2Enum(instanceType) && protectType != null && !"vha_csdr".equals(protectType) && !"csha_csdr".equals(protectType)) {
            return "protect_type is not correct.";
        }
        return instanceType;
    }

    @GET
    @Path(value="/{project_id}/protectable-servers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryProtectableServers(@PathParam(value="project_id") String projectId, @QueryParam(value="region") String regionId, @QueryParam(value="available_zone") String availableZone, @QueryParam(value="instance_type") String instancetype, @QueryParam(value="protect_type") String protectType, @QueryParam(value="instance_id") String instanceId) {
        FeatureRestService service;
        String instanceType = this.getHttpServletRequest().getParameter("instance_type");
        this.recordRequestLog("query protectable servers. projectId:" + projectId + ",regionId:" + regionId + ",availableZone:" + availableZone + ",instanceType:" + instanceType);
        if (protectType != null && !"csha_csdr".equals(protectType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "protect_type parameter is wrong.");
        }
        if (protectType != null && "csha_csdr".equals(protectType) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getFrontValue().equals(instancetype)) {
            instanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getFrontValue();
        }
        if ((service = this.redirect(instanceType)) == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)regionId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "region is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)regionId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "region is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)availableZone)) {
            return this.wrong(Response.Status.BAD_REQUEST, "available_zone is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)availableZone)) {
            return this.wrong(Response.Status.BAD_REQUEST, "available_zone is incorrect.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is incorrect.");
        }
        return service.queryProtectableServers(projectId, regionId, availableZone, instanceType, instanceId);
    }

    @POST
    @Path(value="/{project_id}/servers/action/check_protectable")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response verifyServers(@PathParam(value="project_id") String projectId, BcsVerifyServersRequest request) {
        if (request.getProtectType() != null && !"vha_csdr".equals(request.getProtectType()) && !"csha_csdr".equals(request.getProtectType())) {
            return this.wrong(Response.Status.BAD_REQUEST, "protect_type parameter is wrong.");
        }
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E type = request.getProtectType() != null && "vha_csdr".equals(request.getProtectType()) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(InstanceTypeConverter.new2Enum(request.getInstanceType(), true).getValue()) ? ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION : (request.getProtectType() != null && "csha_csdr".equals(request.getProtectType()) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(InstanceTypeConverter.new2Enum(request.getInstanceType(), true).getValue()) ? ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION : InstanceTypeConverter.new2Enum(request.getInstanceType(), true));
        return this.redirect(ToolRestServiceImpl.class).verifyServers(projectId, request, type);
    }

    @GET
    @Path(value="/{project_id}/quotas")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryProjectQuota(@PathParam(value="project_id") String projectId) {
        this.recordRequestLog("query ProjectQuato , the projectId : " + projectId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        IQuotaService service = (IQuotaService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IQuotaService.class.getName(), IQuotaService.class);
        JSONArray json = service.queryProjectQuotaInfo(projectId);
        JSONObject jsonResult = new JSONObject();
        if (null == json) {
            return this.getResponse(Response.Status.OK, jsonResult);
        }
        jsonResult.put((Object)"quotas", (Object)json);
        return this.getResponse(Response.Status.OK, jsonResult);
    }

    @PUT
    @Path(value="/{project_id}/quotas")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response updateProjectQuota(@PathParam(value="project_id") String projectId, UpdateProjectQuotaRequest request) {
        this.recordRequestLog("updateProjectQuato , the projectId : " + projectId + ", the request body: " + (null == request ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (null == request) {
            return this.wrong(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        if (!this.quotaUtilService.validUpdateRequestParam(request)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        try {
            IQuotaService service = (IQuotaService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IQuotaService.class.getName(), IQuotaService.class);
            service.updateProjectQuotaInfo(projectId, request.getQuotas());
            this.writeSucOperationLog("quota_project_modify_operationname", 3, projectId, "quota_project_modify_log_detail", new String[]{projectId, request.toString()}, "Cloud DR Service");
            return this.getResponse(Response.Status.OK, "update quota success");
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("quota_project_modify_operationname", 3, projectId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("quota_project_modify_operationname", 3, projectId, (Exception)((Object)new LegoCheckedException(-1L)), "Cloud DR Service");
            throw e;
        }
    }

    @POST
    @Path(value="/precheck")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response quotasBudget(@ScopeCheck(value="subscriptions.projectId") BatchSubscriptionRequest request) {
        List<Subscription> subscriptions = request.getSubscriptions();
        if (VerifyUtil.isEmpty(subscriptions)) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscriptions is empty.");
        }
        if (subscriptions.size() > 3000) {
            return this.wrong(Response.Status.BAD_REQUEST, "too many subscriptions in request.");
        }
        Iterator<Subscription> iterator = subscriptions.iterator();
        if (iterator.hasNext()) {
            Subscription subscription = iterator.next();
            return this.redirectQuotasBudget(subscription);
        }
        return Response.ok().build();
    }

    private Response redirectQuotasBudget(Subscription subscription) {
        JSONObject json = JSONObject.fromObject((Object)(subscription != null ? subscription.getParams() : "{}"));
        String rawInstanceType = json.containsKey((Object)"instance_type") ? json.getString("instance_type") : null;
        String error = this.checkSubscription(subscription, false);
        if (error != null) {
            logger.error((Object)("Failed to check Subscription, error=" + error));
            return this.wrong(Response.Status.BAD_REQUEST, error);
        }
        JSONObject data = JSONObject.fromObject((Object)subscription.getParams());
        String action = this.getStringAndDrop(data, "action");
        String projectId = subscription.getProjectId();
        if (ApplicationEnumDefine.ApplicationOperateType.fromType(action) != null) {
            return this.redirectQuotasToApp(action, projectId, data);
        }
        String instanceType = this.getInstanceType(subscription);
        FeatureRestService service = this.redirect(instanceType);
        if (service == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "not supported for " + instanceType);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.ADD_INSTANCE.isCurrent(action)) {
            return this.createServiceInstanceQuotasBudget(service, data, projectId);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.ADD_SERVERS.isCurrent(action)) {
            return this.addServerQuotasBudget(service, projectId, data);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.ADD_VOLUMES.isCurrent(action)) {
            return this.addVolumeToVmQuotasBudget(service, projectId, data);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_INSTANCE.isCurrent(action)) {
            return this.deleteServiceInstanceCheck(service, projectId, data);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_SERVERS.isCurrent(action)) {
            return this.deleteServersCheck(service, projectId, data);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_VOLUMES.isCurrent(action)) {
            return this.delVolumeFromVmCheck(service, projectId, data);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.UPGRADE_INSTANCE.isCurrent(action)) {
            return this.upgradeServerQuotasBudget(service, projectId, subscription, data);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DOWNGRADE_INSTANCE.isCurrent(action)) {
            return this.downgradeServiceInstanceCheck(service, projectId, subscription, data, rawInstanceType);
        }
        return this.wrong(Response.Status.BAD_REQUEST, "not supported operation");
    }

    private Response redirectQuotasToApp(String action, String projectId, JSONObject data) {
        QuotaService quotaService = CommonUtil.getCsrService(QuotaService.class);
        if (ApplicationEnumDefine.ApplicationOperateType.ADD_INSTANCES.isCurrent(action)) {
            return this.getAddInstanceQuotas(projectId, data, quotaService);
        }
        if (ApplicationEnumDefine.ApplicationOperateType.REMOVE_INSTANCE.isCurrent(action)) {
            return this.getRemoveInstanceQuotas(projectId, data, quotaService);
        }
        if (ApplicationEnumDefine.ApplicationOperateType.ADD_APPLICATION.isCurrent(action)) {
            return this.getAddAppQuotas(projectId, data, quotaService);
        }
        if (ApplicationEnumDefine.ApplicationOperateType.DELETE_APPLICATION.isCurrent(action)) {
            return this.getDeleteAppQuotas(projectId, data, quotaService);
        }
        return this.wrong(Response.Status.BAD_REQUEST, "not supported operation");
    }

    private Response getDeleteAppQuotas(String projectId, JSONObject data, QuotaService quotaService) {
        String applicationId = data.getString("application_id");
        try {
            JSONObject result = quotaService.checkCanDeleteApplication(projectId, applicationId);
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 1, applicationId, null, new String[0], "ark");
            return this.getResponse(Response.Status.OK, result);
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 1, applicationId, (Exception)((Object)new LegoCheckedException(-1L)), "ark");
            if (e instanceof LegoCheckedException) {
                throw e;
            }
            throw new LegoCheckedException("GetDeleteAppQuotas failed . msg: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private Response getAddAppQuotas(String projectId, JSONObject data, QuotaService quotaService) {
        ApplicationQuotaPara applicationQuotaPara = (ApplicationQuotaPara)JSONObject.toBean((JSONObject)data.getJSONObject("application"), ApplicationQuotaPara.class);
        try {
            Application application = this.convertApplication(applicationQuotaPara);
            JSONObject result = quotaService.getAddApplicationQuotaUsed(projectId, application);
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 1, applicationQuotaPara.getName(), null, new String[0], "ark");
            return this.getResponse(Response.Status.OK, result);
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 1, applicationQuotaPara.getName(), (Exception)((Object)new LegoCheckedException(-1L)), "ark");
            if (e instanceof LegoCheckedException) {
                throw e;
            }
            throw new LegoCheckedException("GetAddAppQuotas failed . msg: %s" + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private Response getRemoveInstanceQuotas(String projectId, JSONObject data, QuotaService quotaService) {
        String applicationId = data.getString("application_id");
        try {
            JSONObject result = quotaService.checkCanRemoveInstance(projectId, applicationId);
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 1, applicationId, null, new String[0], "ark");
            return this.getResponse(Response.Status.OK, result);
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 1, applicationId, (Exception)((Object)new LegoCheckedException(-1L)), "ark");
            if (e instanceof LegoCheckedException) {
                throw e;
            }
            throw new LegoCheckedException("GetRemoveInstanceQuotas failed . msg: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private Response getAddInstanceQuotas(String projectId, JSONObject data, QuotaService quotaService) {
        String appId = data.getString("application_id");
        try {
            ApplicationQuotaPara applicationQuotaPara = new ApplicationQuotaPara();
            List serviceInstanceQuotaParas = JSONArray.toCollection((JSONArray)data.getJSONArray("service_instances"), ServiceInstanceQuotaPara.class);
            applicationQuotaPara.setServiceInstances(serviceInstanceQuotaParas);
            applicationQuotaPara.setApplicationId(appId);
            Application application = this.convertApplication(applicationQuotaPara);
            JSONObject result = quotaService.getAddInstancesServiceQuotaUsed(projectId, application);
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 1, appId, null, new String[0], "ark");
            return this.getResponse(Response.Status.OK, result);
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 1, appId, (Exception)((Object)new LegoCheckedException(-1L)), "ark");
            if (e instanceof LegoCheckedException) {
                throw e;
            }
            throw new LegoCheckedException("getAddInstanceQuotas failed . msg: " + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private Application convertApplication(ApplicationQuotaPara applicationQuotaPara) {
        Application application = new Application();
        application.setId(applicationQuotaPara.getApplicationId());
        application.setName(applicationQuotaPara.getName());
        application.setCreateType(applicationQuotaPara.getCreateType());
        application.setDescription(applicationQuotaPara.getDescription());
        application.setStatus(applicationQuotaPara.getStatus());
        Set serviceInstances = applicationQuotaPara.getServiceInstances().stream().map(item -> {
            AppServiceInstance instance = new AppServiceInstance();
            instance.setInstanceId(item.getInstanceId());
            instance.setInstanceName(item.getInstanceName());
            instance.setServiceType(item.getServiceType());
            instance.setStatus(item.getStatus());
            return instance;
        }).collect(Collectors.toSet());
        application.setServiceInstances(serviceInstances);
        return application;
    }

    private Response downgradeServiceInstanceCheck(FeatureRestService service, String projectId, Subscription subscription, JSONObject data, String rawInstanceType) {
        String instanceId = this.getStringAndDrop(data, "instance_id");
        if (VerifyUtil.isEmpty((String)subscription.getProductId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "productId is empty.");
        }
        String productId = subscription.getProductId();
        return service.downgradeServiceInstanceCheck(projectId, instanceId, rawInstanceType, productId);
    }

    private Response upgradeServerQuotasBudget(FeatureRestService service, String projectId, Subscription subscription, JSONObject data) {
        BcsCreateInstanceRequest params = (BcsCreateInstanceRequest)JSONObject.toBean((JSONObject)data, BcsCreateInstanceRequest.class);
        if (VerifyUtil.isEmpty((Object)params) || VerifyUtil.isEmpty((Object)params.getInstance())) {
            logger.error((Object)"Failed to UPGRADE_INSTANCE, params or instance is empty.");
            return this.wrong(Response.Status.BAD_REQUEST, "params or instance is empty.");
        }
        params.getInstance().setProjectId(projectId);
        params.getInstance().setId(data.getString("instance_id"));
        if (VerifyUtil.isEmpty((String)subscription.getProductId())) {
            logger.error((Object)"Failed to UPGRADE_INSTANCE, ProductId is empty.");
            return this.wrong(Response.Status.BAD_REQUEST, "ProductId is empty.");
        }
        params.getInstance().setProductId(subscription.getProductId());
        InstanceTypeConverter.new2Old(params.getInstance());
        return service.upgradeServerQuotasBudget(params);
    }

    private Response delVolumeFromVmCheck(FeatureRestService service, String projectId, JSONObject data) {
        String instanceId = this.getStringAndDrop(data, "instance_id");
        String serverId = this.getStringAndDrop(data, "server_id");
        DelVolumeFromVmRequest params = (DelVolumeFromVmRequest)JSONObject.toBean((JSONObject)data, DelVolumeFromVmRequest.class);
        return service.delVolumeFromVmCheck(projectId, instanceId, serverId, params);
    }

    private Response deleteServersCheck(FeatureRestService service, String projectId, JSONObject data) {
        List<String> serverIds = this.getStringJSONArray(data, "server_ids");
        if (serverIds == null || serverIds.isEmpty()) {
            logger.error((Object)"Failed to DEL_SERVERS, server_ids is empty.");
            return this.wrong(Response.Status.BAD_REQUEST, "server_ids is empty.");
        }
        String instanceId = this.getStringAndDrop(data, "instance_id");
        return service.deleteServersCheck(projectId, instanceId, serverIds);
    }

    private Response deleteServiceInstanceCheck(FeatureRestService service, String projectId, JSONObject data) {
        String instanceId = this.getStringAndDrop(data, "instance_id");
        return service.deleteServiceInstanceCheck(projectId, instanceId);
    }

    private Response addVolumeToVmQuotasBudget(FeatureRestService service, String projectId, JSONObject data) {
        String instanceId = this.getStringAndDrop(data, "instance_id");
        String serverId = this.getStringAndDrop(data, "server_id");
        AddVolumeToVmRequest params = (AddVolumeToVmRequest)JSONObject.toBean((JSONObject)data, AddVolumeToVmRequest.class);
        return service.addVolumeToVmQuotasBudget(projectId, instanceId, serverId, params);
    }

    private Response addServerQuotasBudget(FeatureRestService service, String projectId, JSONObject data) {
        String instanceId = this.getStringAndDrop(data, "instance_id");
        AddServersRequest params = (AddServersRequest)JSONObject.toBean((JSONObject)data, AddServersRequest.class);
        return service.addServerQuotasBudget(projectId, instanceId, params);
    }

    private Response createServiceInstanceQuotasBudget(FeatureRestService service, JSONObject data, String projectId) {
        CreateInstanceRequest params = (CreateInstanceRequest)JSONObject.toBean((JSONObject)data, CreateInstanceRequest.class);
        InstanceTypeConverter.new2Old(params.getInstance());
        return service.createServiceInstanceQuotasBudget(projectId, params);
    }

    @POST
    @Path(value="/resources")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response resourceOperation(@ScopeCheck(value="subscriptions.projectId") BatchSubscriptionRequest request) {
        List<Subscription> subscriptions = request.getSubscriptions();
        if (VerifyUtil.isEmpty(subscriptions)) {
            logger.error((Object)"Failed to resourceOperation, subscriptions is empty.");
            return this.wrong(Response.Status.BAD_REQUEST, "subscriptions is empty.");
        }
        if (subscriptions.size() > 3000) {
            return this.wrong(Response.Status.BAD_REQUEST, "too many subscriptions in request.");
        }
        Iterator<Subscription> iterator = subscriptions.iterator();
        if (iterator.hasNext()) {
            JSONObject data;
            String action;
            Subscription subscription = iterator.next();
            String params = subscription.getParams();
            if (params != null && ApplicationEnumDefine.ApplicationOperateType.fromType(action = (data = JSONObject.fromObject((Object)params)).getString("action")) != null) {
                return this.redirectToAppController(action, subscription.getProjectId(), subscription, data);
            }
            return this.redirectResourceOperation(subscription);
        }
        return Response.ok().build();
    }

    private Response redirectResourceOperation(Subscription subscription) {
        JSONObject json = JSONObject.fromObject((Object)(subscription != null ? subscription.getParams() : "{}"));
        String rawInstanceType = json.containsKey((Object)"instance_type") ? json.getString("instance_type") : null;
        String error = this.checkSubscription(subscription, true);
        if (error != null) {
            return this.wrong(Response.Status.BAD_REQUEST, error);
        }
        String subscriptionId = subscription.getSubscriptionId();
        JSONObject data = JSONObject.fromObject((Object)subscription.getParams());
        String action = this.getStringAndDrop(data, "action");
        String instanceType = this.getInstanceType(subscription);
        FeatureRestService service = this.redirect(instanceType);
        if (service == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "not supported for " + instanceType);
        }
        String projectId = subscription.getProjectId();
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.ADD_INSTANCE.isCurrent(action)) {
            return this.createServiceInstance(subscriptionId, data, service, projectId);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.ADD_SERVERS.isCurrent(action)) {
            return this.addServer(subscriptionId, data, service, projectId);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.ADD_VOLUMES.isCurrent(action)) {
            return this.addVolumeToVm(service, subscriptionId, data, projectId);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_INSTANCE.isCurrent(action)) {
            String instanceId = this.getStringAndDrop(data, "instance_id");
            return service.deleteServiceInstance(projectId, instanceId, subscriptionId);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_SERVERS.isCurrent(action)) {
            return this.deleteServers(service, subscriptionId, data, projectId);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DEL_VOLUMES.isCurrent(action)) {
            return this.delVolumeFromVm(service, subscriptionId, data, projectId);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.UPGRADE_INSTANCE.isCurrent(action)) {
            return this.upgradeServiceInstance(service, projectId, subscription, data);
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_OPERATE_TYPE.DOWNGRADE_INSTANCE.isCurrent(action)) {
            return this.downgradeServiceInstance(service, projectId, rawInstanceType, subscription, data);
        }
        return this.wrong(Response.Status.BAD_REQUEST, "not supported operation");
    }

    private Response redirectToAppController(String action, String projectId, Subscription subscription, JSONObject data) {
        if (ApplicationEnumDefine.ApplicationOperateType.ADD_INSTANCES.isCurrent(action)) {
            return this.addServiceInstancesToApp(projectId, subscription, data);
        }
        if (ApplicationEnumDefine.ApplicationOperateType.REMOVE_INSTANCE.isCurrent(action)) {
            return this.removeServiceInstancesFromApp(projectId, subscription, data);
        }
        if (ApplicationEnumDefine.ApplicationOperateType.ADD_APPLICATION.isCurrent(action)) {
            return this.createApplication(projectId, subscription, data);
        }
        if (ApplicationEnumDefine.ApplicationOperateType.DELETE_APPLICATION.isCurrent(action)) {
            return this.deleteApplication(projectId, subscription, data);
        }
        return this.wrong(Response.Status.BAD_REQUEST, "not supported operation");
    }

    private Response addServiceInstancesToApp(String projectId, Subscription subscription, JSONObject data) {
        if (ApplicationEnumDefine.ServiceInstanceOrderOperateType.getType(subscription.getOperateType()) != ApplicationEnumDefine.ServiceInstanceOrderOperateType.MODIFY) {
            return this.wrong(Response.Status.BAD_REQUEST, "operateType must be modify");
        }
        List paraList = JSONArray.toCollection((JSONArray)data.getJSONArray("service_instances"), CreateServiceInstancePara.class);
        HashSet<CreateServiceInstancePara> paraSet = new HashSet<CreateServiceInstancePara>(paraList);
        String appId = this.getStringAndDrop(data, "application_id");
        RequestContext context = this.getRequestContext();
        TaskVo taskVo = this.appRestService.addServiceInstances(subscription.getSubscriptionId(), context, paraSet, appId);
        JSONObject returnJson = JSONObject.fromObject((Object)taskVo);
        return this.getResponse(Response.Status.ACCEPTED, returnJson);
    }

    private Response removeServiceInstancesFromApp(String projectId, Subscription subscription, JSONObject data) {
        if (ApplicationEnumDefine.ServiceInstanceOrderOperateType.getType(subscription.getOperateType()) != ApplicationEnumDefine.ServiceInstanceOrderOperateType.MODIFY) {
            return this.wrong(Response.Status.BAD_REQUEST, "operateType must be modify");
        }
        List<String> instanceIdList = this.getStringJSONArray(data, "instance_id");
        HashSet<String> instanceIdSet = new HashSet<String>(instanceIdList);
        String applicationId = this.getStringAndDrop(data, "application_id");
        RequestContext context = this.getRequestContext();
        TaskVo taskVo = this.appRestService.removeServiceInstances(subscription.getSubscriptionId(), context, instanceIdSet, applicationId);
        JSONObject returnJson = JSONObject.fromObject((Object)taskVo);
        return this.getResponse(Response.Status.ACCEPTED, returnJson);
    }

    private Response createApplication(String projectId, Subscription subscription, JSONObject data) {
        if (ApplicationEnumDefine.ServiceInstanceOrderOperateType.getType(subscription.getOperateType()) != ApplicationEnumDefine.ServiceInstanceOrderOperateType.APPLY) {
            return this.wrong(Response.Status.BAD_REQUEST, "operateType must be apply");
        }
        CreateApplicationPara applicationPara = (CreateApplicationPara)JSONObject.toBean((JSONObject)data.getJSONObject("application"), CreateApplicationPara.class);
        RequestContext context = this.getRequestContext();
        TaskVo taskVo = this.appRestService.createApp(subscription.getSubscriptionId(), context, applicationPara);
        JSONObject returnJson = JSONObject.fromObject((Object)taskVo);
        return this.getResponse(Response.Status.ACCEPTED, returnJson);
    }

    private Response deleteApplication(String projectId, Subscription subscription, JSONObject data) {
        if (ApplicationEnumDefine.ServiceInstanceOrderOperateType.getType(subscription.getOperateType()) != ApplicationEnumDefine.ServiceInstanceOrderOperateType.DELETE) {
            return this.wrong(Response.Status.BAD_REQUEST, "operateType must be delete");
        }
        String appId = this.getStringAndDrop(data, "application_id");
        RequestContext context = this.getRequestContext();
        TaskVo taskVo = this.appRestService.deleteApp(subscription.getSubscriptionId(), context, appId);
        JSONObject returnJson = JSONObject.fromObject((Object)taskVo);
        return this.getResponse(Response.Status.ACCEPTED, returnJson);
    }

    private Response downgradeServiceInstance(FeatureRestService service, String projectId, String rawInstanceType, Subscription subscription, JSONObject data) {
        String subscriptionId = subscription.getSubscriptionId();
        String instanceId = this.getStringAndDrop(data, "instance_id");
        if (VerifyUtil.isEmpty((String)subscription.getProductId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "productId is empty.");
        }
        String productId = subscription.getProductId();
        return service.downgradeServiceInstance(projectId, instanceId, rawInstanceType, subscriptionId, productId);
    }

    private Response upgradeServiceInstance(FeatureRestService service, String projectId, Subscription subscription, JSONObject data) {
        String subscriptionId = subscription.getSubscriptionId();
        BcsCreateInstanceRequest params = (BcsCreateInstanceRequest)JSONObject.toBean((JSONObject)data, BcsCreateInstanceRequest.class);
        if (VerifyUtil.isEmpty((Object)params) || VerifyUtil.isEmpty((Object)params.getInstance())) {
            logger.error((Object)"Failed to UPGRADE_INSTANCE, params or instance is empty.");
            return this.wrong(Response.Status.BAD_REQUEST, "params or instance is empty.");
        }
        params.setSubscriptionId(subscriptionId);
        params.getInstance().setProjectId(projectId);
        params.getInstance().setId(data.getString("instance_id"));
        if (VerifyUtil.isEmpty((String)subscription.getProductId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "productId is empty.");
        }
        params.getInstance().setProductId(subscription.getProductId());
        InstanceTypeConverter.new2Old(params.getInstance());
        return service.upgradeServiceInstance(params, false);
    }

    private Response delVolumeFromVm(FeatureRestService service, String subscriptionId, JSONObject data, String projectId) {
        String instanceId = this.getStringAndDrop(data, "instance_id");
        String serverId = this.getStringAndDrop(data, "server_id");
        DelVolumeFromVmRequest params = (DelVolumeFromVmRequest)JSONObject.toBean((JSONObject)data, DelVolumeFromVmRequest.class);
        return service.delVolumeFromVm(projectId, instanceId, serverId, params, subscriptionId);
    }

    private Response deleteServers(FeatureRestService service, String subscriptionId, JSONObject data, String projectId) {
        List<String> serverIds = this.getStringJSONArray(data, "server_ids");
        if (serverIds == null || serverIds.isEmpty()) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_ids is empty.");
        }
        String instanceId = this.getStringAndDrop(data, "instance_id");
        return service.deleteServers(projectId, instanceId, serverIds, subscriptionId);
    }

    private Response addVolumeToVm(FeatureRestService service, String subscriptionId, JSONObject data, String projectId) {
        String instanceId = this.getStringAndDrop(data, "instance_id");
        String serverId = this.getStringAndDrop(data, "server_id");
        BcsAddVolumeToVmRequest params = (BcsAddVolumeToVmRequest)JSONObject.toBean((JSONObject)data, BcsAddVolumeToVmRequest.class);
        params.setSubscriptionId(subscriptionId);
        return service.addVolumeToVm(projectId, instanceId, serverId, params);
    }

    private Response addServer(String subscriptionId, JSONObject data, FeatureRestService service, String projectId) {
        String instanceId = this.getStringAndDrop(data, "instance_id");
        BcsAddServersRequest params = (BcsAddServersRequest)JSONObject.toBean((JSONObject)data, BcsAddServersRequest.class);
        params.setSubscriptionId(subscriptionId);
        return service.addServer(projectId, instanceId, params);
    }

    private Response createServiceInstance(String subscriptionId, JSONObject data, FeatureRestService service, String projectId) {
        BcsCreateInstanceRequest params = (BcsCreateInstanceRequest)JSONObject.toBean((JSONObject)data, BcsCreateInstanceRequest.class);
        params.setSubscriptionId(subscriptionId);
        InstanceTypeConverter.new2Old(params.getInstance());
        return service.createServiceInstance(projectId, params);
    }

    private String getInstanceType(Subscription subscription) {
        BcsCreateInstanceRequest params;
        JSONObject data = JSONObject.fromObject((Object)subscription.getParams());
        String instanceType = this.getStringAndDrop(data, "instance_type");
        String action = this.getStringAndDrop(data, "action");
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E type = InstanceTypeConverter.new2Enum(instanceType);
        String protectType = null;
        if ("add_instance".equals(action) && !VerifyUtil.isEmpty((Object)(params = (BcsCreateInstanceRequest)JSONObject.toBean((JSONObject)data, BcsCreateInstanceRequest.class))) && !VerifyUtil.isEmpty((Object)params.getInstance())) {
            protectType = params.getInstance().getProtectType();
        }
        if (protectType != null && "vha_csdr".equals(protectType) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.equals((Object)type)) {
            instanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getFrontValue();
        } else if (protectType != null && "csha_csdr".equals(protectType) && ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.equals((Object)type)) {
            instanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getFrontValue();
        }
        if (!"add_instance".equals(action)) {
            String instanceId = data.getString("instance_id");
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(subscription.getProjectId(), instanceId, null);
            if (instanceInfoBO != null) {
                if ("vha_csdr".equals(instanceInfoBO.getProtectType()) || "upgrade_instance".equals(action)) {
                    instanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getFrontValue();
                } else if ("csha_csdr".equals(instanceInfoBO.getProtectType())) {
                    instanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getFrontValue();
                } else {
                    ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E serviceinstanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)instanceInfoBO.getType());
                    if (serviceinstanceType != null) {
                        instanceType = serviceinstanceType.getFrontValue();
                    }
                }
            }
        }
        return instanceType;
    }

    private String getStringAndDrop(JSONObject data, String key) {
        if (data == null) {
            return Optional.empty().toString();
        }
        String value = data.getString(key);
        data.remove((Object)key);
        return value;
    }

    private List<String> getStringJSONArray(JSONObject data, String key) {
        if (data == null) {
            return null;
        }
        JSONArray array = data.getJSONArray(key);
        if (array == null) {
            return null;
        }
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < array.size(); ++i) {
            String serverId = array.getString(i);
            items.add(serverId);
        }
        return items;
    }

    private String checkSubscription(Subscription subscription, boolean isCheckSubscriptionId) {
        if (subscription == null) {
            return "has null item in subscriptions.";
        }
        String operateType = subscription.getOperateType();
        if (!OPERATE_MAPPINGS.containsKey(operateType)) {
            return "operate_type is incorrect.";
        }
        String productId = subscription.getProductId();
        if (VerifyUtil.isEmpty((String)productId)) {
            return "product_id is empty.";
        }
        if (!ParamChecker.checkGeneralId((String)productId)) {
            return "product_id is incorrect.";
        }
        String projectId = subscription.getProjectId();
        if (VerifyUtil.isEmpty((String)projectId)) {
            return "project_id is empty.";
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return "project_id is incorrect.";
        }
        if (isCheckSubscriptionId) {
            String subscriptionId = subscription.getSubscriptionId();
            if (VerifyUtil.isEmpty((String)subscriptionId)) {
                return "subscription_id is empty.";
            }
            if (!ParamChecker.checkGeneralId((String)subscriptionId)) {
                return "subscription_id is incorrect.";
            }
        }
        String params = subscription.getParams();
        return this.checkOperateParam(subscription, operateType, params);
    }

    private String checkOperateParam(Subscription subscription, String operateType, String params) {
        if (VerifyUtil.isEmpty((String)params) || !ParamChecker.checkLongText((String)params)) {
            return "params is incorrect.";
        }
        JSONObject data = JSONObject.fromObject((Object)params);
        if (data.isEmpty()) {
            return "params is illegal.";
        }
        String action = data.getString("action");
        List<String> actions = OPERATE_MAPPINGS.get(operateType);
        if (actions == null || !actions.contains(action)) {
            return "operate_type and action is not match.";
        }
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType = null;
        if (ApplicationEnumDefine.ApplicationOperateType.ADD_APPLICATION.getValue().equals(action) || ApplicationEnumDefine.ApplicationOperateType.ADD_INSTANCES.getValue().equals(action) || ApplicationEnumDefine.ApplicationOperateType.DELETE_APPLICATION.getValue().equals(action) || ApplicationEnumDefine.ApplicationOperateType.REMOVE_INSTANCE.getValue().equals(action)) {
            return null;
        }
        if ("add_instance".equals(action)) {
            instanceType = InstanceTypeConverter.new2Enum(data.getString("instance_type"));
        } else {
            String instanceId = data.getString("instance_id");
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(subscription.getProjectId(), instanceId, null);
            if (instanceInfoBO != null) {
                instanceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)instanceInfoBO.getType());
            }
        }
        if (instanceType == null) {
            return "instance_type is incorrect.";
        }
        data.put((Object)"instance_type", (Object)instanceType.getFrontValue());
        subscription.setParams(data.toString());
        return null;
    }

    @POST
    @Path(value="/certificate/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response updateCertificate(CertificateUpdateParam update) {
        logger.info((Object)"start update certificate...");
        this.recordRequestLog("Update certificate.");
        ISysCertRmiService service = (ISysCertRmiService)this.getBundleService(ISysCertRmiService.class.getName(), ISysCertRmiService.class);
        Response.Status status = Response.Status.OK;
        CertificateOperateStatus certificateOperateStatus = null;
        if (!VerifyUtil.isEmpty((String)update.getCrl()) || !VerifyUtil.isEmpty((String)update.getSmCrl())) {
            if (!ParamChecker.checkBase64((String)update.getCrl()) || !ParamChecker.checkBase64((String)update.getSmCrl())) {
                return this.wrong(Response.Status.BAD_REQUEST, "crl or smCrl is incorrect.");
            }
            certificateOperateStatus = service.revokeCertificate(update);
            String objName = "Revoke Certificates";
            if (!certificateOperateStatus.failure()) {
                logger.info((Object)"update certificate succeed");
                this.writeSucOperationLog("certificate_analysis_crl", 1, objName, null, new String[0], "Cloud DR Service");
                status = Response.Status.OK;
            } else {
                logger.error((Object)"update certificate failed.");
                this.writeFailedOperationLogNoException("certificate_analysis_crl", 2, objName, (Exception)((Object)certificateOperateStatus.exception()), "Cloud DR Service");
                status = Response.Status.BAD_REQUEST;
            }
        }
        if (!(status != Response.Status.OK || update.getCert() == null && VerifyUtil.isEmpty((Collection)update.getSmCerts()))) {
            String certName;
            if (update.getCert() != null) {
                certName = update.getCert().getCertName();
            } else if (!VerifyUtil.isEmpty((Collection)update.getSmCerts())) {
                certName = ((CertificateContent)update.getSmCerts().get(0)).getCertName();
            } else {
                logger.error((Object)"cert_name is empty.");
                return this.wrong(Response.Status.BAD_REQUEST, "cert_name is empty.");
            }
            certificateOperateStatus = service.updateCertificate(update);
            if (!certificateOperateStatus.failure()) {
                logger.info((Object)("update certificate succeed.certName=" + certName));
                this.writeSucOperationLog("certificate_update", 2, certName, "certificate_update_detail", new String[]{certName, update.getTaskId()}, "Cloud DR Service");
                status = Response.Status.OK;
            } else {
                logger.error((Object)("update certificate failed.certName=" + certName));
                this.writeFailedOperationLogNoException("certificate_update", 2, certName, (Exception)((Object)certificateOperateStatus.exception()), "Cloud DR Service");
                status = Response.Status.BAD_REQUEST;
            }
        }
        JSONObject result = JSONObject.fromObject(certificateOperateStatus);
        return this.getResponse(status, result);
    }

    @GET
    @Path(value="/certificate/status/{taskId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryCertificateUpdateStatus(@PathParam(value="taskId") String taskId) {
        logger.info((Object)("query certificate status.taskId=" + (taskId != null ? taskId : "")));
        this.recordRequestLog("query certificate update status. projectId: " + this.getUserProjectId());
        if (VerifyUtil.isEmpty((String)taskId) || !ParamChecker.checkGeneralId((String)taskId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "taskId is empty or incorrect.");
        }
        ISysCertRmiService service = (ISysCertRmiService)this.getBundleService(ISysCertRmiService.class.getName(), ISysCertRmiService.class);
        CertificateUpdateTaskStatus status = service.queryCertificateUpdateTaskStatus(taskId);
        if (status == null) {
            throw new LegoCheckedException(201L, "not find task by id").log(logger);
        }
        CertificateUpdateTaskData data = status.getData();
        String detail = data.getDetail();
        if (detail != null) {
            JSONObject json = JSONObject.fromObject((Object)detail);
            String code = json.getString("code");
            JSONArray keyArgsJsonArray = json.getJSONArray("args");
            if (null == keyArgsJsonArray) {
                logger.error((Object)"Not find param key args.");
                throw new LegoCheckedException(201L, "not find param key args").log(logger);
            }
            String[] args = keyArgsJsonArray.filter(String.class).toArray(new String[0]);
            String key = "lego.err." + code;
            data.setDetail(this.i18n.translateAsZh(key, args) + "##" + this.i18n.translateAsEn(key, args));
        }
        JSONObject result = JSONObject.fromObject((Object)status);
        return this.getResponse(Response.Status.OK, result);
    }

    @PUT
    @Path(value="/bkserver")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response updateSftpServerInfo(SftpServerInfoRequest updateServerInfo) {
        SftpServiceOperateStatus sftpServiceOperateStatus;
        this.recordRequestLog("update SFTP. projectId: " + this.getUserProjectId());
        Response checkResponse = this.checkServerInfo(updateServerInfo);
        if (checkResponse != null) {
            return checkResponse;
        }
        FtpServerInfo ftpServerInfo = this.getFtpServerInfo(updateServerInfo);
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        try {
            confDataBackupService.updateFtpInfoFromMO(ftpServerInfo);
            this.writeSucOperationLog("ManageOne_updateBackupInfo_operateName", 3, "systemDataBackupParams_objectName", null, null);
            sftpServiceOperateStatus = SftpServiceOperateStatus.success();
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("ManageOne_updateBackupInfo_operateName", 3, "systemDataBackupParams_objectName", e);
            sftpServiceOperateStatus = this.getSftpServiceOperateStatus(e);
        }
        JSONObject result = JSONObject.fromObject((Object)sftpServiceOperateStatus);
        result = this.handleResult(result);
        return this.getResponse(Response.Status.OK, result);
    }

    @POST
    @Path(value="/manualpolicy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response creatBackupAction() {
        SftpServiceOperateStatus sftpServiceOperateStatus;
        this.recordRequestLog("creat BackupAction. projectId: " + this.getUserProjectId());
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        try {
            String taskId = confDataBackupService.createBackupAction();
            this.writeSucOperationLog("ManageOne_creatBackupAction_operateName", 3, "systemDataBackupParams_objectName", null, null);
            sftpServiceOperateStatus = SftpServiceOperateStatus.success(taskId);
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("ManageOne_creatBackupAction_operateName", 3, "systemDataBackupParams_objectName", e);
            sftpServiceOperateStatus = this.getSftpServiceOperateStatus(e);
        }
        JSONObject result = JSONObject.fromObject((Object)sftpServiceOperateStatus);
        return this.getResponse(Response.Status.OK, result);
    }

    @DELETE
    @Path(value="/bkserver")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response deleteSftpServerInfo(@QueryParam(value="id") Integer id) {
        SftpServiceOperateStatus sftpServiceOperateStatus;
        this.recordRequestLog("delete SFTP server Info. projectId: " + this.getUserProjectId());
        if (VerifyUtil.isEmpty((Object)id)) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("id is null or empty.")));
        }
        String ftpServerId = id.toString();
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        try {
            confDataBackupService.deleteSftpServerInfo(ftpServerId);
            this.writeSucOperationLog("ManageOne_deleteSftpServerInfo_operateName", 2, "systemDataBackupParams_objectName", null, null);
            sftpServiceOperateStatus = SftpServiceOperateStatus.success();
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("ManageOne_deleteSftpServerInfo_operateName", 2, "systemDataBackupParams_objectName", e);
            sftpServiceOperateStatus = this.getSftpServiceOperateStatus(e);
        }
        JSONObject result = JSONObject.fromObject((Object)sftpServiceOperateStatus);
        result = this.handleResult(result);
        return this.getResponse(Response.Status.OK, result);
    }

    @GET
    @Path(value="/taskstatus")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryBackupTaskStatus(@QueryParam(value="taskId") Long taskId) {
        this.recordRequestLog("query backup task status. projectId: " + this.getUserProjectId());
        JSONObject result = new JSONObject();
        if (VerifyUtil.isEmpty((Object)taskId)) {
            logger.info((Object)"taskId is null");
            result.put((Object)"taskResults", (Object)JSONArray.fromObject(Collections.emptyList()));
            return this.getResponse(Response.Status.BAD_REQUEST, result);
        }
        BackTask backTask = this.getBackTaskService().readTask(taskId.longValue());
        if (VerifyUtil.isEmpty((Object)backTask)) {
            logger.info((Object)"backTask is null or empty");
            result.put((Object)"taskResults", (Object)JSONArray.fromObject(Collections.emptyList()));
            return this.getResponse(Response.Status.OK, result);
        }
        TaskResult taskResult = this.getTaskResult(backTask);
        ArrayList<TaskResult> taskResults = new ArrayList<TaskResult>();
        taskResults.add(taskResult);
        JSONArray resultArray = JSONArray.fromObject(taskResults);
        result.put((Object)"taskResults", (Object)resultArray);
        return this.getResponse(Response.Status.OK, result);
    }

    @PUT
    @Path(value="/backuppolicy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response changeBackupPolicy(SftpPolicyRequest sftpPolicy) {
        SftpServiceOperateStatus sftpServiceOperateStatus;
        this.recordRequestLog("change backup policy. projectId: " + this.getUserProjectId());
        Response checkResponse = this.checkSftpPolicy(sftpPolicy);
        if (!VerifyUtil.isEmpty((Object)checkResponse)) {
            return checkResponse;
        }
        boolean autoBackup = sftpPolicy.getPolicy().isAutoBackup();
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        try {
            confDataBackupService.changeBackupPolicy(autoBackup);
            this.writeSucOperationLog("ManageOne_changeBackupPolicy_operateName", 3, "systemDataBackupSetting_objectName", null, null);
            this.writeAutoBackupOperationLog(autoBackup, null);
            sftpServiceOperateStatus = SftpServiceOperateStatus.success();
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("ManageOne_changeBackupPolicy_operateName", 3, "systemDataBackupSetting_objectName", e);
            this.writeAutoBackupOperationLog(autoBackup, e);
            sftpServiceOperateStatus = this.getSftpServiceOperateStatus(e);
        }
        JSONObject result = JSONObject.fromObject((Object)sftpServiceOperateStatus);
        result = this.handleResult(result);
        return this.getResponse(Response.Status.OK, result);
    }

    @POST
    @Path(value="/version")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response getVersion() {
        this.recordRequestLog("Unified Backup Connectivity. projectId: " + this.getUserProjectId());
        IConfigDataBackupService confDataBackupService = (IConfigDataBackupService)this.getBundleService(IConfigDataBackupService.class);
        String version = confDataBackupService.getVersion();
        JSONObject data = new JSONObject();
        data.put((Object)"status", (Object)"success");
        data.put((Object)"version", (Object)version);
        JSONObject result = new JSONObject();
        result.put((Object)"data", (Object)data);
        return this.getResponse(Response.Status.OK, result);
    }

    @GET
    @Path(value="/subsystem")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response querySubsystem() {
        this.recordRequestLog("query subSystem. projectId: " + this.getUserProjectId());
        ArrayList list = new ArrayList();
        JSONObject result = new JSONObject();
        result.put((Object)"subSystems", list);
        return this.getResponse(Response.Status.OK, result);
    }

    private void writeAutoBackupOperationLog(boolean autoBackup, Exception e) {
        String operationName = this.getChangeAutoBackupOperationName(autoBackup);
        if (VerifyUtil.isEmpty((Object)e)) {
            this.writeSucOperationLog(operationName, 2, "systemDataBackupSetting_objectName", null, null);
        } else {
            this.writeFailedOperationLogNoException(operationName, 2, "systemDataBackupSetting_objectName", e);
        }
    }

    private String getChangeAutoBackupOperationName(boolean autoBackup) {
        if (autoBackup) {
            return "dataMaintainence_enableAutoBackup_operateName";
        }
        return "dataMaintainence_disableAutoBackup_operateName";
    }

    private TaskResult getTaskResult(BackTask backTask) {
        TaskResult taskResult = new TaskResult();
        taskResult.setTaskId(String.valueOf(backTask.getTaskId()));
        int state = backTask.getTaskResult();
        if (BackTaskState.process.getValue() == state) {
            taskResult.setState(2);
            return taskResult;
        }
        taskResult.setState(state);
        taskResult.setEndTime(backTask.getEndTime().getTime());
        if (BackTaskState.succeed.getValue() == state) {
            ArrayList<String> backFiles = new ArrayList<String>();
            backFiles.add(backTask.getTaskLink());
            taskResult.setBackFiles(backFiles);
        } else if (BackTaskState.fail.getValue() == state) {
            String taskDetail = backTask.getTaskDetail();
            String errorCode = this.getManageOneErrorCode(taskDetail);
            taskResult.setErrorCode(errorCode);
            taskResult.setErrorMessage(taskDetail);
        }
        return taskResult;
    }

    private FtpServerInfo getFtpServerInfo(SftpServerInfoRequest updateServerInfo) {
        FtpServerInfo ftpServerInfo = new FtpServerInfo();
        ftpServerInfo.setFtpServerId(String.valueOf(updateServerInfo.getServerID()));
        ftpServerInfo.setIp(updateServerInfo.getBackupServerIP());
        ftpServerInfo.setPort(CommUtil.convertToInteger((Object)updateServerInfo.getBackupServerPort()).intValue());
        ftpServerInfo.setFtpUserName(updateServerInfo.getUserName());
        ftpServerInfo.setFtpPassword(updateServerInfo.getPassWord());
        ftpServerInfo.setBaseDir(updateServerInfo.getBackupDirectory() + "/");
        return ftpServerInfo;
    }

    private SftpServiceOperateStatus getSftpServiceOperateStatus(Exception e) {
        SftpServiceOperateStatus sftpServiceOperateStatus;
        String errorMessage = e.getMessage();
        if (e instanceof LegoCheckedException) {
            LegoCheckedException legoCheckedException = (LegoCheckedException)((Object)e);
            String errorCode = this.getManageOneErrorCode(legoCheckedException.getErrorCode());
            sftpServiceOperateStatus = SftpServiceOperateStatus.failed(errorCode, errorMessage);
        } else {
            sftpServiceOperateStatus = SftpServiceOperateStatus.failed("backup-1000", errorMessage);
        }
        return sftpServiceOperateStatus;
    }

    private String getManageOneErrorCode(String taskDetail) {
        long errorCode;
        try {
            errorCode = Long.parseLong(taskDetail);
        }
        catch (Exception e) {
            logger.info((Object)"taskDetail can not parse to long");
            return "backup-1000";
        }
        return this.getManageOneErrorCode(errorCode);
    }

    private String getManageOneErrorCode(long errorCode) {
        return MANAGEONE_ERRORCODE_MAP.getOrDefault(errorCode, "backup-1000");
    }

    private Response checkSftpPolicy(SftpPolicyRequest sftpPolicy) {
        if (VerifyUtil.isEmpty((Object)sftpPolicy)) {
            logger.error((Object)"sftpPolicy is empty or null");
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("policy is empty or null")));
        }
        SftpPolicy policy = sftpPolicy.getPolicy();
        if (VerifyUtil.isEmpty((Object)policy)) {
            logger.error((Object)"policy is empty or null");
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("policy is empty or null")));
        }
        return null;
    }

    private Response checkServerInfo(SftpServerInfoRequest updateServerInfo) {
        if (VerifyUtil.isEmpty((Object)updateServerInfo.getServerID())) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("id param is empty.")));
        }
        if (VerifyUtil.isEmpty((String)updateServerInfo.getProtocol())) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("sftp protocol param is empty.")));
        }
        if (!SFTP_PROTOCOL.equalsIgnoreCase(updateServerInfo.getProtocol())) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("sftp protocol param is incorrect.")));
        }
        if (VerifyUtil.isEmpty((String)updateServerInfo.getBackupDirectory())) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("backup directory param is empty.")));
        }
        if (VerifyUtil.isEmpty((String)updateServerInfo.getBackupServerIP())) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("sftp server IP param is empty.")));
        }
        if (VerifyUtil.isEmpty((String)updateServerInfo.getBackupServerPort())) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("sftp server port param is empty.")));
        }
        if (VerifyUtil.isEmpty((String)updateServerInfo.getPassWord())) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("sftp user password param is empty.")));
        }
        if (VerifyUtil.isEmpty((String)updateServerInfo.getUserName())) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("sftp username param is empty.")));
        }
        int maxPasswordLength = 64;
        if (updateServerInfo.getPassWord().length() > 64) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("sftp password length more than 64.")));
        }
        int maxUserNameLength = 64;
        if (updateServerInfo.getUserName().length() > 64) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("sftp username length more than 64.")));
        }
        int maxBackupDirectoryLength = 128;
        String backupDirectioy = updateServerInfo.getBackupDirectory();
        if (backupDirectioy.length() > 128 || !backupDirectioy.startsWith("/") || backupDirectioy.endsWith("/")) {
            return this.getResponse(Response.Status.BAD_REQUEST, JSONObject.fromObject((Object)SftpServiceOperateStatus.errorParam("bakcup directory length more than 128 or format error.")));
        }
        return null;
    }

    private JSONObject handleResult(JSONObject result) {
        if (!"0".equals(result.get("state"))) {
            result.remove((Object)"taskId");
        } else {
            result.remove((Object)"errorCode");
            result.remove((Object)"errorMessage");
            result.remove((Object)"taskId");
        }
        return result;
    }

    @PUT
    @Path(value="/modifyPasswd")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response modifyPasswd(UnitePasswordInfo unitePasswordInfo) {
        try {
            this.recordRequestLog("UnitePassword: modifyPasswd. projectId: " + this.getUserProjectId());
            Response checkResponseStatus = this.checkPasswordInfo(unitePasswordInfo);
            if (checkResponseStatus != null) {
                return checkResponseStatus;
            }
            Account account = this.getAccount(unitePasswordInfo);
            Response errorResponse = this.checkModifyPasswdInfo(account);
            if (null != errorResponse) {
                return errorResponse;
            }
            this.checkPasswdComplex(account);
            IUnitePasswordService unitePasswordService = (IUnitePasswordService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IUnitePasswordService.class.getName(), IUnitePasswordService.class);
            unitePasswordService.modifyPassword(account);
            this.writeSucOperationLog("ManageOne_UnitePassword_modify_operateName", 4, "ManageOne_UnitePassword_objectName", null, null);
            return this.getResponse(Response.Status.OK, "create modify password task successful!");
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("ManageOne_UnitePassword_modify_operateName", 4, "ManageOne_UnitePassword_objectName", null, null);
            return this.wrong(Response.Status.BAD_REQUEST, "create modify password task failed");
        }
    }

    private Response checkModifyPasswdInfo(Account account) {
        if (VerifyUtil.isEmpty((String)account.getAccountName())) {
            return this.wrong(Response.Status.BAD_REQUEST, "account name is empty");
        }
        if (!UserRestServiceValidator.checkUserName((String)account.getAccountName()).booleanValue()) {
            return this.wrong(Response.Status.BAD_REQUEST, "account name is incorrect");
        }
        if (VerifyUtil.isEmpty((String)account.getPasswd())) {
            return this.wrong(Response.Status.BAD_REQUEST, "password is empty");
        }
        if (VerifyUtil.isEmpty((String)account.getOldPasswd())) {
            return this.wrong(Response.Status.BAD_REQUEST, "oldPassword is empty");
        }
        if (!ParamChecker.checkLongText((String)account.getOldPasswd())) {
            return this.wrong(Response.Status.BAD_REQUEST, "oldPassword is too long");
        }
        if (!ParamChecker.checkGeneralId((String)account.getRegion())) {
            return this.wrong(Response.Status.BAD_REQUEST, "regionId is incorrect");
        }
        if (!VerifyUtil.isEmpty((String)account.getIp()) && !AddressUtil.isIpAddress((String)account.getIp())) {
            return this.wrong(Response.Status.BAD_REQUEST, "ip is incorrect");
        }
        return null;
    }

    @GET
    @Path(value="/queryStatus")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryStatus(@QueryParam(value="taskId") String taskId) {
        this.recordRequestLog("Unite Password, query modify password task status. projectId: " + this.getUserProjectId());
        JSONObject result = new JSONObject();
        if (VerifyUtil.isEmpty((String)taskId)) {
            logger.info((Object)"taskId is null");
            return this.getResponse(Response.Status.BAD_REQUEST, result);
        }
        if (!ParamChecker.checkGeneralId((String)taskId)) {
            logger.info((Object)"taskId is incorrect");
            return this.getResponse(Response.Status.BAD_REQUEST, result);
        }
        IUnitePasswordService unitePasswordService = (IUnitePasswordService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IUnitePasswordService.class.getName(), IUnitePasswordService.class);
        result = unitePasswordService.queryStatus(taskId);
        return this.getResponse(Response.Status.OK, result);
    }

    @PUT
    @Path(value="/resetPasswd")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response resetPasswd(UnitePasswordInfo passwordInfo) {
        try {
            this.recordRequestLog("UnitePassword: resetPasswd. projectId: " + this.getUserProjectId());
            Response checkResponseStatus = this.checkPasswordInfo(passwordInfo);
            if (null != checkResponseStatus) {
                return checkResponseStatus;
            }
            Account account = this.getAccount(passwordInfo);
            Response errorResponse = this.checkResetPasswdInfo(account);
            if (null != errorResponse) {
                return errorResponse;
            }
            this.checkPasswdComplex(account);
            IUnitePasswordService unitePasswordService = (IUnitePasswordService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IUnitePasswordService.class.getName(), IUnitePasswordService.class);
            unitePasswordService.resetPassword(account);
            this.writeSucOperationLog("ManageOne_UnitePassword_reset_operateName", 4, "ManageOne_UnitePassword_objectName", null, null);
            return this.getResponse(Response.Status.OK, "create reset password task successful!");
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("ManageOne_UnitePassword_reset_operateName", 4, "ManageOne_UnitePassword_objectName", null, null);
            return this.wrong(Response.Status.BAD_REQUEST, "create reset password task failed!");
        }
    }

    private Response checkResetPasswdInfo(Account account) {
        if (VerifyUtil.isEmpty((String)account.getAccountName())) {
            return this.wrong(Response.Status.BAD_REQUEST, "account name is empty");
        }
        if (!UserRestServiceValidator.checkUserName((String)account.getAccountName()).booleanValue()) {
            return this.wrong(Response.Status.BAD_REQUEST, "account name is incorrect");
        }
        if (VerifyUtil.isEmpty((String)account.getPasswd())) {
            return this.wrong(Response.Status.BAD_REQUEST, "password is empty");
        }
        if (!ParamChecker.checkGeneralId((String)account.getRegion())) {
            return this.wrong(Response.Status.BAD_REQUEST, "regionId is incorrect");
        }
        if (!VerifyUtil.isEmpty((String)account.getIp()) && !AddressUtil.isIpAddress((String)account.getIp())) {
            return this.wrong(Response.Status.BAD_REQUEST, "ip is incorrect");
        }
        return null;
    }

    @POST
    @Path(value="/validPasswd")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response validPasswd(Account account) {
        this.recordRequestLog("UnitePassword: validPasswd. projectId: " + this.getUserProjectId());
        Response checkResponseStatus = this.checkValidPasswdInfo(account);
        if (null != checkResponseStatus) {
            return checkResponseStatus;
        }
        try {
            IUnitePasswordService unitePasswordService = (IUnitePasswordService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IUnitePasswordService.class.getName(), IUnitePasswordService.class);
            String result = unitePasswordService.validPasswd(account).replaceAll("\\\\", "");
            this.writeSucOperationLog("ManageOne_UnitePassword_valid_operateName", 1, "ManageOne_UnitePassword_objectName", null, null);
            return this.getResponse(Response.Status.OK, JSONObject.fromObject((Object)result));
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("ManageOne_UnitePassword_valid_operateName", 1, "ManageOne_UnitePassword_objectName", null, null);
            return this.wrong(Response.Status.BAD_REQUEST, "valid password failed!");
        }
    }

    private Response checkValidPasswdInfo(Account account) {
        if (VerifyUtil.isEmpty((String)account.getAccountName())) {
            return this.wrong(Response.Status.BAD_REQUEST, "account name is empty");
        }
        if (!UserRestServiceValidator.checkUserName((String)account.getAccountName()).booleanValue()) {
            return this.wrong(Response.Status.BAD_REQUEST, "account name is incorrect");
        }
        if (VerifyUtil.isEmpty((String)account.getPasswdNew())) {
            return this.wrong(Response.Status.BAD_REQUEST, "passwdNew is empty");
        }
        if (!ParamChecker.checkLongText((String)account.getPasswdNew())) {
            return this.wrong(Response.Status.BAD_REQUEST, "passwdNew is too long");
        }
        if (!VerifyUtil.isEmpty((String)account.getIp()) && !AddressUtil.isIpAddress((String)account.getIp())) {
            return this.wrong(Response.Status.BAD_REQUEST, "ip is incorrect");
        }
        return null;
    }

    private Account getAccount(UnitePasswordInfo passwordInfo) {
        Account account = new Account();
        account.setTaskId(passwordInfo.getTaskId());
        account.setRegion((String)passwordInfo.getAccountparamMap().get("regionId"));
        account.setAccountName((String)passwordInfo.getAccountparamMap().get("accountName"));
        account.setPasswd((String)passwordInfo.getAccountparamMap().get("passwd"));
        account.setOldPasswd((String)passwordInfo.getAccountparamMap().get("oldPasswd"));
        account.setIp((String)passwordInfo.getAccountparamMap().get("ip"));
        account.setAccountType(CommUtil.convertToInteger((Object)passwordInfo.getAccountparamMap().get("accountType")).intValue());
        return account;
    }

    private Response checkPasswordInfo(UnitePasswordInfo passwordInfo) {
        if (VerifyUtil.isEmpty((String)passwordInfo.getTaskId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "taskId is empty");
        }
        if (!ParamChecker.checkGeneralId((String)passwordInfo.getTaskId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "taskId is incorrect");
        }
        if (VerifyUtil.isEmpty(passwordInfo.getAccountparamMap())) {
            return this.wrong(Response.Status.BAD_REQUEST, "accountparamMap is empty");
        }
        if (VerifyUtil.isEmpty((String)passwordInfo.getOwner())) {
            return this.wrong(Response.Status.BAD_REQUEST, "owner is empty");
        }
        return null;
    }

    private void checkPasswdComplex(Account account) {
        String complex;
        String passwd = account.getPasswd();
        if (VerifyUtil.isEmpty((String)passwd) || !CommUtil.checkParam((String)passwd, (int)8, (int)64)) {
            logger.error((Object)"%s complex is not support.", new Object[]{account.getAccountName()});
            throw new LegoCheckedException(1073947393L);
        }
        String string = complex = "DRManager".equals(account.getAccountName()) || "root".equals(account.getAccountName()) ? String.valueOf(3) : this.mgr.getSystemSecPolicy().getUserSecPolicy().getComplex();
        if (!UserRestServiceValidator.isPwdMatchComplex((String)passwd, (String)complex)) {
            logger.error((Object)"%s complex is not support.", new Object[]{account.getAccountName()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    @GET
    @Path(value="/{project_id}/instances/{instance_id}/action/recoveryRegionAZ")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response queryRecoveryRegionAz(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId) {
        this.recordRequestLog("projectId:" + projectId + ",instanceId:" + instanceId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is incorrect.");
        }
        InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        if (instanceInfoBO == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance is not exist.");
        }
        String recoveryPlanId = instanceInfoBO.getRecoveryPlanId();
        IOpenStackRecoveryService iOpenStackRecoveryService = (IOpenStackRecoveryService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenStackRecoveryService.class.getName(), IOpenStackRecoveryService.class);
        JSONObject result = new JSONObject();
        result.put((Object)"recoveryRegion_AZ", (Object)iOpenStackRecoveryService.getRecoveryRegionAz(recoveryPlanId));
        return this.getResponse(Response.Status.OK, result);
    }

    @POST
    @Path(value="/{project_id}/instances/{instance_id}/action/plannedMigration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response plannedMigration(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, RecoveryPolicy recoveryPolicy) {
        return this.redirect(BaseRestServiceImpl.class).plannedMigration(projectId, instanceId, recoveryPolicy);
    }

    @POST
    @Path(value="/{project_id}/instances/{instance_id}/action/{action_type}/continue")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response actionContinue(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, @PathParam(value="action_type") String actionType, RecoveryContinueRequest continueRequest) {
        return this.redirect(BaseRestServiceImpl.class).actionContinue(projectId, instanceId, actionType, continueRequest);
    }

    @POST
    @Path(value="/{project_id}/instances/{instance_id}/action/hotMigration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response hotMigration(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, RecoveryPolicy recoveryPolicy) {
        return this.redirect(BaseRestServiceImpl.class).hotMigration(projectId, instanceId, recoveryPolicy);
    }

    @POST
    @Path(value="/{project_id}/instances/{instance_id}/action/diasterRecovery")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response diasterRecovery(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, RecoveryPolicy recoveryPolicy) {
        return this.redirect(BaseRestServiceImpl.class).disasterRecovery(projectId, instanceId, recoveryPolicy);
    }

    @POST
    @Path(value="/{project_id}/instances/{instance_id}/action/reprotect")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response reprotect(@PathParam(value="project_id") String projectId, @PathParam(value="instance_id") String instanceId, RecoveryPolicy recoveryPolicy) {
        return this.redirect(BaseRestServiceImpl.class).reprotect(projectId, instanceId, recoveryPolicy);
    }

    @POST
    @Path(value="/rest/alarm/clear")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response reverseClear(AlarmOperationRequest operationrequest) {
        Map resultMap;
        List<AlarmRecord> clearList = operationrequest.getAlarmRecords();
        if (!ParamChecker.checkList(clearList, record -> !VerifyUtil.isEmpty((Object)record) && !VerifyUtil.isEmpty((String)record.getMatchKey()) && ParamChecker.checkGeneralId((String)record.getMatchKey()), (int)100)) {
            logger.error((Object)"Alarm clear param is error, alarmRecords is null or the size is more than 100 or matchKey is incorrect!");
            this.writeFailedOperationLog("oc_operate_alarm_clear_operationName", 2, "alarm_operateName", null);
            return this.getResponse(Response.Status.BAD_REQUEST, "alarm clear failed! param error");
        }
        try {
            ICloudServiceFaultService service = (ICloudServiceFaultService)this.getBundleService("DRM_FusionSphere_Openstack", ICloudServiceFaultService.class.getName(), ICloudServiceFaultService.class);
            resultMap = service.reverseClearAlarm(clearList);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("oc_operate_alarm_clear_operationName", 2, "alarm_operateName", e);
            return this.getResponse(Response.Status.BAD_REQUEST, "reverseClearAlarm failed!");
        }
        this.writeSucOperationLog("oc_operate_alarm_clear_operationName", 2, "alarm_operateName", "", null);
        JSONObject jsonObject = JSONObject.fromObject((Object)resultMap);
        return this.getResponse(Response.Status.OK, jsonObject);
    }

    @POST
    @Path(value="/rest/alarm/check-alarm")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response checkAlarm(AlarmOperationRequest operationrequest) {
        List clearedList;
        List<AlarmRecord> checkList = operationrequest.getAlarmRecords();
        if (!ParamChecker.checkList(checkList, record -> !VerifyUtil.isEmpty((Object)record) && !VerifyUtil.isEmpty((String)record.getMatchKey()) && ParamChecker.checkGeneralId((String)record.getMatchKey()), (int)100)) {
            logger.error((Object)"Alarm check param is error, alarmRecords is null or the size is more than 100 or matchKey is incorrect!");
            this.writeFailedOperationLog("oc_operate_alarm_check_operationName", 3, "alarm_operateName", null);
            return this.getResponse(Response.Status.BAD_REQUEST, "alarm check failed! param error");
        }
        try {
            ICloudServiceFaultService service = (ICloudServiceFaultService)this.getBundleService("DRM_FusionSphere_Openstack", ICloudServiceFaultService.class.getName(), ICloudServiceFaultService.class);
            clearedList = service.checkAlarm(checkList);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("oc_operate_alarm_check_operationName", 3, "alarm_operateName", e);
            return this.getResponse(Response.Status.BAD_REQUEST, "check alarm failed!");
        }
        this.writeSucOperationLog("oc_operate_alarm_check_operationName", 3, "alarm_operateName", "", null);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"alarmLists", (Object)JSONArray.fromObject((Object)clearedList).toString());
        return this.getResponse(Response.Status.OK, jsonObject);
    }

    @GET
    @Path(value="/rest/alarm/sync-alarm")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public Response syncAlarm(@QueryParam(value="startTime") String startTime, @QueryParam(value="endTime") String endTime, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit) {
        Paging alarmList;
        long longStartTime = NumberUtil.convertToLong((Object)startTime);
        long longEndTime = NumberUtil.convertToLong((Object)endTime);
        if (longEndTime == 0L) {
            longEndTime = System.currentTimeMillis();
        }
        if (longStartTime < 0L || longStartTime > longEndTime || offset < 0 || limit < 100 || limit > 1000) {
            logger.error((Object)"Param is illegal: startTime: %s, endTime: %s, offset: %s, limit: %s", new Object[]{startTime, endTime, offset, limit});
            this.writeFailedOperationLogNoException("oc_operate_alarm_sync_operationName", 2, "alarm_operateName", null);
            return this.getResponse(Response.Status.BAD_REQUEST, "param error");
        }
        try {
            ICloudServiceFaultService service = (ICloudServiceFaultService)this.getBundleService("DRM_FusionSphere_Openstack", ICloudServiceFaultService.class.getName(), ICloudServiceFaultService.class);
            alarmList = service.syncAlarm(longStartTime, longEndTime, offset, limit);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("oc_operate_alarm_sync_operationName", 2, "alarm_operateName", e);
            return this.getResponse(Response.Status.BAD_REQUEST, "sync alarm error");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"total", (Object)alarmList.getiCount());
        jsonObject.put((Object)"alarmLists", (Object)JSONArray.fromObject((Object)alarmList.getData()).toString());
        this.writeSucOperationLog("oc_operate_alarm_sync_operationName", 2, "alarm_operateName", "", null);
        return this.getResponse(Response.Status.OK, jsonObject);
    }

    @GET
    @Path(value="/{region_id}/meter/{service_name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response queryMeterInfos(@PathParam(value="region_id") String regionId, @PathParam(value="service_name") String serviceName, @QueryParam(value="start_time") String startTime, @QueryParam(value="end_time") String endTime) {
        int marker;
        int limit;
        String strMarker;
        String strLimit = this.getHttpServletRequest().getParameter("limit");
        if (strLimit == null) {
            strLimit = "1000";
        }
        if ((strMarker = this.getHttpServletRequest().getParameter("marker")) == null) {
            strMarker = "0";
        }
        try {
            limit = Integer.parseInt(strLimit);
            marker = Integer.parseInt(strMarker);
        }
        catch (NumberFormatException exception) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)startTime) || VerifyUtil.isEmpty((String)endTime) || startTime.compareTo(endTime) > 0) {
            logger.error((Object)"startTime is bigger than endTime.");
            throw new LegoCheckedException(1073947393L);
        }
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.OK);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -3);
        calendar.add(5, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String time3MonthAgo = sdf.format(calendar.getTime());
        if (endTime.compareTo(time3MonthAgo) < 0) {
            result.put("marker", "" + marker);
            result.put("source_data", Collections.emptyList());
            rb.entity(result);
            return rb.build();
        }
        MeterService resService = (MeterService)this.getBundleService("om_metering", MeterService.class.getName(), MeterService.class);
        List metaDataList = resService.queryMeterInfos(regionId, serviceName, startTime, endTime);
        List subList = new ArrayList();
        if (marker < metaDataList.size()) {
            int right = Math.min(limit + marker, metaDataList.size());
            subList = metaDataList.subList(marker, right);
        }
        logger.info((Object)"Meter record size: %s", new Object[]{String.valueOf(subList.size())});
        result.put("marker", "" + (marker + subList.size()));
        result.put("source_data", subList);
        rb.entity(result);
        return rb.build();
    }
}

