/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs;

import com.huawei.ism.drm.cloudservice.bo.AddServersRequest;
import com.huawei.ism.drm.cloudservice.bo.AddVolumeToVmRequest;
import com.huawei.ism.drm.cloudservice.bo.CreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.bo.DelVolumeFromVmRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.RedirectRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddVolumeToVmRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsCreateInstanceRequest;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.PolicyBO;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.bo.VmInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRepicaAvailabilityZone;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;

public abstract class FeatureRestService
extends RedirectRestService {
    private static final Log logger = LogFactory.getInstance(FeatureRestService.class);

    public abstract Response queryAzPairs(String var1);

    public abstract Response createServiceInstanceQuotasBudget(String var1, CreateInstanceRequest var2);

    public abstract Response createServiceInstance(String var1, BcsCreateInstanceRequest var2);

    public abstract Response addServerQuotasBudget(String var1, String var2, AddServersRequest var3);

    public abstract Response addServer(String var1, String var2, BcsAddServersRequest var3);

    protected abstract JSONArray constructAddVolumeToVmQuotasBudget(InstanceInfoBO var1, List<QuotaResourcesBo> var2);

    public Response addVolumeToVmQuotasBudget(String projectId, String instanceId, String serverId, AddVolumeToVmRequest request) {
        VmInfoBO vmInfoBO;
        InstanceInfoBO instanceInfoBO;
        HashSet<ProtectedVolumeInfo> addVolsSet;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + ",serverId is " + serverId + "," + (null == request ? "" : request.toString()));
        Response respParam = this.checkParameters(projectId, instanceId, serverId, request, reqId);
        if (null != respParam) {
            return respParam;
        }
        List<VolumeBO> addVolList = request.getAddVols();
        Response respAddVol = this.dealAddVol(addVolList, addVolsSet = new HashSet<ProtectedVolumeInfo>(), reqId);
        if (null != respAddVol) {
            return respAddVol;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, serverId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            List list = this.getInstanceService().checkAddVolumeParamAndCalQuota(projectId, instanceId, serverId, addVolsSet, extendParam);
            JSONObject returnJson = new JSONObject();
            JSONArray array = this.constructAddVolumeToVmQuotasBudget(instanceInfoBO, list);
            returnJson.put((Object)"quotas", (Object)array);
            logger.debug((Object)("AddVolumeToVmQuotasBudget: " + array));
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "request success.");
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 2, vmInfoBO.getName(), "instance_server_vol_add_log_detail", new String[]{instanceInfoBO.getName()}, instanceInfoBO.getType());
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, vmInfoBO.getName(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, vmInfoBO.getName(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    public Response addVolumeToVm(String projectId, String instanceId, String serverId, BcsAddVolumeToVmRequest request) {
        VmInfoBO vmInfoBO;
        InstanceInfoBO instanceInfoBO;
        HashSet<ProtectedVolumeInfo> addVolsSet;
        String reqId = this.recordRequestLog("Projectid is " + projectId + ",instanceId is " + instanceId + ",serverId is " + serverId + "," + (null == request ? "" : request.toString()));
        Response respParam = this.checkParameters(projectId, instanceId, serverId, request, reqId);
        if (null != respParam) {
            return respParam;
        }
        if (!ParamChecker.checkGeneralId((String)request.getSubscriptionId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscription_id is incorrect.");
        }
        List<VolumeBO> addVolList = request.getAddVols();
        Response respAddVol = this.dealAddVol(addVolList, addVolsSet = new HashSet<ProtectedVolumeInfo>(), reqId);
        if (null != respAddVol) {
            return respAddVol;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_server_vol_add_operationname", 3, serverId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            String taskId = this.getInstanceService().addVolumesToVm(projectId, instanceId, serverId, addVolsSet, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "Accept request. task_id is " + taskId + ".");
            this.writeSucOperationLog("instance_server_vol_add_operationname", 3, vmInfoBO.getName(), "instance_server_vol_add_log_detail", new String[]{instanceInfoBO.getName()}, instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_server_vol_add_operationname", 3, vmInfoBO.getName(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("instance_server_vol_add_operationname", 3, vmInfoBO.getName(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    protected Response dealAddVol(List<VolumeBO> addVolList, Set<ProtectedVolumeInfo> addVolsSet, String reqId) {
        if (VerifyUtil.isEmpty(addVolList)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The add_vols parameter is empty.");
        }
        if (addVolList.size() > 60) {
            return this.wrong(Response.Status.BAD_REQUEST, "volumes is more than 60");
        }
        for (VolumeBO bo : addVolList) {
            if (!this.validateVolumeParam(bo)) {
                return this.wrong(Response.Status.BAD_REQUEST, "VolumeBO isn't fulfilled.");
            }
            ProtectedVolumeInfo po = new ProtectedVolumeInfo();
            po.setDrVolumeType(bo.getDrVolumeType());
            po.setVolumeId(bo.getVolumeId());
            po.setVolumeType(bo.getVolumeType());
            addVolsSet.add(po);
        }
        return null;
    }

    protected abstract boolean validateVolumeParam(VolumeBO var1);

    public Response deleteServiceInstanceCheck(String projectId, String instanceId) {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("ProjectId is " + projectId + "instanceId is " + instanceId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Instance_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, instanceId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            String result = this.getInstanceService().deleteServiceInstance(projectId, instanceId, extendParam);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), result);
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 1, instanceInfoBO.getName(), null, new String[0], instanceInfoBO.getType());
            return this.getResponse(Response.Status.OK, "quota check success");
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, instanceInfoBO.getName(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, instanceInfoBO.getName(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    public Response deleteServiceInstance(String projectId, String instanceId, String subscriptionId) {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectId is " + projectId + "instanceId is " + instanceId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_delete_operationname", 2, instanceId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(subscriptionId);
            String taskId = this.getInstanceService().deleteServiceInstance(projectId, instanceId, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "Accept request. task_id is " + taskId + ".");
            this.writeSucOperationLog("instance_delete_operationname", 2, instanceInfoBO.getName(), null, new String[0], instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_delete_operationname", 2, instanceInfoBO.getName(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("instance_delete_operationname", 2, instanceInfoBO.getName(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    public Response deleteServersCheck(String projectId, String instanceId, List<String> serverIds) {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("ProjectId is " + projectId + ",instanceId is " + instanceId + "serverIds is " + serverIds);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Instance_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (VerifyUtil.isEmpty(serverIds)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Server_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "server_id is empty.");
        }
        ArrayList<String> nameList = new ArrayList<String>();
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            for (String serverId : serverIds) {
                VmInfoBO vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
                nameList.add(vmInfoBO.getName());
            }
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 1, ((Object)nameList).toString(), (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            String result = this.getInstanceService().deleteServerInServiceInstance(projectId, instanceId, new HashSet<String>(serverIds), extendParam);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), result);
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 1, ((Object)nameList).toString(), "instance_server_delete_log_detail", new String[]{instanceInfoBO.getName()}, instanceInfoBO.getType());
            return this.getResponse(Response.Status.OK, "quota check success");
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, ((Object)nameList).toString(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, ((Object)nameList).toString(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    public Response deleteServers(String projectId, String instanceId, List<String> serverIds, String subscriptionId) {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("ProjectId is " + projectId + ",instanceId is " + instanceId + "serverId is " + serverIds);
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty(serverIds)) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is empty.");
        }
        if (serverIds.size() > 256) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id in request is more than 256");
        }
        for (String serverId : serverIds) {
            if (VerifyUtil.isEmpty((String)serverId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "server_id is empty.");
            }
            if (ParamChecker.checkGeneralId((String)serverId)) continue;
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is incorrect.");
        }
        ArrayList<String> nameList = new ArrayList<String>();
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            for (String serverId : serverIds) {
                VmInfoBO vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
                nameList.add(vmInfoBO.getName());
            }
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_server_delete_operationname", 2, ((Object)nameList).toString(), (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(subscriptionId);
            String taskId = this.getInstanceService().deleteServerInServiceInstance(projectId, instanceId, new HashSet<String>(serverIds), extendParam);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
            this.writeSucOperationLog("instance_server_delete_operationname", 2, ((Object)nameList).toString(), "instance_server_delete_log_detail", new String[]{instanceInfoBO.getName()}, instanceInfoBO.getType());
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_server_delete_operationname", 2, ((Object)nameList).toString(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("instance_server_delete_operationname", 2, ((Object)nameList).toString(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    public Response delVolumeFromVmCheck(String projectId, String instanceId, String serverId, DelVolumeFromVmRequest request) {
        VmInfoBO vmInfoBO;
        InstanceInfoBO instanceInfoBO;
        HashSet<ProtectedVolumeInfo> delVolsSet;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + ",serverId is " + serverId + (null == request ? "" : request.toString()));
        Response respParam = this.checkParameters(projectId, instanceId, serverId, request, reqId);
        if (null != respParam) {
            return respParam;
        }
        List<String> delVolList = request.getDelVols();
        Response respDelVol = this.dealDelVols(delVolList, delVolsSet = new HashSet<ProtectedVolumeInfo>(), reqId);
        if (null != respDelVol) {
            return respDelVol;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, serverId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            String result = this.getInstanceService().delVolumesFromVm(projectId, instanceId, serverId, delVolsSet, extendParam);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), result);
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 2, vmInfoBO.getName(), "instance_server_vol_del_log_detail", new String[]{instanceInfoBO.getName()}, instanceInfoBO.getType());
            return this.getResponse(Response.Status.OK, "quota check success");
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, vmInfoBO.getName(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, vmInfoBO.getName(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    public Response delVolumeFromVm(String projectId, String instanceId, String serverId, DelVolumeFromVmRequest request, String subscriptionId) {
        VmInfoBO vmInfoBO;
        InstanceInfoBO instanceInfoBO;
        HashSet<ProtectedVolumeInfo> delVolsSet;
        String reqId = this.recordRequestLog(String.format("projectid is %s,, instanceId is %s, serverId is %s, %s", projectId, instanceId, serverId, null == request ? "" : request.toString()));
        Response respParam = this.checkParameters(projectId, instanceId, serverId, request, reqId);
        if (null != respParam) {
            return respParam;
        }
        List<String> delVolList = request.getDelVols();
        Response respDelVol = this.dealDelVols(delVolList, delVolsSet = new HashSet<ProtectedVolumeInfo>(), reqId);
        if (null != respDelVol) {
            return respDelVol;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_server_vol_del_operationname", 2, serverId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(subscriptionId);
            String taskId = this.getInstanceService().delVolumesFromVm(projectId, instanceId, serverId, delVolsSet, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
            this.writeSucOperationLog("instance_server_vol_del_operationname", 2, vmInfoBO.getName(), "instance_server_vol_del_log_detail", new String[]{instanceInfoBO.getName()}, instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_server_vol_del_operationname", 2, vmInfoBO.getName(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("instance_server_vol_del_operationname", 2, vmInfoBO.getName(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    protected Response checkParameters(String projectId, String instanceId, String serverId, Object request, String reqId) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)serverId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)serverId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is incorrect.");
        }
        if (null == request) {
            return this.wrong(Response.Status.BAD_REQUEST, "requestBO is empty.");
        }
        return null;
    }

    protected Response dealDelVols(List<String> delVolList, Set<ProtectedVolumeInfo> delVolsSet, String reqId) {
        if (VerifyUtil.isEmpty(delVolList)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The del_vols parameter is empty.");
        }
        if (delVolList.size() > 60) {
            return this.wrong(Response.Status.BAD_REQUEST, "volumes is more than 60");
        }
        for (String volumeId : delVolList) {
            if (VerifyUtil.isEmpty((String)volumeId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "VolumeId is empty.");
            }
            if (!ParamChecker.checkGeneralId((String)volumeId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "VolumeId is incorrect.");
            }
            ProtectedVolumeInfo po = new ProtectedVolumeInfo();
            po.setVolumeId(volumeId);
            delVolsSet.add(po);
        }
        return null;
    }

    public abstract Response downgradeServiceInstanceCheck(String var1, String var2, String var3, String var4);

    public Response downgradeServiceInstance(String projectId, String instanceId, String instanceType, String subscriptionId, String productId) {
        return null;
    }

    public Response upgradeServiceInstance(BcsCreateInstanceRequest request, boolean isCheck) {
        return null;
    }

    public Response upgradeServerQuotasBudget(BcsCreateInstanceRequest request) {
        return null;
    }

    public Response queryAvailableOsPlaceholderServers(String instanceType, String serverId, String projectId, String remoteProjectId, OpenStackAvailabilityZoneMapping zoneMapping) {
        String regionId = zoneMapping.getPrimaryRegionId();
        String remoteRegionId = zoneMapping.getSecondRegionId();
        String remoteAzName = zoneMapping.getSecondAzId();
        this.recordRequestLog("projectId:" + projectId + ",serverId:" + serverId + ",regionId:" + regionId + ",remoteRegionId:" + remoteRegionId + ",remoteAzName:" + remoteAzName);
        List vms = this.getInstanceService().queryAvailableOccupiedVms(instanceType, serverId, projectId, remoteProjectId, zoneMapping);
        JSONArray result = new JSONArray();
        for (VmInfoBO vm : vms) {
            result.add((Object)this.getPlaceHoldVmJsonObject(vm));
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"servers", (Object)result);
        return this.getResponse(Response.Status.OK, returnJson);
    }

    public Response queryProtectableServers(String projectId, String regionId, String availableZone, String instanceType, String instanceID) {
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E type;
        Response resultResponse = this.checkParamForProtectableServers(projectId, regionId, availableZone, instanceType);
        if (resultResponse != null) {
            return resultResponse;
        }
        List protectedServiceIdList = null;
        if (!VerifyUtil.isEmpty((String)instanceID)) {
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceID, null);
            protectedServiceIdList = instanceInfoBO.getServers();
        }
        if ((type = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)instanceType)) == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is incorrect.");
        }
        List vms = this.getInstanceService().queryAvailableVms(type.getValue(), projectId, regionId, availableZone, protectedServiceIdList);
        JSONArray result = new JSONArray();
        for (VmInfoBO vm : vms) {
            JSONObject obj = this.getProtectAbleVmJsonObject(vm);
            result.add((Object)obj);
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"servers", (Object)result);
        return this.getResponse(Response.Status.OK, returnJson);
    }

    private Response checkParamForProtectableServers(String projectId, String regionId, String availableZone, String instanceType) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)regionId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "regionId is empty.");
        }
        if (VerifyUtil.isEmpty((String)availableZone)) {
            return this.wrong(Response.Status.BAD_REQUEST, "remoteRegionId is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is empty.");
        }
        return null;
    }

    protected JSONObject getProtectAbleVmJsonObject(VmInfoBO vm) {
        JSONObject jsonObject = this.getPlaceHoldVmJsonObject(vm);
        jsonObject.put((Object)"vm_status", (Object)vm.getVmStatus());
        jsonObject.put((Object)"storage_sn", (Object)vm.getStorageSn());
        jsonObject.put((Object)"tags", (Object)vm.getTags());
        jsonObject.put((Object)"description", (Object)vm.getDescription());
        return jsonObject;
    }

    protected JSONObject getPlaceHoldVmJsonObject(VmInfoBO vm) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"server_id", (Object)vm.getServerId());
        obj.put((Object)"name", (Object)vm.getName());
        obj.put((Object)"ip_address", (Object)vm.getIp());
        obj.put((Object)"ipv6_address", (Object)vm.getIpv6());
        JSONObject flavor = new JSONObject();
        flavor.put((Object)"ram", (Object)vm.getRam());
        flavor.put((Object)"cpu_count", (Object)vm.getCpu());
        obj.put((Object)"flavor", (Object)flavor);
        return obj;
    }

    public Response queryAzPairs(String regionId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E type) {
        List mappings = this.getOpenstackResourceService().getAvailabilityZoneMappingsFromDB();
        ArrayList<Map<String, Object>> maps = new ArrayList();
        if (type == ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION || type == ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION) {
            maps = this.getOpenstackResourceService().getVHACSDRMapping(regionId, type);
            this.deleteRepeatAZMap(maps);
        } else {
            this.getAZMap(mappings, regionId, type, maps);
        }
        ArrayList<OpenStackRepicaAvailabilityZone.RegionInfo> regionPairs = new ArrayList<OpenStackRepicaAvailabilityZone.RegionInfo>();
        boolean isAddSucc = false;
        for (int i = 0; i < maps.size(); ++i) {
            Map item = (Map)maps.get(i);
            if (item == null) {
                throw new LegoCheckedException(0x300001L);
            }
            for (int j = 0; j < regionPairs.size(); ++j) {
                isAddSucc = false;
                OpenStackRepicaAvailabilityZone.RegionInfo regionPair = (OpenStackRepicaAvailabilityZone.RegionInfo)regionPairs.get(j);
                if (regionPair == null) {
                    throw new LegoCheckedException(0x300001L);
                }
                String primaryRegionId = regionPair.getPrimaryRegion().getRegionId();
                String secondRegionId = regionPair.getSecondRegion().getRegionId();
                if (primaryRegionId != null && secondRegionId != null && (isAddSucc = this.sameAZInSameRegion(j, regionPairs, item, type))) break;
            }
            if (!isAddSucc && ((String)item.get("primary_region_id")).equals(regionId)) {
                this.getAZMap(item, regionPairs, true, type);
                continue;
            }
            if (isAddSucc || !((String)item.get("second_region_id")).equals(regionId)) continue;
            this.getAZMap(item, regionPairs, true, type);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"region_pairs", regionPairs);
        return Response.ok().entity((Object)jsonObject.toString()).build();
    }

    private void getAZMap(List<OpenStackAvailabilityZoneMapping> mappings, String regionId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E type, List<Map<String, Object>> maps) {
        for (OpenStackAvailabilityZoneMapping mapping : mappings) {
            if (type != ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)mapping.getType()) || regionId != null && !this.isRelatedAZMapping(mapping, regionId)) continue;
            Map map = mapping.toMap();
            map.put("primary_region_name", map.get("primary_region"));
            map.put("second_region_name", map.get("second_region"));
            map.put("primary_az_name", map.get("primary_az"));
            map.put("second_az_name", map.get("second_az"));
            map.remove("primary_region");
            map.remove("second_region");
            map.remove("primary_az");
            map.remove("second_az");
            map.remove("type");
            maps.add(map);
        }
    }

    private boolean isRelatedAZMapping(OpenStackAvailabilityZoneMapping mapping, String regionId) {
        if (mapping == null || regionId == null) {
            return false;
        }
        if (regionId.equals(mapping.getPrimaryRegionId())) {
            return true;
        }
        return regionId.equals(mapping.getSecondRegionId());
    }

    protected OpenStackAvailabilityZoneMapping initOpenStackAvailabilityZoneMapping(String regionId, String remoteRegionId, String remoteAzName) {
        OpenStackAvailabilityZoneMapping zoneMapping = new OpenStackAvailabilityZoneMapping();
        zoneMapping.setPrimaryRegionId(regionId);
        zoneMapping.setSecondRegionId(remoteRegionId);
        zoneMapping.setSecondAzId(remoteAzName);
        zoneMapping.setSecondAz(remoteAzName);
        return zoneMapping;
    }

    protected JSONArray constructQuotaResult(String type, String projectId, String regionId, String drProjectId, String drRegionId, List<QuotaResourcesBo> list) {
        JSONArray quotaResourceList = new JSONArray();
        for (QuotaResourcesBo bo : list) {
            if ("gigabytes".equals(bo.getType()) || "volumes".equals(bo.getType())) continue;
            JSONObject quotaResource = new JSONObject();
            quotaResource.put((Object)"resource", (Object)bo.getType());
            quotaResource.put((Object)"used", (Object)Float.valueOf(bo.getQuota()));
            quotaResourceList.add((Object)quotaResource);
        }
        JSONObject usage = new JSONObject();
        usage.put((Object)"resources", (Object)quotaResourceList);
        usage.put((Object)"service_id", (Object)ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getServiceIdFromServiceType((String)type));
        JSONArray usagesList = new JSONArray();
        usagesList.add((Object)usage);
        JSONArray quotas = new JSONArray();
        JSONObject quota = new JSONObject();
        quota.put((Object)"project_id", (Object)projectId);
        quota.put((Object)"region_id", (Object)regionId);
        quota.put((Object)"usages", (Object)usagesList);
        quotas.add((Object)quota);
        if (null != drProjectId) {
            JSONObject drQuota = new JSONObject();
            drQuota.put((Object)"project_id", (Object)drProjectId);
            drQuota.put((Object)"region_id", (Object)drRegionId);
            drQuota.put((Object)"usages", (Object)usagesList);
            quotas.add((Object)drQuota);
        }
        return quotas;
    }

    protected JSONObject constructEvsQuota(String drAzid, String drProjectId, String drRegionId, List<QuotaResourcesBo> list) {
        float size = 0.0f;
        float num = 0.0f;
        float drvolSize = 0.0f;
        float drvolNum = 0.0f;
        float cshaDrvolSize = 0.0f;
        float cshaDrvolNum = 0.0f;
        IQuotaService service = (IQuotaService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IQuotaService.class.getName(), IQuotaService.class);
        String evsId = service.getEVSServiceId();
        logger.debug((Object)("EVSServiceId is: " + evsId));
        for (QuotaResourcesBo bo : list) {
            if (bo.getType().endsWith("vol.size")) {
                size += bo.getQuota();
                continue;
            }
            if (bo.getType().endsWith("vol.num")) {
                num += bo.getQuota();
                continue;
            }
            if ("volumes".equals(bo.getType())) {
                drvolNum = bo.getQuota();
                continue;
            }
            if ("gigabytes".equals(bo.getType())) {
                drvolSize = bo.getQuota();
                continue;
            }
            if ("csha_volumes".equals(bo.getType())) {
                cshaDrvolNum = bo.getQuota();
                continue;
            }
            if (!"csha_gigabytes".equals(bo.getType())) continue;
            cshaDrvolSize = bo.getQuota();
        }
        JSONArray quotaResourceList = new JSONArray();
        JSONObject sizeResource = new JSONObject();
        sizeResource.put((Object)"resource", (Object)"gigabytes");
        sizeResource.put((Object)"used", (Object)Float.valueOf(size - Math.max(drvolSize, cshaDrvolSize)));
        quotaResourceList.add((Object)sizeResource);
        JSONObject numResource = new JSONObject();
        numResource.put((Object)"resource", (Object)"volumes");
        numResource.put((Object)"used", (Object)Float.valueOf(num - Math.max(drvolNum, cshaDrvolNum)));
        quotaResourceList.add((Object)numResource);
        JSONObject usage = new JSONObject();
        usage.put((Object)"resources", (Object)quotaResourceList);
        usage.put((Object)"service_id", (Object)evsId);
        usage.put((Object)"available_zone", (Object)this.getIdFromUuid(drAzid));
        JSONArray usagesList = new JSONArray();
        usagesList.add((Object)usage);
        JSONObject quota = new JSONObject();
        quota.put((Object)"project_id", (Object)drProjectId);
        quota.put((Object)"region_id", (Object)drRegionId);
        quota.put((Object)"usages", (Object)usagesList);
        return quota;
    }

    public String getIdFromUuid(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            return null;
        }
        if (uuid.contains(":")) {
            uuid = uuid.split(":")[1];
        }
        return uuid;
    }

    public abstract ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E getInstanceType();

    private void getAZMap(Map<String, Object> item, List<OpenStackRepicaAvailabilityZone.RegionInfo> regionPairs, boolean reverseAZ, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E type) {
        OpenStackRepicaAvailabilityZone.Az azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
        OpenStackRepicaAvailabilityZone.AzPair azPair = new OpenStackRepicaAvailabilityZone.AzPair();
        ArrayList<OpenStackRepicaAvailabilityZone.AzPair> azPairs = new ArrayList<OpenStackRepicaAvailabilityZone.AzPair>();
        azNameAndId.setAzId(reverseAZ ? (String)item.get("primary_az_id") : (String)item.get("second_az_id"));
        azNameAndId.setAzName(reverseAZ ? (String)item.get("primary_az_name") : (String)item.get("second_az_name"));
        azPair.setPrimaryAz(azNameAndId);
        azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
        azNameAndId.setAzId(reverseAZ ? (String)item.get("second_az_id") : (String)item.get("primary_az_id"));
        azNameAndId.setAzName(reverseAZ ? (String)item.get("second_az_name") : (String)item.get("primary_az_name"));
        azPair.setSecondAz(azNameAndId);
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.equals((Object)type)) {
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            azNameAndId.setAzId((String)item.get("dr_second_az_id"));
            azNameAndId.setAzName((String)item.get("dr_second_az_name"));
            azPair.setDrRregionSsecondAz(azNameAndId);
        }
        azPairs.add(azPair);
        OpenStackRepicaAvailabilityZone.Region region = new OpenStackRepicaAvailabilityZone.Region();
        OpenStackRepicaAvailabilityZone.RegionInfo regionInfo = new OpenStackRepicaAvailabilityZone.RegionInfo();
        region.setRegionId(reverseAZ ? (String)item.get("primary_region_id") : (String)item.get("second_region_id"));
        region.setRegionName(reverseAZ ? (String)item.get("primary_region_name") : (String)item.get("second_region_name"));
        regionInfo.setPrimaryRegion(region);
        region = new OpenStackRepicaAvailabilityZone.Region();
        region.setRegionId(reverseAZ ? (String)item.get("second_region_id") : (String)item.get("primary_region_id"));
        region.setRegionName(reverseAZ ? (String)item.get("second_region_name") : (String)item.get("primary_region_name"));
        regionInfo.setSecondRegion(region);
        regionInfo.setAzPairs(azPairs);
        regionPairs.add(regionInfo);
    }

    private void deleteRepeatAZMap(List<Map<String, Object>> maps) {
        for (int num = 0; num < maps.size(); ++num) {
            for (int j = maps.size() - 1; j > num; --j) {
                boolean reverseCheckEqual;
                Map<String, Object> firstItem = maps.get(num);
                Map<String, Object> secondItem = maps.get(j);
                String firstPrimaryRegionId = (String)firstItem.get("primary_region_id");
                String firstDrregionId = (String)firstItem.get("second_region_id");
                String firstPrimaryAzId = (String)firstItem.get("primary_az_id");
                String firstDrZzId = (String)firstItem.get("second_az_id");
                String firstSameRegionDrZzId = VerifyUtil.isEmpty((String)((String)firstItem.get("dr_second_az_id"))) ? "" : (String)firstItem.get("dr_second_az_id");
                String sencondPrimaryRegionId = (String)secondItem.get("primary_region_id");
                String sencondDrRegionId = (String)secondItem.get("second_region_id");
                String sencondPrimaryAzId = (String)secondItem.get("primary_az_id");
                String sencondDrAzId = (String)secondItem.get("second_az_id");
                String sencondSameRegionDrZzId = VerifyUtil.isEmpty((String)((String)secondItem.get("dr_second_az_id"))) ? "" : (String)secondItem.get("dr_second_az_id");
                boolean checkEqual = firstPrimaryRegionId.equals(sencondPrimaryRegionId) && firstDrregionId.equals(sencondDrRegionId) && firstPrimaryAzId.equals(sencondPrimaryAzId) && firstDrZzId.equals(sencondDrAzId) && firstSameRegionDrZzId.equals(sencondSameRegionDrZzId);
                boolean bl = reverseCheckEqual = firstPrimaryRegionId.equals(sencondDrRegionId) && firstDrregionId.equals(sencondPrimaryRegionId) && firstPrimaryAzId.equals(sencondDrAzId) && firstDrZzId.equals(sencondPrimaryAzId) && firstSameRegionDrZzId.equals(sencondSameRegionDrZzId);
                if (!checkEqual && !reverseCheckEqual) continue;
                maps.remove(j);
            }
        }
    }

    private boolean sameAZInSameRegion(int azIndex, List<OpenStackRepicaAvailabilityZone.RegionInfo> regionPairs, Map<String, Object> item, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E type) {
        OpenStackRepicaAvailabilityZone.Az azNameAndId = null;
        boolean isAddSucc = false;
        OpenStackRepicaAvailabilityZone.RegionInfo regionPair = regionPairs.get(azIndex);
        String primaryRegionId = regionPair.getPrimaryRegion().getRegionId();
        String secondRegionId = regionPair.getSecondRegion().getRegionId();
        OpenStackRepicaAvailabilityZone.Az drAzNameAndId = null;
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.equals((Object)type)) {
            drAzNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            drAzNameAndId.setAzId((String)item.get("dr_second_az_id"));
            drAzNameAndId.setAzName((String)item.get("dr_second_az_name"));
        }
        if (primaryRegionId.equals(item.get("primary_region_id")) && secondRegionId.equals(item.get("second_region_id"))) {
            isAddSucc = true;
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            OpenStackRepicaAvailabilityZone.AzPair azPair = new OpenStackRepicaAvailabilityZone.AzPair();
            azNameAndId.setAzId((String)item.get("primary_az_id"));
            azNameAndId.setAzName((String)item.get("primary_az_name"));
            azPair.setPrimaryAz(azNameAndId);
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            azNameAndId.setAzId((String)item.get("second_az_id"));
            azNameAndId.setAzName((String)item.get("second_az_name"));
            azPair.setSecondAz(azNameAndId);
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.equals((Object)type)) {
                azPair.setDrRregionSsecondAz(drAzNameAndId);
            }
            List azPairs = regionPair.getAzPairs();
            azPairs.add(azPair);
            regionPairs.get(azIndex).setAzPairs(azPairs);
        } else if (primaryRegionId.equals(item.get("second_region_id")) && secondRegionId.equals(item.get("primary_region_id"))) {
            isAddSucc = true;
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            OpenStackRepicaAvailabilityZone.AzPair azPair = new OpenStackRepicaAvailabilityZone.AzPair();
            azNameAndId.setAzId((String)item.get("second_az_id"));
            azNameAndId.setAzName((String)item.get("second_az_name"));
            azPair.setPrimaryAz(azNameAndId);
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            azNameAndId.setAzId((String)item.get("primary_az_id"));
            azNameAndId.setAzName((String)item.get("primary_az_name"));
            azPair.setSecondAz(azNameAndId);
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.equals((Object)type)) {
                azPair.setDrRregionSsecondAz(drAzNameAndId);
            }
            List azPairs = regionPair.getAzPairs();
            azPairs.add(azPair);
            regionPairs.get(azIndex).setAzPairs(azPairs);
        }
        return isAddSucc;
    }

    protected JSONObject getCreateInstanceJsonObject(String projectId, BcsCreateInstanceRequest request, String reqId) {
        ProtectGroup pg = this.convertInstanceBOToPg(request, projectId);
        ExtendParamInfo extendParam = new ExtendParamInfo();
        extendParam.setSubscriptionId(request.getSubscriptionId());
        String taskId = this.getInstanceService().createServiceInstance(pg, extendParam);
        JSONObject json = new JSONObject();
        json.put((Object)"task_id", (Object)taskId);
        this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
        return json;
    }

    protected ProtectGroup convertInstanceBOToPg(CreateInstanceRequest request, String projectId) {
        ProtectGroup pg = new ProtectGroup();
        ServiceInstanceBO instance = request.getInstance();
        pg.setName(instance.getName());
        pg.setDescription(instance.getDescription());
        pg.setProperty("regionId", (Object)instance.getRegionName());
        pg.setProperty("projectId", (Object)projectId);
        pg.setProperty("zoneName", (Object)instance.getAzName());
        pg.setProperty("originalAvailableZone", (Object)instance.getAzName());
        if (!VerifyUtil.isEmpty((String)instance.getSlaveRegionName())) {
            pg.setProperty("drRegionId", (Object)instance.getSlaveRegionName());
        }
        if (!VerifyUtil.isEmpty((String)instance.getRemoteProjectId())) {
            pg.setProperty("drProjectId", (Object)instance.getRemoteProjectId());
        }
        if (!VerifyUtil.isEmpty((String)instance.getSlaveAzName())) {
            pg.setProperty("drZoneName", (Object)instance.getSlaveAzName());
        }
        if (null != instance.getDrAvailableZone()) {
            pg.setProperty("prod_region_drZoneName", (Object)instance.getDrAvailableZone());
        }
        pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue());
        pg.setPoType(12);
        PolicyTemplate template = new PolicyTemplate();
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_REPLICATION_TYPE_E.SYNCHRONIZE.getValue().equals(instance.getReplicationType())) {
            template.setType(21);
        } else {
            template.setType(22);
            PolicyBO policy = instance.getPolicy();
            Schedule autoSchedule = this.convertPolicyToSchedule(template, policy);
            template.getSchedules().add(autoSchedule);
        }
        pg.setTemplate(template);
        HashSet<ProtectObject> poList = new HashSet<ProtectObject>();
        if (VerifyUtil.isEmpty((Collection)instance.getServers())) {
            logger.error((Object)"Instance servers is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        for (ServerBO server : instance.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            poList.add(po);
        }
        pg.setPolist(poList);
        IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().lookup("user/usermgr");
        if (null == userMgr) {
            logger.error((Object)"get user manager failed.");
            throw new LegoCheckedException(102410L);
        }
        User user = userMgr.getUserByName("admin");
        if (null == user) {
            logger.error((Object)"get admin user failed.");
            throw new LegoCheckedException(1073947393L);
        }
        pg.setOwnerId(user.getUserId());
        return pg;
    }

    private Schedule convertPolicyToSchedule(PolicyTemplate template, PolicyBO policy) {
        Schedule autoSchedule = this.convertPolicyToSchedule(policy);
        autoSchedule.setPolicyTemplate(template);
        return autoSchedule;
    }

    protected ProtectObject convertServerBOToPo(ServerBO server) {
        ProtectObject po = new ProtectObject();
        if (VerifyUtil.isEmpty((Object)server)) {
            logger.error((Object)"the serverBO is empty");
            throw new LegoCheckedException(1073947393L);
        }
        po.setMoUuid(server.getServerId());
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)server.getVolumes())) {
            throw new LegoCheckedException(1073947393L);
        }
        for (VolumeBO volume : server.getVolumes()) {
            JSONObject json = new JSONObject();
            if (VerifyUtil.isEmpty((String)volume.getVolumeId())) {
                throw new LegoCheckedException(1073947393L);
            }
            json.put((Object)"volumeId", (Object)volume.getVolumeId());
            if (!VerifyUtil.isEmpty((String)volume.getDrVolumeType())) {
                json.put((Object)"drVolumeType", (Object)volume.getDrVolumeType());
            }
            if (!VerifyUtil.isEmpty((String)volume.getVolumeType())) {
                json.put((Object)"volumeType", (Object)volume.getVolumeType());
            }
            array.add((Object)json);
        }
        po.setProperty("volumeConfig", (Object)array.toString());
        if (!VerifyUtil.isEmpty((String)server.getOccupiedServerId())) {
            po.setProperty("occupied_vm", (Object)server.getOccupiedServerId());
        }
        return po;
    }

    private Schedule convertPolicyToSchedule(PolicyBO policy) {
        Schedule autoSchedule = new Schedule();
        autoSchedule.setScheduleMode(0);
        autoSchedule.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.A_B.getValue());
        autoSchedule.setScheduleId(UUIDGenerator.getUUID());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, 30);
        Date beginTime = cal.getTime();
        autoSchedule.setStartTime(String.valueOf(beginTime.getTime()));
        if (VerifyUtil.isEmpty((Object)policy)) {
            logger.error((Object)"Policy is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)policy.getPeriodInterval())) {
            logger.error((Object)"Policy period interval is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            autoSchedule.setPeriodInterval(Integer.parseInt(policy.getPeriodInterval()));
        }
        catch (NumberFormatException e) {
            throw new LegoCheckedException(1073947393L, "PeriodInterval is error.", (Throwable)e);
        }
        if (VerifyUtil.isEmpty((String)policy.getPeriodType())) {
            logger.error((Object)"Policy period type is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if ("minute".equals(policy.getPeriodType())) {
            autoSchedule.setPeriodType(0);
        } else if ("hour".equals(policy.getPeriodType())) {
            autoSchedule.setPeriodType(1);
        } else {
            autoSchedule.setPeriodType(2);
            if (VerifyUtil.isEmpty((String)policy.getTimePoint())) {
                logger.error((Object)"Policy period time point is empty.");
                throw new LegoCheckedException(1073947393L);
            }
            String[] schduleTime = policy.getTimePoint().split(":");
            if (null == schduleTime || schduleTime.length != 2) {
                throw new LegoCheckedException(1073947393L, "TimePoint is error.");
            }
            autoSchedule.setHours(schduleTime[0]);
            autoSchedule.setMinutes(schduleTime[1]);
        }
        return autoSchedule;
    }
}

