/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.cloudservice.bo.UpdateProjectQuotaRequest;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaBo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackConsts;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QuotaUtilService {
    private static final Log logger = LogFactory.getInstance(QuotaUtilService.class);
    public static final int MAX_QUOTA_IN_PROJECT = 128;
    public static final int MAX_RESOURCE_IN_QUOTA = 128;

    public boolean validUpdateRequestParam(UpdateProjectQuotaRequest request) {
        if (VerifyUtil.isEmpty(request.getQuotas())) {
            logger.error((Object)"Failed to validate uppdate requestParam. quotas list is null");
            return false;
        }
        if (request.getQuotas().size() > 128) {
            logger.error((Object)"Failed to validate uppdate requestParam. quotas list is too large");
            return false;
        }
        return request.getQuotas().stream().allMatch(this::isValidUpdateQuotaBo);
    }

    private boolean isValidUpdateQuotaBo(QuotaBo quota) {
        if (quota == null) {
            logger.error((Object)"Quota is null.");
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)quota.getResources())) {
            logger.error((Object)"Resources list is null.");
            return false;
        }
        if (quota.getResources().size() > 128) {
            logger.error((Object)"Too many resources in quota.");
            return false;
        }
        Map<String, Map<String, Float>> settings = this.getQuotaSettings(quota);
        if (settings.isEmpty()) {
            logger.error((Object)"No supported service type for quota setting.");
            return false;
        }
        List invalid = settings.entrySet().stream().filter(e -> !this.isCorrectQuotaSetting((Map)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!invalid.isEmpty()) {
            logger.error((Object)"Resource quota is invalid. quota: %s", new Object[]{invalid});
            return false;
        }
        return true;
    }

    private boolean isCorrectQuotaSetting(Map<String, Float> settings) {
        if (settings.keySet().containsAll(OpenstackConsts.ALLOWED_RESOURCE_TYPE)) {
            return true;
        }
        return settings.entrySet().stream().map(e -> ((Float)e.getValue()).floatValue() < 0.0f ? 0 : 1).distinct().count() == 1L;
    }

    private Map<String, Map<String, Float>> getQuotaSettings(QuotaBo quota) {
        HashMap<String, Map<String, Float>> map = new HashMap<String, Map<String, Float>>();
        for (QuotaResourcesBo resource : quota.getResources()) {
            String resourceType = resource.getType();
            int index = resourceType.indexOf(46);
            if (index == -1) {
                logger.error((Object)"Incorrect resource type: %s", new Object[]{resourceType});
                continue;
            }
            String prefix = resourceType.substring(0, index);
            String suffix = resourceType.substring(index + 1);
            if (!OpenstackConsts.SUPPORTED_SERVICE_TYPES.contains(prefix)) {
                logger.error((Object)"Incorrect resource type: %s", new Object[]{resourceType});
                continue;
            }
            if (!OpenstackConsts.ALLOWED_RESOURCE_TYPE.contains(suffix)) {
                logger.error((Object)"incorrect resource type: %s", new Object[]{resourceType});
                continue;
            }
            Map resources = map.computeIfAbsent(prefix, k -> new HashMap());
            resources.put(suffix, Float.valueOf(resource.getQuota()));
        }
        return map;
    }
}

