/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features;

import com.huawei.ism.drm.cloudservice.bo.AddServersRequest;
import com.huawei.ism.drm.cloudservice.bo.CreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.FeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsCreateInstanceRequest;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.PolicyBO;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.Response;

public class CsdrFeatureRestService
extends FeatureRestService {
    private static final Log logger = LogFactory.getInstance(CsdrFeatureRestService.class);

    @Override
    public Response queryAzPairs(String regionId) {
        return this.queryAzPairs(regionId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION);
    }

    private Response createServiceInstanceParamValidate(String projectId, CreateInstanceRequest request) {
        String reqId = this.recordRequestLog("projectid is " + projectId + ", request: " + request);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (null == request) {
            logger.error((Object)"request is null");
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "The request parameter is error.");
            return this.getResponse(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        if (!this.validateInstanceParam(request)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "The request parameter is error.");
            return this.getResponse(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        String description = request.getInstance().getDescription();
        if (!this.validateNameDesc(request.getInstance().getName(), description)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "The instance's name or description parameter is error.");
            return this.getResponse(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        String type = request.getInstance().getType();
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(type)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Not support instance type.type=" + type);
            return this.getResponse(Response.Status.BAD_REQUEST, "Not support instance type.");
        }
        String replicationType = request.getInstance().getReplicationType();
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_REPLICATION_TYPE_E.SYNCHRONIZE.getValue().equals(replicationType) && !ServiceInstaceEnumDefine.SERVICEINSTANCE_REPLICATION_TYPE_E.ASYNCHRONIZE.getValue().equals(replicationType)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Not support replication type.type=" + replicationType);
            return this.getResponse(Response.Status.BAD_REQUEST, "Not support replication type.");
        }
        return null;
    }

    @Override
    public Response createServiceInstanceQuotasBudget(String projectId, CreateInstanceRequest request) {
        Response error = this.createServiceInstanceParamValidate(projectId, request);
        if (error != null) {
            return error;
        }
        String replicationType = request.getInstance().getReplicationType();
        PolicyBO policy = request.getInstance().getPolicy();
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_REPLICATION_TYPE_E.ASYNCHRONIZE.getValue().equals(replicationType) && !this.validatePolicy(policy)) {
            this.recordResponseLog(Response.Status.BAD_REQUEST.getStatusCode(), "Not set policy.");
            return this.getResponse(Response.Status.BAD_REQUEST, "Not set policy.");
        }
        String serviceInstanceName = request.getInstance().getName();
        String type = request.getInstance().getType();
        try {
            ProtectGroup pg = this.convertInstanceBOToPg(request, projectId);
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            List list = this.getInstanceService().checkCreateInstanceParamAndCalQuota(pg, projectId, extendParam);
            JSONObject returnJson = new JSONObject();
            String regionId = (String)pg.getProps().get("regionId");
            String protId = (String)pg.getProps().get("projectId");
            String drRegionId = (String)pg.getProps().get("drRegionId");
            String drProId = (String)pg.getProps().get("drProjectId");
            JSONArray array = this.constructQuotaResult(type, protId, regionId, drProId, drRegionId, list);
            String drAzid = (String)pg.getProps().get("drZoneName");
            array.add((Object)this.constructEvsQuota(drAzid, drProId, drRegionId, list));
            returnJson.put((Object)"quotas", (Object)array);
            logger.debug((Object)("createServiceInstanceQuotasBudget: " + array));
            this.recordResponseLog(Response.Status.OK.getStatusCode(), "request success.");
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 1, serviceInstanceName, null, new String[0], type);
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 1, serviceInstanceName, (Exception)((Object)e), type);
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 1, serviceInstanceName, (Exception)((Object)new LegoCheckedException(-1L)), type);
            throw e;
        }
    }

    protected Response validateCreateRequestParam(String projectId, CreateInstanceRequest request) {
        String description;
        String subscriptionId;
        this.recordRequestLog("projectid is " + projectId + "," + (null == request ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (request instanceof BcsCreateInstanceRequest && !ParamChecker.checkGeneralId((String)(subscriptionId = ((BcsCreateInstanceRequest)request).getSubscriptionId()))) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscription_id is incorrect.");
        }
        if (null == request) {
            return this.wrong(Response.Status.BAD_REQUEST, "request is null.");
        }
        if (!this.validateInstanceParam(request)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        String serviceInstanceName = request.getInstance().getName();
        if (!this.validateNameDesc(serviceInstanceName, description = request.getInstance().getDescription())) {
            return this.wrong(Response.Status.BAD_REQUEST, "The instance's name or description parameter is error.");
        }
        String type = request.getInstance().getType();
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(type)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not support instance type.");
        }
        String replicationType = request.getInstance().getReplicationType();
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_REPLICATION_TYPE_E.SYNCHRONIZE.getValue().equals(replicationType) && !ServiceInstaceEnumDefine.SERVICEINSTANCE_REPLICATION_TYPE_E.ASYNCHRONIZE.getValue().equals(replicationType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not support replication type.");
        }
        PolicyBO policy = request.getInstance().getPolicy();
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_REPLICATION_TYPE_E.ASYNCHRONIZE.getValue().equals(replicationType) && !this.validatePolicy(policy)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not set policy.");
        }
        return this.getResponse(Response.Status.OK, "OK");
    }

    @Override
    public Response createServiceInstance(String projectId, BcsCreateInstanceRequest request) {
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + (null == request ? "" : request.toString()));
        Response response = this.validateCreateRequestParam(projectId, request);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            return response;
        }
        String serviceInstanceName = request.getInstance().getName();
        String type = request.getInstance().getType();
        try {
            JSONObject json = this.getCreateInstanceJsonObject(projectId, request, reqId);
            this.writeSucOperationLog("instance_create_operationname", 3, serviceInstanceName, null, new String[0], type);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_create_operationname", 3, serviceInstanceName, (Exception)((Object)e), type);
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("instance_create_operationname", 3, serviceInstanceName, (Exception)((Object)new LegoCheckedException(-1L)), type);
            throw e;
        }
    }

    protected boolean validateInstanceParam(CreateInstanceRequest request) {
        ServiceInstanceBO serviceInstance = request.getInstance();
        if (null == serviceInstance) {
            return false;
        }
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(serviceInstance.getName());
        attributes.add(serviceInstance.getAzName());
        attributes.add(serviceInstance.getRegionName());
        attributes.add(serviceInstance.getSlaveAzName());
        attributes.add(serviceInstance.getSlaveRegionName());
        attributes.add(serviceInstance.getRemoteProjectId());
        attributes.add(serviceInstance.getType());
        attributes.add(serviceInstance.getReplicationType());
        try {
            CommUtils.verifyParameterList(attributes);
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getAzName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getRegionName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getSlaveAzName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getSlaveRegionName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getRemoteProjectId())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getDrAvailableZone())) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        catch (LegoCheckedException e) {
            String parameter = "name=" + serviceInstance.getName() + ",azName=" + serviceInstance.getAzName() + ",regionName=" + serviceInstance.getRegionName() + ",remoteProjectId=" + serviceInstance.getRemoteProjectId() + ",slaveName=" + serviceInstance.getSlaveAzName() + ",type=" + serviceInstance.getType() + ",type=" + serviceInstance.getReplicationType();
            logger.error((Object)("validateParam error. instance details:" + parameter), (Throwable)e);
            return false;
        }
        List servers = serviceInstance.getServers();
        return this.validateServerParam(servers);
    }

    protected boolean validateServerParam(List<ServerBO> servers) {
        try {
            CommUtils.isNullCollection(servers);
            if (servers.size() > 256) {
                logger.error((Object)"validateServerParam failed. Servers in request is more than 256");
                return false;
            }
            for (ServerBO server : servers) {
                if (CommUtils.isNullStr((String)server.getServerId())) {
                    logger.error((Object)"validateServerParam failed. serverId is null");
                    return false;
                }
                if (!ParamChecker.checkGeneralId((String)server.getServerId())) {
                    logger.error((Object)"validateServerParam failed. serverId is incorrect");
                    return false;
                }
                if (CommUtils.isNullStr((String)server.getOccupiedServerId())) {
                    logger.error((Object)"validateServerParam failed. occupied ServerId is null");
                    return false;
                }
                if (!ParamChecker.checkGeneralId((String)server.getOccupiedServerId())) {
                    logger.error((Object)"validateServerParam failed. occupied ServerId is incorrect");
                    return false;
                }
                List volumes = server.getVolumes();
                CommUtils.isNullCollection((Collection)volumes);
                if (volumes.size() > 60) {
                    logger.error((Object)"volumes of server is more than 60");
                    return false;
                }
                for (VolumeBO volume : volumes) {
                    if (this.validateVolumeParam(volume)) continue;
                    String parameter = "volumeId=" + volume.getVolumeId() + ",volumeType=" + volume.getVolumeType() + ",drVolumeType=" + volume.getDrVolumeType();
                    logger.error((Object)("validateServerParam failed. volume details=" + parameter));
                    return false;
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"validateServerParam error.", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateVolumeParam(VolumeBO volume) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(volume.getVolumeId());
        attributes.add(volume.getVolumeType());
        try {
            CommUtils.verifyParameterList(attributes);
            if (!ParamChecker.checkGeneralId((String)volume.getVolumeId())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkVolumeType((String)volume.getVolumeType())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkVolumeType((String)volume.getDrVolumeType())) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        catch (LegoCheckedException e) {
            String parameter = "volumeId=" + volume.getVolumeId() + ",volumeType=" + volume.getVolumeType();
            logger.error((Object)"ValidateServerParam error. volume details: %s", (Throwable)e, new Object[]{parameter});
            return false;
        }
        return true;
    }

    private boolean validateNameDesc(String name, String description) {
        if (!CommUtil.checkDrmDescParam((String)description)) {
            logger.error((Object)("validateNameDesc failed. description=" + description));
            return false;
        }
        if (!CommUtil.checkDrmNameParam((String)name)) {
            logger.error((Object)("validateNameDesc failed. name=" + name));
            return false;
        }
        return true;
    }

    private boolean validatePolicy(PolicyBO policy) {
        if (null == policy) {
            logger.error((Object)"policy is null.");
            return false;
        }
        try {
            policy.validate();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"policy is invalid.", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Response addServerQuotasBudget(String projectId, String instanceId, AddServersRequest request) {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + "," + (null == request ? "" : request.toString()));
        try {
            VerifyUtil.checkObjs((Object[])new Object[]{projectId, instanceId, request});
        }
        catch (Exception e) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "parameters is empty.");
            logger.error((Object)"parameters is empty:projectId=%s,instanceId=%s", new Object[]{projectId, instanceId});
            return this.getResponse(Response.Status.BAD_REQUEST, "parameters is empty");
        }
        if (VerifyUtil.isEmpty(request.getServers())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "servers is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "servers is empty.");
        }
        if (!this.validateServerParam(request.getServers())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "servers param is not correct.");
            return this.getResponse(Response.Status.BAD_REQUEST, "servers param is not correct.");
        }
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        for (ServerBO server : request.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            addPos.add(po);
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_server_add_operationname", 3, instanceId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            List list = this.getInstanceService().addServerToServiceInstanceAndCalQuota(projectId, instanceId, addPos, extendParam);
            JSONObject returnJson = new JSONObject();
            JSONArray array = this.constructAddVolumeToVmQuotasBudget(instanceInfoBO, list);
            returnJson.put((Object)"quotas", (Object)array);
            logger.debug((Object)("addServerQuotasBudget: " + array));
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "request success.");
            this.writeSucOperationLog("sc_subscription_precheck_operationname", 1, instanceInfoBO.getName(), null, new String[0], instanceInfoBO.getType());
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, instanceInfoBO.getName(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("sc_subscription_precheck_operationname", 2, instanceInfoBO.getName(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    @Override
    public Response addServer(String projectId, String instanceId, BcsAddServersRequest request) {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + "," + (null == request ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((Object)request)) {
            return this.wrong(Response.Status.BAD_REQUEST, "request is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)request.getSubscriptionId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscription_id is incorrect.");
        }
        if (VerifyUtil.isEmpty(request.getServers())) {
            return this.wrong(Response.Status.BAD_REQUEST, "servers is empty.");
        }
        if (!this.validateServerParam(request.getServers())) {
            return this.wrong(Response.Status.BAD_REQUEST, "servers param is not correct.");
        }
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        for (ServerBO server : request.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            addPos.add(po);
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_server_add_operationname", 3, instanceId, (Exception)((Object)e), "Cloud DR Service");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            String taskId = this.getInstanceService().addServerToServiceInstance(projectId, instanceId, addPos, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
            this.writeSucOperationLog("instance_server_add_operationname", 3, instanceInfoBO.getName(), null, new String[0], instanceInfoBO.getType());
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            this.writeFailedOperationLogNoException("instance_server_add_operationname", 3, instanceInfoBO.getName(), (Exception)((Object)e), instanceInfoBO.getType());
            throw e;
        }
        catch (Exception e) {
            this.writeFailedOperationLogNoException("instance_server_add_operationname", 3, instanceInfoBO.getName(), (Exception)((Object)new LegoCheckedException(-1L)), instanceInfoBO.getType());
            throw e;
        }
    }

    @Override
    protected JSONArray constructAddVolumeToVmQuotasBudget(InstanceInfoBO instanceInfoBO, List<QuotaResourcesBo> list) {
        String proId = instanceInfoBO.getProjectId();
        String regionId = instanceInfoBO.getRegion();
        String drProId = instanceInfoBO.getRemoteProjectId();
        String drRegion = instanceInfoBO.getSlaveRegionName();
        JSONArray array = this.constructQuotaResult(instanceInfoBO.getType(), proId, regionId, drProId, this.getIdFromUuid(drRegion), list);
        String drAzid = instanceInfoBO.getSalveAvailableZone();
        array.add((Object)this.constructEvsQuota(drAzid, drProId, this.getIdFromUuid(drRegion), list));
        return array;
    }

    @Override
    public Response downgradeServiceInstanceCheck(String projectId, String instanceId, String instanceType, String productId) {
        return null;
    }

    @Override
    public ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E getInstanceType() {
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION;
    }
}

