/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.common;

import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class OperationLogAspect {
    private static final Log logger = LogFactory.getInstance(OperationLogAspect.class);
    private static final int SUCCESS = 1;
    private static final int FAILURE = 0;
    private static final List<String> CLOUD_URIS = Arrays.asList("/ws/csha", "/ws/csdr", "/ws/bcs", "/ws/om", "/ws/csr");

    public void doAfterReturning(JoinPoint joinPoint) {
        try {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            BaseController restService = (BaseController)((Object)joinPoint.getTarget());
            SysOptLog sysOptLog = this.buildBaseLogInfo(method, restService);
            sysOptLog.setLevel(1);
            sysOptLog.setResult(1);
            SysOpLogBuilder.writeOperateLog((SysOptLog)sysOptLog);
        }
        catch (Exception err) {
            logger.error((Object)"After returning pointcut execute failed, err: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
        }
    }

    public void doThrowing(JoinPoint joinPoint, Exception ex) {
        try {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            BaseController restService = (BaseController)((Object)joinPoint.getTarget());
            SysOptLog sysOptLog = this.buildBaseLogInfo(method, restService);
            sysOptLog.setLevel(3);
            sysOptLog.setResult(0);
            if (ex instanceof LegoCheckedException) {
                sysOptLog.setDetail("lego.err." + ((LegoCheckedException)((Object)ex)).getErrorCode());
                sysOptLog.setDetailPara(((LegoCheckedException)((Object)ex)).getParameters());
            } else {
                sysOptLog.setDetail("lego.err.-1");
                sysOptLog.setDetailPara(new String[0]);
            }
            SysOpLogBuilder.writeOperateLog((SysOptLog)sysOptLog);
        }
        catch (Exception err) {
            logger.error((Object)"Throwing pointcut execute failed, err: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
        }
    }

    private SysOptLog buildBaseLogInfo(Method method, AbstractRestService restService) {
        SysOptLog sysOptLog = new SysOptLog();
        OperationLog opLog = method.getAnnotation(OperationLog.class);
        if (opLog != null) {
            String tokenUser = (String)restService.getRequest().getAttribute("iam-x-auth-user-json");
            JSONObject jsonObject = JSONObject.fromObject((Object)tokenUser);
            String currentUserName = jsonObject.getString("name");
            if (VerifyUtil.isEmpty((String)currentUserName)) {
                currentUserName = restService.getCurrentUser().getUserName();
            }
            sysOptLog.setOperation(opLog.operationName());
            sysOptLog.setOperator(currentUserName);
            sysOptLog.setDate(new Date(System.currentTimeMillis()));
            sysOptLog.setModule(opLog.operationModule());
            if (VerifyUtil.isEmpty((String)opLog.operationDetail())) {
                sysOptLog.setDetail("");
            } else {
                sysOptLog.setDetail(opLog.operationDetail());
            }
            sysOptLog.setLevel(opLog.level());
            sysOptLog.setServiceType(opLog.drType());
            sysOptLog.setTokenUser(tokenUser);
            sysOptLog.setProjectId((String)restService.getRequest().getAttribute("iam-x-auth-user-project"));
            sysOptLog.setTarget(restService.getOperLogAttrMap().getOrDefault("operationLogTarget", ""));
            sysOptLog.setTargetLocal(Boolean.TRUE);
            sysOptLog.setTerminalIp(this.getTerminalIp(restService));
            sysOptLog.setLogType(this.getLogType(restService));
        }
        return sysOptLog;
    }

    private String getLogType(AbstractRestService restService) {
        String uri = this.getRequestUri(restService);
        if (this.isCloudRestService(uri)) {
            return "tenantlog";
        }
        return "administratorlog";
    }

    private String getTerminalIp(AbstractRestService restService) {
        String ip = AbstractRestService.getRemoteAddr((HttpServletRequest)restService.getRequest());
        if (this.isCloudRestService(this.getRequestUri(restService))) {
            return RequestUtil.getFirstIPFromIPStr((String)ip);
        }
        return ip;
    }

    private String getRequestUri(AbstractRestService restService) {
        String uri = restService.getRequest().getRequestURI();
        return UriUtil.canonicalPath((String)uri);
    }

    private boolean isCloudRestService(String uri) {
        for (String subUri : CLOUD_URIS) {
            if (!uri.startsWith(subUri)) continue;
            return true;
        }
        return false;
    }
}

