/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr;

import com.huawei.csr.framework.common.constants.DisasterRecoveryType;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.statusopt.status.AppStatus;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import com.huawei.csr.framework.core.context.RequestContext;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.CreateApplicationPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.CreateServiceInstancePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.RegionAz;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.TaskVo;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AppRestService
extends BaseController {
    private static final int NAME_MINSIZE = 4;
    private static final int NAME_MAXSIZE = 32;
    private static final int DESC_MAXSIZE = 255;
    private static final int INSTANCE_MAXNUM = 64;
    private static final Log LOGGER = LogFactory.getInstance(AppRestService.class);

    private AppService getAppService() {
        return (AppService)this.getBundleService("csr_framework", AppService.class.getName(), AppService.class);
    }

    private ConfigService getConfigService() {
        return (ConfigService)this.getBundleService("csr_framework", ConfigService.class.getName(), ConfigService.class);
    }

    @OperationLog(operationName="app_create_operationname", operationModule="protect", level=2)
    public TaskVo createApp(String subId, RequestContext context, CreateApplicationPara para) {
        this.getOperLogAttrMap().put("operationLogTarget", para.getName());
        Application application = this.buildApplication(context, para);
        String taskId = this.getAppService().createApp(subId, context, application);
        TaskVo taskVo = new TaskVo();
        taskVo.setTaskId(taskId);
        return taskVo;
    }

    @OperationLog(operationName="instances_add_operationname", operationModule="protect", level=2)
    public TaskVo addServiceInstances(String subId, RequestContext context, Set<CreateServiceInstancePara> para, String appId) {
        this.getOperLogAttrMap().put("operationLogTarget", this.getAppService().getApplicationById(appId).getName());
        Set<AppServiceInstance> serviceInstances = this.convert2ServiceInstance(context, para);
        String taskId = this.getAppService().addServiceInstances(subId, context, serviceInstances, appId);
        TaskVo taskVo = new TaskVo();
        taskVo.setTaskId(taskId);
        return taskVo;
    }

    @OperationLog(operationName="instances_del_operationname", operationModule="protect", level=3)
    public TaskVo removeServiceInstances(String subId, RequestContext context, Set<String> serviceInstanceIds, String appId) {
        this.getOperLogAttrMap().put("operationLogTarget", this.getAppService().getApplicationById(appId).getName());
        String taskId = this.getAppService().removeServiceInstances(subId, context, serviceInstanceIds, appId);
        TaskVo taskVo = new TaskVo();
        taskVo.setTaskId(taskId);
        return taskVo;
    }

    @OperationLog(operationName="app_delete_operationname", operationModule="protect", level=3)
    public TaskVo deleteApp(String subId, RequestContext context, String appId) {
        AppService appService = this.getAppService();
        Application applicationById = appService.getApplicationById(appId);
        this.getOperLogAttrMap().put("operationLogTarget", applicationById.getName());
        String taskId = appService.deleteApp(subId, context, appId);
        TaskVo taskVo = new TaskVo();
        taskVo.setTaskId(taskId);
        return taskVo;
    }

    private Application buildApplication(RequestContext context, CreateApplicationPara applicationPara) {
        Application application = new Application();
        application.setName(applicationPara.getName());
        application.setDescription(applicationPara.getDescription());
        application.setCreateType(applicationPara.getCreateType().getValue());
        application.setProjectId(context.getProjectId());
        application.setStatus(AppStatus.NORMAL.getValue());
        Set serviceInstances = applicationPara.getServiceInstances().stream().map(serviceInstancePara -> {
            AppServiceInstance serviceInstance = new AppServiceInstance();
            serviceInstance.setServiceType(serviceInstancePara.getServiceType());
            serviceInstance.setProjectId(context.getProjectId());
            serviceInstance.setApplication(application);
            return this.getServiceInstance((CreateServiceInstancePara)serviceInstancePara, serviceInstance);
        }).collect(Collectors.toSet());
        application.setServiceInstances(serviceInstances);
        return application;
    }

    private void validateAppPara(CreateApplicationPara applicationPara) {
        if (VerifyUtil.isEmpty((Object)applicationPara)) {
            throw new LegoCheckedException(1073952400L, "AppPara can not be null or empty");
        }
        String name = applicationPara.getName();
        if (VerifyUtil.isEmpty((String)name)) {
            throw new LegoCheckedException(1073952400L, "AppName can not be null or empty");
        }
        CommUtil.checkParam((String)name, (String)"^[\\u4e00-\\u9fa50-9a-zA-Z_][\\u4e00-\\u9fa5a-zA-Z_0-9-]{3,31}$", (int)4, (int)32);
        String description = applicationPara.getDescription();
        if (!VerifyUtil.isEmpty((String)description)) {
            CommUtil.checkParam((String)description, (int)0, (int)255);
        }
        if (VerifyUtil.isEmpty((Object)applicationPara.getCreateType())) {
            throw new LegoCheckedException(1073952400L, "Create_type is invalid");
        }
        List<CreateServiceInstancePara> serviceInstances = applicationPara.getServiceInstances();
        if (VerifyUtil.isEmpty(serviceInstances) || serviceInstances.size() > 64) {
            LOGGER.error((Object)"instance num more than limit AppName(%s)", new Object[]{applicationPara.getName()});
            throw new LegoCheckedException(1073952400L, "The length of service_instances is limited in 1-64");
        }
        serviceInstances.forEach(this::validinstancePara);
    }

    private Set<AppServiceInstance> convert2ServiceInstance(RequestContext context, Set<CreateServiceInstancePara> para) {
        return para.stream().map(createServiceInstancePara -> {
            AppServiceInstance serviceInstance = new AppServiceInstance();
            serviceInstance.setServiceType(createServiceInstancePara.getServiceType());
            serviceInstance.setProjectId(context.getProjectId());
            return this.getServiceInstance((CreateServiceInstancePara)createServiceInstancePara, serviceInstance);
        }).collect(Collectors.toSet());
    }

    private void validinstancePara(CreateServiceInstancePara instancePara) {
        if (VerifyUtil.isEmpty((String)instancePara.getInstanceId())) {
            throw new LegoCheckedException(1073952400L, "Instance_id can not be null or empty");
        }
        if (VerifyUtil.isEmpty((String)instancePara.getInstanceName())) {
            throw new LegoCheckedException(1073952400L, "Instance_name can not be null or empty");
        }
        String serviceType = instancePara.getServiceType();
        if (VerifyUtil.isEmpty((String)serviceType)) {
            throw new LegoCheckedException(1073952400L, "Instance_type can not be null or empty");
        }
        if (VerifyUtil.isEmpty((Object)ServiceType.from((String)serviceType))) {
            throw new LegoCheckedException(1073952400L, "Instance_type illegale");
        }
        ServiceType instanceType = ServiceType.from((String)serviceType);
        RegionAz pdRegionAz = instancePara.getPdRegionAz();
        RegionAz drRegionAz = instancePara.getDrRegionAz();
        if (instanceType == ServiceType.RDS || instanceType == ServiceType.DCS || instanceType == ServiceType.CSHA) {
            this.validateRegionAz(pdRegionAz, true);
            this.validateRegionAz(drRegionAz, true);
        } else if (instanceType == ServiceType.ECS || instanceType == ServiceType.CCE) {
            this.validateRegionAz(pdRegionAz, true);
        } else {
            this.validateRegionAz(pdRegionAz, false);
        }
        String status = instancePara.getStatus();
        if (VerifyUtil.isEmpty((String)status) || ServiceInstanceStatus.from((String)status) == null) {
            throw new LegoCheckedException(1073952400L, "Status is null or empty or illegal");
        }
        if (!VerifyUtil.isEmpty((String)instancePara.getDrType()) && DisasterRecoveryType.from((String)instancePara.getDrType()) == null) {
            throw new LegoCheckedException(1073952400L, "Disaster_recovery_type is illegal");
        }
    }

    private void validateRegionAz(RegionAz regionAz, boolean isCheckAz) {
        if (VerifyUtil.isEmpty((Object)regionAz) || VerifyUtil.isEmpty((Object)regionAz.getRegion()) || VerifyUtil.isEmpty((String)regionAz.getRegion().getRegionId())) {
            throw new LegoCheckedException(1073952400L, "Region can not be null or empty");
        }
        if (isCheckAz && (VerifyUtil.isEmpty((Object)regionAz.getAz()) || VerifyUtil.isEmpty((String)regionAz.getAz().getAzId()))) {
            throw new LegoCheckedException(1073952400L, "Az can not be null or empty");
        }
    }

    private AppServiceInstance getServiceInstance(CreateServiceInstancePara createServiceInstancePara, AppServiceInstance serviceInstance) {
        SiteInfo drSiteInfo;
        SiteInfo pdSiteInfo;
        if (createServiceInstancePara.getDrType() != null) {
            serviceInstance.setDrType(createServiceInstancePara.getDrType());
        }
        ConfigService configService = this.getConfigService();
        RegionAz pdRegionAz = createServiceInstancePara.getPdRegionAz();
        serviceInstance.setPdRegionId(pdRegionAz.getRegion().getRegionId());
        serviceInstance.setPdRegionName(pdRegionAz.getRegion().getRegionName());
        serviceInstance.setPdAzId(pdRegionAz.getAz().getAzId());
        serviceInstance.setPdAzName(pdRegionAz.getAz().getAzName());
        if (serviceInstance.getPdRegionId() != null && serviceInstance.getPdAzId() != null && !VerifyUtil.isEmpty((Object)(pdSiteInfo = configService.getSiteInfoByRegionAz(serviceInstance.getPdRegionId(), serviceInstance.getPdAzId())))) {
            serviceInstance.setPdSiteId(pdSiteInfo.getSiteId());
            serviceInstance.setPdSiteName(pdSiteInfo.getSiteName());
        }
        serviceInstance.setInstanceAddress(createServiceInstancePara.getInstanceAddress());
        serviceInstance.setDrRegionId(createServiceInstancePara.getDrRegionAz().getRegion().getRegionId());
        serviceInstance.setDrRegionName(createServiceInstancePara.getDrRegionAz().getRegion().getRegionName());
        serviceInstance.setDrAzId(createServiceInstancePara.getDrRegionAz().getAz().getAzId());
        serviceInstance.setDrAzName(createServiceInstancePara.getDrRegionAz().getAz().getAzName());
        if (serviceInstance.getDrRegionId() != null && serviceInstance.getDrAzId() != null && !VerifyUtil.isEmpty((Object)(drSiteInfo = configService.getSiteInfoByRegionAz(serviceInstance.getDrRegionId(), serviceInstance.getDrAzId())))) {
            serviceInstance.setDrSiteId(drSiteInfo.getSiteId());
            serviceInstance.setDrSiteName(drSiteInfo.getSiteName());
        }
        serviceInstance.setInstanceId(createServiceInstancePara.getInstanceId());
        serviceInstance.setInstanceName(createServiceInstancePara.getInstanceName());
        serviceInstance.setStatus(createServiceInstancePara.getStatus());
        serviceInstance.setInstanceObjectCount(createServiceInstancePara.getInstanceCount());
        serviceInstance.setReplicaStatus(createServiceInstancePara.getReplicaStatus());
        return serviceInstance;
    }
}

