/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils;

import com.huawei.csr.framework.common.model.ApplicationBo;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.csr.framework.service.PlanService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.SiteHelper;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.AppVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.UnprotectedInstanceVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Az;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Region;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.RegionAz;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.SiteInfoVo;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class AppHelper {
    private AppHelper() {
    }

    public static List<UnprotectedInstanceVo> convert2unprotectedInstances(List<AppServiceInstance> serviceInstances) {
        return serviceInstances.stream().map(serviceInstance -> {
            UnprotectedInstanceVo unprotectedInstanceVo = new UnprotectedInstanceVo();
            unprotectedInstanceVo.setId(serviceInstance.getId());
            unprotectedInstanceVo.setInstanceId(serviceInstance.getInstanceId());
            unprotectedInstanceVo.setInstanceName(serviceInstance.getInstanceName());
            unprotectedInstanceVo.setInstanceAddress(serviceInstance.getInstanceAddress());
            RegionAz pdRegionAz = new RegionAz();
            pdRegionAz.setRegion(new Region(serviceInstance.getPdRegionId(), serviceInstance.getPdRegionName()));
            pdRegionAz.setAz(new Az(serviceInstance.getPdAzId(), serviceInstance.getPdAzName()));
            unprotectedInstanceVo.setPdRegionAz(pdRegionAz);
            unprotectedInstanceVo.setInstanceObjectCount(serviceInstance.getInstanceObjectCount() == null ? 0 : serviceInstance.getInstanceObjectCount());
            RegionAz drRegionAz = new RegionAz();
            drRegionAz.setRegion(new Region(serviceInstance.getDrRegionId(), serviceInstance.getDrRegionName()));
            drRegionAz.setAz(new Az(serviceInstance.getDrAzId(), serviceInstance.getDrAzName()));
            unprotectedInstanceVo.setDrRegionAz(drRegionAz);
            unprotectedInstanceVo.setStatus(serviceInstance.getStatus());
            unprotectedInstanceVo.setInstanceType(serviceInstance.getServiceType());
            unprotectedInstanceVo.setReplicaStatus(serviceInstance.getReplicaStatus());
            return unprotectedInstanceVo;
        }).collect(Collectors.toList());
    }

    public static AppVo generateAppVo(ApplicationBo appBo) {
        RecoverPlan recoverPlan;
        AppVo appVo = new AppVo();
        if (appBo.getRecoverPlanId() != null && (recoverPlan = CommonUtil.getCsrService(PlanService.class).getRecoverPlanByRecoverPlanId(appBo.getRecoverPlanId())) != null) {
            appVo.setPlanName(recoverPlan.getName());
        }
        appVo.setId(appBo.getApplicationId());
        appVo.setName(appBo.getApplicationName());
        appVo.setDescription(appBo.getApplicationDesc());
        appVo.setCreateTime(appBo.getCreatedAt());
        appVo.setStatus(appBo.getStatus());
        Set serviceInstances = appBo.getServiceInstances();
        appVo.setInstanceCount(serviceInstances == null ? 0 : serviceInstances.size());
        appVo.setSiteInfo(SiteHelper.convertToSiteVo(appBo.getSiteInfoList()));
        appVo.setPlanId(appBo.getRecoverPlanId());
        return appVo;
    }

    public static List<SiteInfoVo> generateSiteInfoVo(String siteId) {
        if (!VerifyUtil.isEmpty((String)siteId)) {
            List siteInfos = CommonUtil.getCsrService(ConfigService.class).getSiteInfos(siteId);
            return SiteHelper.convertToSiteVo(siteInfos);
        }
        return Collections.emptyList();
    }
}

