/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils;

import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.model.ApplicationBo;
import com.huawei.csr.framework.common.model.RecoverFlowQuery;
import com.huawei.csr.framework.common.model.RecoverLogQuery;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.common.model.SitePlanMapQuery;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.dao.model.AbstractEntity;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.SitePlan;
import com.huawei.csr.framework.dao.model.SitePlanMap;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.PlanService;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.RecoverStageService;
import com.huawei.csr.framework.service.RecoverStepService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.SiteInfoVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.LogStatistics;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverLogPlanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverLogSitePlanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverLogVo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public final class RecoverLogUtils {
    private static final Log LOG = LogFactory.getInstance(RecoverLogUtils.class);
    public static final String PLAN_LEVEL = "planLevel";
    public static final String PRE_PLAN_LEVEL = "prePlanLevel";
    public static final String STAGE_LEVEL = "stageLevel";
    public static final String FLOW_LEVEL = "flowLevel";
    public static final String STEP_LEVEL = "stepLevel";
    public static final int SORT_RECOVER_LOG_BY_PRE_ID_MAX_TIME = 20;

    private RecoverLogUtils() {
    }

    public static List<RecoverLogVo> getPlanLogInfo(RecoverLog logSite, String logLevel, String siteId) {
        RecoverLogQuery logPlanQuery = new RecoverLogQuery();
        logPlanQuery.setProjectId(logSite.getProjectId());
        logPlanQuery.setParentIds(Collections.singletonList(logSite.getId()));
        logPlanQuery.setStartTimeAsc(true);
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        List logPlanList = planService.getRecoverLogList(logPlanQuery);
        ArrayList logVoPlanList = new ArrayList();
        SitePlanMapQuery sitePlanMapQuery = new SitePlanMapQuery();
        sitePlanMapQuery.setSitePlanId(logSite.getResourceId());
        List sitePlanMapList = planService.queryPagedSitePlanMapBySitePlanId(sitePlanMapQuery);
        Map sitePlanMap = sitePlanMapList.stream().collect(Collectors.toMap(SitePlanMap::getRecoverPlanId, Function.identity(), (keyOld, keyNew) -> keyNew));
        logPlanList.forEach(logPlan -> {
            RecoverLogVo logVoPlan = RecoverLogUtils.getRecoverLogVoCommon(logPlan);
            Optional<RecoverPlan> recoverPlanOptional = RecoverLogUtils.getPlanDetail(logSite.getProjectId(), logPlan.getResourceId());
            recoverPlanOptional.ifPresent(recoverPlan -> logVoPlan.setResourceName(recoverPlan.getName()));
            if (sitePlanMap.containsKey(logPlan.getResourceId())) {
                int priority = ((SitePlanMap)sitePlanMap.get(logPlan.getResourceId())).getPriority();
                logVoPlan.setPriority(priority);
            }
            if (!logLevel.equals(PLAN_LEVEL)) {
                List<RecoverLogVo> logVoPrePlanList = RecoverLogUtils.getPrePlanLogInfo(logPlan, logLevel, siteId);
                if (CollectionUtils.isNotEmpty(logVoPrePlanList)) {
                    List<SiteInfoVo> targetSiteInfoVos = RecoverLogUtils.getTargetSiteInfoVos(logSite.getProjectId(), logPlan, logVoPrePlanList.get(0).getSiteInfos());
                    logVoPlan.setSiteInfos(targetSiteInfoVos);
                }
                logVoPlan.setRecoverLogVoList(logVoPrePlanList);
            }
            logVoPlanList.add(logVoPlan);
        });
        return logVoPlanList.stream().sorted(Comparator.comparing(RecoverLogVo::getStartTime, Comparator.nullsLast(Timestamp::compareTo))).collect(Collectors.toList());
    }

    public static List<RecoverLogVo> getPrePlanLogInfo(RecoverLog parentLogPlan, String logLevel, String siteId) {
        List<RecoverLog> logPrePlanList = RecoverLogUtils.getRecoverLogList(parentLogPlan);
        List<RecoverPreplan> recoverPreplanList = RecoverLogUtils.getRecoverPreplanList(parentLogPlan, siteId);
        ArrayList<RecoverLogVo> logVoPrePlanList = new ArrayList<RecoverLogVo>();
        RecoverLogUtils.getTruePrePlanLogInfo(logLevel, logPrePlanList, logVoPrePlanList);
        if (!VerifyUtil.isEmpty((String)siteId)) {
            Set resourceIdsInLogPrePlanSet = logPrePlanList.stream().map(RecoverLog::getResourceId).collect(Collectors.toSet());
            List<RecoverPreplan> recoverPreplanListNotInLogPrePlanList = recoverPreplanList.stream().filter(item -> !resourceIdsInLogPrePlanSet.contains(item.getId())).collect(Collectors.toList());
            RecoverLogUtils.getFakePrePlanLogInfo(logLevel, logPrePlanList, recoverPreplanListNotInLogPrePlanList, logVoPrePlanList);
        }
        return logVoPrePlanList.stream().sorted(Comparator.comparing(RecoverLogVo::getStartTime, Comparator.nullsLast(Timestamp::compareTo)).reversed()).collect(Collectors.toList());
    }

    private static void getTruePrePlanLogInfo(String logLevel, List<RecoverLog> logPrePlanList, List<RecoverLogVo> logVoPrePlanList) {
        for (RecoverLog logPrePlan : logPrePlanList) {
            RecoverLogVo logVoPrePlan = RecoverLogUtils.getRecoverLogVoCommon(logPrePlan);
            RecoverLogUtils.setLogVoPrePlanOtherInfo(logVoPrePlan, logPrePlan.getProjectId(), logPrePlan.getSiteId());
            if (!logLevel.equals(PRE_PLAN_LEVEL)) {
                List<RecoverLogVo> logVoPlanStageList = RecoverLogUtils.getStageLogInfo(logPrePlan, logLevel);
                logVoPrePlan.setRecoverLogVoList(logVoPlanStageList);
            }
            logVoPrePlan.setLogStatistics(RecoverLogUtils.getChildLogStatistics(logVoPrePlan.getRecoverLogVoList()));
            logVoPrePlanList.add(logVoPrePlan);
        }
    }

    private static void getFakePrePlanLogInfo(String logLevel, List<RecoverLog> logPrePlanList, List<RecoverPreplan> recoverPreplanList, List<RecoverLogVo> logVoPrePlanList) {
        Map<Object, Object> logPrePlanMap = new HashMap();
        if (CollectionUtils.isNotEmpty(logPrePlanList)) {
            logPrePlanMap = logPrePlanList.stream().collect(Collectors.toMap(RecoverLog::getResourceId, Function.identity(), (keyOld, keyNew) -> keyNew));
        }
        for (RecoverPreplan recoverPreplan : recoverPreplanList) {
            RecoverLogVo logVoPrePlan = new RecoverLogVo();
            RecoverLog logPrePlan = new RecoverLog();
            if (logPrePlanMap.containsKey(recoverPreplan.getId())) {
                logPrePlan = (RecoverLog)logPrePlanMap.get(recoverPreplan.getId());
                logVoPrePlan = RecoverLogUtils.getRecoverLogVoCommon(logPrePlan);
            } else {
                logPrePlan.setResourceId(recoverPreplan.getId());
                logPrePlan.setProjectId(recoverPreplan.getProjectId());
                logVoPrePlan.setStatus(RecoverLogStatus.WAITING.getValue());
                logVoPrePlan.setResourceId(recoverPreplan.getId());
                logVoPrePlan.setResourceName(recoverPreplan.getName());
                logVoPrePlan.setResourceType(RecoverResourceType.RECOVER_PREPLAN.getValue());
            }
            logVoPrePlan.setOperateType(recoverPreplan.getType());
            RecoverLogUtils.setLogVoPrePlanOtherInfo(logVoPrePlan, recoverPreplan.getProjectId(), recoverPreplan.getSiteId());
            if (!logLevel.equals(PRE_PLAN_LEVEL)) {
                List<RecoverLogVo> logVoPlanStageList = RecoverLogUtils.getStageLogInfo(logPrePlan, logLevel);
                logVoPrePlan.setRecoverLogVoList(logVoPlanStageList);
            }
            logVoPrePlan.setLogStatistics(RecoverLogUtils.getChildLogStatistics(logVoPrePlan.getRecoverLogVoList()));
            logVoPrePlanList.add(logVoPrePlan);
        }
    }

    private static void setLogVoPrePlanOtherInfo(RecoverLogVo logVoPrePlan, String projectId, String siteId) {
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        SitePlan sitePlan = planService.querySitePlanBySiteId(projectId, siteId);
        if (!VerifyUtil.isEmpty((Object)sitePlan)) {
            ArrayList<SiteInfoVo> siteInfoVoList = new ArrayList<SiteInfoVo>();
            SiteInfoVo siteInfoVo = new SiteInfoVo();
            siteInfoVo.setSiteName(sitePlan.getSiteName());
            siteInfoVo.setSiteId(sitePlan.getSiteId());
            siteInfoVoList.add(siteInfoVo);
            logVoPrePlan.setSiteInfos(siteInfoVoList);
        }
    }

    public static List<RecoverLogVo> getStageLogInfo(RecoverLog logPrePlan, String logLevel) {
        ArrayList<RecoverLog> logPlanStageList = new ArrayList();
        if (!VerifyUtil.isEmpty((String)logPrePlan.getId())) {
            logPlanStageList = RecoverLogUtils.getRecoverLogList(logPrePlan);
        }
        List recoverStageList = CommonUtil.getCsrService(RecoverStageService.class).getStageList(logPrePlan.getProjectId(), logPrePlan.getResourceId());
        ArrayList<RecoverLogVo> logVoPlanStageList = new ArrayList<RecoverLogVo>();
        RecoverLogUtils.getTrueStageLogInfo(logLevel, logPlanStageList, recoverStageList, logVoPlanStageList);
        Set resourceIdsInLogStageSet = logPlanStageList.stream().map(RecoverLog::getResourceId).collect(Collectors.toSet());
        List<RecoverStage> recoverStageListNotInLogStageList = recoverStageList.stream().filter(item -> !resourceIdsInLogStageSet.contains(item.getId())).collect(Collectors.toList());
        RecoverLogUtils.getFakeStageLogInfo(logLevel, logPlanStageList, recoverStageListNotInLogStageList, logVoPlanStageList);
        List<RecoverLogVo> sortedByStartTime = logVoPlanStageList.stream().sorted(Comparator.comparing(RecoverLogVo::getStartTime, Comparator.nullsLast(Timestamp::compareTo))).collect(Collectors.toList());
        return RecoverLogUtils.sortRecoverLogByPreId(sortedByStartTime);
    }

    private static void getTrueStageLogInfo(String logLevel, List<RecoverLog> logPlanStageList, List<RecoverStage> recoverStageList, List<RecoverLogVo> logVoPlanStageList) {
        Map<Object, Object> recoverStageMap = new HashMap();
        if (CollectionUtils.isNotEmpty(recoverStageList)) {
            recoverStageMap = recoverStageList.stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity(), (keyOld, keyNew) -> keyNew));
        }
        for (RecoverLog logPlanStage : logPlanStageList) {
            RecoverLogVo logVoPlanStage = RecoverLogUtils.getRecoverLogVoCommon(logPlanStage);
            if (recoverStageMap.containsKey(logPlanStage.getResourceId())) {
                RecoverStage recoverStage = (RecoverStage)recoverStageMap.get(logPlanStage.getResourceId());
                logVoPlanStage.setStageType(recoverStage.getType());
                logVoPlanStage.setPreResourceIds(Collections.singletonList(recoverStage.getPreStageId()));
            }
            if (!logLevel.equals(STAGE_LEVEL)) {
                List<RecoverLogVo> logVoFlowList = RecoverLogUtils.getFlowLogInfo(logPlanStage, logLevel);
                logVoPlanStage.setRecoverLogVoList(logVoFlowList);
            }
            logVoPlanStageList.add(logVoPlanStage);
        }
    }

    private static void getFakeStageLogInfo(String logLevel, List<RecoverLog> logPlanStageList, List<RecoverStage> recoverStageList, List<RecoverLogVo> logVoPlanStageList) {
        Map<Object, Object> logPlanStageMap = new HashMap();
        if (CollectionUtils.isNotEmpty(logPlanStageList)) {
            logPlanStageMap = logPlanStageList.stream().collect(Collectors.toMap(RecoverLog::getResourceId, Function.identity(), (keyOld, keyNew) -> keyNew));
        }
        for (RecoverStage recoverStage : recoverStageList) {
            RecoverLogVo logVoPlanStage = new RecoverLogVo();
            RecoverLog logPlanStage = new RecoverLog();
            if (logPlanStageMap.containsKey(recoverStage.getId())) {
                logPlanStage = (RecoverLog)logPlanStageMap.get(recoverStage.getId());
                logVoPlanStage = RecoverLogUtils.getRecoverLogVoCommon(logPlanStage);
            } else {
                logPlanStage.setResourceId(recoverStage.getId());
                logPlanStage.setProjectId(recoverStage.getProjectId());
                logVoPlanStage.setStatus(RecoverLogStatus.WAITING.getValue());
                logVoPlanStage.setResourceId(recoverStage.getId());
                logVoPlanStage.setResourceName(recoverStage.getName());
                logVoPlanStage.setResourceType(RecoverResourceType.RECOVER_STAGE.getValue());
            }
            logVoPlanStage.setStageType(recoverStage.getType());
            logVoPlanStage.setPreResourceIds(Collections.singletonList(recoverStage.getPreStageId()));
            if (!logLevel.equals(STAGE_LEVEL)) {
                List<RecoverLogVo> logVoFlowList = RecoverLogUtils.getFlowLogInfo(logPlanStage, logLevel);
                logVoPlanStage.setRecoverLogVoList(logVoFlowList);
            }
            logVoPlanStageList.add(logVoPlanStage);
        }
    }

    public static List<RecoverLogVo> getFlowLogInfo(RecoverLog logPlanStage, String logLevel) {
        ArrayList<RecoverLog> logFlowList = new ArrayList();
        if (!VerifyUtil.isEmpty((String)logPlanStage.getId())) {
            logFlowList = RecoverLogUtils.getRecoverLogList(logPlanStage);
        }
        RecoverFlowQuery recoverFlowQuery = new RecoverFlowQuery();
        recoverFlowQuery.setPage(false);
        recoverFlowQuery.setStageId(logPlanStage.getResourceId());
        RecoverFlowService flowService = CommonUtil.getCsrService(RecoverFlowService.class);
        List recoverFlowList = flowService.queryRecoverFlowList(recoverFlowQuery);
        ArrayList<RecoverLogVo> logVoFlowList = new ArrayList<RecoverLogVo>();
        RecoverLogUtils.getTrueFlowLogInfo(logPlanStage, logLevel, logFlowList, recoverFlowList, logVoFlowList);
        Set resourceIdsInLogFlowSet = logFlowList.stream().map(RecoverLog::getResourceId).collect(Collectors.toSet());
        List<RecoverFlow> recoverFlowListNotInLogFlowList = recoverFlowList.stream().filter(item -> !resourceIdsInLogFlowSet.contains(item.getId())).collect(Collectors.toList());
        RecoverLogUtils.getFakeFlowLogInfo(logPlanStage, logLevel, logFlowList, recoverFlowListNotInLogFlowList, logVoFlowList);
        List<RecoverLogVo> sortedByStartTime = logVoFlowList.stream().sorted(Comparator.comparing(RecoverLogVo::getStartTime, Comparator.nullsLast(Timestamp::compareTo))).collect(Collectors.toList());
        return RecoverLogUtils.sortRecoverLogByPreId(sortedByStartTime);
    }

    private static void getTrueFlowLogInfo(RecoverLog logPlanStage, String logLevel, List<RecoverLog> logFlowList, List<RecoverFlow> recoverFlowList, List<RecoverLogVo> logVoFlowList) {
        Map<Object, Object> recoverFlowMap = new HashMap();
        if (CollectionUtils.isNotEmpty(recoverFlowList)) {
            recoverFlowMap = recoverFlowList.stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity(), (keyOld, keyNew) -> keyNew));
        }
        for (RecoverLog logFlow : logFlowList) {
            RecoverLogVo logVoFlow = RecoverLogUtils.getRecoverLogVoCommon(logFlow);
            ApplicationBo applicationBo = null;
            if (recoverFlowMap.containsKey(logFlow.getResourceId())) {
                RecoverFlow recoverFlow = (RecoverFlow)recoverFlowMap.get(logFlow.getResourceId());
                logVoFlow.setOperateType(recoverFlow.getType());
                RecoverFlowService flowService = CommonUtil.getCsrService(RecoverFlowService.class);
                List preFlowIdList = flowService.queryPreFlowIdList(logPlanStage.getResourceId(), recoverFlow.getId());
                if (preFlowIdList.size() == 0) {
                    logVoFlow.setPreResourceIds(Collections.singletonList(null));
                } else {
                    logVoFlow.setPreResourceIds(preFlowIdList);
                }
                applicationBo = CommonUtil.getCsrService(AppService.class).queryApp(recoverFlow.getAppId(), recoverFlow.getProjectId());
                logVoFlow.setAppName(applicationBo.getApplicationName());
            }
            if (!logLevel.equals(FLOW_LEVEL)) {
                List<RecoverLogVo> logVoStepList = VerifyUtil.isEmpty(applicationBo) ? RecoverLogUtils.getStepLogInfo(logFlow, null) : RecoverLogUtils.getStepLogInfo(logFlow, applicationBo.getApplicationId());
                logVoFlow.setRecoverLogVoList(logVoStepList);
            }
            logVoFlowList.add(logVoFlow);
        }
    }

    private static void getFakeFlowLogInfo(RecoverLog logPlanStage, String logLevel, List<RecoverLog> logFlowList, List<RecoverFlow> recoverFlowList, List<RecoverLogVo> logVoFlowList) {
        Map<Object, Object> logFlowMap = new HashMap();
        if (CollectionUtils.isNotEmpty(logFlowList)) {
            logFlowMap = logFlowList.stream().collect(Collectors.toMap(RecoverLog::getResourceId, Function.identity(), (keyOld, keyNew) -> keyNew));
        }
        for (RecoverFlow recoverFlow : recoverFlowList) {
            RecoverLogVo logVoFlow = new RecoverLogVo();
            RecoverLog logFlow = new RecoverLog();
            if (logFlowMap.containsKey(recoverFlow.getId())) {
                logFlow = (RecoverLog)logFlowMap.get(recoverFlow.getId());
                logVoFlow = RecoverLogUtils.getRecoverLogVoCommon(logFlow);
            } else {
                logFlow.setResourceId(recoverFlow.getId());
                logFlow.setProjectId(recoverFlow.getProjectId());
                logVoFlow.setStatus(RecoverLogStatus.WAITING.getValue());
                logVoFlow.setResourceId(recoverFlow.getId());
                logVoFlow.setResourceName(recoverFlow.getName());
                logVoFlow.setResourceType(RecoverResourceType.RECOVER_FLOW.getValue());
            }
            logVoFlow.setOperateType(recoverFlow.getType());
            RecoverFlowService flowService = CommonUtil.getCsrService(RecoverFlowService.class);
            List preFlowIdList = flowService.queryPreFlowIdList(logPlanStage.getResourceId(), recoverFlow.getId());
            if (preFlowIdList.size() == 0) {
                logVoFlow.setPreResourceIds(Collections.singletonList(null));
            } else {
                logVoFlow.setPreResourceIds(preFlowIdList);
            }
            ApplicationBo applicationBo = CommonUtil.getCsrService(AppService.class).queryApp(recoverFlow.getAppId(), recoverFlow.getProjectId());
            logVoFlow.setAppName(applicationBo.getApplicationName());
            if (!logLevel.equals(FLOW_LEVEL)) {
                List<RecoverLogVo> logVoStepList = VerifyUtil.isEmpty((Object)applicationBo) ? RecoverLogUtils.getStepLogInfo(logFlow, null) : RecoverLogUtils.getStepLogInfo(logFlow, applicationBo.getApplicationId());
                logVoFlow.setRecoverLogVoList(logVoStepList);
            }
            logVoFlowList.add(logVoFlow);
        }
    }

    public static List<RecoverLogVo> getStepLogInfo(RecoverLog logFlow, String applicationId) {
        ArrayList<RecoverLog> logStepList = new ArrayList();
        if (!VerifyUtil.isEmpty((String)logFlow.getId())) {
            logStepList = RecoverLogUtils.getRecoverLogList(logFlow);
        }
        RecoverStepQuery recoverStepQuery = new RecoverStepQuery();
        recoverStepQuery.setPage(false);
        recoverStepQuery.setFlowId(logFlow.getResourceId());
        RecoverStepService stepService = CommonUtil.getCsrService(RecoverStepService.class);
        List recoverStepList = stepService.queryRecoverStepList(recoverStepQuery);
        ArrayList<RecoverLogVo> logVoStepList = new ArrayList<RecoverLogVo>();
        RecoverLogUtils.getTrueStepLogInfo(logFlow, applicationId, logStepList, recoverStepList, logVoStepList);
        Set resourceIdsInLogStepSet = logStepList.stream().map(RecoverLog::getResourceId).collect(Collectors.toSet());
        List<RecoverStep> recoverStepListNotInLogStepList = recoverStepList.stream().filter(item -> !resourceIdsInLogStepSet.contains(item.getId())).collect(Collectors.toList());
        RecoverLogUtils.getFakeStepLogInfo(logFlow, applicationId, logStepList, recoverStepListNotInLogStepList, logVoStepList);
        List<RecoverLogVo> sortedByStartTime = logVoStepList.stream().sorted(Comparator.comparing(RecoverLogVo::getStartTime, Comparator.nullsLast(Timestamp::compareTo))).collect(Collectors.toList());
        return RecoverLogUtils.sortRecoverLogByPreId(sortedByStartTime);
    }

    private static void getTrueStepLogInfo(RecoverLog logFlow, String applicationId, List<RecoverLog> logStepList, List<RecoverStep> recoverStepList, List<RecoverLogVo> logVoStepList) {
        Map<Object, Object> recoverStepMap = new HashMap();
        if (CollectionUtils.isNotEmpty(recoverStepList)) {
            recoverStepMap = recoverStepList.stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity(), (keyOld, keyNew) -> keyNew));
        }
        for (RecoverLog logStep : logStepList) {
            RecoverLogVo logVoStep = RecoverLogUtils.getRecoverLogVoCommon(logStep);
            if (recoverStepMap.containsKey(logStep.getResourceId())) {
                RecoverStep recoverStep = (RecoverStep)recoverStepMap.get(logStep.getResourceId());
                logVoStep.setStepAction(recoverStep.getAction());
                logVoStep.setPreDelayTime(recoverStep.getPreDelayTime());
                logVoStep.setAfterDelayTime(recoverStep.getAfterDelayTime());
                RecoverLogUtils.setLogVoStepOtherInfo(logFlow, applicationId, recoverStep, logVoStep, logStep);
            }
            logVoStepList.add(logVoStep);
        }
    }

    private static void getFakeStepLogInfo(RecoverLog logFlow, String applicationId, List<RecoverLog> logStepList, List<RecoverStep> recoverStepList, List<RecoverLogVo> logVoStepList) {
        Map<Object, Object> logStepMap = new HashMap();
        if (CollectionUtils.isNotEmpty(logStepList)) {
            logStepMap = logStepList.stream().collect(Collectors.toMap(RecoverLog::getResourceId, Function.identity(), (keyOld, keyNew) -> keyNew));
        }
        for (RecoverStep recoverStep : recoverStepList) {
            RecoverLogVo logVoStep = new RecoverLogVo();
            RecoverLog logStep = new RecoverLog();
            if (logStepMap.containsKey(recoverStep.getId())) {
                logStep = (RecoverLog)logStepMap.get(recoverStep.getId());
                logVoStep = RecoverLogUtils.getRecoverLogVoCommon(logStep);
            } else {
                logStep.setProjectId(recoverStep.getProjectId());
                logVoStep.setStatus(RecoverLogStatus.WAITING.getValue());
                logVoStep.setResourceId(recoverStep.getId());
                logVoStep.setResourceName(recoverStep.getName());
                logVoStep.setResourceType(RecoverResourceType.RECOVER_STEP.getValue());
            }
            logVoStep.setStepAction(recoverStep.getAction());
            logVoStep.setPreDelayTime(recoverStep.getPreDelayTime());
            logVoStep.setAfterDelayTime(recoverStep.getAfterDelayTime());
            RecoverLogUtils.setLogVoStepOtherInfo(logFlow, applicationId, recoverStep, logVoStep, logStep);
            logVoStepList.add(logVoStep);
        }
    }

    private static void setLogVoStepOtherInfo(RecoverLog logFlow, String applicationId, RecoverStep recoverStep, RecoverLogVo logVoStep, RecoverLog logStep) {
        RecoverStepService stepService = CommonUtil.getCsrService(RecoverStepService.class);
        List preStepList = stepService.queryAllPreStepIdInFlow(recoverStep.getId(), logFlow.getResourceId());
        if (preStepList.size() == 0) {
            logVoStep.setPreResourceIds(Collections.singletonList(null));
        } else {
            logVoStep.setPreResourceIds(preStepList);
        }
        Optional<AppServiceInstance> serviceInstanceOptional = RecoverLogUtils.getAppServiceInstance(applicationId, recoverStep, logStep);
        if (serviceInstanceOptional.isPresent()) {
            logVoStep.setInstanceName(serviceInstanceOptional.get().getInstanceName());
            logVoStep.setServiceType(serviceInstanceOptional.get().getServiceType());
        }
    }

    private static Optional<AppServiceInstance> getAppServiceInstance(String applicationId, RecoverStep recoverStep, RecoverLog logStep) {
        if (!VerifyUtil.isEmpty((String)applicationId)) {
            ServiceInstanceQuery serviceInstanceQuery = new ServiceInstanceQuery();
            serviceInstanceQuery.setAppId(applicationId);
            serviceInstanceQuery.setProjectId(logStep.getProjectId());
            serviceInstanceQuery.setInstanceId(recoverStep.getServiceInstanceId());
            return Optional.ofNullable(CommonUtil.getCsrService(AppService.class).queryProtectedInstance(serviceInstanceQuery));
        }
        return Optional.empty();
    }

    private static List<RecoverLog> getRecoverLogList(RecoverLog recoverLog) {
        RecoverLogQuery logQuery = new RecoverLogQuery();
        logQuery.setProjectId(recoverLog.getProjectId());
        logQuery.setParentIds(Collections.singletonList(recoverLog.getId()));
        logQuery.setStartTimeAsc(true);
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        List logList = planService.getRecoverLogList(logQuery);
        return logList;
    }

    public static Optional<SitePlan> getSitePlanDetail(String projectId, String sitePlanId) {
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        try {
            return Optional.ofNullable(planService.querySitePlan(projectId, sitePlanId));
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != 1073952205L) {
                LOG.error((Object)"Query RecoverLog when query sitePlan error.");
                throw e;
            }
            return Optional.empty();
        }
    }

    public static Optional<RecoverPlan> getPlanDetail(String projectId, String planId) {
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        try {
            return Optional.ofNullable(planService.queryPlan(projectId, planId, null));
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != 1073952109L) {
                LOG.error((Object)"Query RecoverLog when query recoverPlan error.");
                throw e;
            }
            return Optional.empty();
        }
    }

    public static Optional<RecoverPreplan> getPrePlanDetail(String prePlanId) {
        RecoverPreplanService prePlanService = CommonUtil.getCsrService(RecoverPreplanService.class);
        try {
            return Optional.ofNullable(prePlanService.queryPreplanById(prePlanId));
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != 1073952800L) {
                LOG.error((Object)"Query RecoverLog when query sitePlan and prePlan error.");
                throw e;
            }
            return Optional.empty();
        }
    }

    public static RecoverLogVo getRecoverLogVoCommon(RecoverLog recoverLog) {
        RecoverLogVo logVo = new RecoverLogVo();
        logVo.setId(recoverLog.getId());
        logVo.setParentId(recoverLog.getParentId());
        logVo.setStatus(recoverLog.getStatus());
        logVo.setStartTime(recoverLog.getStartTime());
        logVo.setEndTime(recoverLog.getEndTime());
        logVo.setResourceId(recoverLog.getResourceId());
        logVo.setSiteId(recoverLog.getSiteId());
        logVo.setResourceName(recoverLog.getResourceName());
        logVo.setResourceType(recoverLog.getResourceType());
        logVo.setOperateType(recoverLog.getOperationType());
        logVo.setProgress(recoverLog.getProcess());
        logVo.setErrorCode(recoverLog.getErrorCode());
        logVo.setPreResourceIds(Collections.singletonList(null));
        long nowTime = System.currentTimeMillis();
        if (VerifyUtil.isEmpty((Object)recoverLog.getStartTime())) {
            return logVo;
        }
        if (VerifyUtil.isEmpty((Object)recoverLog.getEndTime())) {
            logVo.setSpendTime(nowTime - recoverLog.getStartTime().getTime());
        } else {
            long spendTime = recoverLog.getEndTime().getTime() - recoverLog.getStartTime().getTime();
            if (spendTime < 0L) {
                LOG.warn((Object)"RecoverLog(%s) spendTIme < 0.", new Object[]{recoverLog.getId()});
            }
            logVo.setSpendTime(Math.max(spendTime, 0L));
        }
        return logVo;
    }

    public static LogStatistics getChildLogStatistics(List<RecoverLogVo> recoverLogVoList) {
        LogStatistics logStatistics = new LogStatistics();
        if (!VerifyUtil.isEmpty(recoverLogVoList)) {
            int logTotal = recoverLogVoList.size();
            int logFailedNum = (int)recoverLogVoList.stream().filter(item -> RecoverLogStatus.FAILED.getValue().equals(item.getStatus())).count();
            int logSuccessNum = (int)recoverLogVoList.stream().filter(item -> RecoverLogStatus.SUCCESS.getValue().equals(item.getStatus())).count();
            int logRunningNum = (int)recoverLogVoList.stream().filter(item -> RecoverLogStatus.RUNNING.getValue().equals(item.getStatus()) || RecoverLogStatus.SUSPENDED.getValue().equals(item.getStatus()) || RecoverLogStatus.WAITING.getValue().equals(item.getStatus())).count();
            logStatistics.setLogTotal(logTotal);
            logStatistics.setLogFailedNum(logFailedNum);
            logStatistics.setLogSuccessNum(logSuccessNum);
            logStatistics.setLogRunningNum(logRunningNum);
        }
        return logStatistics;
    }

    public static List<SiteInfoVo> getTargetSiteInfoVos(String projectId, RecoverLog logPlan, List<SiteInfoVo> prePlanSiteInfos) {
        String sourceSiteId;
        if (CollectionUtils.isNotEmpty(prePlanSiteInfos) && !VerifyUtil.isEmpty((String)(sourceSiteId = prePlanSiteInfos.get(0).getSiteId()))) {
            PlanService planService = CommonUtil.getCsrService(PlanService.class);
            Map sourceToTargetSiteInfoMap = planService.getSourceToTargetSiteInfoMap(projectId, logPlan.getResourceId());
            Set targetSiteIds = (Set)sourceToTargetSiteInfoMap.get(sourceSiteId);
            if (VerifyUtil.isEmpty((Collection)targetSiteIds)) {
                LOG.warn((Object)"Query target sites empty, check instance or app of the plan(%s), Site id:%s.", new Object[]{logPlan.getResourceId(), sourceSiteId});
                return Collections.emptyList();
            }
            ArrayList<SiteInfoVo> targetSiteInfoVos = new ArrayList<SiteInfoVo>();
            targetSiteIds.forEach(targetSiteId -> {
                SitePlan sitePlan = planService.querySitePlanBySiteId(projectId, targetSiteId);
                SiteInfoVo siteInfoVo = new SiteInfoVo();
                siteInfoVo.setSiteName(sitePlan.getSiteName());
                siteInfoVo.setSiteId(sitePlan.getSiteId());
                targetSiteInfoVos.add(siteInfoVo);
            });
            return targetSiteInfoVos;
        }
        return Collections.emptyList();
    }

    public static RecoverLogQuery getSitePlanLogRecoverLogQuery(String projectId, int limit, int marker, RecoverLogSitePlanPara recoverLogSitePlanPara) {
        RecoverLogQuery recoverLogQuery = new RecoverLogQuery();
        recoverLogQuery.setProjectId(projectId);
        if (!VerifyUtil.isEmpty((String)recoverLogSitePlanPara.getSitePlanId())) {
            recoverLogQuery.setResourceIds(Collections.singletonList(recoverLogSitePlanPara.getSitePlanId()));
        }
        recoverLogQuery.setResourceType(RecoverResourceType.SITE_PLAN.getValue());
        recoverLogQuery.setStatus(recoverLogSitePlanPara.getStatus());
        recoverLogQuery.setLimit(limit);
        recoverLogQuery.setMarker(marker);
        recoverLogQuery.setPage(true);
        return recoverLogQuery;
    }

    public static RecoverLogQuery getPlanLogRecoverLogQuery(String projectId, int limit, int marker, RecoverLogPlanPara recoverLogPlanPara) {
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        List<Object> planLogIds = new ArrayList();
        if (!VerifyUtil.isEmpty((String)recoverLogPlanPara.getSiteId()) || !VerifyUtil.isEmpty((String)recoverLogPlanPara.getPreplanName())) {
            planLogIds = RecoverLogUtils.getPlanLogIds(projectId, recoverLogPlanPara, planService);
        }
        List<Object> planIds = new ArrayList();
        if (!VerifyUtil.isEmpty((String)recoverLogPlanPara.getPlanId())) {
            planIds = Collections.singletonList(recoverLogPlanPara.getPlanId());
        }
        RecoverLogQuery recoverLogQuery = new RecoverLogQuery();
        if (!VerifyUtil.isEmpty(planLogIds)) {
            recoverLogQuery.setIds(planLogIds);
        }
        recoverLogQuery.setProjectId(projectId);
        recoverLogQuery.setResourceIds(planIds);
        recoverLogQuery.setResourceType(RecoverResourceType.RECOVER_PLAN.getValue());
        recoverLogQuery.setStatus(recoverLogPlanPara.getStatus());
        recoverLogQuery.setOperateType(recoverLogPlanPara.getOperateType());
        recoverLogQuery.setLimit(limit);
        recoverLogQuery.setMarker(marker);
        recoverLogQuery.setPage(true);
        return recoverLogQuery;
    }

    public static Optional<String> getSiteId(String projectId, RecoverLog logPlan) {
        Optional<SitePlan> sitePlanOptional;
        RecoverLogQuery logQuery = new RecoverLogQuery();
        logQuery.setProjectId(logPlan.getProjectId());
        logQuery.setIds(Collections.singletonList(logPlan.getParentId()));
        logQuery.setStartTimeAsc(true);
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        List logList = planService.getRecoverLogList(logQuery);
        if (CollectionUtils.isNotEmpty((Collection)logList) && (sitePlanOptional = RecoverLogUtils.getSitePlanDetail(projectId, ((RecoverLog)logList.get(0)).getResourceId())).isPresent()) {
            return Optional.ofNullable(sitePlanOptional.get().getSiteId());
        }
        return Optional.empty();
    }

    private static List<String> getPlanLogIds(String projectId, RecoverLogPlanPara recoverLogPlanPara, PlanService planService) {
        List<Object> planIds = new ArrayList();
        if (!VerifyUtil.isEmpty((String)recoverLogPlanPara.getSiteId()) || !VerifyUtil.isEmpty((String)recoverLogPlanPara.getPreplanName())) {
            RecoverPreplanService recoverPreplanService = CommonUtil.getCsrService(RecoverPreplanService.class);
            RecoverPreplanQuery recoverPreplanQuery = new RecoverPreplanQuery();
            recoverPreplanQuery.setProjectId(projectId);
            recoverPreplanQuery.setPlanId(recoverLogPlanPara.getPlanId());
            recoverPreplanQuery.setPreplanType(recoverLogPlanPara.getOperateType());
            recoverPreplanQuery.setPreplanName(recoverLogPlanPara.getPreplanName());
            recoverPreplanQuery.setSiteId(recoverLogPlanPara.getSiteId());
            recoverPreplanQuery.setPage(false);
            List recoverPrePlanList = recoverPreplanService.queryPreplans(recoverPreplanQuery);
            if (CollectionUtils.isEmpty((Collection)recoverPrePlanList)) {
                return new ArrayList<String>();
            }
            planIds = recoverPrePlanList.stream().map(RecoverPreplan::getRecoverPlanId).collect(Collectors.toList());
        }
        RecoverLogQuery prePlanLogQuery = new RecoverLogQuery();
        prePlanLogQuery.setProjectId(projectId);
        if (CollectionUtils.isNotEmpty(planIds)) {
            prePlanLogQuery.setResourceIds(planIds);
            prePlanLogQuery.setSiteId(recoverLogPlanPara.getSiteId());
        }
        prePlanLogQuery.setPage(false);
        List logPlanList = planService.getRecoverLogList(prePlanLogQuery);
        return logPlanList.stream().map(AbstractEntity::getId).collect(Collectors.toList());
    }

    private static List<RecoverPreplan> getRecoverPreplanList(RecoverLog parentLogPlan, String siteId) {
        RecoverPreplanService recoverPreplanService = CommonUtil.getCsrService(RecoverPreplanService.class);
        RecoverPreplanQuery recoverPreplanQuery = new RecoverPreplanQuery();
        recoverPreplanQuery.setProjectId(parentLogPlan.getProjectId());
        recoverPreplanQuery.setPlanId(parentLogPlan.getResourceId());
        recoverPreplanQuery.setPreplanType(parentLogPlan.getOperationType());
        recoverPreplanQuery.setSiteId(siteId);
        recoverPreplanQuery.setPage(false);
        return recoverPreplanService.queryPreplans(recoverPreplanQuery);
    }

    private static List<RecoverLogVo> sortRecoverLogByPreId(List<RecoverLogVo> logVoList) {
        ArrayList<RecoverLogVo> resultList = new ArrayList<RecoverLogVo>();
        List<Object> parentIdList = new ArrayList();
        parentIdList.add(null);
        LOG.info((Object)"Sort log by pre id begin");
        for (int maxTime = 0; logVoList.size() != 0 && maxTime < 20; ++maxTime) {
            ArrayList<RecoverLogVo> filterParentList = new ArrayList<RecoverLogVo>();
            for (RecoverLogVo recoverLogVo : logVoList) {
                if (recoverLogVo.getPreResourceIds().size() == 0 || !parentIdList.contains(recoverLogVo.getPreResourceIds().get(0))) continue;
                LOG.info((Object)"Sort log by pre id, resource_id is %s, pre_resource_id is %s.", new Object[]{recoverLogVo.getResourceId(), recoverLogVo.getPreResourceIds().get(0)});
                filterParentList.add(recoverLogVo);
            }
            resultList.addAll(filterParentList);
            logVoList.removeAll(filterParentList);
            parentIdList = filterParentList.stream().map(RecoverLogVo::getResourceId).collect(Collectors.toList());
        }
        if (logVoList.size() != 0) {
            resultList.addAll(logVoList);
        }
        LOG.info((Object)"Sort log by pre id end, source list size is %s, filter list size is %s", new Object[]{logVoList.size(), resultList.size()});
        return resultList;
    }
}

