/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils;

import com.huawei.csr.framework.common.constants.DisasterRecoveryType;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.dao.model.ServiceInfo;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Az;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Region;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.RegionAz;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.RegionAzPair;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.ServiceInfoVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.SiteInfoVo;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SiteHelper {
    public static List<SiteInfoVo> convertToSiteVo(List<SiteInfo> siteList) {
        ArrayList<SiteInfoVo> siteInfoVoList = new ArrayList<SiteInfoVo>();
        if (VerifyUtil.isEmpty(siteList)) {
            return siteInfoVoList;
        }
        HashMap<String, SiteInfoVo> cacheMap = new HashMap<String, SiteInfoVo>();
        for (SiteInfo siteInfo : siteList) {
            String siteId = siteInfo.getSiteId();
            SiteInfoVo vo = (SiteInfoVo)cacheMap.get(siteId);
            if (vo == null) {
                vo = new SiteInfoVo();
                vo.setSiteId(siteId);
                vo.setSiteName(siteInfo.getSiteName());
                vo.setRegionAzList(new ArrayList<RegionAz>());
                cacheMap.put(siteId, vo);
                siteInfoVoList.add(vo);
            }
            RegionAz regionAz = new RegionAz();
            regionAz.setRegion(new Region(siteInfo.getRegionId(), siteInfo.getRegionName()));
            regionAz.setAz(new Az(siteInfo.getAzId(), siteInfo.getAzName()));
            vo.getRegionAzList().add(regionAz);
        }
        return siteInfoVoList;
    }

    public static List<ServiceInfoVo> convertToServiceVo(List<ServiceInfo> serviceInfoList) {
        ArrayList<ServiceInfoVo> serviceInfoVoList = new ArrayList<ServiceInfoVo>();
        for (ServiceInfo serviceInfo : serviceInfoList) {
            ServiceInfoVo vo = new ServiceInfoVo();
            vo.setId(serviceInfo.getId());
            vo.setServiceType(ServiceType.from((String)serviceInfo.getServiceType()));
            vo.setDisasterRecoveryType(DisasterRecoveryType.from((String)serviceInfo.getDrType()));
            if (vo.getServiceType().isLimitOneSideRegionAz()) {
                RegionAz regionAz = new RegionAz();
                regionAz.setRegion(new Region(serviceInfo.getRegionId(), serviceInfo.getRegionName()));
                regionAz.setAz(new Az(serviceInfo.getAzId(), serviceInfo.getAzName()));
                vo.setRegionAz(regionAz);
            } else {
                RegionAzPair regionAzPair = new RegionAzPair();
                RegionAz primaryRegionAz = new RegionAz();
                primaryRegionAz.setRegion(new Region(serviceInfo.getRegionId(), serviceInfo.getRegionName()));
                primaryRegionAz.setAz(new Az(serviceInfo.getAzId(), serviceInfo.getAzName()));
                regionAzPair.setPrimaryRegionAz(primaryRegionAz);
                RegionAz secondRegionAz = new RegionAz();
                secondRegionAz.setRegion(new Region(serviceInfo.getDrRegionId(), serviceInfo.getDrRegionName()));
                secondRegionAz.setAz(new Az(serviceInfo.getDrAzId(), serviceInfo.getDrAzName()));
                regionAzPair.setSecondRegionAz(secondRegionAz);
                vo.setRegionAzPair(regionAzPair);
            }
            serviceInfoVoList.add(vo);
        }
        return serviceInfoVoList;
    }
}

