/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.controller;

import com.huawei.csr.framework.common.constants.DisasterRecoveryType;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.constants.TopoRelationState;
import com.huawei.csr.framework.common.model.ApplicationBo;
import com.huawei.csr.framework.common.model.ApplicationQuery;
import com.huawei.csr.framework.common.model.InstanceObjectQuery;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.common.model.TopoLinkQuery;
import com.huawei.csr.framework.common.model.TopoNodeQuery;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.InstanceObject;
import com.huawei.csr.framework.dao.model.TopoLink;
import com.huawei.csr.framework.dao.model.TopoNode;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.AppHelper;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.SiteHelper;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.AppBasicVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.AppInfoVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.AppListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.AppResponse;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.AppVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.ApplicationTopologyVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.CanStepProtectInstanceListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.ProtectInstanceListResponse;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.ProtectInstanceVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.ProtectObjectListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.ProtectObjectVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.ProtectedInstanceResponse;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.QueryAppListPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.QueryCanStepInstanceListPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.QueryServiceInstanceListPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.QueryUnprotectedInstanceListPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.TopoLinkPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.TopoLinkVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.TopoNodeVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.UnprotectedInstanceListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.UpdateAppInfoPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Az;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Region;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.RegionAz;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.TaskVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.SiteInfoVo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.RequestBody;

public class ApplicationController
extends BaseController {
    private AppService getAppService() {
        return (AppService)this.getBundleService("csr_framework", AppService.class.getName(), AppService.class);
    }

    private ConfigService getConfigService() {
        return (ConfigService)this.getBundleService("csr_framework", ConfigService.class.getName(), ConfigService.class);
    }

    @GET
    @Path(value="/v1/{project_id}/applications/unprotected-instances")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public UnprotectedInstanceListVo queryUnprotectedInstanceList(@PathParam(value="project_id") String projectId, @Valid @BeanParam QueryUnprotectedInstanceListPara listPara) {
        Pair pageResult = this.getAppService().queryUnprotectedInstanceList(this.getRequestContext(), this.buildInstanceFilter(listPara));
        UnprotectedInstanceListVo listVo = new UnprotectedInstanceListVo();
        listVo.setTotalCount((Integer)pageResult.getRight());
        listVo.setUnprotectedInstanceVoList(AppHelper.convert2unprotectedInstances((List)pageResult.getLeft()));
        return listVo;
    }

    @GET
    @Path(value="/v1/{project_id}/applications")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public AppListVo queryApps(@NotNull @PathParam(value="project_id") String projectId, @Valid @BeanParam QueryAppListPara appListPara) {
        ApplicationQuery query = this.bindApplicationQuery(appListPara, projectId);
        Pair queryResult = this.getAppService().queryApps(query);
        AppListVo appListVo = new AppListVo();
        appListVo.setTotalCount(((Integer)queryResult.getRight()).intValue());
        for (ApplicationBo appBo : (List)queryResult.getLeft()) {
            AppVo appVo = AppHelper.generateAppVo(appBo);
            appListVo.getAppVoList().add(appVo);
        }
        return appListVo;
    }

    private ApplicationQuery bindApplicationQuery(QueryAppListPara para, String projectId) {
        ApplicationQuery appQuery = new ApplicationQuery();
        appQuery.setLimit(para.getLimit());
        appQuery.setMarker(para.getMarker());
        appQuery.setProjectId(projectId);
        appQuery.setPage(true);
        appQuery.setSiteId(para.getSiteId());
        appQuery.setName(para.getAppName());
        appQuery.setPlanId(para.getPlanId());
        appQuery.setStatus(para.getStatus());
        appQuery.setBelongPlan(para.getIsBelongPlan());
        appQuery.setFlowId(para.getFlowId());
        appQuery.setSupportCreateFlow(para.getIsSupportCreateFlow());
        return appQuery;
    }

    @GET
    @Path(value="/v1/{project_id}/applications/{application_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public AppResponse queryApplication(@NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") @PathParam(value="application_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") String appId, @NotNull @PathParam(value="project_id") String projectId) {
        ApplicationBo appBo = this.getAppService().queryApp(appId, projectId);
        return new AppResponse(AppHelper.generateAppVo(appBo));
    }

    @GET
    @Path(value="/v1/{project_id}/applications/{application_id}/service-instances")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public ProtectInstanceListResponse queryProtectedInstances(@PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") @PathParam(value="application_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") String appId, @Valid @BeanParam QueryServiceInstanceListPara para) {
        ServiceInstanceQuery serviceInstanceQuery = this.bindServiceInstanceQuery(para, projectId, appId);
        Pair queryResult = this.getAppService().queryProtectedInstances(serviceInstanceQuery);
        return this.getProtectInstanceListResponse((Pair<List<AppServiceInstance>, Integer>)queryResult);
    }

    private ServiceInstanceQuery bindServiceInstanceQuery(QueryServiceInstanceListPara para, String projectId, String appId) {
        ServiceInstanceQuery serviceInstanceQuery = new ServiceInstanceQuery();
        serviceInstanceQuery.setLimit(para.getLimit());
        serviceInstanceQuery.setMarker(para.getMarker());
        serviceInstanceQuery.setPage(true);
        serviceInstanceQuery.setProjectId(projectId);
        serviceInstanceQuery.setAppId(appId);
        serviceInstanceQuery.setDrType(para.getDrType());
        serviceInstanceQuery.setServiceType(para.getServictType());
        serviceInstanceQuery.setInstanceName(para.getInstanceName());
        serviceInstanceQuery.setInstanceStatus(para.getStatus());
        return serviceInstanceQuery;
    }

    @GET
    @Path(value="/v1/{project_id}/applications/{application_id}/service-instances/{instance_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public ProtectedInstanceResponse queryProtectedServiceInstance(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") @PathParam(value="application_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") String applicationId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="instance_id is incorrect") @PathParam(value="instance_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="instance_id is incorrect") String instanceId) {
        ServiceInstanceQuery query = new ServiceInstanceQuery();
        query.setAppId(applicationId);
        query.setProjectId(projectId);
        query.setInstanceId(instanceId);
        AppServiceInstance serviceInstance = this.getAppService().queryProtectedInstance(query);
        ProtectedInstanceResponse response = new ProtectedInstanceResponse();
        response.setProtectInstanceVo(this.generateProtectInstanceVo(serviceInstance));
        return response;
    }

    @GET
    @Path(value="/v1/{project_id}/flows/service-instances")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public CanStepProtectInstanceListVo queryCanCreateStepServiceInstances(@NotNull @PathParam(value="project_id") String projectId, @Valid @BeanParam QueryCanStepInstanceListPara para) {
        ServiceInstanceQuery query = this.bindCanStepQuery(projectId, para);
        Pair queryResult = this.getAppService().queryCanStepProtectedInstances(query);
        return this.getCanStepProtectInstanceListVo((Pair<List<AppServiceInstance>, Integer>)queryResult);
    }

    @POST
    @Path(value="/v1/{project_id}/applications/{application_id}/check")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="app_refresh_operationname", operationModule="protect", level=3)
    public TaskVo refreshApp(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") @PathParam(value="application_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") String appId) {
        this.getOperLogAttrMap().put("operationLogTarget", this.getAppService().getApplicationById(appId).getName());
        String taskId = this.getAppService().refreshApp(this.getRequestContext(), appId);
        TaskVo taskVo = new TaskVo();
        taskVo.setTaskId(taskId);
        return taskVo;
    }

    private ProtectInstanceListResponse getProtectInstanceListResponse(Pair<List<AppServiceInstance>, Integer> queryResult) {
        ProtectInstanceListResponse listResponse = new ProtectInstanceListResponse();
        listResponse.setTotalCount((Integer)queryResult.getRight());
        ArrayList<ProtectInstanceVo> protectInstanceVoList = new ArrayList<ProtectInstanceVo>();
        for (AppServiceInstance serviceInstance : (List)queryResult.getLeft()) {
            ProtectInstanceVo protectInstanceVo = this.generateProtectInstanceVo(serviceInstance);
            protectInstanceVoList.add(protectInstanceVo);
        }
        listResponse.setProtectInstanceVos(protectInstanceVoList);
        return listResponse;
    }

    private CanStepProtectInstanceListVo getCanStepProtectInstanceListVo(Pair<List<AppServiceInstance>, Integer> queryResult) {
        CanStepProtectInstanceListVo listResponse = new CanStepProtectInstanceListVo();
        listResponse.setTotalCount((Integer)queryResult.getRight());
        ArrayList<ProtectInstanceVo> protectInstanceVoList = new ArrayList<ProtectInstanceVo>();
        for (AppServiceInstance serviceInstance : (List)queryResult.getLeft()) {
            ProtectInstanceVo protectInstanceVo = this.generateProtectInstanceVo(serviceInstance);
            protectInstanceVoList.add(protectInstanceVo);
        }
        listResponse.setProtectInstanceVos(protectInstanceVoList);
        return listResponse;
    }

    private ServiceInstanceQuery bindCanStepQuery(String projectId, QueryCanStepInstanceListPara para) {
        ServiceInstanceQuery query = new ServiceInstanceQuery();
        query.setProjectId(projectId);
        query.setLimit(para.getLimit());
        query.setMarker(para.getMarker());
        query.setPage(true);
        query.setPdRegionId(para.getRegionId());
        query.setDrRegionId(para.getRegionId());
        query.setServiceType(para.getServiceType());
        query.setPdAzId(para.getAzId());
        query.setDrAzId(para.getAzId());
        query.setInstanceName(para.getInstanceName());
        query.setId(para.getId());
        query.setInstanceId(para.getInstanceId());
        query.setInstanceStatus(para.getInstanceStatus());
        query.setApplicationName(para.getAppName());
        query.setStepId(para.getStepId());
        return query;
    }

    @GET
    @Path(value="/v1/{project_id}/applications/{application_id}/service-instances/{instance_id}/instance-objects")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public ProtectObjectListVo queryProtectObjects(@NotNull @PathParam(value="project_id") String projectId, @Min(value=1L, message="limit out of range") @Max(value=512L, message="limit out of range") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=1L, message="limit out of range") @Max(value=512L, message="limit out of range") int limit, @Min(value=0L, message="limit out of range") @DefaultValue(value="0") @QueryParam(value="marker") @Min(value=0L, message="limit out of range") int marker, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="instance_id is incorrect") @PathParam(value="instance_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="instance_id is incorrect") String instanceId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") @PathParam(value="application_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") String appId) {
        InstanceObjectQuery instanceObjectQuery = new InstanceObjectQuery();
        instanceObjectQuery.setLimit(limit);
        instanceObjectQuery.setMarker(marker);
        instanceObjectQuery.setPage(true);
        instanceObjectQuery.setInstanceId(instanceId);
        instanceObjectQuery.setAppId(appId);
        instanceObjectQuery.setProjectId(projectId);
        Pair pair = this.getAppService().queryProtectedObjects(instanceObjectQuery);
        ProtectObjectListVo protectObjectListVo = new ProtectObjectListVo();
        protectObjectListVo.setTotalCount((Long)pair.getRight());
        ArrayList<ProtectObjectVo> instanceObjectVos = new ArrayList<ProtectObjectVo>();
        for (InstanceObject instanceObject : (List)pair.getLeft()) {
            instanceObjectVos.add(this.generateProtectObjectVo(instanceObject));
        }
        protectObjectListVo.setProtectObjectVos(instanceObjectVos);
        return protectObjectListVo;
    }

    @PUT
    @Path(value="/v1/{project_id}/applications/{application_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="app_update_operationname", operationModule="protect", level=3)
    public AppInfoVo updateAppInfo(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") @PathParam(value="application_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") String appId, @Valid @RequestBody UpdateAppInfoPara updateAppInfoPara) {
        ApplicationBo app = new ApplicationBo(projectId, appId);
        app.setApplicationName(updateAppInfoPara.getApplication().getName());
        app.setApplicationDesc(updateAppInfoPara.getApplication().getDescription());
        this.getOperLogAttrMap().put("operationLogTarget", app.getApplicationName());
        Application application = this.getAppService().updateApp(app);
        AppInfoVo appInfoVo = new AppInfoVo();
        AppBasicVo appBasicVo = new AppBasicVo();
        appBasicVo.setName(application.getName());
        appBasicVo.setDescription(application.getDescription());
        appInfoVo.setAppBasicVo(appBasicVo);
        return appInfoVo;
    }

    private ProtectInstanceVo generateProtectInstanceVo(AppServiceInstance serviceInstance) {
        List<SiteInfoVo> infoVos;
        ProtectInstanceVo protectInstanceVo = new ProtectInstanceVo();
        protectInstanceVo.setId(serviceInstance.getId());
        protectInstanceVo.setInstanceId(serviceInstance.getInstanceId());
        protectInstanceVo.setInstanceName(serviceInstance.getInstanceName());
        protectInstanceVo.setInstanceAddress(serviceInstance.getInstanceAddress());
        protectInstanceVo.setInstanceObjectCount(serviceInstance.getInstanceObjectCount());
        RegionAz pdRegionAz = new RegionAz();
        pdRegionAz.setRegion(new Region(serviceInstance.getPdRegionId(), serviceInstance.getPdRegionName()));
        pdRegionAz.setAz(new Az(serviceInstance.getPdAzId(), serviceInstance.getPdAzName()));
        protectInstanceVo.setPdRegionAz(pdRegionAz);
        RegionAz drRegionAz = new RegionAz();
        drRegionAz.setRegion(new Region(serviceInstance.getDrRegionId(), serviceInstance.getDrRegionName()));
        drRegionAz.setAz(new Az(serviceInstance.getDrAzId(), serviceInstance.getDrAzName()));
        protectInstanceVo.setDrRegionAz(drRegionAz);
        protectInstanceVo.setInstanceType(serviceInstance.getServiceType());
        protectInstanceVo.setStatus(serviceInstance.getStatus());
        protectInstanceVo.setDrType(serviceInstance.getDrType());
        protectInstanceVo.setRpo(serviceInstance.getRpo());
        protectInstanceVo.setReplicationStatus(serviceInstance.getReplicaStatus());
        protectInstanceVo.setServiceType(serviceInstance.getServiceType());
        protectInstanceVo.setStatus(serviceInstance.getStatus());
        protectInstanceVo.setSiteInfos(AppHelper.generateSiteInfoVo(serviceInstance.getPdSiteId()));
        if (protectInstanceVo.getSiteInfos() != null && (infoVos = AppHelper.generateSiteInfoVo(serviceInstance.getDrSiteId())) != null) {
            protectInstanceVo.getSiteInfos().addAll(infoVos);
        }
        if (serviceInstance.getApplication() != null) {
            protectInstanceVo.setAppName(serviceInstance.getApplication().getName());
        }
        return protectInstanceVo;
    }

    private ProtectObjectVo generateProtectObjectVo(InstanceObject instanceObject) {
        ProtectObjectVo vo = new ProtectObjectVo();
        vo.setPdObjectId(instanceObject.getPdId());
        vo.setPdObjectName(instanceObject.getPdName());
        Region pdRegion = new Region(instanceObject.getPdRegionId(), instanceObject.getPdRegionName());
        Az pdAz = new Az(instanceObject.getPdAzId(), instanceObject.getPdAzName());
        RegionAz pdRegionAz = new RegionAz();
        pdRegionAz.setRegion(pdRegion);
        pdRegionAz.setAz(pdAz);
        vo.setPdRegionAz(pdRegionAz);
        Region drRegion = new Region(instanceObject.getDrRegionId(), instanceObject.getDrRegionName());
        Az drAz = new Az(instanceObject.getDrAzId(), instanceObject.getDrAzName());
        RegionAz drRegionAz = new RegionAz();
        drRegionAz.setRegion(drRegion);
        drRegionAz.setAz(drAz);
        vo.setDrRegionAz(drRegionAz);
        vo.setDrProtectObjectId(instanceObject.getProjectId());
        vo.setPdObjectStatus(instanceObject.getPdStatus());
        vo.setDrObjectStatus(instanceObject.getDrStatus());
        vo.setObjectType("");
        vo.setDrProtectObjectId(instanceObject.getDrId());
        vo.setDrObjectName(instanceObject.getDrName());
        return vo;
    }

    private ServiceInstanceFilter buildInstanceFilter(QueryUnprotectedInstanceListPara para) {
        ServiceInstanceFilter instanceFilter = new ServiceInstanceFilter();
        instanceFilter.setServiceType(ServiceType.from((String)para.getServiceType()));
        instanceFilter.setInstanceName(para.getInstanceName());
        instanceFilter.setPdRegionId(para.getPdRegionId());
        instanceFilter.setDrRegionId(para.getDrRegionId());
        instanceFilter.setPdAzId(para.getPdAzId());
        instanceFilter.setDrAzId(para.getDrAzId());
        instanceFilter.setInstanceId(para.getInstanceId());
        instanceFilter.setMarker(para.getMarker());
        instanceFilter.setLimit(para.getLimit());
        instanceFilter.setDrType(DisasterRecoveryType.from((String)para.getDisasterRecoveryType()));
        return instanceFilter;
    }

    @GET
    @Path(value="/v1/{project_id}/topo/{application_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public ApplicationTopologyVo queryApplicationTopology(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") @PathParam(value="application_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") String applicationId) {
        AppService appService = this.getAppService();
        TopoNodeQuery nodeQuery = new TopoNodeQuery();
        nodeQuery.setProjectId(projectId);
        nodeQuery.setApplicationId(applicationId);
        List topoNodeList = appService.queryTopoNodes(nodeQuery);
        TopoLinkQuery linkQuery = new TopoLinkQuery();
        linkQuery.setProjectId(projectId);
        linkQuery.setApplicationId(applicationId);
        List topoLinkList = appService.queryTopoLinks(linkQuery);
        ApplicationTopologyVo topologyVo = new ApplicationTopologyVo();
        topologyVo.setNodes(topoNodeList.stream().map(this::convertNodeDbToVo).collect(Collectors.toList()));
        topologyVo.setLinks(topoLinkList.stream().map(this::convertLinkDbToVo).collect(Collectors.toList()));
        return topologyVo;
    }

    private TopoNodeVo convertNodeDbToVo(TopoNode topoNode) {
        TopoNodeVo topoNodeVo = new TopoNodeVo();
        topoNodeVo.setNodeId(topoNode.getId());
        topoNodeVo.setName(topoNode.getName());
        topoNodeVo.setNodeType(topoNode.getNodeType());
        topoNodeVo.setNodeStatus(topoNode.getNodeStatus());
        topoNodeVo.setState(TopoRelationState.from((String)topoNode.getState()));
        topoNodeVo.setResourceType(topoNode.getResourceType());
        topoNodeVo.setResourceId(topoNode.getResourceId());
        topoNodeVo.setRegionAz(this.buildRegionAz(topoNode));
        if (!VerifyUtil.isEmpty((String)topoNode.getSiteId())) {
            topoNodeVo.setSite(SiteHelper.convertToSiteVo(this.getConfigService().getSiteInfos(topoNode.getSiteId())).get(0));
        }
        return topoNodeVo;
    }

    private RegionAz buildRegionAz(TopoNode topoNode) {
        Region region = new Region();
        region.setRegionId(topoNode.getRegionId());
        region.setRegionName(topoNode.getRegionName());
        Az az = new Az();
        az.setAzId(topoNode.getAzId());
        az.setAzName(topoNode.getAzName());
        RegionAz regionAz = new RegionAz();
        regionAz.setRegion(region);
        regionAz.setAz(az);
        return regionAz;
    }

    private TopoLinkVo convertLinkDbToVo(TopoLink topoLink) {
        TopoLinkVo topoLinkVo = new TopoLinkVo();
        topoLinkVo.setSourceId(topoLink.getSourceId());
        topoLinkVo.setTargetId(topoLink.getTargetId());
        topoLinkVo.setReplicationStatus(topoLink.getReplicationStatus());
        return topoLinkVo;
    }

    @PUT
    @Path(value="/v1/{project_id}/topo/{application_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="topo_create_operationname", operationModule="protect", level=3)
    public void createApplicationTopologyLink(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") @PathParam(value="application_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") String applicationId, @Valid @RequestBody TopoLinkPara topoLinkPara) {
        this.getOperLogAttrMap().put("operationLogTarget", topoLinkPara.getSourceId() + "-" + topoLinkPara.getTargetId());
        TopoLink topoLink = new TopoLink();
        topoLink.setProjectId(projectId);
        topoLink.setApplicationId(applicationId);
        topoLink.setSourceId(topoLinkPara.getSourceId());
        topoLink.setTargetId(topoLinkPara.getTargetId());
        topoLink.setUserOpt(true);
        if (!this.getAppService().createTopoLink(topoLink)) {
            throw new LegoCheckedException(1073952400L);
        }
    }

    @DELETE
    @Path(value="/v1/{project_id}/topo/{application_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="topo_delete_operationname", operationModule="protect", level=4)
    public void deleteApplicationTopologyLink(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") @PathParam(value="application_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="application_id is incorrect") String applicationId, @Valid @RequestBody TopoLinkPara topoLinkPara) {
        this.getOperLogAttrMap().put("operationLogTarget", topoLinkPara.getSourceId() + "-" + topoLinkPara.getTargetId());
        TopoLink topoLink = new TopoLink();
        topoLink.setProjectId(projectId);
        topoLink.setApplicationId(applicationId);
        topoLink.setSourceId(topoLinkPara.getSourceId());
        topoLink.setTargetId(topoLinkPara.getTargetId());
        if (!this.getAppService().deleteTopoLink(topoLink)) {
            throw new LegoCheckedException(1073952400L);
        }
    }
}

