/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.controller;

import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.dao.model.ServiceInfo;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.constants.OperateType;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.SiteHelper;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Az;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Region;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.RegionAz;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.RegionAzPair;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.ServiceInfoCreatePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.ServiceInfoListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.ServiceInfoUpdatePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.SiteInfoListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.SiteInfoPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.SiteInfoUpdatePara;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.web.bind.annotation.RequestBody;

public class ConfigController
extends BaseController {
    private static final Log LOG = LogFactory.getInstance(ConfigController.class);

    @POST
    @Path(value="/v1/sites")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="site_create_operationname", operationModule="site", level=3)
    public void createSite(@Valid @RequestBody SiteInfoPara para) {
        this.getOperLogAttrMap().put("operationLogTarget", para.getSiteName());
        CommonUtil.getCsrService(ConfigService.class).createSiteInfo(para.getSiteName(), this.buildSiteRegionAzs(para.getRegionAzList()));
    }

    private List<SiteInfo> buildSiteRegionAzs(List<RegionAz> regionAzList) {
        ArrayList<SiteInfo> siteList = new ArrayList<SiteInfo>();
        for (RegionAz regionAz : regionAzList) {
            Region region = regionAz.getRegion();
            Az az = regionAz.getAz();
            SiteInfo site = new SiteInfo();
            site.setRegionId(region.getRegionId());
            site.setRegionName(region.getRegionName());
            site.setAzId(az.getAzId());
            site.setAzName(az.getAzName());
            siteList.add(site);
        }
        return siteList;
    }

    @PUT
    @Path(value="/v1/sites/{site_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="site_modify_region_az_operationname", operationModule="site", level=3)
    public void addOrRemoveSiteRegionAzs(@NotEmpty(message="site_id is empty") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="site_id is incorrect") @PathParam(value="site_id") @NotEmpty(message="site_id is empty") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="site_id is incorrect") String siteId, @Valid SiteInfoUpdatePara siteInfoUpdate) {
        OperateType operateType = siteInfoUpdate.getOperateType();
        List<SiteInfo> siteList = this.buildSiteRegionAzs(siteInfoUpdate.getRegionAzList());
        ConfigService service = CommonUtil.getCsrService(ConfigService.class);
        this.getOperLogAttrMap().put("operationLogTarget", Optional.of(service.getSiteInfos(siteId)).map(siteInfos -> (SiteInfo)siteInfos.get(0)).map(SiteInfo::getSiteName).orElse(""));
        if (OperateType.ADD.equals((Object)operateType)) {
            service.addSiteRegionAzs(siteId, siteList);
        }
        if (OperateType.REMOVE.equals((Object)operateType)) {
            service.removeSiteRegionAzs(siteId, siteList);
        }
    }

    @DELETE
    @Path(value="/v1/sites/{site_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="site_delete_operationname", operationModule="site", level=4)
    public void deleteSites(@Pattern(regexp="^[0-9a-fA-F]{32}$", message="site_id is incorrect") @PathParam(value="site_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="site_id is incorrect") String siteId) {
        ConfigService configService = CommonUtil.getCsrService(ConfigService.class);
        String siteName = ((SiteInfo)configService.getSiteInfos(siteId).get(0)).getSiteName();
        configService.deleteSiteInfo(siteId);
        this.getOperLogAttrMap().put("operationLogTarget", siteName);
    }

    @GET
    @Path(value="/v1/sites")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public SiteInfoListVo getSites() {
        List siteList = CommonUtil.getCsrService(ConfigService.class).getSiteInfos();
        SiteInfoListVo siteInfoListVo = new SiteInfoListVo();
        siteInfoListVo.setSiteInfoVoList(SiteHelper.convertToSiteVo(siteList));
        return siteInfoListVo;
    }

    @POST
    @Path(value="/v1/cloudserv")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="site_create_cloudserv_operationname", operationModule="site", level=3)
    public void createServiceInfos(@Valid @RequestBody ServiceInfoCreatePara servicePara) {
        this.getOperLogAttrMap().put("operationLogTarget", servicePara.getServiceType());
        CommonUtil.getCsrService(ConfigService.class).createServiceInfos(this.buildCreateServiceInfos(servicePara));
    }

    private List<ServiceInfo> buildCreateServiceInfos(ServiceInfoCreatePara servicePara) {
        ArrayList<ServiceInfo> serviceInfoList = new ArrayList<ServiceInfo>();
        ServiceType serviceType = servicePara.getServiceType();
        String drType = servicePara.getDisasterRecoveryType().getValue();
        List<RegionAzPair> regionAzPairList = servicePara.getRegionAzPairList();
        List<RegionAz> regionAzList = servicePara.getRegionAzList();
        if (serviceType.isLimitOneSideRegionAz() && !VerifyUtil.isEmpty(regionAzList)) {
            for (RegionAz regionAz : regionAzList) {
                serviceInfoList.add(this.buildServiceInfoWithRegionAz(serviceType.getValue(), drType, regionAz));
            }
        } else if (!serviceType.isLimitOneSideRegionAz() && !VerifyUtil.isEmpty(regionAzPairList)) {
            for (RegionAzPair regionAzPair : regionAzPairList) {
                serviceInfoList.add(this.buildServiceInfoWithRegionAzPair(serviceType.getValue(), drType, regionAzPair));
            }
        } else {
            LOG.error((Object)"Build services infos failed, service type:%s, regionAzList:%s, regionAzPairList:%s", new Object[]{serviceType, regionAzList, regionAzPairList});
            throw new LegoCheckedException(1073952208L, new String[]{serviceType.getValue(), String.valueOf(regionAzList), String.valueOf(regionAzPairList)});
        }
        return serviceInfoList;
    }

    private ServiceInfo buildServiceInfoWithRegionAzPair(String serviceType, String drType, RegionAzPair regionAzPair) {
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setServiceType(serviceType);
        serviceInfo.setDrType(drType);
        serviceInfo.setRegionId(regionAzPair.getPrimaryRegionAz().getRegion().getRegionId());
        serviceInfo.setRegionName(regionAzPair.getPrimaryRegionAz().getRegion().getRegionName());
        serviceInfo.setAzId(regionAzPair.getPrimaryRegionAz().getAz().getAzId());
        serviceInfo.setAzName(regionAzPair.getPrimaryRegionAz().getAz().getAzName());
        serviceInfo.setDrRegionId(regionAzPair.getSecondRegionAz().getRegion().getRegionId());
        serviceInfo.setDrRegionName(regionAzPair.getSecondRegionAz().getRegion().getRegionName());
        serviceInfo.setDrAzId(regionAzPair.getSecondRegionAz().getAz().getAzId());
        serviceInfo.setDrAzName(regionAzPair.getSecondRegionAz().getAz().getAzName());
        return serviceInfo;
    }

    private ServiceInfo buildServiceInfoWithRegionAz(String serviceType, String drType, RegionAz regionAz) {
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setServiceType(serviceType);
        serviceInfo.setDrType(drType);
        serviceInfo.setRegionId(regionAz.getRegion().getRegionId());
        serviceInfo.setRegionName(regionAz.getRegion().getRegionName());
        serviceInfo.setAzId(regionAz.getAz().getAzId());
        serviceInfo.setAzName(regionAz.getAz().getAzName());
        return serviceInfo;
    }

    @PUT
    @Path(value="/v1/cloudserv/{service_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="site_modify_cloudserv_operationname", operationModule="site", level=3)
    public void updateServiceInfo(@PathParam(value="service_id") String serviceId, @Valid @RequestBody ServiceInfoUpdatePara servicePara) {
        ServiceInfo serviceInfo = this.buildUpdateServiceInfo(serviceId, servicePara);
        this.getOperLogAttrMap().put("operationLogTarget", serviceInfo.getServiceType());
        CommonUtil.getCsrService(ConfigService.class).updateServiceRegionAz(serviceInfo);
    }

    private ServiceInfo buildUpdateServiceInfo(String serviceId, ServiceInfoUpdatePara servicePara) {
        ServiceInfo serviceInfo;
        ServiceType serviceType = servicePara.getServiceType();
        RegionAz regionAz = servicePara.getRegionAz();
        RegionAzPair regionAzPair = servicePara.getRegionAzPair();
        if (serviceType.isLimitOneSideRegionAz() && !VerifyUtil.isEmpty((Object)regionAz)) {
            serviceInfo = this.buildServiceInfoWithRegionAz(serviceType.getValue(), null, regionAz);
        } else if (!serviceType.isLimitOneSideRegionAz() && !VerifyUtil.isEmpty((Object)regionAzPair)) {
            serviceInfo = this.buildServiceInfoWithRegionAzPair(serviceType.getValue(), null, regionAzPair);
        } else {
            LOG.error((Object)"Build services infos failed, service type:%s, regionAz:%s, regionAzPair:%s", new Object[]{serviceType, regionAz, regionAzPair});
            throw new LegoCheckedException(1073952208L, new String[]{serviceType.getValue(), String.valueOf(regionAz), String.valueOf(regionAzPair)});
        }
        serviceInfo.setId(serviceId);
        return serviceInfo;
    }

    @DELETE
    @Path(value="/v1/cloudserv")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="site_delete_cloudserv_operationname", operationModule="site", level=3)
    public void deleteServiceInfos(@NotEmpty List<String> serviceIdList) {
        ConfigService configService = CommonUtil.getCsrService(ConfigService.class);
        String targetName = serviceIdList.stream().map(arg_0 -> ((ConfigService)configService).getServiceInfoById(arg_0)).filter(Objects::nonNull).map(ServiceInfo::getServiceType).collect(Collectors.joining(","));
        this.getOperLogAttrMap().put("operationLogTarget", targetName);
        configService.deleteServiceInfos(serviceIdList);
    }

    @GET
    @Path(value="/v1/cloudserv")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public ServiceInfoListVo getServices() {
        ServiceInfoListVo serviceInfoListVo = new ServiceInfoListVo();
        serviceInfoListVo.setServiceInfoVoList(SiteHelper.convertToServiceVo(CommonUtil.getCsrService(ConfigService.class).getServiceInfos()));
        return serviceInfoListVo;
    }
}

