/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.controller;

import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.model.RecoverExecuteBo;
import com.huawei.csr.framework.common.model.RecoverLogQuery;
import com.huawei.csr.framework.common.model.RecoverPlanQuery;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.model.RevocerPlanBo;
import com.huawei.csr.framework.common.model.SitePlanExecuteBo;
import com.huawei.csr.framework.common.model.SitePlanMapQuery;
import com.huawei.csr.framework.common.model.SitePlanQuery;
import com.huawei.csr.framework.dao.model.AbstractEntity;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.dao.model.SitePlan;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.csr.framework.service.PlanService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.constants.OperateType;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.RecoverLogUtils;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Az;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.Region;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.common.RegionAz;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.config.SiteInfoVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.AddAppToPlanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.CreatePlanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.ExecutePlanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.PlanPriorityListPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.PlanPriorityPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.PlanVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.PlanVoResponse;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.QueryPlansFromSitePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.QueryPlansPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.QueryRecoverPlansForSitePlanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverExecuteVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverLogDetailVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverLogListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverLogPlanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverLogSitePlanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverLogVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverPlanBasicInfo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverPlanListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.RecoverPlanVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.SingleSitePlanVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.SiteName;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.SitePlanBasicInfoVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.SitePlanExecutePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.SitePlanListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.UpdatePlanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.plan.UpdatePlanResponse;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.RequestBody;

public class PlanController
extends BaseController {
    private static final Log LOG = LogFactory.getInstance(PlanController.class);

    @POST
    @Path(value="/v1/{project_id}/plans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="plan_create_operationname", operationModule="recovery", level=3)
    public PlanVoResponse createPlan(@PathParam(value="project_id") String projectId, @Valid @RequestBody CreatePlanPara createPlanPara) {
        this.getOperLogAttrMap().put("operationLogTarget", createPlanPara.getName());
        RevocerPlanBo parameters = new RevocerPlanBo();
        parameters.setName(createPlanPara.getName());
        parameters.setDescription(createPlanPara.getDescription());
        parameters.setProjectId(projectId);
        parameters.setApplicationIds(createPlanPara.getApplications());
        PlanVoResponse response = new PlanVoResponse();
        response.setPlan(this.convertRecoverPlan2PlanVo(projectId, CommonUtil.getCsrService(PlanService.class).createPlan(parameters)));
        return response;
    }

    @GET
    @Path(value="/v1/{project_id}/siteplans/{siteplan_id}/unbindplans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverPlanListVo<PlanVo> queryRecoverPlansForSitePlan(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id is incorrect") @PathParam(value="siteplan_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id is incorrect") String sitePlanId, @Valid @BeanParam QueryRecoverPlansForSitePlanPara param) {
        RecoverPlanQuery query = new RecoverPlanQuery();
        query.setProjectId(projectId);
        query.setPage(false);
        query.setLimit(param.getLimit());
        query.setMarker(param.getMarker());
        query.setPlanName(param.getName());
        query.setPage(false);
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        Pair queryResult = planService.queryRecoverPlansForSitePlan(query, sitePlanId);
        RecoverPlanListVo<PlanVo> response = new RecoverPlanListVo<PlanVo>();
        response.setRecoverPlanList(((List)queryResult.getLeft()).stream().map(plan -> this.convertRecoverPlan2PlanVo(projectId, (RecoverPlan)plan)).collect(Collectors.toList()));
        response.setTotalCount(((Integer)queryResult.getRight()).intValue());
        return response;
    }

    @GET
    @Path(value="/v1/{project_id}/plans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverPlanListVo<PlanVo> queryPlans(@PathParam(value="project_id") String projectId, @Min(value=1L, message="limit out of range") @Max(value=512L, message="limit out of range") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=1L, message="limit out of range") @Max(value=512L, message="limit out of range") int limit, @Min(value=0L, message="marker out of range") @DefaultValue(value="0") @QueryParam(value="marker") @Min(value=0L, message="marker out of range") int marker, @Valid @BeanParam QueryPlansPara param) {
        RecoverPlanQuery query = new RecoverPlanQuery();
        query.setProjectId(projectId);
        query.setLimit(limit);
        query.setMarker(marker);
        query.setPlanName(param.getPlanName());
        query.setSitePlanId(param.getSitePlanId());
        query.setSiteName(param.getSiteName());
        query.setStatus(param.getStatus());
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        Pair queryResult = planService.queryPlans(query);
        RecoverPlanListVo<PlanVo> response = new RecoverPlanListVo<PlanVo>();
        response.setRecoverPlanList(((List)queryResult.getLeft()).stream().map(plan -> this.convertRecoverPlan2PlanVo(projectId, (RecoverPlan)plan)).collect(Collectors.toList()));
        response.setTotalCount(((Integer)queryResult.getRight()).intValue());
        return response;
    }

    @GET
    @Path(value="/v1/{project_id}/plans/{plan_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public PlanVoResponse queryPlan(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") @PathParam(value="plan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") String planId, @Pattern(regexp="^$|^[0-9a-fA-F]{32}$", message="application_id is incorrect") @QueryParam(value="application_id") @Pattern(regexp="^$|^[0-9a-fA-F]{32}$", message="application_id is incorrect") String applicationId) {
        PlanVoResponse response = new PlanVoResponse();
        response.setPlan(this.convertRecoverPlan2PlanVo(projectId, CommonUtil.getCsrService(PlanService.class).queryPlan(projectId, planId, applicationId)));
        return response;
    }

    @PUT
    @Path(value="/v1/{project_id}/plans/{plan_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="plan_modify_operationname", operationModule="recovery", level=3)
    public UpdatePlanResponse updatePlanBasicInfo(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") @PathParam(value="plan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") String planId, @Valid @RequestBody UpdatePlanPara updatePlanPara) {
        this.getOperLogAttrMap().put("operationLogTarget", updatePlanPara.getPlan().getName());
        RevocerPlanBo params = new RevocerPlanBo();
        params.setPlanId(planId);
        params.setProjectId(projectId);
        params.setDescription(updatePlanPara.getPlan().getDescription());
        params.setName(updatePlanPara.getPlan().getName());
        RecoverPlan recoverPlan = CommonUtil.getCsrService(PlanService.class).updatePlan(params);
        UpdatePlanResponse updatePlanResponse = new UpdatePlanResponse();
        RecoverPlanBasicInfo recoverPlanBasicInfo = new RecoverPlanBasicInfo();
        recoverPlanBasicInfo.setName(recoverPlan.getName());
        recoverPlanBasicInfo.setDescription(recoverPlan.getDescription());
        updatePlanResponse.setInstance(recoverPlanBasicInfo);
        return updatePlanResponse;
    }

    @DELETE
    @Path(value="/v1/{project_id}/plans/{plan_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="plan_delete_operationname", operationModule="recovery", level=4)
    public void deletePlan(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") @PathParam(value="plan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") String planId) {
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        this.getOperLogAttrMap().put("operationLogTarget", Optional.of(planService.getRecoverPlanById(planId)).map(RecoverPlan::getName).orElse(""));
        planService.deletePlan(projectId, planId);
    }

    @POST
    @Path(value="/v1/{project_id}/plans/{plan_id}/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="plan_execute_operationname", operationModule="recovery", level=4)
    public RecoverExecuteVo executePlan(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") @PathParam(value="plan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") String planId, @Valid @RequestBody ExecutePlanPara para) {
        RecoverExecuteBo executeBo = new RecoverExecuteBo();
        executeBo.setProjectId(projectId);
        executeBo.setPlanId(planId);
        executeBo.setRecoverPreplanId(para.getPreplanId());
        executeBo.setAction(para.getAction());
        RecoverExecuteVo recoverExecuteVo = new RecoverExecuteVo();
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        this.getOperLogAttrMap().put("operationLogTarget", Optional.of(planService.getRecoverPlanById(planId)).map(RecoverPlan::getName).orElse(""));
        String taskId = planService.executePlan(this.getRequestContext(), executeBo);
        recoverExecuteVo.setTaskId(taskId);
        return recoverExecuteVo;
    }

    private SitePlanBasicInfoVo generateSitePlanBasicInfo(SitePlan sitePlan, List<SiteInfo> siteInfoList, long count) {
        SitePlanBasicInfoVo sitePlanBasicInfoVo = new SitePlanBasicInfoVo();
        if (!VerifyUtil.isEmpty(siteInfoList)) {
            sitePlanBasicInfoVo.setSiteName(siteInfoList.get(0).getSiteName());
        }
        sitePlanBasicInfoVo.setSiteId(sitePlan.getSiteId());
        sitePlanBasicInfoVo.setSitePlanId(sitePlan.getId());
        sitePlanBasicInfoVo.setLastExecuteTime(sitePlan.getLastExecuteTime());
        sitePlanBasicInfoVo.setPlanCount(count);
        sitePlanBasicInfoVo.setStatus(sitePlan.getStatus());
        for (SiteInfo siteInfo : siteInfoList) {
            Region region = new Region();
            Az az = new Az();
            region.setRegionId(siteInfo.getRegionId());
            region.setRegionName(siteInfo.getRegionName());
            az.setAzId(siteInfo.getAzId());
            az.setAzName(siteInfo.getAzName());
            RegionAz regionAz = new RegionAz();
            regionAz.setAz(az);
            regionAz.setRegion(region);
            sitePlanBasicInfoVo.getRegionAZListVo().add(regionAz);
        }
        return sitePlanBasicInfoVo;
    }

    @GET
    @Path(value="/v1/{project_id}/siteplans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public SitePlanListVo querySitePlans(@NotNull @PathParam(value="project_id") String projectId) {
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        SitePlanQuery sitePlanQuery = new SitePlanQuery();
        sitePlanQuery.setProjectId(projectId);
        List sitePlanList = planService.querySitePlans(sitePlanQuery);
        SitePlanListVo sitePlanListVo = new SitePlanListVo();
        sitePlanListVo.setTotalCount(planService.getSitePlanCountByProjectId(projectId));
        if (sitePlanList.isEmpty()) {
            return sitePlanListVo;
        }
        ConfigService configService = CommonUtil.getCsrService(ConfigService.class);
        for (SitePlan sitePlan : sitePlanList) {
            List siteInfoList = configService.getSiteInfos(sitePlan.getSiteId());
            long count = planService.getRecoverPlanCountBySitePlanId(sitePlan.getId());
            SitePlanBasicInfoVo sitePlanBasicInfoVo = this.generateSitePlanBasicInfo(sitePlan, siteInfoList, count);
            sitePlanListVo.getSitePlanBasicInfoVoList().add(sitePlanBasicInfoVo);
        }
        return sitePlanListVo;
    }

    @GET
    @Path(value="/v1/{project_id}/siteplans/{site_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public SingleSitePlanVo querySitePlan(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="site_id format is incorrect") @PathParam(value="site_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="site_id format is incorrect") String siteId) {
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        SitePlan dbSitePlan = planService.querySitePlanBySiteId(projectId, siteId);
        if (VerifyUtil.isEmpty((Object)dbSitePlan)) {
            return new SingleSitePlanVo();
        }
        ConfigService configService = CommonUtil.getCsrService(ConfigService.class);
        List siteInfoList = configService.getSiteInfos(siteId);
        long count = planService.getRecoverPlanCountBySitePlanId(dbSitePlan.getId());
        SingleSitePlanVo sitePlanVo = new SingleSitePlanVo();
        sitePlanVo.setSitePlanVo(this.generateSitePlanBasicInfo(dbSitePlan, siteInfoList, count));
        return sitePlanVo;
    }

    private Map<String, Integer> convertPlanPriorityToMap(List<PlanPriorityPara> planPriorityParaList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (PlanPriorityPara para : planPriorityParaList) {
            map.put(para.getPlanId(), para.getPriority());
        }
        return map;
    }

    @POST
    @Path(value="/v1/{project_id}/siteplans/{siteplan_id}/plans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="site_add_plan_operationname", operationModule="site", level=3)
    public SitePlanBasicInfoVo addPlanToSite(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") @PathParam(value="siteplan_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") String sitePlanId, @Valid @RequestBody PlanPriorityListPara paraList) {
        Map<String, Integer> planPriorityMap = this.convertPlanPriorityToMap(paraList.getParaList());
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        SitePlan sitePlan = planService.querySitePlan(projectId, sitePlanId);
        this.getOperLogAttrMap().put("operationLogTarget", sitePlan.getSiteName());
        List siteInfoList = planService.addPlanToSite(projectId, sitePlanId, planPriorityMap);
        long count = planService.getRecoverPlanCountBySitePlanId(sitePlanId);
        return this.generateSitePlanBasicInfo(sitePlan, siteInfoList, count);
    }

    @DELETE
    @Path(value="/v1/{project_id}/siteplans/{siteplan_id}/plans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="site_delete_plan_operationname", operationModule="site", level=4)
    public SitePlanBasicInfoVo removePlanToSite(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") @PathParam(value="siteplan_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") String sitePlanId, @Valid @RequestBody PlanPriorityListPara paraList) {
        ArrayList<String> planList = new ArrayList<String>();
        for (PlanPriorityPara para : paraList.getParaList()) {
            planList.add(para.getPlanId());
        }
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        SitePlan sitePlan = planService.querySitePlan(projectId, sitePlanId);
        List siteInfoList = planService.removePlanToSite(projectId, sitePlanId, planList);
        long count = planService.getRecoverPlanCountBySitePlanId(sitePlanId);
        SitePlanBasicInfoVo sitePlanBasicInfoVo = this.generateSitePlanBasicInfo(sitePlan, siteInfoList, count);
        this.getOperLogAttrMap().put("operationLogTarget", sitePlan.getSiteName());
        return sitePlanBasicInfoVo;
    }

    @PUT
    @Path(value="/v1/{project_id}/siteplans/{siteplan_id}/plans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="site_modify_proprity_operationname", operationModule="site", level=3)
    public SitePlanBasicInfoVo modifyPlanPriority(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") @PathParam(value="siteplan_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") String sitePlanId, @Valid @RequestBody PlanPriorityListPara paraList) {
        Map<String, Integer> planPriorityMap = this.convertPlanPriorityToMap(paraList.getParaList());
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        SitePlan sitePlan = planService.querySitePlan(projectId, sitePlanId);
        this.getOperLogAttrMap().put("operationLogTarget", sitePlan.getSiteName());
        List siteInfoList = planService.modifyPlanPriority(projectId, sitePlanId, planPriorityMap);
        long count = planService.getRecoverPlanCountBySitePlanId(sitePlanId);
        return this.generateSitePlanBasicInfo(sitePlan, siteInfoList, count);
    }

    private RecoverPlanVo generateRecoverPlanVo(PlanService planService, String projectId, String sitePlanId, RecoverPlan recoverPlan) {
        RecoverPlanVo recoverPlanVo = new RecoverPlanVo();
        AppService appService = CommonUtil.getCsrService(AppService.class);
        ConfigService configService = CommonUtil.getCsrService(ConfigService.class);
        SitePlan sitePlan = planService.querySitePlan(projectId, sitePlanId);
        long appCount = appService.getAppCountByRecoverPlanAndSiteId(projectId, recoverPlan.getId(), sitePlan.getSiteId());
        long preplanCount = planService.getPreplanCountByRecoverPlanAndSiteId(recoverPlan.getId(), sitePlan.getSiteId());
        int priority = planService.queryRecoverPlanPriority(sitePlanId, recoverPlan.getId());
        recoverPlanVo.setId(recoverPlan.getId());
        recoverPlanVo.setName(recoverPlan.getName());
        recoverPlanVo.setApplicationCount(appCount);
        recoverPlanVo.setPrePlanCount(preplanCount);
        recoverPlanVo.setDisasterRecoveryPreplanCount(this.getPreplanCountByType(projectId, recoverPlan.getId(), sitePlan.getSiteId(), RecoverOperateType.DISASTER_RECOVERY.getValue()));
        recoverPlanVo.setReprotectPreplanCount(this.getPreplanCountByType(projectId, recoverPlan.getId(), sitePlan.getSiteId(), RecoverOperateType.REPROTECT.getValue()));
        recoverPlanVo.setSwitchbackPreplanCount(this.getPreplanCountByType(projectId, recoverPlan.getId(), sitePlan.getSiteId(), RecoverOperateType.SWITCHBACK.getValue()));
        recoverPlanVo.setPriority(priority);
        recoverPlanVo.setStatus(recoverPlan.getStatus());
        recoverPlanVo.setDescription(recoverPlan.getDescription());
        recoverPlanVo.setLastExecuteTime(recoverPlan.getLastExecuteTime());
        recoverPlanVo.setLastExecuteStr(recoverPlan.getLastExecuteStr());
        recoverPlanVo.setExpectedRTO(recoverPlan.getExpectedRTO());
        List siteInfoList = configService.getSiteInfosByRecoverPlanId(projectId, recoverPlan.getId());
        for (SiteInfo siteInfo : siteInfoList) {
            SiteName siteName = new SiteName();
            siteName.setId(siteInfo.getId());
            siteName.setName(siteInfo.getSiteName());
            recoverPlanVo.getSiteNameList().add(siteName);
        }
        return recoverPlanVo;
    }

    private long getPreplanCountByType(String projectId, String recoverPlanId, String siteId, String type) {
        RecoverPreplanQuery recoverPreplanQuery = new RecoverPreplanQuery();
        recoverPreplanQuery.setProjectId(projectId);
        recoverPreplanQuery.setPlanId(recoverPlanId);
        recoverPreplanQuery.setSiteId(siteId);
        recoverPreplanQuery.setPreplanType(type);
        return CommonUtil.getCsrService(RecoverPreplanService.class).queryPreplansCount(recoverPreplanQuery);
    }

    @GET
    @Path(value="/v1/{project_id}/siteplans/{siteplan_id}/plans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverPlanListVo<RecoverPlanVo> queryRecoverPlansFromSite(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") @PathParam(value="siteplan_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") String sitePlanId, @Valid @BeanParam QueryPlansFromSitePara para) {
        SitePlanMapQuery sitePlanMapQuery = new SitePlanMapQuery();
        sitePlanMapQuery.setLimit(para.getLimit());
        sitePlanMapQuery.setMarker(para.getMarker());
        sitePlanMapQuery.setPage(true);
        sitePlanMapQuery.setSitePlanId(sitePlanId);
        if (!VerifyUtil.isEmpty((String)para.getName())) {
            sitePlanMapQuery.setRecoverPlanName(para.getName());
        }
        if (!VerifyUtil.isEmpty((String)para.getStatus())) {
            sitePlanMapQuery.setRecoverPlanStatus(para.getStatus());
        }
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        Pair recoverPlanPair = planService.queryRecoverPlansFromSite(projectId, sitePlanMapQuery);
        RecoverPlanListVo<RecoverPlanVo> recoverPlanListVo = new RecoverPlanListVo<RecoverPlanVo>();
        recoverPlanListVo.setTotalCount(((Integer)recoverPlanPair.getRight()).intValue());
        for (RecoverPlan recoverPlan : (List)recoverPlanPair.getLeft()) {
            RecoverPlanVo recoverPlanVo = this.generateRecoverPlanVo(planService, projectId, sitePlanId, recoverPlan);
            recoverPlanListVo.getRecoverPlanList().add(recoverPlanVo);
        }
        return recoverPlanListVo;
    }

    private PlanVo convertRecoverPlan2PlanVo(String projectId, RecoverPlan recoverPlan) {
        PlanVo vo = new PlanVo();
        vo.setId(recoverPlan.getId());
        vo.setName(recoverPlan.getName());
        vo.setDecription(recoverPlan.getDescription());
        vo.setLastExecuteTime(recoverPlan.getLastExecuteTime());
        vo.setStatus(recoverPlan.getStatus());
        List applicationList = CommonUtil.getCsrService(AppService.class).getApplicationListByPlanId(projectId, recoverPlan.getId());
        vo.setApplicationCount(applicationList.size());
        List siteInfoList = CommonUtil.getCsrService(PlanService.class).getSiteOfAppByRecoverPlanId(projectId, recoverPlan.getId());
        HashMap siteInfoMap = new HashMap();
        siteInfoList.forEach(siteInfo -> {
            String siteId = siteInfo.getSiteId();
            RegionAz regionAz = new RegionAz();
            regionAz.setRegion(new Region(siteInfo.getRegionId(), siteInfo.getRegionName()));
            regionAz.setAz(new Az(siteInfo.getAzId(), siteInfo.getAzName()));
            if (siteInfoMap.containsKey(siteId)) {
                ((SiteInfoVo)siteInfoMap.get(siteId)).getRegionAzList().add(regionAz);
                return;
            }
            SiteInfoVo siteInfoVo = new SiteInfoVo();
            siteInfoVo.setSiteId(siteId);
            siteInfoVo.setSiteName(siteInfo.getSiteName());
            siteInfoVo.setRegionAzList(new ArrayList<RegionAz>());
            siteInfoVo.getRegionAzList().add(regionAz);
            siteInfoMap.put(siteId, siteInfoVo);
        });
        vo.setSiteInfos(new ArrayList<SiteInfoVo>(siteInfoMap.values()));
        vo.setExpectedRTO(recoverPlan.getExpectedRTO());
        vo.setPrePlanCount(CommonUtil.getCsrService(PlanService.class).getPreplanCountByRecoverPlan(recoverPlan.getId()));
        vo.setLastExecuteStr(recoverPlan.getLastExecuteStr());
        vo.setApplicationIds(applicationList.stream().map(AbstractEntity::getId).collect(Collectors.toList()));
        vo.setSourceToTargetSiteIdMap(CommonUtil.getCsrService(PlanService.class).getSourceToTargetSiteInfoMap(projectId, recoverPlan.getId()));
        return vo;
    }

    @PUT
    @Path(value="/v1/{project_id}/plans/{plan_id}/applications")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="plan_add_remove_app_operationname", operationModule="recovery", level=3)
    public PlanVoResponse addAppToPlan(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") @PathParam(value="plan_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") String planId, @Valid @NotNull AddAppToPlanPara addAppToPlanPara) {
        OperateType operateType = addAppToPlanPara.getOperateType();
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        this.getOperLogAttrMap().put("operationLogTarget", planService.queryPlan(projectId, planId, null).getName());
        if (OperateType.ADD.equals((Object)operateType)) {
            planService.addAppToPlan(projectId, planId, addAppToPlanPara.getApplications());
        }
        if (OperateType.REMOVE.equals((Object)operateType)) {
            planService.removeAppFromPlan(projectId, planId, addAppToPlanPara.getApplications());
        }
        PlanVoResponse response = new PlanVoResponse();
        response.setPlan(this.convertRecoverPlan2PlanVo(projectId, planService.queryPlan(projectId, planId, null)));
        return response;
    }

    @GET
    @Path(value="/v1/{project_id}/siteplans/logs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverLogListVo queryRecoverSitePlansHistoryLogs(@NotNull @PathParam(value="project_id") String projectId, @Min(value=1L, message="limit out of range") @Max(value=512L, message="limit out of range") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=1L, message="limit out of range") @Max(value=512L, message="limit out of range") int limit, @Min(value=0L, message="marker out of range") @DefaultValue(value="0") @QueryParam(value="marker") @Min(value=0L, message="marker out of range") int marker, @Valid @BeanParam RecoverLogSitePlanPara recoverLogSitePlanPara) {
        RecoverLogQuery recoverLogQuery = RecoverLogUtils.getSitePlanLogRecoverLogQuery(projectId, limit, marker, recoverLogSitePlanPara);
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        List logSiteList = planService.getRecoverLogList(recoverLogQuery);
        RecoverLogListVo recoverLogListVo = new RecoverLogListVo();
        recoverLogQuery.setPage(false);
        recoverLogListVo.setTotalCount(planService.getRecoverLogCount(recoverLogQuery));
        for (RecoverLog logSite : logSiteList) {
            RecoverLogVo recoverLogVo = RecoverLogUtils.getRecoverLogVoCommon(logSite);
            Optional<SitePlan> sitePlanOptional = RecoverLogUtils.getSitePlanDetail(projectId, logSite.getResourceId());
            String siteId = null;
            if (sitePlanOptional.isPresent()) {
                recoverLogVo.setResourceName(sitePlanOptional.get().getSiteName());
                siteId = sitePlanOptional.get().getSiteId();
            }
            List<RecoverLogVo> logVoPlanList = RecoverLogUtils.getPlanLogInfo(logSite, "prePlanLevel", siteId);
            recoverLogVo.setLogStatistics(RecoverLogUtils.getChildLogStatistics(logVoPlanList));
            recoverLogVo.setRecoverLogVoList(logVoPlanList);
            recoverLogListVo.getLogs().add(recoverLogVo);
        }
        return recoverLogListVo;
    }

    @GET
    @Path(value="/v1/{project_id}/plans/logs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverLogListVo queryRecoverPlansHistoryLogs(@NotNull @PathParam(value="project_id") String projectId, @Min(value=1L, message="limit out of range") @Max(value=512L, message="limit out of range") @DefaultValue(value="512") @QueryParam(value="limit") @Min(value=1L, message="limit out of range") @Max(value=512L, message="limit out of range") int limit, @Min(value=0L, message="marker out of range") @DefaultValue(value="0") @QueryParam(value="marker") @Min(value=0L, message="marker out of range") int marker, @Valid @BeanParam RecoverLogPlanPara recoverLogPlanPara) {
        RecoverLogQuery recoverLogQuery = RecoverLogUtils.getPlanLogRecoverLogQuery(projectId, limit, marker, recoverLogPlanPara);
        RecoverLogListVo recoverLogListVo = new RecoverLogListVo();
        if (!(VerifyUtil.isEmpty((String)recoverLogPlanPara.getSiteId()) && VerifyUtil.isEmpty((String)recoverLogPlanPara.getPreplanName()) || !CollectionUtils.isEmpty((Collection)recoverLogQuery.getIds()))) {
            recoverLogListVo.setTotalCount(0L);
            return recoverLogListVo;
        }
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        List logPlanList = planService.getRecoverLogList(recoverLogQuery);
        if (logPlanList.size() == 0) {
            recoverLogListVo.setTotalCount(0L);
            return recoverLogListVo;
        }
        recoverLogListVo.setTotalCount(planService.getRecoverLogCount(recoverLogQuery));
        for (RecoverLog logPlan : logPlanList) {
            String siteId = RecoverLogUtils.getSiteId(projectId, logPlan).orElse(null);
            List<RecoverLogVo> logVoPrePlanList = RecoverLogUtils.getPrePlanLogInfo(logPlan, "stageLevel", siteId);
            RecoverLogVo recoverLogVo = RecoverLogUtils.getRecoverLogVoCommon(logPlan);
            Optional<RecoverPlan> recoverPlanOptional = RecoverLogUtils.getPlanDetail(projectId, logPlan.getResourceId());
            recoverPlanOptional.ifPresent(recoverPlan -> recoverLogVo.setResourceName(recoverPlan.getName()));
            recoverLogVo.setRecoverLogVoList(logVoPrePlanList);
            if (CollectionUtils.isNotEmpty(logVoPrePlanList)) {
                List<SiteInfoVo> targetSiteInfoVos = RecoverLogUtils.getTargetSiteInfoVos(projectId, logPlan, logVoPrePlanList.get(0).getSiteInfos());
                recoverLogVo.setSiteInfos(targetSiteInfoVos);
            }
            recoverLogListVo.getLogs().add(recoverLogVo);
        }
        return recoverLogListVo;
    }

    @GET
    @Path(value="/v1/{project_id}/siteplans/{siteplan_id}/logs/{log_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverLogDetailVo queryRecoverSiteHistoryLogDetail(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") @PathParam(value="siteplan_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id format is incorrect") String sitePlanId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="log_id format is incorrect") @PathParam(value="log_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="log_id format is incorrect") String logId) {
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        RecoverLogQuery logSiteQuery = new RecoverLogQuery();
        logSiteQuery.setProjectId(projectId);
        logSiteQuery.setIds(Collections.singletonList(logId));
        RecoverLog logSite = (RecoverLog)planService.getRecoverLogList(logSiteQuery).get(0);
        RecoverLogVo logVoSite = RecoverLogUtils.getRecoverLogVoCommon(logSite);
        Optional<SitePlan> sitePlanOptional = RecoverLogUtils.getSitePlanDetail(projectId, sitePlanId);
        String siteId = null;
        if (sitePlanOptional.isPresent()) {
            logVoSite.setResourceName(sitePlanOptional.get().getSiteName());
            siteId = sitePlanOptional.get().getSiteId();
        }
        List<RecoverLogVo> logVoPlanList = RecoverLogUtils.getPlanLogInfo(logSite, "stepLevel", siteId);
        logVoSite.setLogStatistics(RecoverLogUtils.getChildLogStatistics(logVoPlanList));
        logVoSite.setRecoverLogVoList(logVoPlanList);
        RecoverLogDetailVo result = new RecoverLogDetailVo();
        result.setRecoverLogVo(logVoSite);
        return result;
    }

    @GET
    @Path(value="/v1/{project_id}/plans/{plan_id}/logs/{log_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverLogDetailVo queryRecoverPlanHistoryLogDetail(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") @PathParam(value="plan_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id is incorrect") String planId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="log_id is incorrect") @PathParam(value="log_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="log_id is incorrect") String logId) {
        PlanService planService = CommonUtil.getCsrService(PlanService.class);
        RecoverLogQuery logPlanQuery = new RecoverLogQuery();
        logPlanQuery.setProjectId(projectId);
        logPlanQuery.setIds(Collections.singletonList(logId));
        RecoverLog logPlan = (RecoverLog)planService.getRecoverLogList(logPlanQuery).get(0);
        RecoverLogVo logVoPlan = RecoverLogUtils.getRecoverLogVoCommon(logPlan);
        Optional<RecoverPlan> recoverPlanOptional = RecoverLogUtils.getPlanDetail(projectId, logPlan.getResourceId());
        recoverPlanOptional.ifPresent(recoverPlan -> logVoPlan.setResourceName(recoverPlan.getName()));
        String siteId = RecoverLogUtils.getSiteId(projectId, logPlan).orElse(null);
        List<RecoverLogVo> logVoPrePlanList = RecoverLogUtils.getPrePlanLogInfo(logPlan, "stepLevel", siteId);
        if (CollectionUtils.isNotEmpty(logVoPrePlanList)) {
            logVoPlan.setRecoverLogVoList(logVoPrePlanList);
            List<SiteInfoVo> siteInfoVoList = RecoverLogUtils.getTargetSiteInfoVos(projectId, logPlan, logVoPrePlanList.get(0).getSiteInfos());
            logVoPlan.setSiteInfos(siteInfoVoList);
        }
        RecoverLogDetailVo result = new RecoverLogDetailVo();
        result.setRecoverLogVo(logVoPlan);
        return result;
    }

    @POST
    @Path(value="/v1/{project_id}/siteplans/{siteplan_id}/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="siteplan_execute_operationname", operationModule="recovery", level=4)
    public RecoverExecuteVo executeSitePlan(@NotNull @PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id is incorrect") @NotNull @PathParam(value="siteplan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="siteplan_id is incorrect") @NotNull String sitePlanId, @Valid @RequestBody SitePlanExecutePara param) {
        SitePlanExecuteBo executeBo = new SitePlanExecuteBo();
        executeBo.setProjectId(projectId);
        executeBo.setSitePlanId(sitePlanId);
        executeBo.setOperationType(param.getOperationType());
        executeBo.setAction(param.getAction());
        executeBo.setContinuePlanId(param.getContinuePlanId());
        RecoverExecuteVo recoverExecuteVo = new RecoverExecuteVo();
        String siteName = CommonUtil.getCsrService(PlanService.class).querySitePlan(projectId, sitePlanId).getSiteName();
        this.getOperLogAttrMap().put("operationLogTarget", siteName);
        String taskId = CommonUtil.getCsrService(PlanService.class).executeSitePlan(this.getRequestContext(), executeBo);
        recoverExecuteVo.setTaskId(taskId);
        return recoverExecuteVo;
    }
}

