/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.controller;

import com.huawei.csr.framework.common.model.RecoverFlowBo;
import com.huawei.csr.framework.common.model.RecoverFlowQuery;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.RecoverStageService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.AppHelper;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.CreateRecoverFlowPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.FlowNotInPreplanQueryPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.FlowPreplanInfo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.NotFlowInstanceListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.NotFlowInstanceQueryPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.RecoverFlowQueryPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.RecoverFlowVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.RecoverFlowsListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.SingleRecoverFlowVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.UpdateRecoverFlowPara;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.RequestBody;

public class RecoverFlowController
extends BaseController {
    @POST
    @Path(value="/v1/{project_id}/flows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="flow_create_operationname", operationModule="recovery", level=3)
    public RecoverFlowVo createRecoverFlow(@PathParam(value="project_id") String projectId, @Valid @RequestBody CreateRecoverFlowPara createRecoverFlowPara) {
        RecoverFlow flow = new RecoverFlow();
        flow.setProjectId(projectId);
        flow.setName(createRecoverFlowPara.getName());
        flow.setAppId(createRecoverFlowPara.getApplicationId());
        flow.setType(createRecoverFlowPara.getOperationType().getValue());
        this.getOperLogAttrMap().put("operationLogTarget", flow.getName());
        String flowId = CommonUtil.getCsrService(RecoverFlowService.class).createFlow(createRecoverFlowPara.isGenerateStep(), flow);
        if (!VerifyUtil.isEmpty((String)createRecoverFlowPara.getStageId())) {
            CommonUtil.getCsrService(RecoverStageService.class).addFlowToStage(createRecoverFlowPara.getStageId(), flowId);
        }
        RecoverFlowVo recoverFlowVo = new RecoverFlowVo();
        recoverFlowVo.setId(flowId);
        return recoverFlowVo;
    }

    @PUT
    @Path(value="/v1/{project_id}/flows/{flow_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="flow_update_operationname", operationModule="recovery", level=3)
    public RecoverFlowVo updateRecoverFlow(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") @PathParam(value="flow_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") String flowId, @Valid @RequestBody UpdateRecoverFlowPara updateRecoverFlowPara) {
        RecoverFlowBo flowBo = new RecoverFlowBo();
        flowBo.setProjectId(projectId);
        flowBo.setFlowId(flowId);
        flowBo.setFlowName(updateRecoverFlowPara.getName());
        flowBo.setAppId(updateRecoverFlowPara.getApplicationId());
        flowBo.setGenerateStep(updateRecoverFlowPara.getGenerateStep());
        if (!VerifyUtil.isEmpty((Object)updateRecoverFlowPara.getOperationType())) {
            flowBo.setOperationType(updateRecoverFlowPara.getOperationType().getValue());
        }
        RecoverFlowService flowService = CommonUtil.getCsrService(RecoverFlowService.class);
        this.getOperLogAttrMap().put("operationLogTarget", flowBo.getFlowName());
        flowService.updateFlow(flowBo);
        RecoverFlow recoverFlow = flowService.getRecoverFlowById(flowId);
        return this.generateFlowInfo(recoverFlow);
    }

    @DELETE
    @Path(value="/v1/{project_id}/flows/{flow_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="flow_delete_operationname", operationModule="recovery", level=4)
    public Response deleteRecoverFlow(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") @PathParam(value="flow_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") String flowId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="preplan_id format is incorrect") @QueryParam(value="preplan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="preplan_id format is incorrect") String preplanId) {
        RecoverFlowService flowService = CommonUtil.getCsrService(RecoverFlowService.class);
        this.getOperLogAttrMap().put("operationLogTarget", Optional.of(flowService.getRecoverFlowById(flowId)).map(RecoverFlow::getName).orElse(""));
        flowService.deleteFlow(projectId, flowId, preplanId);
        return Response.ok().build();
    }

    @GET
    @Path(value="/v1/{project_id}/flows/{flow_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public SingleRecoverFlowVo getRecoverFlow(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") @PathParam(value="flow_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") String flowId) {
        RecoverFlow recoverFlow = CommonUtil.getCsrService(RecoverFlowService.class).getRecoverFlowById(flowId);
        SingleRecoverFlowVo flowVo = new SingleRecoverFlowVo();
        flowVo.setRecoverFlowVo(this.generateFlowInfo(recoverFlow));
        return flowVo;
    }

    @GET
    @Path(value="/v1/{project_id}/flows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverFlowsListVo getFlowsList(@PathParam(value="project_id") String projectId, @Valid @BeanParam RecoverFlowQueryPara queryPara) {
        RecoverFlowQuery recoverFlowQuery = new RecoverFlowQuery();
        recoverFlowQuery.setProjectId(projectId);
        recoverFlowQuery.setLimit(queryPara.getLimit());
        recoverFlowQuery.setMarker(queryPara.getMarker());
        recoverFlowQuery.setPage(true);
        recoverFlowQuery.setAppName(queryPara.getApplicationName());
        recoverFlowQuery.setFlowName(queryPara.getFlowName());
        recoverFlowQuery.setFlowPrePlanName(queryPara.getPreplanName());
        recoverFlowQuery.setStatus(queryPara.getStatus());
        recoverFlowQuery.setType(queryPara.getOperationType());
        RecoverFlowService flowService = CommonUtil.getCsrService(RecoverFlowService.class);
        List recoverFlowList = flowService.queryRecoverFlowList(recoverFlowQuery);
        ArrayList<RecoverFlowVo> recoverFlowVoList = new ArrayList<RecoverFlowVo>();
        for (RecoverFlow recoverFlow : recoverFlowList) {
            recoverFlowVoList.add(this.generateFlowInfo(recoverFlow));
        }
        long flowInfoCount = flowService.queryRecoverFlowCount(recoverFlowQuery);
        RecoverFlowsListVo flowsListResponse = new RecoverFlowsListVo();
        flowsListResponse.setFlows(recoverFlowVoList);
        flowsListResponse.setTotalCount(flowInfoCount);
        return flowsListResponse;
    }

    @GET
    @Path(value="/v1/{project_id}/flows/{flow_id}/resources")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public NotFlowInstanceListVo queryNotFlowInstances(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") @PathParam(value="flow_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") String flowId, @Valid @BeanParam NotFlowInstanceQueryPara instancePara) {
        ServiceInstanceQuery instanceQuery = new ServiceInstanceQuery();
        instanceQuery.setProjectId(projectId);
        instanceQuery.setFlowId(flowId);
        instanceQuery.setInstanceStatus(instancePara.getStatus());
        instanceQuery.setInstanceId(instancePara.getInstanceId());
        instanceQuery.setInstanceName(instancePara.getInstanceName());
        instanceQuery.setServiceType(instancePara.getServiceType());
        List instanceList = CommonUtil.getCsrService(AppService.class).queryNotInFlowInstanceList(instanceQuery);
        NotFlowInstanceListVo notFlowInstanceListVo = new NotFlowInstanceListVo();
        notFlowInstanceListVo.setUnprotectedInstanceVoList(AppHelper.convert2unprotectedInstances(instanceList));
        return notFlowInstanceListVo;
    }

    @GET
    @Path(value="/v1/{project_id}/flows/not-inpreplan")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverFlowsListVo queryFlowNotInPrePlan(@PathParam(value="project_id") String projectId, @Valid @BeanParam FlowNotInPreplanQueryPara queryPara) {
        RecoverFlowQuery recoverFlowQuery = new RecoverFlowQuery();
        recoverFlowQuery.setProjectId(projectId);
        recoverFlowQuery.setLimit(queryPara.getLimit());
        recoverFlowQuery.setMarker(queryPara.getMarker());
        recoverFlowQuery.setPage(true);
        recoverFlowQuery.setStatus(queryPara.getStatus());
        recoverFlowQuery.setPrePlanId(queryPara.getPreplanId());
        recoverFlowQuery.setFlowName(queryPara.getFlowName());
        recoverFlowQuery.setAppName(queryPara.getApplicationName());
        RecoverFlowService flowService = CommonUtil.getCsrService(RecoverFlowService.class);
        Pair recoverFlowPair = flowService.queryRecoverFlowListNotInPreplan(recoverFlowQuery);
        RecoverFlowsListVo flowsListVo = new RecoverFlowsListVo();
        flowsListVo.setTotalCount((Long)recoverFlowPair.getRight());
        ((List)recoverFlowPair.getLeft()).forEach(recoverFlow -> flowsListVo.getFlows().add(this.generateFlowInfo((RecoverFlow)recoverFlow)));
        return flowsListVo;
    }

    private RecoverFlowVo generateFlowInfo(RecoverFlow recoverFlow) {
        RecoverFlowService flowService = CommonUtil.getCsrService(RecoverFlowService.class);
        RecoverFlowVo recoverFlowVo = new RecoverFlowVo();
        recoverFlowVo.setId(recoverFlow.getId());
        recoverFlowVo.setName(recoverFlow.getName());
        recoverFlowVo.setStatus(recoverFlow.getStatus());
        recoverFlowVo.setPreFlowId(flowService.queryPreFlowIdList(null, recoverFlow.getId()));
        recoverFlowVo.setApplicationId(recoverFlow.getAppId());
        recoverFlowVo.setApplicationName(CommonUtil.getCsrService(AppService.class).getApplicationById(recoverFlow.getAppId()).getName());
        recoverFlowVo.setAverageExecuteDuration(recoverFlow.getAverageExecuteDuration());
        recoverFlowVo.setLastExecuteDuration(recoverFlow.getLastExecuteDuration());
        if (!VerifyUtil.isEmpty((Object)recoverFlow.getLastExecuteTime())) {
            recoverFlowVo.setLastExecuteTime(String.valueOf(recoverFlow.getLastExecuteTime()));
        }
        recoverFlowVo.setFlowType(recoverFlow.getType());
        recoverFlowVo.setOperationType(recoverFlow.getType());
        List stageIdList = flowService.queryStageIdListByFlowId(recoverFlow.getProjectId(), recoverFlow.getId());
        recoverFlowVo.setStageId(stageIdList);
        RecoverPreplanService preplanService = CommonUtil.getCsrService(RecoverPreplanService.class);
        stageIdList.forEach(stageId -> {
            RecoverPreplan preplan = preplanService.queryPreplanByStageId(stageId);
            recoverFlowVo.getFlowPreplanInfos().add(new FlowPreplanInfo(preplan.getId(), preplan.getName(), preplan.getStatus()));
        });
        ServiceInstanceQuery instanceQuery = new ServiceInstanceQuery();
        instanceQuery.setProjectId(recoverFlow.getProjectId());
        instanceQuery.setFlowId(recoverFlow.getId());
        recoverFlowVo.setInstancesNumNotInFlow(CommonUtil.getCsrService(AppService.class).queryNotInFlowInstanceList(instanceQuery).size());
        return recoverFlowVo;
    }
}

