/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.controller;

import com.huawei.csr.framework.common.model.ApplicationBo;
import com.huawei.csr.framework.common.model.ApplicationQuery;
import com.huawei.csr.framework.common.model.RecoverPreplanBo;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.AppHelper;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.app.AppVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.preplan.CreatePreplanPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.preplan.PreplanListResponse;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.preplan.PreplanQueryPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.preplan.PreplanVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.preplan.PreplanVoResponse;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.preplan.UnprotectedAppAndInstancePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.preplan.UnprotectedAppListResponse;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.preplan.UnprotectedAppVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.preplan.UpdatePreplanPara;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.web.bind.annotation.RequestBody;

public class RecoverPreplanController
extends BaseController {
    @POST
    @Path(value="/v1/{project_id}/plans/{plan_id}/preplans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="preplan_create_operationname", operationModule="recovery", level=3)
    public PreplanVo createPreplan(@PathParam(value="project_id") String projectId, @PathParam(value="plan_id") String planId, @Valid @RequestBody CreatePreplanPara createPreplanPara) {
        RecoverPreplan recoverPreplan = new RecoverPreplan();
        recoverPreplan.setProjectId(projectId);
        recoverPreplan.setRecoverPlanId(planId);
        recoverPreplan.setName(createPreplanPara.getName());
        recoverPreplan.setDescription(createPreplanPara.getDescription());
        recoverPreplan.setSiteId(createPreplanPara.getSiteId());
        recoverPreplan.setType(createPreplanPara.getOperateType().getValue());
        if (!VerifyUtil.isEmpty((Object)createPreplanPara.getExpectRTO())) {
            recoverPreplan.setExpectRTO(createPreplanPara.getExpectRTO().longValue());
        }
        String preplanId = CommonUtil.getCsrService(RecoverPreplanService.class).createPreplan(createPreplanPara.getDefaultProcess().booleanValue(), recoverPreplan);
        PreplanVo preplanVo = new PreplanVo();
        preplanVo.setPreplanId(preplanId);
        this.getOperLogAttrMap().put("operationLogTarget", recoverPreplan.getName());
        return preplanVo;
    }

    @PUT
    @Path(value="/v1/{project_id}/plans/{plan_id}/preplans/{preplan_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="preplan_modify_operationname", operationModule="recovery", level=3)
    public PreplanVoResponse modifyPreplanInfo(@PathParam(value="project_id") String projectId, @PathParam(value="plan_id") String planId, @PathParam(value="preplan_id") String preplanId, @Valid @RequestBody UpdatePreplanPara updatePreplanPara) {
        RecoverPreplanBo recoverPreplanBo = new RecoverPreplanBo();
        recoverPreplanBo.setRecoverPreplanId(preplanId);
        recoverPreplanBo.setProjectId(projectId);
        recoverPreplanBo.setPlanId(planId);
        recoverPreplanBo.setName(updatePreplanPara.getName());
        recoverPreplanBo.setDescription(updatePreplanPara.getDescription());
        recoverPreplanBo.setGenerateDefaultProcess(updatePreplanPara.getDefaultProcess());
        if (!VerifyUtil.isEmpty((Object)updatePreplanPara.getExpectRTO())) {
            recoverPreplanBo.setExpectRTO(updatePreplanPara.getExpectRTO().longValue());
        }
        RecoverPreplanService recoverPreplanService = CommonUtil.getCsrService(RecoverPreplanService.class);
        recoverPreplanService.updatePreplan(recoverPreplanBo);
        PreplanVoResponse preplanInfoResponse = new PreplanVoResponse();
        preplanInfoResponse.setPreplan(this.buildPreplanBasicInfo(recoverPreplanService.queryPreplanById(preplanId)));
        this.getOperLogAttrMap().put("operationLogTarget", preplanInfoResponse.getPreplan().getName());
        return preplanInfoResponse;
    }

    @DELETE
    @Path(value="/v1/{project_id}/preplans/{preplan_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="preplan_delete_operationname", operationModule="recovery", level=4)
    public Response deletePreplan(@PathParam(value="project_id") String projectId, @PathParam(value="preplan_id") String preplanId) {
        RecoverPreplanService preplanService = CommonUtil.getCsrService(RecoverPreplanService.class);
        RecoverPreplan recoverPreplan = preplanService.queryPreplanById(preplanId);
        preplanService.deletePreplan(projectId, preplanId);
        this.getOperLogAttrMap().put("operationLogTarget", recoverPreplan.getName());
        return Response.ok().build();
    }

    @GET
    @Path(value="/v1/{project_id}/plans/{plan_id}/preplans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public PreplanListResponse queryPreplans(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id format is incorrect") @PathParam(value="plan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id format is incorrect") String planId, @Valid @BeanParam PreplanQueryPara queryPara) {
        RecoverPreplanQuery recoverPreplanQuery = new RecoverPreplanQuery();
        recoverPreplanQuery.setProjectId(projectId);
        recoverPreplanQuery.setPlanId(planId);
        recoverPreplanQuery.setLimit(queryPara.getLimit());
        recoverPreplanQuery.setMarker(queryPara.getMarker());
        recoverPreplanQuery.setStatus(queryPara.getStatus());
        recoverPreplanQuery.setSiteName(queryPara.getSiteName());
        RecoverPreplanService recoverPreplanService = CommonUtil.getCsrService(RecoverPreplanService.class);
        List recoverPreplanList = recoverPreplanService.queryPreplans(recoverPreplanQuery);
        PreplanListResponse queryPreplansVo = new PreplanListResponse();
        if (recoverPreplanList.size() == 0) {
            queryPreplansVo.setTotalCount(0);
            return queryPreplansVo;
        }
        queryPreplansVo.setTotalCount(recoverPreplanService.queryPreplansCount(recoverPreplanQuery));
        recoverPreplanList.forEach(preplan -> queryPreplansVo.getPreplanBasicInfos().add(this.buildPreplanBasicInfo((RecoverPreplan)preplan)));
        return queryPreplansVo;
    }

    @GET
    @Path(value="/v1/{project_id}/preplans/{preplan_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public PreplanVoResponse getPreplan(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="preplan_id format is incorrect") @PathParam(value="preplan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="preplan_id format is incorrect") String preplanId) {
        RecoverPreplan recoverPreplan = CommonUtil.getCsrService(RecoverPreplanService.class).queryPreplanById(preplanId);
        PreplanVoResponse preplanInfoResponse = new PreplanVoResponse();
        preplanInfoResponse.setPreplan(this.buildPreplanBasicInfo(recoverPreplan));
        return preplanInfoResponse;
    }

    @GET
    @Path(value="/v1/{project_id}/plans/{plan_id}/preplans/{preplan_id}/resources")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public UnprotectedAppListResponse queryNotPreplanAppAndInstances(@PathParam(value="project_id") String projectId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id format is incorrect") @PathParam(value="plan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="plan_id format is incorrect") String planId, @Pattern(regexp="^[0-9a-fA-F]{32}$", message="preplan_id format is incorrect") @PathParam(value="preplan_id") @Pattern(regexp="^[0-9a-fA-F]{32}$", message="preplan_id format is incorrect") String preplanId, @Valid @BeanParam UnprotectedAppAndInstancePara unprotectedPara) {
        ApplicationQuery appQuery = this.setApplicationQuery(projectId, planId, preplanId, unprotectedPara);
        AppService appService = CommonUtil.getCsrService(AppService.class);
        List appResult = appService.queryNotInPreplanApplicationList(appQuery);
        RecoverPreplanService preplanService = CommonUtil.getCsrService(RecoverPreplanService.class);
        RecoverPreplan preplan = preplanService.queryPreplanById(preplanId);
        UnprotectedAppListResponse unprotectedRes = new UnprotectedAppListResponse();
        for (ApplicationBo appBo : appResult) {
            List instanceList = appService.queryNotInPreplanInstanceList(appBo.getApplicationId(), preplanId, preplan.getSiteId());
            if (instanceList.size() == 0) continue;
            UnprotectedAppVo vo = new UnprotectedAppVo();
            vo.setNotInpreplanInstances(AppHelper.convert2unprotectedInstances(instanceList));
            vo.setInstanceNotinpreplanCount(instanceList.size());
            AppVo appVo = AppHelper.generateAppVo(appBo);
            vo.setId(appVo.getId());
            vo.setName(appVo.getName());
            vo.setDescription(appVo.getDescription());
            vo.setCreateTime(appVo.getCreateTime());
            vo.setStatus(appVo.getStatus());
            vo.setInstanceCount(appVo.getInstanceCount());
            vo.setSiteInfo(appVo.getSiteInfo());
            vo.setPlanId(appVo.getPlanId());
            vo.setPlanName(appVo.getPlanName());
            if (appQuery.getBelongPreplan() != null) {
                vo.setApplicationInpreplan(appQuery.getBelongPreplan());
            } else {
                RecoverPreplanBo preplanBo = new RecoverPreplanBo();
                preplanBo.setRecoverPreplanId(preplanId);
                preplanBo.setApplicationId(appBo.getApplicationId());
                vo.setApplicationInpreplan(preplanService.isApplicationProtectedByPreplan(preplanBo));
            }
            unprotectedRes.getNotInPrePlanApps().add(vo);
        }
        return unprotectedRes;
    }

    private ApplicationQuery setApplicationQuery(String projectId, String planId, String preplanId, UnprotectedAppAndInstancePara unprotectedPara) {
        ApplicationQuery appQuery = new ApplicationQuery();
        appQuery.setProjectId(projectId);
        appQuery.setPlanId(planId);
        appQuery.setPrePlanId(preplanId);
        appQuery.setStatus(unprotectedPara.getStatus());
        appQuery.setName(unprotectedPara.getApplicationName());
        appQuery.setBelongPreplan(unprotectedPara.getAppInpreplan());
        return appQuery;
    }

    private PreplanVo buildPreplanBasicInfo(RecoverPreplan recoverPreplan) {
        PreplanVo preplanBasicInfo = new PreplanVo();
        preplanBasicInfo.setPreplanId(recoverPreplan.getId());
        preplanBasicInfo.setName(recoverPreplan.getName());
        preplanBasicInfo.setDescription(recoverPreplan.getDescription());
        preplanBasicInfo.setStatus(recoverPreplan.getStatus());
        if (!VerifyUtil.isEmpty((Object)recoverPreplan.getLastExecuteTime())) {
            preplanBasicInfo.setLastExecuteTime(String.valueOf(recoverPreplan.getLastExecuteTime()));
        }
        preplanBasicInfo.setAverageExecuteDuration(recoverPreplan.getAverageExecuteDuration());
        preplanBasicInfo.setLastExecuteDuration(recoverPreplan.getLastExecuteDuration());
        preplanBasicInfo.setOperateType(recoverPreplan.getType());
        preplanBasicInfo.setAvailableFlag(recoverPreplan.getIsValid());
        preplanBasicInfo.setExpectedRTO(String.valueOf(recoverPreplan.getExpectRTO()));
        preplanBasicInfo.setSiteId(recoverPreplan.getSiteId());
        preplanBasicInfo.setPlanId(recoverPreplan.getRecoverPlanId());
        ApplicationQuery appQuery = new ApplicationQuery();
        appQuery.setProjectId(recoverPreplan.getProjectId());
        appQuery.setPlanId(recoverPreplan.getRecoverPlanId());
        appQuery.setPrePlanId(recoverPreplan.getId());
        AppService appService = CommonUtil.getCsrService(AppService.class);
        RecoverPreplanService preplanService = CommonUtil.getCsrService(RecoverPreplanService.class);
        List appResult = appService.queryNotInPreplanApplicationList(appQuery);
        int instanceCount = 0;
        int appCount = 0;
        for (ApplicationBo appBo : appResult) {
            int unprotectInstanceSize = appService.queryNotInPreplanInstanceList(appBo.getApplicationId(), recoverPreplan.getId(), recoverPreplan.getSiteId()).size();
            instanceCount += unprotectInstanceSize;
            RecoverPreplanBo preplanBo = new RecoverPreplanBo();
            preplanBo.setRecoverPreplanId(recoverPreplan.getId());
            preplanBo.setApplicationId(appBo.getApplicationId());
            if (unprotectInstanceSize <= 0 || preplanService.isApplicationProtectedByPreplan(preplanBo)) continue;
            ++appCount;
        }
        preplanBasicInfo.setNotInpreplanAppCount(appCount);
        preplanBasicInfo.setNotInpreplanInstancesCount(instanceCount);
        return preplanBasicInfo;
    }
}

