/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.controller;

import com.huawei.csr.framework.common.model.RecoverFlowQuery;
import com.huawei.csr.framework.common.model.RecoverStageBo;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverStageService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverflow.BasicFlowVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstage.AddRecoverFlowToStagePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstage.CreateRecoverStagePara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstage.RecoverStageListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstage.RecoverStageVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstage.StageFlowDependPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstage.UpdateRecoverStagePara;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.web.bind.annotation.RequestBody;

public class RecoverStageController
extends BaseController {
    @POST
    @Path(value="/v1/{project_id}/preplans/{preplan_id}/stages")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="stage_create_operationname", operationModule="recovery", level=3)
    public RecoverStageVo createPreplanstage(@PathParam(value="project_id") String projectId, @PathParam(value="preplan_id") String prePlanId, @Valid @RequestBody CreateRecoverStagePara createStagePara) {
        this.getOperLogAttrMap().put("operationLogTarget", createStagePara.getStageName());
        RecoverStageBo recoverStage = new RecoverStageBo();
        String stageName = createStagePara.getStageName();
        String stageType = createStagePara.getStageType().getValue();
        recoverStage.setStageName(stageName);
        recoverStage.setStageType(stageType);
        recoverStage.setPreStageId(createStagePara.getPreStageId());
        recoverStage.setPrePlanId(prePlanId);
        recoverStage.setProjectId(projectId);
        String stageId = CommonUtil.getCsrService(RecoverStageService.class).createStage(recoverStage);
        RecoverStageVo recoverStageVo = new RecoverStageVo();
        recoverStageVo.setStageId(stageId);
        recoverStageVo.setStageName(stageName);
        recoverStageVo.setStageType(stageType);
        return recoverStageVo;
    }

    @PUT
    @Path(value="/v1/{project_id}/preplans/{preplan_id}/stages/{stage_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="stage_update_operationname", operationModule="recovery", level=3)
    public RecoverStageVo modifyPreplanstage(@PathParam(value="project_id") String projectId, @PathParam(value="preplan_id") String prePlanId, @PathParam(value="stage_id") String stageId, @Valid @RequestBody UpdateRecoverStagePara updateRecoverStagePara) {
        String stageName = updateRecoverStagePara.getName();
        CommonUtil.getCsrService(RecoverStageService.class).updateStage(stageId, stageName);
        RecoverStageVo recoverStageVo = new RecoverStageVo();
        recoverStageVo.setStageId(stageId);
        recoverStageVo.setStageName(stageName);
        this.getOperLogAttrMap().put("operationLogTarget", stageName);
        return recoverStageVo;
    }

    @DELETE
    @Path(value="/v1/{project_id}/preplans/{preplan_id}/stages/{stage_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="stage_delete_operationname", operationModule="recovery", level=4)
    public Response deletePreplanstage(@PathParam(value="project_id") String projectId, @PathParam(value="preplan_id") String prePlanId, @PathParam(value="stage_id") String stageId) {
        RecoverStageService recoverStageService = CommonUtil.getCsrService(RecoverStageService.class);
        String stageName = recoverStageService.getStageById(stageId).getName();
        this.getOperLogAttrMap().put("operationLogTarget", stageName);
        recoverStageService.deleteStage(projectId, stageId);
        return Response.ok().build();
    }

    @GET
    @Path(value="/v1/{project_id}/plans/{plan_id}/preplans/{preplan_id}/stages")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverStageListVo queryPreplanProcess(@PathParam(value="project_id") String projectId, @PathParam(value="plan_id") String planId, @PathParam(value="preplan_id") String prePlanId) {
        List stageList = CommonUtil.getCsrService(RecoverStageService.class).getStageList(projectId, prePlanId);
        List<RecoverStageVo> recoverStageVoList = this.generateStageFlowList(stageList);
        RecoverStageListVo stageListResponse = new RecoverStageListVo();
        stageListResponse.setRecoverStageVoList(recoverStageVoList);
        return stageListResponse;
    }

    @POST
    @Path(value="/v1/{project_id}/preplans/{preplan_id}/stages/{stage_id}/flows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="stage_add_flow_operationname", operationModule="recovery", level=3)
    public Response addFlowToStage(@PathParam(value="project_id") String projectId, @PathParam(value="preplan_id") String prePlanId, @NotNull @PathParam(value="stage_id") String stageId, @Valid @RequestBody AddRecoverFlowToStagePara addRecoverFlowToStagePara) {
        String flowId = addRecoverFlowToStagePara.getFlowId();
        RecoverStageService stageService = CommonUtil.getCsrService(RecoverStageService.class);
        this.getOperLogAttrMap().put("operationLogTarget", Optional.of(stageService.getStageById(stageId)).map(RecoverStage::getName).orElse(""));
        stageService.addFlowToStage(stageId, flowId);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/v1/{project_id}/preplans/{preplan_id}/stages/{stage_id}/flows/{flow_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="stage_delete_flow_operationname", operationModule="recovery", level=4)
    public Response removeFlowFromStage(@PathParam(value="project_id") String projectId, @PathParam(value="preplan_id") String prePlanId, @PathParam(value="stage_id") String stageId, @PathParam(value="flow_id") String flowId) {
        RecoverStageService stageService = CommonUtil.getCsrService(RecoverStageService.class);
        this.getOperLogAttrMap().put("operationLogTarget", Optional.of(stageService.getStageById(stageId)).map(RecoverStage::getName).orElse(""));
        stageService.removeFlowFromStage(stageId, flowId);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/v1/{project_id}/preplans/{preplan_id}/stages/{stage_id}/flows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="flow_add_depend_operationname", operationModule="recovery", level=3)
    public Response updateStageFlowsDependent(@PathParam(value="project_id") String projectId, @PathParam(value="preplan_id") String prePlanId, @PathParam(value="stage_id") String stageId, @Valid @RequestBody StageFlowDependPara stageFlowsDependPara) {
        String preFlowId = stageFlowsDependPara.getPreFlowId();
        String nextFlowId = stageFlowsDependPara.getFlowId();
        RecoverStageService stageService = CommonUtil.getCsrService(RecoverStageService.class);
        this.getOperLogAttrMap().put("operationLogTarget", Optional.of(stageService.getStageById(stageId)).map(RecoverStage::getName).orElse(""));
        stageService.updateFlowDepend(stageId, preFlowId, nextFlowId);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/v1/{project_id}/preplans/{preplan_id}/stages/{stage_id}/flows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="flow_delete_depend_operationname", operationModule="recovery", level=4)
    public Response deleteStageFlowsDependent(@PathParam(value="project_id") String projectId, @PathParam(value="preplan_id") String prePlanId, @PathParam(value="stage_id") String stageId, @Valid @RequestBody StageFlowDependPara stageFlowsDependPara) {
        String preFlowId = stageFlowsDependPara.getPreFlowId();
        String nextFlowId = stageFlowsDependPara.getFlowId();
        RecoverStageService stageService = CommonUtil.getCsrService(RecoverStageService.class);
        this.getOperLogAttrMap().put("operationLogTarget", Optional.of(stageService.getStageById(stageId)).map(RecoverStage::getName).orElse(""));
        stageService.deleteFlowDepend(stageId, preFlowId, nextFlowId);
        return Response.ok().build();
    }

    private List<RecoverStageVo> generateStageFlowList(List<RecoverStage> stageList) {
        ArrayList<RecoverStageVo> recoverStageVoList = new ArrayList<RecoverStageVo>();
        for (RecoverStage stage : stageList) {
            RecoverStageVo recoverStageVo = new RecoverStageVo();
            recoverStageVo.setStageName(stage.getName());
            recoverStageVo.setStageId(stage.getId());
            recoverStageVo.setStageType(stage.getType());
            if (!VerifyUtil.isEmpty((String)stage.getPreStageId())) {
                recoverStageVo.setPreStageId(stage.getPreStageId());
            }
            recoverStageVo.setFlows(this.generateFlowInfoList(stage.getId()));
            recoverStageVoList.add(recoverStageVo);
        }
        return recoverStageVoList;
    }

    private List<BasicFlowVo> generateFlowInfoList(String stageId) {
        RecoverFlowQuery recoverFlowQuery = new RecoverFlowQuery();
        recoverFlowQuery.setPage(false);
        recoverFlowQuery.setStageId(stageId);
        RecoverFlowService flowService = CommonUtil.getCsrService(RecoverFlowService.class);
        List recoverFlowList = flowService.queryRecoverFlowList(recoverFlowQuery);
        ArrayList<BasicFlowVo> basicFlowVoList = new ArrayList<BasicFlowVo>();
        for (RecoverFlow recoverFlow : recoverFlowList) {
            BasicFlowVo basicFlowVo = new BasicFlowVo();
            basicFlowVo.setId(recoverFlow.getId());
            basicFlowVo.setName(recoverFlow.getName());
            basicFlowVo.setApplicationId(recoverFlow.getAppId());
            basicFlowVo.setApplicationName(CommonUtil.getCsrService(AppService.class).getApplicationById(recoverFlow.getAppId()).getName());
            basicFlowVo.setStatus(recoverFlow.getStatus());
            basicFlowVo.setFlowType(recoverFlow.getType());
            basicFlowVo.setOperationType(recoverFlow.getType());
            basicFlowVo.setAverageExecuteDuration(recoverFlow.getAverageExecuteDuration());
            basicFlowVo.setLastExecuteDuration(recoverFlow.getLastExecuteDuration());
            if (!VerifyUtil.isEmpty((Object)recoverFlow.getLastExecuteTime())) {
                basicFlowVo.setLastExecuteTime(String.valueOf(recoverFlow.getLastExecuteTime()));
            }
            List preFlowIdList = flowService.queryPreFlowIdList(stageId, recoverFlow.getId());
            basicFlowVo.setPreFlowId(preFlowIdList);
            ServiceInstanceQuery instanceQuery = new ServiceInstanceQuery();
            instanceQuery.setProjectId(recoverFlow.getProjectId());
            instanceQuery.setFlowId(recoverFlow.getId());
            basicFlowVo.setInstancesNumNotInFlow(CommonUtil.getCsrService(AppService.class).queryNotInFlowInstanceList(instanceQuery).size());
            basicFlowVoList.add(basicFlowVo);
        }
        return basicFlowVoList;
    }
}

