/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.controller;

import com.huawei.csr.framework.common.model.RecoverStepChainQuery;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.StepChain;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverStepService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.BaseController;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.OperationLog;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.common.utils.CommonUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstep.AddRecoverStepToFlowPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstep.ModifyRecoverStepPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstep.RecoverStepLinkPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstep.RecoverStepListVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstep.RecoverStepPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstep.RecoverStepQueryPara;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstep.RecoverStepVo;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.csr.model.recoverstep.SingleRecoverStepVo;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.RequestBody;

public class RecoverStepController
extends BaseController {
    private RecoverStepVo createRecoverStepVoFromModel(String projectId, RecoverStepService recoverStepService, RecoverStep recoverStep, String flowId) {
        RecoverStepVo recoverStepVo = new RecoverStepVo();
        recoverStepVo.setId(recoverStep.getId());
        recoverStepVo.setName(recoverStep.getName());
        List preStepList = !VerifyUtil.isEmpty((String)flowId) ? recoverStepService.queryAllPreStepIdInFlow(recoverStep.getId(), flowId) : recoverStepService.getAllPrestepId(recoverStep.getId());
        recoverStepVo.getPreStepIdList().addAll(preStepList);
        AppServiceInstance instance = recoverStepService.getServiceInstance(recoverStep.getServiceInstanceId());
        if (!VerifyUtil.isEmpty((Object)instance)) {
            recoverStepVo.setInstanceId(instance.getInstanceId());
            recoverStepVo.setInstanceName(instance.getInstanceName());
        }
        recoverStepVo.setInstanceId(recoverStep.getServiceInstanceId());
        List flowList = recoverStepService.getFlowListByStepId(recoverStep.getId());
        flowList.forEach(flow -> {
            recoverStepVo.getFlowId().add(flow.getId());
            recoverStepVo.getFlowName().add(flow.getName());
        });
        recoverStepVo.setAverageExecuteDuration(recoverStep.getAverageExecuteDuration());
        recoverStepVo.setLastExecuteTime(recoverStep.getLastExecuteTime());
        recoverStepVo.setLastExecuteDuration(recoverStep.getLastExecuteDuration());
        recoverStepVo.setAvailableFlag(recoverStep.getIsValid());
        recoverStepVo.setOperationName(recoverStep.getAction());
        recoverStepVo.setServiceType(recoverStep.getServiceType());
        recoverStepVo.setStatus(recoverStep.getStatus());
        recoverStepVo.setPreDelayTime(recoverStep.getPreDelayTime());
        recoverStepVo.setAfterDelayTime(recoverStep.getAfterDelayTime());
        recoverStepVo.setExpectRTO(recoverStep.getExpectRTO());
        return recoverStepVo;
    }

    private RecoverStep createRecoverStepFromPara(String projectId, RecoverStepPara recoverStepPara) {
        RecoverStep recoverStep = new RecoverStep();
        recoverStep.setProjectId(projectId);
        recoverStep.setName(recoverStepPara.getName());
        recoverStep.setServiceType(recoverStepPara.getServiceType().getValue());
        recoverStep.setServiceInstanceId(recoverStepPara.getInstanceId());
        recoverStep.setStatus(RecoverStatus.NORMAL.getValue());
        recoverStep.setAction(recoverStepPara.getAction().getValue());
        if (!VerifyUtil.isEmpty((Object)recoverStepPara.getExpectRTO())) {
            recoverStep.setExpectRTO(recoverStepPara.getExpectRTO().longValue());
        }
        if (!VerifyUtil.isEmpty((Object)recoverStepPara.getPreDelayTime())) {
            recoverStep.setPreDelayTime(recoverStepPara.getPreDelayTime().longValue());
        }
        if (!VerifyUtil.isEmpty((Object)recoverStepPara.getAfterDelayTime())) {
            recoverStep.setAfterDelayTime(recoverStepPara.getAfterDelayTime().longValue());
        }
        return recoverStep;
    }

    private RecoverStep createRecoverStepFromModifyPara(ModifyRecoverStepPara modifyRecoverStepPara) {
        RecoverStep recoverStep = new RecoverStep();
        if (!VerifyUtil.isEmpty((String)modifyRecoverStepPara.getName())) {
            recoverStep.setName(modifyRecoverStepPara.getName());
        }
        if (!VerifyUtil.isEmpty((Object)modifyRecoverStepPara.getPreDelayTime())) {
            recoverStep.setPreDelayTime(modifyRecoverStepPara.getPreDelayTime().longValue());
        }
        if (!VerifyUtil.isEmpty((Object)modifyRecoverStepPara.getAfterDelayTime())) {
            recoverStep.setAfterDelayTime(modifyRecoverStepPara.getAfterDelayTime().longValue());
        }
        if (!VerifyUtil.isEmpty((String)modifyRecoverStepPara.getInstanceId())) {
            recoverStep.setServiceInstanceId(modifyRecoverStepPara.getInstanceId());
        }
        if (!VerifyUtil.isEmpty((Object)modifyRecoverStepPara.getOperationType())) {
            recoverStep.setAction(modifyRecoverStepPara.getOperationType().getValue());
        }
        if (!VerifyUtil.isEmpty((Object)modifyRecoverStepPara.getExpectRTO())) {
            recoverStep.setExpectRTO(modifyRecoverStepPara.getExpectRTO().longValue());
        }
        if (!VerifyUtil.isEmpty((Object)modifyRecoverStepPara.getServiceType())) {
            recoverStep.setServiceType(modifyRecoverStepPara.getServiceType().getValue());
        }
        return recoverStep;
    }

    @POST
    @Path(value="/v1/{project_id}/steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="step_create_operationname", operationModule="recovery", level=3)
    public RecoverStepVo createRecoverStep(@NotNull @PathParam(value="project_id") String projectId, @Valid @RequestBody RecoverStepPara recoverStepPara) {
        this.getOperLogAttrMap().put("operationLogTarget", recoverStepPara.getName());
        RecoverStepService recoverStepService = CommonUtil.getCsrService(RecoverStepService.class);
        RecoverStep recoverStep = this.createRecoverStepFromPara(projectId, recoverStepPara);
        String stepId = recoverStepService.createRecoverStep(projectId, recoverStep);
        recoverStep.setId(stepId);
        if (!VerifyUtil.isEmpty((String)recoverStepPara.getFlowId())) {
            recoverStepService.addStepToFlow(projectId, recoverStepPara.getFlowId(), stepId);
        }
        return this.createRecoverStepVoFromModel(projectId, recoverStepService, recoverStep, null);
    }

    @DELETE
    @Path(value="/v1/{project_id}/step/{step_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="step_delete_operationname", operationModule="recovery", level=3)
    public Response deleteRecoverStep(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="step_id format is incorrect") @PathParam(value="step_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="step_id format is incorrect") String stepId, @QueryParam(value="flow_id") String flowId) {
        RecoverStepQuery recoverStepQuery = new RecoverStepQuery();
        recoverStepQuery.setProjectId(projectId);
        recoverStepQuery.setStepId(stepId);
        recoverStepQuery.setFlowId(flowId);
        RecoverStepService stepService = CommonUtil.getCsrService(RecoverStepService.class);
        RecoverStep recoverStep = stepService.queryRecoverStepById(stepId);
        this.getOperLogAttrMap().put("operationLogTarget", recoverStep.getName());
        stepService.deleteRecoverStep(recoverStepQuery);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/v1/{project_id}/steps/{step_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="step_update_operationname", operationModule="recovery", level=3)
    public SingleRecoverStepVo modifyRecoverStep(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="step_id format is incorrect") @PathParam(value="step_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="step_id format is incorrect") String stepId, @Valid @RequestBody ModifyRecoverStepPara modifyRecoverStepPara) {
        this.getOperLogAttrMap().put("operationLogTarget", modifyRecoverStepPara.getName());
        RecoverStepService stepService = CommonUtil.getCsrService(RecoverStepService.class);
        RecoverStep recoverStep = this.createRecoverStepFromModifyPara(modifyRecoverStepPara);
        RecoverStepQuery query = new RecoverStepQuery();
        query.setProjectId(projectId);
        query.setStepId(stepId);
        recoverStep = stepService.modifyRecoverStep(projectId, query, recoverStep);
        SingleRecoverStepVo vo = new SingleRecoverStepVo();
        vo.setRecoverStepVo(this.createRecoverStepVoFromModel(projectId, stepService, recoverStep, null));
        return vo;
    }

    RecoverStepQuery generateStepQuery(String flowId, String preplanName, String status, String flowName, String stepName) {
        RecoverStepQuery query = new RecoverStepQuery();
        if (!VerifyUtil.isEmpty((String)flowId)) {
            query.setFlowId(flowId);
        }
        if (!VerifyUtil.isEmpty((String)preplanName)) {
            query.setFlowId(preplanName);
        }
        if (!VerifyUtil.isEmpty((String)status)) {
            query.setStatus(status);
        }
        if (!VerifyUtil.isEmpty((String)flowName)) {
            query.setFlowName(flowName);
        }
        if (!VerifyUtil.isEmpty((String)stepName)) {
            query.setStepName(stepName);
        }
        return query;
    }

    @GET
    @Path(value="/v1/{project_id}/steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverStepListVo queryRecoverStepList(@NotNull @PathParam(value="project_id") String projectId, @Valid @BeanParam RecoverStepQueryPara queryPara) {
        RecoverStepService stepService = CommonUtil.getCsrService(RecoverStepService.class);
        RecoverStepQuery recoverStepQuery = this.generateStepQuery(queryPara.getFlowId(), queryPara.getPreplanName(), queryPara.getStatus(), queryPara.getFlowName(), queryPara.getStepName());
        recoverStepQuery.setProjectId(projectId);
        recoverStepQuery.setPage(true);
        recoverStepQuery.setLimit(queryPara.getLimit());
        recoverStepQuery.setMarker(queryPara.getMarker());
        recoverStepQuery.setServiceType(queryPara.getServiceType());
        recoverStepQuery.setInstanceName(queryPara.getInstanceName());
        List recoverStepList = stepService.queryRecoverStepList(recoverStepQuery);
        recoverStepQuery.setPage(false);
        long recoverStepCount = stepService.getRecoverStepCount(recoverStepQuery);
        RecoverStepListVo recoverStepListVo = new RecoverStepListVo();
        recoverStepListVo.setTotalCount(recoverStepCount);
        recoverStepList.forEach(recoverStep -> recoverStepListVo.getRecoverStepVoList().add(this.createRecoverStepVoFromModel(projectId, stepService, (RecoverStep)recoverStep, queryPara.getFlowId())));
        return recoverStepListVo;
    }

    @GET
    @Path(value="/v1/{project_id}/steps/{step_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public SingleRecoverStepVo queryStep(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="step_id format is incorrect") @PathParam(value="step_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="step_id format is incorrect") String stepId) {
        RecoverStepService service = CommonUtil.getCsrService(RecoverStepService.class);
        RecoverStepQuery query = new RecoverStepQuery();
        query.setProjectId(projectId);
        query.setStepId(stepId);
        RecoverStep step = service.queryRecoverStep(query);
        SingleRecoverStepVo vo = new SingleRecoverStepVo();
        vo.setRecoverStepVo(this.createRecoverStepVoFromModel(projectId, service, step, null));
        return vo;
    }

    @POST
    @Path(value="/v1/{project_id}/flows/{flow_id}/steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="flow_add_step_operationname", operationModule="recovery", level=3)
    public Response addStepToFlow(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") @PathParam(value="flow_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") String flowId, @Valid @RequestBody AddRecoverStepToFlowPara para) {
        this.writeFlowNameToLogAttr(flowId);
        CommonUtil.getCsrService(RecoverStepService.class).addStepToFlow(projectId, flowId, para.getStepId());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/v1/{project_id}/flows/{flow_id}/steps/{step_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="flow_delete_step_operationname", operationModule="recovery", level=3)
    public Response removeStepFromFlow(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") @PathParam(value="flow_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") String flowId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="step_id format is incorrect") @PathParam(value="step_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="step_id format is incorrect") String stepId) {
        this.writeFlowNameToLogAttr(flowId);
        CommonUtil.getCsrService(RecoverStepService.class).removeStepFromFlow(projectId, flowId, stepId);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/v1/{project_id}/flows/{flow_id}/steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="flow_update_step_depend_operationname", operationModule="recovery", level=3)
    public Response modifyLinkStepFromFlow(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") @PathParam(value="flow_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") String flowId, @Valid @RequestBody RecoverStepLinkPara recoverStepLinkPara) {
        this.writeFlowNameToLogAttr(flowId);
        StepChain chain = new StepChain();
        chain.setRecoverFlowId(flowId);
        chain.setPrevStepId(recoverStepLinkPara.getPreStepId());
        chain.setNextStepId(recoverStepLinkPara.getStepId());
        CommonUtil.getCsrService(RecoverStepService.class).modifyLinkStepFromFlow(projectId, chain);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/v1/{project_id}/flows/{flow_id}/steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    @OperationLog(operationName="flow_delete_step_depend_operationname", operationModule="recovery", level=3)
    public Response deleteLinkStepFromFlow(@NotNull @PathParam(value="project_id") String projectId, @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") @PathParam(value="flow_id") @NotNull @Pattern(regexp="^[0-9a-fA-F]{32}$", message="flow_id format is incorrect") String flowId, @Valid @RequestBody RecoverStepLinkPara recoverStepLinkPara) {
        this.writeFlowNameToLogAttr(flowId);
        RecoverStepChainQuery query = new RecoverStepChainQuery();
        query.setFlowId(flowId);
        query.setPrevStepId(recoverStepLinkPara.getPreStepId());
        query.setNextStepId(recoverStepLinkPara.getStepId());
        CommonUtil.getCsrService(RecoverStepService.class).deleteLinkStepFromFlow(projectId, query);
        return Response.ok().build();
    }

    @GET
    @Path(value="/v1/{project_id}/steps/not-inflow")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;version=1.0"})
    public RecoverStepListVo queryRecoverStepsNotInFlow(@PathParam(value="project_id") String projectId, @Valid @BeanParam RecoverStepQueryPara queryPara) {
        RecoverStepQuery recoverStepQuery = this.generateStepQuery(queryPara.getFlowId(), queryPara.getPreplanName(), queryPara.getStatus(), queryPara.getFlowName(), queryPara.getStepName());
        recoverStepQuery.setServiceType(queryPara.getServiceType());
        recoverStepQuery.setInstanceName(queryPara.getInstanceName());
        recoverStepQuery.setProjectId(projectId);
        RecoverStepService stepService = CommonUtil.getCsrService(RecoverStepService.class);
        Pair recoverStepPair = stepService.queryRecoverStepsNotInFlow(recoverStepQuery, queryPara.getMarker(), queryPara.getLimit());
        RecoverStepListVo recoverStepListVo = new RecoverStepListVo();
        recoverStepListVo.setTotalCount((Long)recoverStepPair.getRight());
        ((List)recoverStepPair.getLeft()).forEach(recoverStep -> recoverStepListVo.getRecoverStepVoList().add(this.createRecoverStepVoFromModel(projectId, stepService, (RecoverStep)recoverStep, queryPara.getFlowId())));
        return recoverStepListVo;
    }

    private void writeFlowNameToLogAttr(String flowId) {
        RecoverFlow recoverFlow = CommonUtil.getCsrService(RecoverFlowService.class).getRecoverFlowById(flowId);
        this.getOperLogAttrMap().put("operationLogTarget", Optional.of(recoverFlow).map(RecoverFlow::getName));
    }
}

